pages = [{"l":"index.html#","e":false,"i":"","n":"fs2-io","t":"fs2-io","d":"","k":"static","x":""},
{"l":"fs2/io.html#","e":false,"i":"","n":"fs2.io","t":"fs2.io","d":"","k":"package","x":"Provides various ways to work with streams that perform IO.\n"},
{"l":"fs2/io.html#ClosedChannelException-0","e":false,"i":"","n":"ClosedChannelException","t":"ClosedChannelException = ClosedChannelException","d":"fs2.io","k":"type","x":""},
{"l":"fs2/io.html#IOException-0","e":false,"i":"","n":"IOException","t":"IOException = IOException","d":"fs2.io","k":"type","x":""},
{"l":"fs2/io.html#InterruptedIOException-0","e":false,"i":"","n":"InterruptedIOException","t":"InterruptedIOException = InterruptedIOException","d":"fs2.io","k":"type","x":""},
{"l":"fs2/io.html#readClassLoaderResource-563","e":false,"i":"","n":"readClassLoaderResource","t":"readClassLoaderResource[F[_]](name: String, chunkSize: Int, classLoader: ClassLoader)(implicit F: Sync[F]): Stream[F, Byte]","d":"fs2.io","k":"def","x":"Stream of bytes read asynchronously from the specified classloader resource."},
{"l":"fs2/io.html#readClassResource-874","e":false,"i":"","n":"readClassResource","t":"readClassResource[F[_], C](name: String, chunkSize: Int)(implicit F: Sync[F], ct: ClassTag[C]): Stream[F, Byte]","d":"fs2.io","k":"def","x":"Stream of bytes read asynchronously from the specified resource relative to the class C."},
{"l":"fs2/io.html#readInputStream-f0c","e":false,"i":"","n":"readInputStream","t":"readInputStream[F[_]](fis: F[InputStream], chunkSize: Int, closeAfterUse: Boolean)(implicit F: Sync[F]): Stream[F, Byte]","d":"fs2.io","k":"def","x":"Reads all bytes from the specified InputStream with a buffer size of chunkSize.\nSet closeAfterUse to false if the InputStream should not be closed after use.\n"},
{"l":"fs2/io.html#readOutputStream-fffff37b","e":false,"i":"","n":"readOutputStream","t":"readOutputStream[F[_] : Async](chunkSize: Int)(f: OutputStream => F[Unit]): Stream[F, Byte]","d":"fs2.io","k":"def","x":"Take a function that emits to a java.io.OutputStream effectfully,\nand return a stream which, when run, will perform that function and emit\nthe bytes recorded in the OutputStream as an fs2.Stream"},
{"l":"fs2/io.html#stderr-fffff4e2","e":false,"i":"","n":"stderr","t":"stderr[F[_] : Sync]: (F, Byte) => Nothing","d":"fs2.io","k":"def","x":"Pipe of bytes that writes emitted values to standard error asynchronously."},
{"l":"fs2/io.html#stdin-73","e":false,"i":"","n":"stdin","t":"stdin[F[_]](bufSize: Int, F: Sync[F]): Stream[F, Byte]","d":"fs2.io","k":"def","x":""},
{"l":"fs2/io.html#stdin-316","e":false,"i":"","n":"stdin","t":"stdin[F[_]](bufSize: Int)(implicit F: Async[F]): Stream[F, Byte]","d":"fs2.io","k":"def","x":"Stream of bytes read asynchronously from standard input."},
{"l":"fs2/io.html#stdinUtf8-73","e":false,"i":"","n":"stdinUtf8","t":"stdinUtf8[F[_]](bufSize: Int, F: Sync[F]): Stream[F, String]","d":"fs2.io","k":"def","x":""},
{"l":"fs2/io.html#stdinUtf8-316","e":false,"i":"","n":"stdinUtf8","t":"stdinUtf8[F[_] : Async](bufSize: Int): Stream[F, String]","d":"fs2.io","k":"def","x":"Stream of String read asynchronously from standard input decoded in UTF-8."},
{"l":"fs2/io.html#stdout-fffff4e2","e":false,"i":"","n":"stdout","t":"stdout[F[_] : Sync]: (F, Byte) => Nothing","d":"fs2.io","k":"def","x":"Pipe of bytes that writes emitted values to standard output asynchronously."},
{"l":"fs2/io.html#stdoutLines-d0d","e":false,"i":"","n":"stdoutLines","t":"stdoutLines[F[_] : Sync, O : Show](charset: Charset): (F, O) => Nothing","d":"fs2.io","k":"def","x":"Writes this stream to standard output asynchronously, converting each element to\na sequence of bytes via Show and the given Charset.\n"},
{"l":"fs2/io.html#toInputStream-fc9","e":false,"i":"","n":"toInputStream","t":"toInputStream[F[_] : Async]: (F, Byte) => InputStream","d":"fs2.io","k":"def","x":"Pipe that converts a stream of bytes to a stream that will emit a single java.io.InputStream,\nthat is closed whenever the resulting stream terminates."},
{"l":"fs2/io.html#toInputStreamResource-fffffb42","e":false,"i":"","n":"toInputStreamResource","t":"toInputStreamResource[F[_] : Async](source: Stream[F, Byte]): Resource[F, InputStream]","d":"fs2.io","k":"def","x":"Like toInputStream but returns a Resource rather than a single element stream.\n"},
{"l":"fs2/io.html#unsafeReadInputStream-f0c","e":false,"i":"","n":"unsafeReadInputStream","t":"unsafeReadInputStream[F[_]](fis: F[InputStream], chunkSize: Int, closeAfterUse: Boolean)(implicit F: Sync[F]): Stream[F, Byte]","d":"fs2.io","k":"def","x":"Reads all bytes from the specified InputStream with a buffer size of chunkSize.\nSet closeAfterUse to false if the InputStream should not be closed after use."},
{"l":"fs2/io.html#writeOutputStream-a8d","e":false,"i":"","n":"writeOutputStream","t":"writeOutputStream[F[_]](fos: F[OutputStream], closeAfterUse: Boolean)(implicit F: Sync[F]): (F, Byte) => Nothing","d":"fs2.io","k":"def","x":"Writes all bytes to the specified OutputStream. Each chunk is flushed\nimmediately after writing. Set closeAfterUse to false if\nthe OutputStream should not be closed after use.\n"},
{"l":"fs2/io/file.html#","e":false,"i":"","n":"fs2.io.file","t":"fs2.io.file","d":"","k":"package","x":"Provides support for working with files."},
{"l":"fs2/io/file.html#AccessDeniedException-0","e":false,"i":"","n":"AccessDeniedException","t":"AccessDeniedException = AccessDeniedException","d":"fs2.io.file","k":"type","x":""},
{"l":"fs2/io/file.html#DirectoryNotEmptyException-0","e":false,"i":"","n":"DirectoryNotEmptyException","t":"DirectoryNotEmptyException = DirectoryNotEmptyException","d":"fs2.io.file","k":"type","x":""},
{"l":"fs2/io/file.html#FileAlreadyExistsException-0","e":false,"i":"","n":"FileAlreadyExistsException","t":"FileAlreadyExistsException = FileAlreadyExistsException","d":"fs2.io.file","k":"type","x":""},
{"l":"fs2/io/file.html#FileSystemException-0","e":false,"i":"","n":"FileSystemException","t":"FileSystemException = FileSystemException","d":"fs2.io.file","k":"type","x":""},
{"l":"fs2/io/file.html#FileSystemLoopException-0","e":false,"i":"","n":"FileSystemLoopException","t":"FileSystemLoopException = FileSystemLoopException","d":"fs2.io.file","k":"type","x":""},
{"l":"fs2/io/file.html#NoSuchFileException-0","e":false,"i":"","n":"NoSuchFileException","t":"NoSuchFileException = NoSuchFileException","d":"fs2.io.file","k":"type","x":""},
{"l":"fs2/io/file.html#NotDirectoryException-0","e":false,"i":"","n":"NotDirectoryException","t":"NotDirectoryException = NotDirectoryException","d":"fs2.io.file","k":"type","x":""},
{"l":"fs2/io/file.html#copy-328","e":false,"i":"","n":"copy","t":"copy[F[_] : Async](source: Path, target: Path, flags: Seq[CopyOption]): F[Path]","d":"fs2.io.file","k":"def","x":"Copies a file from the source to the target path,"},
{"l":"fs2/io/file.html#createDirectories-917","e":false,"i":"","n":"createDirectories","t":"createDirectories[F[_] : Async](path: Path, flags: Seq[FileAttribute[_]]): F[Path]","d":"fs2.io.file","k":"def","x":"Creates a new directory at the given path and creates all nonexistent parent directories beforehand.\n"},
{"l":"fs2/io/file.html#createDirectory-917","e":false,"i":"","n":"createDirectory","t":"createDirectory[F[_] : Async](path: Path, flags: Seq[FileAttribute[_]]): F[Path]","d":"fs2.io.file","k":"def","x":"Creates a new directory at the given path\n"},
{"l":"fs2/io/file.html#delete-fffff56c","e":false,"i":"","n":"delete","t":"delete[F[_] : Async](path: Path): F[Unit]","d":"fs2.io.file","k":"def","x":"Deletes a file."},
{"l":"fs2/io/file.html#deleteDirectoryRecursively-fffffa1a","e":false,"i":"","n":"deleteDirectoryRecursively","t":"deleteDirectoryRecursively[F[_] : Async](path: Path, options: Set[FileVisitOption]): F[Unit]","d":"fs2.io.file","k":"def","x":"Recursively delete a directory\n"},
{"l":"fs2/io/file.html#deleteIfExists-fffff56c","e":false,"i":"","n":"deleteIfExists","t":"deleteIfExists[F[_] : Async](path: Path): F[Boolean]","d":"fs2.io.file","k":"def","x":"Like delete, but will not fail when the path doesn't exist.\n"},
{"l":"fs2/io/file.html#directoryStream-742","e":false,"i":"","n":"directoryStream","t":"directoryStream[F[_] : Async](path: Path): Stream[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a stream of Paths inside a directory.\n"},
{"l":"fs2/io/file.html#directoryStream-fffff1cf","e":false,"i":"","n":"directoryStream","t":"directoryStream[F[_] : Async](path: Path, filter: Path => Boolean): Stream[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a stream of Paths inside a directory, filtering the results by the given predicate.\n"},
{"l":"fs2/io/file.html#directoryStream-67","e":false,"i":"","n":"directoryStream","t":"directoryStream[F[_] : Async](path: Path, glob: String): Stream[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a stream of Paths inside a directory which match the given glob.\n"},
{"l":"fs2/io/file.html#exists-917","e":false,"i":"","n":"exists","t":"exists[F[_] : Async](path: Path, flags: Seq[LinkOption]): F[Boolean]","d":"fs2.io.file","k":"def","x":"Checks if a file exists"},
{"l":"fs2/io/file.html#move-328","e":false,"i":"","n":"move","t":"move[F[_] : Async](source: Path, target: Path, flags: Seq[CopyOption]): F[Path]","d":"fs2.io.file","k":"def","x":"Moves (or renames) a file from the source to the target path."},
{"l":"fs2/io/file.html#permissions-917","e":false,"i":"","n":"permissions","t":"permissions[F[_] : Async](path: Path, flags: Seq[LinkOption]): F[Set[PosixFilePermission]]","d":"fs2.io.file","k":"def","x":"Get file permissions as set of PosixFilePermission."},
{"l":"fs2/io/file.html#readAll-fffffd65","e":false,"i":"","n":"readAll","t":"readAll[F[_] : Async](path: Path, chunkSize: Int): Stream[F, Byte]","d":"fs2.io.file","k":"def","x":""},
{"l":"fs2/io/file.html#readRange-e6d","e":false,"i":"","n":"readRange","t":"readRange[F[_] : Async](path: Path, chunkSize: Int, start: Long, end: Long): Stream[F, Byte]","d":"fs2.io.file","k":"def","x":"Reads a range of data synchronously from the file at the specified java.nio.file.Path.\nstart is inclusive, end is exclusive, so when start is 0 and end is 2,\ntwo bytes are read.\n"},
{"l":"fs2/io/file.html#setPermissions-fffffa1a","e":false,"i":"","n":"setPermissions","t":"setPermissions[F[_] : Async](path: Path, permissions: Set[PosixFilePermission]): F[Path]","d":"fs2.io.file","k":"def","x":"Set file permissions from set of PosixFilePermission."},
{"l":"fs2/io/file.html#size-fffff56c","e":false,"i":"","n":"size","t":"size[F[_] : Async](path: Path): F[Long]","d":"fs2.io.file","k":"def","x":"Returns the size of a file (in bytes).\n"},
{"l":"fs2/io/file.html#tail-577","e":false,"i":"","n":"tail","t":"tail[F[_] : Async](path: Path, chunkSize: Int, offset: Long, pollDelay: FiniteDuration): Stream[F, Byte]","d":"fs2.io.file","k":"def","x":"Returns an infinite stream of data from the file at the specified path.\nStarts reading from the specified offset and upon reaching the end of the file,\npolls every pollDuration for additional updates to the file."},
{"l":"fs2/io/file.html#tempDirectoryResource-fffff04a","e":false,"i":"","n":"tempDirectoryResource","t":"tempDirectoryResource[F[_] : Async](dir: Path, prefix: String, attributes: Seq[FileAttribute[_]]): Resource[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a resource containing the path of a temporary directory."},
{"l":"fs2/io/file.html#tempDirectoryStream-fffff192","e":false,"i":"","n":"tempDirectoryStream","t":"tempDirectoryStream[F[_] : Async](dir: Path, prefix: String, attributes: Seq[FileAttribute[_]]): Stream[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a stream containing the path of a temporary directory."},
{"l":"fs2/io/file.html#tempFileResource-685","e":false,"i":"","n":"tempFileResource","t":"tempFileResource[F[_] : Async](dir: Path, prefix: String, suffix: String, attributes: Seq[FileAttribute[_]]): Resource[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a resource containing the path of a temporary file."},
{"l":"fs2/io/file.html#tempFileStream-1f7","e":false,"i":"","n":"tempFileStream","t":"tempFileStream[F[_] : Async](dir: Path, prefix: String, suffix: String, attributes: Seq[FileAttribute[_]]): Stream[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a stream containing the path of a temporary file."},
{"l":"fs2/io/file.html#walk-742","e":false,"i":"","n":"walk","t":"walk[F[_] : Async](start: Path): Stream[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a stream of Paths contained in a given file tree. Depth is unlimited.\n"},
{"l":"fs2/io/file.html#walk-fffff72d","e":false,"i":"","n":"walk","t":"walk[F[_] : Async](start: Path, options: Seq[FileVisitOption]): Stream[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a stream of Paths contained in a given file tree, respecting the supplied options. Depth is unlimited.\n"},
{"l":"fs2/io/file.html#walk-e10","e":false,"i":"","n":"walk","t":"walk[F[_] : Async](start: Path, maxDepth: Int, options: Seq[FileVisitOption]): Stream[F, Path]","d":"fs2.io.file","k":"def","x":"Creates a stream of Paths contained in a given file tree down to a given depth.\n"},
{"l":"fs2/io/file.html#watch-be6","e":false,"i":"","n":"watch","t":"watch[F[_]](path: Path, types: Seq[EventType], modifiers: Seq[Modifier], pollTimeout: FiniteDuration)(implicit F: Async[F]): Stream[F, Event]","d":"fs2.io.file","k":"def","x":"Watches a single path."},
{"l":"fs2/io/file.html#watcher-54b","e":false,"i":"","n":"watcher","t":"watcher[F[_]](implicit F: Async[F]): Resource[F, Watcher[F]]","d":"fs2.io.file","k":"def","x":"Creates a Watcher for the default file system."},
{"l":"fs2/io/file.html#writeAll-fffff48d","e":false,"i":"","n":"writeAll","t":"writeAll[F[_] : Async](path: Path, flags: Seq[StandardOpenOption]): (F, Byte) => Nothing","d":"fs2.io.file","k":"def","x":"Writes all data to the file at the specified java.nio.file.Path."},
{"l":"fs2/io/file.html#writeRotate-fffffc87","e":false,"i":"","n":"writeRotate","t":"writeRotate[F[_]](computePath: F[Path], limit: Long, flags: Seq[StandardOpenOption])(implicit F: Async[F]): (F, Byte) => Nothing","d":"fs2.io.file","k":"def","x":"Writes all data to a sequence of files, each limited in size to limit."},
{"l":"fs2/io/file/BasicFileAttributes.html#","e":false,"i":"","n":"BasicFileAttributes","t":"BasicFileAttributes","d":"fs2.io.file","k":"trait","x":"Attributes of a file that are provided by most operating systems and file systems."},
{"l":"fs2/io/file/BasicFileAttributes.html#creationTime-0","e":false,"i":"","n":"creationTime","t":"creationTime: FiniteDuration","d":"fs2.io.file.BasicFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/BasicFileAttributes.html#fileKey-0","e":false,"i":"","n":"fileKey","t":"fileKey: Option[FileKey]","d":"fs2.io.file.BasicFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/BasicFileAttributes.html#isDirectory-0","e":false,"i":"","n":"isDirectory","t":"isDirectory: Boolean","d":"fs2.io.file.BasicFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/BasicFileAttributes.html#isOther-0","e":false,"i":"","n":"isOther","t":"isOther: Boolean","d":"fs2.io.file.BasicFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/BasicFileAttributes.html#isRegularFile-0","e":false,"i":"","n":"isRegularFile","t":"isRegularFile: Boolean","d":"fs2.io.file.BasicFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/BasicFileAttributes.html#isSymbolicLink-0","e":false,"i":"","n":"isSymbolicLink","t":"isSymbolicLink: Boolean","d":"fs2.io.file.BasicFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/BasicFileAttributes.html#lastAccessTime-0","e":false,"i":"","n":"lastAccessTime","t":"lastAccessTime: FiniteDuration","d":"fs2.io.file.BasicFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/BasicFileAttributes.html#lastModifiedTime-0","e":false,"i":"","n":"lastModifiedTime","t":"lastModifiedTime: FiniteDuration","d":"fs2.io.file.BasicFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/BasicFileAttributes.html#size-0","e":false,"i":"","n":"size","t":"size: Long","d":"fs2.io.file.BasicFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/BasicFileAttributes$.html#","e":false,"i":"","n":"BasicFileAttributes","t":"BasicFileAttributes","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/CopyFlag.html#","e":false,"i":"","n":"CopyFlag","t":"CopyFlag extends AnyVal","d":"fs2.io.file","k":"class","x":""},
{"l":"fs2/io/file/CopyFlag$.html#","e":false,"i":"","n":"CopyFlag","t":"CopyFlag","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/CopyFlag$.html#AtomicMove-0","e":false,"i":"","n":"AtomicMove","t":"AtomicMove: CopyFlag","d":"fs2.io.file.CopyFlag","k":"val","x":""},
{"l":"fs2/io/file/CopyFlag$.html#CopyAttributes-0","e":false,"i":"","n":"CopyAttributes","t":"CopyAttributes: CopyFlag","d":"fs2.io.file.CopyFlag","k":"val","x":""},
{"l":"fs2/io/file/CopyFlag$.html#ReplaceExisting-0","e":false,"i":"","n":"ReplaceExisting","t":"ReplaceExisting: CopyFlag","d":"fs2.io.file.CopyFlag","k":"val","x":""},
{"l":"fs2/io/file/CopyFlag$.html#fromCopyOption-2ec","e":false,"i":"","n":"fromCopyOption","t":"fromCopyOption(option: CopyOption): CopyFlag","d":"fs2.io.file.CopyFlag","k":"def","x":""},
{"l":"fs2/io/file/CopyFlags.html#","e":false,"i":"","n":"CopyFlags","t":"CopyFlags(value: List[CopyFlag])","d":"fs2.io.file","k":"class","x":""},
{"l":"fs2/io/file/CopyFlags.html#contains-fffff4aa","e":false,"i":"","n":"contains","t":"contains(flag: CopyFlag): Boolean","d":"fs2.io.file.CopyFlags","k":"def","x":""},
{"l":"fs2/io/file/CopyFlags$.html#","e":false,"i":"","n":"CopyFlags","t":"CopyFlags","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/CopyFlags$.html#apply-fffffdd4","e":false,"i":"","n":"apply","t":"apply(flags: CopyFlag*): CopyFlags","d":"fs2.io.file.CopyFlags","k":"def","x":""},
{"l":"fs2/io/file/CopyFlags$.html#empty-0","e":false,"i":"","n":"empty","t":"empty: CopyFlags","d":"fs2.io.file.CopyFlags","k":"val","x":""},
{"l":"fs2/io/file/CopyFlags$.html#fromCopyOptions-a25","e":false,"i":"","n":"fromCopyOptions","t":"fromCopyOptions(options: Iterable[CopyOption]): CopyFlags","d":"fs2.io.file.CopyFlags","k":"def","x":""},
{"l":"fs2/io/file/FileHandle.html#","e":false,"i":"","n":"FileHandle","t":"FileHandle[F[_]]","d":"fs2.io.file","k":"trait","x":"Provides the ability to read/write/lock/inspect a file in the effect F.\n"},
{"l":"fs2/io/file/FileHandle.html#Lock-0","e":false,"i":"","n":"Lock","t":"Lock","d":"fs2.io.file.FileHandle","k":"type","x":"Opaque type representing an exclusive lock on a file."},
{"l":"fs2/io/file/FileHandle.html#force-fffff0f3","e":false,"i":"","n":"force","t":"force(metaData: Boolean): F[Unit]","d":"fs2.io.file.FileHandle","k":"def","x":"Force any updates for the underlying file to storage."},
{"l":"fs2/io/file/FileHandle.html#lock-66b","e":false,"i":"","n":"lock","t":"lock(position: Long, size: Long, shared: Boolean): F[Lock]","d":"fs2.io.file.FileHandle","k":"def","x":"Acquire a lock on the specified region of the underlying file."},
{"l":"fs2/io/file/FileHandle.html#lock-0","e":false,"i":"","n":"lock","t":"lock: F[Lock]","d":"fs2.io.file.FileHandle","k":"def","x":"Acquire an exclusive lock on the underlying file."},
{"l":"fs2/io/file/FileHandle.html#read-43e","e":false,"i":"","n":"read","t":"read(numBytes: Int, offset: Long): F[Option[Chunk[Byte]]]","d":"fs2.io.file.FileHandle","k":"def","x":"Read the specified number of bytes at a particular offset."},
{"l":"fs2/io/file/FileHandle.html#size-0","e":false,"i":"","n":"size","t":"size: F[Long]","d":"fs2.io.file.FileHandle","k":"def","x":"Report the current size of the file."},
{"l":"fs2/io/file/FileHandle.html#truncate-7d7","e":false,"i":"","n":"truncate","t":"truncate(size: Long): F[Unit]","d":"fs2.io.file.FileHandle","k":"def","x":"Truncate the underlying file to the specified size."},
{"l":"fs2/io/file/FileHandle.html#tryLock-66b","e":false,"i":"","n":"tryLock","t":"tryLock(position: Long, size: Long, shared: Boolean): F[Option[Lock]]","d":"fs2.io.file.FileHandle","k":"def","x":"Attempt to acquire a lock on the specified region of the underlying file."},
{"l":"fs2/io/file/FileHandle.html#tryLock-0","e":false,"i":"","n":"tryLock","t":"tryLock: F[Option[Lock]]","d":"fs2.io.file.FileHandle","k":"def","x":"Attempt to acquire an exclusive lock on the underlying file."},
{"l":"fs2/io/file/FileHandle.html#unlock-d26","e":false,"i":"","n":"unlock","t":"unlock(lock: Lock): F[Unit]","d":"fs2.io.file.FileHandle","k":"def","x":"Unlock the (exclusive or regional) lock represented by the supplied Lock."},
{"l":"fs2/io/file/FileHandle.html#write-fffff6fb","e":false,"i":"","n":"write","t":"write(bytes: Chunk[Byte], offset: Long): F[Int]","d":"fs2.io.file.FileHandle","k":"def","x":"Write the specified bytes at a particular offset."},
{"l":"fs2/io/file/FileHandle$.html#","e":false,"i":"","n":"FileHandle","t":"FileHandle","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/FileHandle$.html#fromFileChannel-fffff2d8","e":false,"i":"","n":"fromFileChannel","t":"fromFileChannel[F[_] : Async](channel: F[FileChannel]): Resource[F, FileHandle[F]]","d":"fs2.io.file.FileHandle","k":"def","x":""},
{"l":"fs2/io/file/FileHandle$.html#fromPath-fffff40f","e":false,"i":"","n":"fromPath","t":"fromPath[F[_] : Async](path: Path, flags: Seq[OpenOption]): Resource[F, FileHandle[F]]","d":"fs2.io.file.FileHandle","k":"def","x":""},
{"l":"fs2/io/file/FileKey.html#","e":false,"i":"","n":"FileKey","t":"FileKey","d":"fs2.io.file","k":"trait","x":"An opaque, unique identifier for a file."},
{"l":"fs2/io/file/FileKey$.html#","e":false,"i":"","n":"FileKey","t":"FileKey","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/FileKey$.html#hash-0","e":false,"i":"","n":"hash","t":"hash: Hash[FileKey]","d":"fs2.io.file.FileKey","k":"val","x":""},
{"l":"fs2/io/file/FileKey$.html#show-0","e":false,"i":"","n":"show","t":"show: Show[FileKey]","d":"fs2.io.file.FileKey","k":"val","x":""},
{"l":"fs2/io/file/Files.html#","e":false,"i":"","n":"Files","t":"Files[F[_]]","d":"fs2.io.file","k":"trait","x":"Provides operations related to working with files in the effect F."},
{"l":"fs2/io/file/Files.html#F-0","e":false,"i":"","n":"F","t":"F: Async[F]","d":"fs2.io.file.Files","k":"val","x":""},
{"l":"fs2/io/file/Files.html#_runJavaCollectionResource-fffff4b6","e":false,"i":"","n":"_runJavaCollectionResource","t":"_runJavaCollectionResource[C <: AutoCloseable](javaCollection: F[C], collectionIterator: C => Iterator[Path]): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":""},
{"l":"fs2/io/file/Files.html#copy-b83","e":false,"i":"","n":"copy","t":"copy(source: Path, target: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Copies the source to the target, failing if source does not exist or the target already exists.\nTo replace the existing instead, use copy(source, target, CopyFlags(CopyFlag.ReplaceExisting)).\n"},
{"l":"fs2/io/file/Files.html#copy-fffffec2","e":false,"i":"","n":"copy","t":"copy(source: Path, target: Path, flags: CopyFlags): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Copies the source to the target, following any directives supplied in the flags.\nBy default, an error occurs if the target already exists, though this can be overriden via CopyFlag.ReplaceExisting.\n"},
{"l":"fs2/io/file/Files.html#copy-ea0","e":false,"i":"","n":"copy","t":"copy(source: Path, target: Path, flags: Seq[CopyOption]): F[Path]","d":"fs2.io.file.Files","k":"def","x":"Copies a file from the source to the target path,"},
{"l":"fs2/io/file/Files.html#createDirectories-a8b","e":false,"i":"","n":"createDirectories","t":"createDirectories(path: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Creates the specified directory and any non-existant parent directories."},
{"l":"fs2/io/file/Files.html#createDirectories-2c8","e":false,"i":"","n":"createDirectories","t":"createDirectories(path: Path, permissions: Option[Permissions]): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Creates the specified directory and any parent directories, using the supplied permissions for any directories\nthat get created as a result of this operation. For example if /a exists and\ncreateDirectories(Path(\"/a/b/c\"), Some(p)) is called, /a/b and /a/b/c are created with permissions set\nto p on each (and the permissions of /a remain unmodified).\n"},
{"l":"fs2/io/file/Files.html#createDirectories-74f","e":false,"i":"","n":"createDirectories","t":"createDirectories(path: Path, flags: Seq[FileAttribute[_]]): F[Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a new directory at the given path and creates all nonexistent parent directories beforehand.\n"},
{"l":"fs2/io/file/Files.html#createDirectory-a8b","e":false,"i":"","n":"createDirectory","t":"createDirectory(path: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Creates the specified directory. Fails if the parent path does not already exist.\n"},
{"l":"fs2/io/file/Files.html#createDirectory-2c8","e":false,"i":"","n":"createDirectory","t":"createDirectory(path: Path, permissions: Option[Permissions]): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Creates the specified directory with the specified permissions. Fails if the parent path does not already exist.\n"},
{"l":"fs2/io/file/Files.html#createDirectory-74f","e":false,"i":"","n":"createDirectory","t":"createDirectory(path: Path, flags: Seq[FileAttribute[_]]): F[Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a new directory at the given path.\n"},
{"l":"fs2/io/file/Files.html#createFile-a8b","e":false,"i":"","n":"createFile","t":"createFile(path: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Creates the specified file. Fails if the parent path does not already exist.\n"},
{"l":"fs2/io/file/Files.html#createFile-2c8","e":false,"i":"","n":"createFile","t":"createFile(path: Path, permissions: Option[Permissions]): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Creates the specified file with the specified permissions. Fails if the parent path does not already exist.\n"},
{"l":"fs2/io/file/Files.html#createLink-b83","e":false,"i":"","n":"createLink","t":"createLink(link: Path, existing: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Creates a hard link with an existing file."},
{"l":"fs2/io/file/Files.html#createSymbolicLink-b83","e":false,"i":"","n":"createSymbolicLink","t":"createSymbolicLink(link: Path, target: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Creates a symbolic link which points to the supplied target."},
{"l":"fs2/io/file/Files.html#createSymbolicLink-ffffffc0","e":false,"i":"","n":"createSymbolicLink","t":"createSymbolicLink(link: Path, target: Path, permissions: Option[Permissions]): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Creates a symbolic link which points to the supplied target. If defined, the supplied permissions are set on the created link."},
{"l":"fs2/io/file/Files.html#createTempDirectory-0","e":false,"i":"","n":"createTempDirectory","t":"createTempDirectory: F[Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a temporary directory.\nThe created directory is not automatically deleted - it is up to the operating system to decide when the file is deleted.\nAlternatively, use tempDirectory to get a resource which deletes upon resource finalization.\n"},
{"l":"fs2/io/file/Files.html#createTempDirectory-172","e":false,"i":"","n":"createTempDirectory","t":"createTempDirectory(dir: Option[Path], prefix: String, permissions: Option[Permissions]): F[Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a temporary directory.\nThe created directory is not automatically deleted - it is up to the operating system to decide when the file is deleted.\nAlternatively, use tempDirectory to get a resource which deletes upon resource finalization.\n"},
{"l":"fs2/io/file/Files.html#createTempFile-0","e":false,"i":"","n":"createTempFile","t":"createTempFile: F[Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a temporary file.\nThe created file is not automatically deleted - it is up to the operating system to decide when the file is deleted.\nAlternatively, use tempFile to get a resource, which is deleted upon resource finalization.\n"},
{"l":"fs2/io/file/Files.html#createTempFile-a57","e":false,"i":"","n":"createTempFile","t":"createTempFile(dir: Option[Path], prefix: String, suffix: String, permissions: Option[Permissions]): F[Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a temporary file.\nThe created file is not automatically deleted - it is up to the operating system to decide when the file is deleted.\nAlternatively, use tempFile to get a resource which deletes upon resource finalization.\n"},
{"l":"fs2/io/file/Files.html#currentWorkingDirectory-0","e":false,"i":"","n":"currentWorkingDirectory","t":"currentWorkingDirectory: F[Path]","d":"fs2.io.file.Files","k":"def","x":"User's current working directory"},
{"l":"fs2/io/file/Files.html#delete-a8b","e":false,"i":"","n":"delete","t":"delete(path: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Deletes the specified file or empty directory, failing if it does not exist."},
{"l":"fs2/io/file/Files.html#delete-fffff6e4","e":false,"i":"","n":"delete","t":"delete(path: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Deletes a file."},
{"l":"fs2/io/file/Files.html#deleteDirectoryRecursively-152","e":false,"i":"","n":"deleteDirectoryRecursively","t":"deleteDirectoryRecursively(path: Path, options: Set[FileVisitOption]): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Recursively delete a directory\n"},
{"l":"fs2/io/file/Files.html#deleteIfExists-a8b","e":false,"i":"","n":"deleteIfExists","t":"deleteIfExists(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Deletes the specified file or empty directory, passing if it does not exist."},
{"l":"fs2/io/file/Files.html#deleteIfExists-fffff6e4","e":false,"i":"","n":"deleteIfExists","t":"deleteIfExists(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Like delete, but will not fail when the path doesn't exist.\n"},
{"l":"fs2/io/file/Files.html#deleteRecursively-a8b","e":false,"i":"","n":"deleteRecursively","t":"deleteRecursively(path: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Deletes the specified file or directory.\nIf the path is a directory and is non-empty, its contents are recursively deleted.\nSymbolic links are not followed (but are deleted).\n"},
{"l":"fs2/io/file/Files.html#deleteRecursively-fffff2fb","e":false,"i":"","n":"deleteRecursively","t":"deleteRecursively(path: Path, followLinks: Boolean): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Deletes the specified file or directory.\nIf the path is a directory and is non-empty, its contents are recursively deleted.\nSymbolic links are followed when followLinks is true.\n"},
{"l":"fs2/io/file/Files.html#directoryStream-fffffcdf","e":false,"i":"","n":"directoryStream","t":"directoryStream(path: Path, glob: String): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a stream of Paths inside a directory which match the given glob.\n"},
{"l":"fs2/io/file/Files.html#directoryStream-5c9","e":false,"i":"","n":"directoryStream","t":"directoryStream(path: Path, filter: Path => Boolean): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a stream of Paths inside a directory, filtering the results by the given predicate.\n"},
{"l":"fs2/io/file/Files.html#directoryStream-fffff2ba","e":false,"i":"","n":"directoryStream","t":"directoryStream(path: Path): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a stream of Paths inside a directory.\n"},
{"l":"fs2/io/file/Files.html#exists-a8b","e":false,"i":"","n":"exists","t":"exists(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the specified path exists.\nSymbolic links are followed -- see the overload for more details on links.\n"},
{"l":"fs2/io/file/Files.html#exists-fffff2fb","e":false,"i":"","n":"exists","t":"exists(path: Path, followLinks: Boolean): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the specified path exists.\nSymbolic links are followed when followLinks is true.\nFor example, if the symbolic link foo points to bar and bar does not exist,\nexists(Path(\"foo\"), true) returns false but exists(Path(\"foo\"), false) returns true.\n"},
{"l":"fs2/io/file/Files.html#exists-74f","e":false,"i":"","n":"exists","t":"exists(path: Path, flags: Seq[LinkOption]): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Checks if a file exists."},
{"l":"fs2/io/file/Files.html#getBasicFileAttributes-a8b","e":false,"i":"","n":"getBasicFileAttributes","t":"getBasicFileAttributes(path: Path): F[BasicFileAttributes]","d":"fs2.io.file.Files","k":"def","x":"Gets BasicFileAttributes for the supplied path. Symbolic links are not followed."},
{"l":"fs2/io/file/Files.html#getBasicFileAttributes-fffff2fb","e":false,"i":"","n":"getBasicFileAttributes","t":"getBasicFileAttributes(path: Path, followLinks: Boolean): F[BasicFileAttributes]","d":"fs2.io.file.Files","k":"def","x":"Gets BasicFileAttributes for the supplied path. Symbolic links are followed when followLinks is true."},
{"l":"fs2/io/file/Files.html#getLastModifiedTime-a8b","e":false,"i":"","n":"getLastModifiedTime","t":"getLastModifiedTime(path: Path): F[FiniteDuration]","d":"fs2.io.file.Files","k":"def","x":"Gets the last modified time of the supplied path.\nThe last modified time is represented as a duration since the Unix epoch.\nSymbolic links are followed.\n"},
{"l":"fs2/io/file/Files.html#getLastModifiedTime-fffff2fb","e":false,"i":"","n":"getLastModifiedTime","t":"getLastModifiedTime(path: Path, followLinks: Boolean): F[FiniteDuration]","d":"fs2.io.file.Files","k":"def","x":"Gets the last modified time of the supplied path.\nThe last modified time is represented as a duration since the Unix epoch.\nSymbolic links are followed when followLinks is true.\n"},
{"l":"fs2/io/file/Files.html#getPosixFileAttributes-a8b","e":false,"i":"","n":"getPosixFileAttributes","t":"getPosixFileAttributes(path: Path): F[PosixFileAttributes]","d":"fs2.io.file.Files","k":"def","x":"Gets the POSIX attributes for the supplied path.\nSymbolic links are not followed.\n"},
{"l":"fs2/io/file/Files.html#getPosixFileAttributes-fffff2fb","e":false,"i":"","n":"getPosixFileAttributes","t":"getPosixFileAttributes(path: Path, followLinks: Boolean): F[PosixFileAttributes]","d":"fs2.io.file.Files","k":"def","x":"Gets the POSIX attributes for the supplied path.\nSymbolic links are followed when followLinks is true.\n"},
{"l":"fs2/io/file/Files.html#getPosixPermissions-a8b","e":false,"i":"","n":"getPosixPermissions","t":"getPosixPermissions(path: Path): F[PosixPermissions]","d":"fs2.io.file.Files","k":"def","x":"Gets the POSIX permissions of the supplied path.\nSymbolic links are followed.\n"},
{"l":"fs2/io/file/Files.html#getPosixPermissions-fffff2fb","e":false,"i":"","n":"getPosixPermissions","t":"getPosixPermissions(path: Path, followLinks: Boolean): F[PosixPermissions]","d":"fs2.io.file.Files","k":"def","x":"Gets the POSIX permissions of the supplied path.\nSymbolic links are followed when followLinks is true.\n"},
{"l":"fs2/io/file/Files.html#isDirectory-a8b","e":false,"i":"","n":"isDirectory","t":"isDirectory(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied path exists and is a directory. Symbolic links are followed."},
{"l":"fs2/io/file/Files.html#isDirectory-fffff2fb","e":false,"i":"","n":"isDirectory","t":"isDirectory(path: Path, followLinks: Boolean): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied path exists and is a directory. Symbolic links are followed when followLinks is true."},
{"l":"fs2/io/file/Files.html#isDirectory-74f","e":false,"i":"","n":"isDirectory","t":"isDirectory(path: Path, linkOption: Seq[LinkOption]): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Tests whether a file is a directory."},
{"l":"fs2/io/file/Files.html#isExecutable-a8b","e":false,"i":"","n":"isExecutable","t":"isExecutable(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied path exists and is executable."},
{"l":"fs2/io/file/Files.html#isFile-74f","e":false,"i":"","n":"isFile","t":"isFile(path: Path, linkOption: Seq[LinkOption]): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Tests whether a file is a regular file with opaque content."},
{"l":"fs2/io/file/Files.html#isHidden-a8b","e":false,"i":"","n":"isHidden","t":"isHidden(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied path is a hidden file (note: may not check for existence)."},
{"l":"fs2/io/file/Files.html#isReadable-a8b","e":false,"i":"","n":"isReadable","t":"isReadable(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied path exists and is readable."},
{"l":"fs2/io/file/Files.html#isRegularFile-a8b","e":false,"i":"","n":"isRegularFile","t":"isRegularFile(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied path is a regular file. Symbolic links are followed."},
{"l":"fs2/io/file/Files.html#isRegularFile-fffff2fb","e":false,"i":"","n":"isRegularFile","t":"isRegularFile(path: Path, followLinks: Boolean): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied path is a regular file. Symbolic links are followed when followLinks is true."},
{"l":"fs2/io/file/Files.html#isSameFile-b83","e":false,"i":"","n":"isSameFile","t":"isSameFile(path1: Path, path2: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied paths reference the same file."},
{"l":"fs2/io/file/Files.html#isSymbolicLink-a8b","e":false,"i":"","n":"isSymbolicLink","t":"isSymbolicLink(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied path is a symbolic link."},
{"l":"fs2/io/file/Files.html#isWritable-a8b","e":false,"i":"","n":"isWritable","t":"isWritable(path: Path): F[Boolean]","d":"fs2.io.file.Files","k":"def","x":"Returns true if the supplied path exists and is writable."},
{"l":"fs2/io/file/Files.html#lineSeparator-0","e":false,"i":"","n":"lineSeparator","t":"lineSeparator: String","d":"fs2.io.file.Files","k":"def","x":"Returns the line separator for the specific OS"},
{"l":"fs2/io/file/Files.html#list-ffffffa1","e":false,"i":"","n":"list","t":"list(path: Path): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Gets the contents of the specified directory."},
{"l":"fs2/io/file/Files.html#list-fffffbc6","e":false,"i":"","n":"list","t":"list(path: Path, glob: String): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Gets the contents of the specified directory whose paths match the supplied glob pattern."},
{"l":"fs2/io/file/Files.html#move-b83","e":false,"i":"","n":"move","t":"move(source: Path, target: Path): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Moves the source to the target, failing if source does not exist or the target already exists.\nTo replace the existing instead, use move(source, target, CopyFlags(CopyFlag.ReplaceExisting)).\n"},
{"l":"fs2/io/file/Files.html#move-fffffec2","e":false,"i":"","n":"move","t":"move(source: Path, target: Path, flags: CopyFlags): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Moves the source to the target, following any directives supplied in the flags.\nBy default, an error occurs if the target already exists, though this can be overriden via CopyFlag.ReplaceExisting.\n"},
{"l":"fs2/io/file/Files.html#move-ea0","e":false,"i":"","n":"move","t":"move(source: Path, target: Path, flags: Seq[CopyOption]): F[Path]","d":"fs2.io.file.Files","k":"def","x":"Moves (or renames) a file from the source to the target path."},
{"l":"fs2/io/file/Files.html#open-fffff277","e":false,"i":"","n":"open","t":"open(path: Path, flags: Flags): Resource[F, FileHandle[F]]","d":"fs2.io.file.Files","k":"def","x":"Creates a FileHandle for the file at the supplied Path.\nThe supplied flags indicate the mode used when opening the file (e.g. read, write, append)\nas well as the ability to specify additional options (e.g. automatic deletion at process exit).\n"},
{"l":"fs2/io/file/Files.html#open-2d7","e":false,"i":"","n":"open","t":"open(path: Path, flags: Seq[OpenOption]): Resource[F, FileHandle[F]]","d":"fs2.io.file.Files","k":"def","x":"Creates a FileHandle for the file at the supplied Path."},
{"l":"fs2/io/file/Files.html#openFileChannel-fffff0a0","e":false,"i":"","n":"openFileChannel","t":"openFileChannel(channel: F[FileChannel]): Resource[F, FileHandle[F]]","d":"fs2.io.file.Files","k":"def","x":"Creates a FileHandle for the supplied NIO FileChannel. JVM only."},
{"l":"fs2/io/file/Files.html#openSeekableByteChannel-156","e":false,"i":"","n":"openSeekableByteChannel","t":"openSeekableByteChannel(channel: F[SeekableByteChannel], unsupportedOperationException: => Throwable): Resource[F, FileHandle[F]]","d":"fs2.io.file.Files","k":"def","x":"Creates a FileHandle for the supplied NIO SeekableByteChannel. Because a SeekableByteChannel doesn't provide all the functionalities required by FileHandle some features like locking will be unavailable. JVM only."},
{"l":"fs2/io/file/Files.html#permissions-74f","e":false,"i":"","n":"permissions","t":"permissions(path: Path, flags: Seq[LinkOption]): F[Set[PosixFilePermission]]","d":"fs2.io.file.Files","k":"def","x":"Get file permissions as set of PosixFilePermission."},
{"l":"fs2/io/file/Files.html#readAll-ffffffa1","e":false,"i":"","n":"readAll","t":"readAll(path: Path): Stream[F, Byte]","d":"fs2.io.file.Files","k":"def","x":"Reads all bytes from the file specified."},
{"l":"fs2/io/file/Files.html#readAll-fffffd2e","e":false,"i":"","n":"readAll","t":"readAll(path: Path, chunkSize: Int, flags: Flags): Stream[F, Byte]","d":"fs2.io.file.Files","k":"def","x":"Reads all bytes from the file specified, reading in chunks up to the specified limit,\nand using the supplied flags to open the file.\n"},
{"l":"fs2/io/file/Files.html#readAll-fffff41f","e":false,"i":"","n":"readAll","t":"readAll(path: Path, chunkSize: Int): Stream[F, Byte]","d":"fs2.io.file.Files","k":"def","x":"Reads all data from the file at the specified java.nio.file.Path.\n"},
{"l":"fs2/io/file/Files.html#readCursor-fffff277","e":false,"i":"","n":"readCursor","t":"readCursor(path: Path, flags: Flags): Resource[F, ReadCursor[F]]","d":"fs2.io.file.Files","k":"def","x":"Returns a ReadCursor for the specified path, using the supplied flags when opening the file."},
{"l":"fs2/io/file/Files.html#readCursor-2d7","e":false,"i":"","n":"readCursor","t":"readCursor(path: Path, flags: Seq[OpenOption]): Resource[F, ReadCursor[F]]","d":"fs2.io.file.Files","k":"def","x":"Returns a ReadCursor for the specified path. The READ option is added to the supplied flags.\n"},
{"l":"fs2/io/file/Files.html#readCursor-422","e":false,"i":"","n":"readCursor","t":"readCursor(path: Path): Resource[F, ReadCursor[F]]","d":"fs2.io.file.Files","k":"def","x":"Returns a ReadCursor for the specified path.\n"},
{"l":"fs2/io/file/Files.html#readRange-b20","e":false,"i":"","n":"readRange","t":"readRange(path: Path, chunkSize: Int, start: Long, end: Long): Stream[F, Byte]","d":"fs2.io.file.Files","k":"def","x":"Reads a range of data synchronously from the file at the specified path.\nstart is inclusive, end is exclusive, so when start is 0 and end is 2,\ntwo bytes are read.\n"},
{"l":"fs2/io/file/Files.html#readRange-aa7","e":false,"i":"","n":"readRange","t":"readRange(path: Path, chunkSize: Int, start: Long, end: Long): Stream[F, Byte]","d":"fs2.io.file.Files","k":"def","x":"Reads a range of data synchronously from the file at the specified java.nio.file.Path.\nstart is inclusive, end is exclusive, so when start is 0 and end is 2,\ntwo bytes are read.\n"},
{"l":"fs2/io/file/Files.html#readUtf8-ffffffa1","e":false,"i":"","n":"readUtf8","t":"readUtf8(path: Path): Stream[F, String]","d":"fs2.io.file.Files","k":"def","x":"Reads all bytes from the file specified and decodes them as a utf8 string."},
{"l":"fs2/io/file/Files.html#readUtf8Lines-ffffffa1","e":false,"i":"","n":"readUtf8Lines","t":"readUtf8Lines(path: Path): Stream[F, String]","d":"fs2.io.file.Files","k":"def","x":"Reads all bytes from the file specified and decodes them as utf8 lines."},
{"l":"fs2/io/file/Files.html#realPath-a8b","e":false,"i":"","n":"realPath","t":"realPath(path: Path): F[Path]","d":"fs2.io.file.Files","k":"def","x":"Returns the real path i.e. the actual location of path.\nThe precise definition of this method is implementation dependent but in general\nit derives from this path, an absolute path that locates the same file as this path,\nbut with name elements that represent the actual name of the directories and the file.\n"},
{"l":"fs2/io/file/Files.html#setFileTimes-624","e":false,"i":"","n":"setFileTimes","t":"setFileTimes(path: Path, lastModified: Option[FiniteDuration], lastAccess: Option[FiniteDuration], creationTime: Option[FiniteDuration], followLinks: Boolean): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Sets the last modified, last access, and creation time fields of the specified path."},
{"l":"fs2/io/file/Files.html#setPermissions-152","e":false,"i":"","n":"setPermissions","t":"setPermissions(path: Path, permissions: Set[PosixFilePermission]): F[Path]","d":"fs2.io.file.Files","k":"def","x":"Set file permissions from set of PosixFilePermission."},
{"l":"fs2/io/file/Files.html#setPosixPermissions-8df","e":false,"i":"","n":"setPosixPermissions","t":"setPosixPermissions(path: Path, permissions: PosixPermissions): F[Unit]","d":"fs2.io.file.Files","k":"def","x":"Sets the POSIX permissions for the supplied path. Fails on non-POSIX file systems."},
{"l":"fs2/io/file/Files.html#size-a8b","e":false,"i":"","n":"size","t":"size(path: Path): F[Long]","d":"fs2.io.file.Files","k":"def","x":"Gets the size of the supplied path, failing if it does not exist."},
{"l":"fs2/io/file/Files.html#size-fffff6e4","e":false,"i":"","n":"size","t":"size(path: Path): F[Long]","d":"fs2.io.file.Files","k":"def","x":"Returns the size of a file (in bytes).\n"},
{"l":"fs2/io/file/Files.html#tail-2aa","e":false,"i":"","n":"tail","t":"tail(path: Path, chunkSize: Int, offset: Long, pollDelay: FiniteDuration): Stream[F, Byte]","d":"fs2.io.file.Files","k":"def","x":"Returns an infinite stream of data from the file at the specified path.\nStarts reading from the specified offset and upon reaching the end of the file,\npolls every pollDuration for additional updates to the file."},
{"l":"fs2/io/file/Files.html#tail-fffffbf1","e":false,"i":"","n":"tail","t":"tail(path: Path, chunkSize: Int, offset: Long, pollDelay: FiniteDuration): Stream[F, Byte]","d":"fs2.io.file.Files","k":"def","x":"Returns an infinite stream of data from the file at the specified path.\nStarts reading from the specified offset and upon reaching the end of the file,\npolls every pollDuration for additional updates to the file."},
{"l":"fs2/io/file/Files.html#tempDirectory-0","e":false,"i":"","n":"tempDirectory","t":"tempDirectory: Resource[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a temporary directory and deletes it upon finalization of the returned resource.\n"},
{"l":"fs2/io/file/Files.html#tempDirectory-4d4","e":false,"i":"","n":"tempDirectory","t":"tempDirectory(dir: Option[Path], prefix: String, permissions: Option[Permissions]): Resource[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a temporary directory and deletes it upon finalization of the returned resource.\n"},
{"l":"fs2/io/file/Files.html#tempDirectory-a6","e":false,"i":"","n":"tempDirectory","t":"tempDirectory(dir: Option[Path], prefix: String, attributes: Seq[FileAttribute[_]]): Resource[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a Resource which can be used to create a temporary directory.\nThe directory is created during resource allocation, and removed during its release.\n"},
{"l":"fs2/io/file/Files.html#tempFile-0","e":false,"i":"","n":"tempFile","t":"tempFile: Resource[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a temporary file and deletes it upon finalization of the returned resource."},
{"l":"fs2/io/file/Files.html#tempFile-acf","e":false,"i":"","n":"tempFile","t":"tempFile(dir: Option[Path], prefix: String, suffix: String, permissions: Option[Permissions]): Resource[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a temporary file and deletes it upon finalization of the returned resource.\n"},
{"l":"fs2/io/file/Files.html#tempFile-fffffde1","e":false,"i":"","n":"tempFile","t":"tempFile(dir: Option[Path], prefix: String, suffix: String, attributes: Seq[FileAttribute[_]]): Resource[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a Resource which can be used to create a temporary file.\nThe file is created during resource allocation, and removed during its release.\n"},
{"l":"fs2/io/file/Files.html#userHome-0","e":false,"i":"","n":"userHome","t":"userHome: F[Path]","d":"fs2.io.file.Files","k":"def","x":"User's home directory"},
{"l":"fs2/io/file/Files.html#walk-ffffffa1","e":false,"i":"","n":"walk","t":"walk(start: Path): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a stream of paths contained in a given file tree. Depth is unlimited."},
{"l":"fs2/io/file/Files.html#walk-fffff893","e":false,"i":"","n":"walk","t":"walk(start: Path, options: WalkOptions): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a stream of paths contained in a given file tree."},
{"l":"fs2/io/file/Files.html#walk-9fa","e":false,"i":"","n":"walk","t":"walk(start: Path, maxDepth: Int, followLinks: Boolean): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a stream of paths contained in a given file tree down to a given depth.\n"},
{"l":"fs2/io/file/Files.html#walk-fffff20a","e":false,"i":"","n":"walk","t":"walk(start: Path, maxDepth: Int, options: Seq[FileVisitOption]): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a stream of JPaths contained in a given file tree down to a given depth.\n"},
{"l":"fs2/io/file/Files.html#walk-ffffff65","e":false,"i":"","n":"walk","t":"walk(start: Path, options: Seq[FileVisitOption]): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a stream of JPaths contained in a given file tree, respecting the supplied options. Depth is unlimited.\n"},
{"l":"fs2/io/file/Files.html#walk-fffff2ba","e":false,"i":"","n":"walk","t":"walk(start: Path): Stream[F, Path]","d":"fs2.io.file.Files","k":"def","x":"Creates a stream of JPaths contained in a given file tree. Depth is unlimited.\n"},
{"l":"fs2/io/file/Files.html#walkWithAttributes-ffffffa1","e":false,"i":"","n":"walkWithAttributes","t":"walkWithAttributes(start: Path): Stream[F, PathInfo]","d":"fs2.io.file.Files","k":"def","x":"Like walk but returns a PathInfo, which provides both the Path and BasicFileAttributes."},
{"l":"fs2/io/file/Files.html#walkWithAttributes-fffff893","e":false,"i":"","n":"walkWithAttributes","t":"walkWithAttributes(start: Path, options: WalkOptions): Stream[F, PathInfo]","d":"fs2.io.file.Files","k":"def","x":"Like walk but returns a PathInfo, which provides both the Path and BasicFileAttributes."},
{"l":"fs2/io/file/Files.html#watch-d45","e":false,"i":"","n":"watch","t":"watch(path: Path, types: Seq[EventType], modifiers: Seq[Modifier], pollTimeout: FiniteDuration): Stream[F, Event]","d":"fs2.io.file.Files","k":"def","x":"Watches a single path."},
{"l":"fs2/io/file/Files.html#watch-ffffffa1","e":false,"i":"","n":"watch","t":"watch(path: Path): Stream[F, Event]","d":"fs2.io.file.Files","k":"def","x":"Watches a single path."},
{"l":"fs2/io/file/Files.html#watch-fde","e":false,"i":"","n":"watch","t":"watch(path: Path, types: Seq[EventType], modifiers: Seq[Modifier], pollTimeout: FiniteDuration): Stream[F, Event]","d":"fs2.io.file.Files","k":"def","x":"Watches a single path."},
{"l":"fs2/io/file/Files.html#watcher-0","e":false,"i":"","n":"watcher","t":"watcher: Resource[F, Watcher[F]]","d":"fs2.io.file.Files","k":"def","x":"Creates a Watcher for the default file system."},
{"l":"fs2/io/file/Files.html#writeAll-499","e":false,"i":"","n":"writeAll","t":"writeAll(path: Path): (F, Byte) => Nothing","d":"fs2.io.file.Files","k":"def","x":"Writes all data to the file at the specified path."},
{"l":"fs2/io/file/Files.html#writeAll-ef5","e":false,"i":"","n":"writeAll","t":"writeAll(path: Path, flags: Flags): (F, Byte) => Nothing","d":"fs2.io.file.Files","k":"def","x":"Writes all data to the file at the specified path, using the\nspecified flags to open the file.\n"},
{"l":"fs2/io/file/Files.html#writeAll-f55","e":false,"i":"","n":"writeAll","t":"writeAll(path: Path, flags: Seq[StandardOpenOption]): (F, Byte) => Nothing","d":"fs2.io.file.Files","k":"def","x":"Writes all data to the file at the specified java.nio.file.JPath."},
{"l":"fs2/io/file/Files.html#writeCursor-fffff277","e":false,"i":"","n":"writeCursor","t":"writeCursor(path: Path, flags: Flags): Resource[F, WriteCursor[F]]","d":"fs2.io.file.Files","k":"def","x":"Returns a WriteCursor for the specified path.\n"},
{"l":"fs2/io/file/Files.html#writeCursor-2d7","e":false,"i":"","n":"writeCursor","t":"writeCursor(path: Path, flags: Seq[OpenOption]): Resource[F, WriteCursor[F]]","d":"fs2.io.file.Files","k":"def","x":"Returns a WriteCursor for the specified path."},
{"l":"fs2/io/file/Files.html#writeCursorFromFileHandle-efc","e":false,"i":"","n":"writeCursorFromFileHandle","t":"writeCursorFromFileHandle(file: FileHandle[F], append: Boolean): F[WriteCursor[F]]","d":"fs2.io.file.Files","k":"def","x":"Returns a WriteCursor for the specified file handle."},
{"l":"fs2/io/file/Files.html#writeRotate-fffff614","e":false,"i":"","n":"writeRotate","t":"writeRotate(computePath: F[Path], limit: Long, flags: Flags): (F, Byte) => Nothing","d":"fs2.io.file.Files","k":"def","x":"Writes all data to a sequence of files, each limited in size to limit."},
{"l":"fs2/io/file/Files.html#writeRotate-fffff44f","e":false,"i":"","n":"writeRotate","t":"writeRotate(computePath: F[Path], limit: Long, flags: Seq[StandardOpenOption]): (F, Byte) => Nothing","d":"fs2.io.file.Files","k":"def","x":"Writes all data to a sequence of files, each limited in size to limit."},
{"l":"fs2/io/file/Files.html#writeUtf8-499","e":false,"i":"","n":"writeUtf8","t":"writeUtf8(path: Path): (F, String) => Nothing","d":"fs2.io.file.Files","k":"def","x":"Writes to the specified file as an utf8 string."},
{"l":"fs2/io/file/Files.html#writeUtf8-ef5","e":false,"i":"","n":"writeUtf8","t":"writeUtf8(path: Path, flags: Flags): (F, String) => Nothing","d":"fs2.io.file.Files","k":"def","x":"Writes to the specified file as an utf8 string using\nthe specified flags to open the file.\n"},
{"l":"fs2/io/file/Files.html#writeUtf8Lines-499","e":false,"i":"","n":"writeUtf8Lines","t":"writeUtf8Lines(path: Path): (F, String) => Nothing","d":"fs2.io.file.Files","k":"def","x":"Writes each string to the specified file as utf8 lines."},
{"l":"fs2/io/file/Files.html#writeUtf8Lines-ef5","e":false,"i":"","n":"writeUtf8Lines","t":"writeUtf8Lines(path: Path, flags: Flags): (F, String) => Nothing","d":"fs2.io.file.Files","k":"def","x":"Writes each string to the specified file as utf8 lines\nusing the specified flags to open the file.\n"},
{"l":"fs2/io/file/Files$.html#","e":false,"i":"","n":"Files","t":"Files","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/Files$.html#apply-c71","e":false,"i":"","n":"apply","t":"apply[F[_]](implicit F: Files[F]): Files[F]","d":"fs2.io.file.Files","k":"def","x":""},
{"l":"fs2/io/file/Files$.html#forAsync-53c","e":false,"i":"","n":"forAsync","t":"forAsync[F[_] : Async]: Files[F]","d":"fs2.io.file.Files","k":"def","x":""},
{"l":"fs2/io/file/Files$.html#forIO-0","e":false,"i":"","n":"forIO","t":"forIO: Files[IO]","d":"fs2.io.file.Files","k":"def","x":""},
{"l":"fs2/io/file/Files$.html#forLiftIO-fffff51f","e":false,"i":"","n":"forLiftIO","t":"forLiftIO[F[_] : LiftIO]: Files[F]","d":"fs2.io.file.Files","k":"def","x":""},
{"l":"fs2/io/file/Files$.html#implicitForAsync-53c","e":false,"i":"","n":"implicitForAsync","t":"implicitForAsync[F[_] : Async]: Files[F]","d":"fs2.io.file.Files","k":"def","x":""},
{"l":"fs2/io/file/Flag.html#","e":false,"i":"","n":"Flag","t":"Flag extends AnyVal","d":"fs2.io.file","k":"class","x":""},
{"l":"fs2/io/file/Flag$.html#","e":false,"i":"","n":"Flag","t":"Flag","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/Flag$.html#Append-0","e":false,"i":"","n":"Append","t":"Append: Flag","d":"fs2.io.file.Flag","k":"val","x":"When combined with Write, writes are done at the end of the file."},
{"l":"fs2/io/file/Flag$.html#Create-0","e":false,"i":"","n":"Create","t":"Create: Flag","d":"fs2.io.file.Flag","k":"val","x":"Creates the file if it does not exist."},
{"l":"fs2/io/file/Flag$.html#CreateNew-0","e":false,"i":"","n":"CreateNew","t":"CreateNew: Flag","d":"fs2.io.file.Flag","k":"val","x":"Creates the file if it does not exist and fails if it already exists."},
{"l":"fs2/io/file/Flag$.html#DeleteOnClose-0","e":false,"i":"","n":"DeleteOnClose","t":"DeleteOnClose: Flag","d":"fs2.io.file.Flag","k":"val","x":""},
{"l":"fs2/io/file/Flag$.html#Dsync-0","e":false,"i":"","n":"Dsync","t":"Dsync: Flag","d":"fs2.io.file.Flag","k":"val","x":"Requires all updates to the file content be written synchronously to underlying storage."},
{"l":"fs2/io/file/Flag$.html#Read-0","e":false,"i":"","n":"Read","t":"Read: Flag","d":"fs2.io.file.Flag","k":"val","x":"Open file for read access."},
{"l":"fs2/io/file/Flag$.html#Sparse-0","e":false,"i":"","n":"Sparse","t":"Sparse: Flag","d":"fs2.io.file.Flag","k":"val","x":""},
{"l":"fs2/io/file/Flag$.html#Sync-0","e":false,"i":"","n":"Sync","t":"Sync: Flag","d":"fs2.io.file.Flag","k":"val","x":"Requires all updates to the file content and metadata be written synchronously to underlying storage."},
{"l":"fs2/io/file/Flag$.html#Truncate-0","e":false,"i":"","n":"Truncate","t":"Truncate: Flag","d":"fs2.io.file.Flag","k":"val","x":"When combined with Write, truncates the file to 0 bytes when opening."},
{"l":"fs2/io/file/Flag$.html#Write-0","e":false,"i":"","n":"Write","t":"Write: Flag","d":"fs2.io.file.Flag","k":"val","x":"Open file for write access."},
{"l":"fs2/io/file/Flag$.html#fromOpenOption-a16","e":false,"i":"","n":"fromOpenOption","t":"fromOpenOption(option: OpenOption): Flag","d":"fs2.io.file.Flag","k":"def","x":""},
{"l":"fs2/io/file/Flags.html#","e":false,"i":"","n":"Flags","t":"Flags(value: List[Flag])","d":"fs2.io.file","k":"class","x":"Flags describing how a file should be opened by Files[F].open(path, flags)."},
{"l":"fs2/io/file/Flags.html#addIfAbsent-fffffde9","e":false,"i":"","n":"addIfAbsent","t":"addIfAbsent(flag: Flag): Flags","d":"fs2.io.file.Flags","k":"def","x":""},
{"l":"fs2/io/file/Flags.html#contains-bb5","e":false,"i":"","n":"contains","t":"contains(flag: Flag): Boolean","d":"fs2.io.file.Flags","k":"def","x":""},
{"l":"fs2/io/file/Flags$.html#","e":false,"i":"","n":"Flags","t":"Flags","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/Flags$.html#Append-0","e":false,"i":"","n":"Append","t":"Append: Flags","d":"fs2.io.file.Flags","k":"val","x":"Flags used for opening a file for appending, creating it if it doesn't exist."},
{"l":"fs2/io/file/Flags$.html#Read-0","e":false,"i":"","n":"Read","t":"Read: Flags","d":"fs2.io.file.Flags","k":"val","x":"Flags used for opening a file for reading."},
{"l":"fs2/io/file/Flags$.html#Write-0","e":false,"i":"","n":"Write","t":"Write: Flags","d":"fs2.io.file.Flags","k":"val","x":"Flags used for opening a file for writing, creating it if it doesn't exist, and truncating it."},
{"l":"fs2/io/file/Flags$.html#apply-d49","e":false,"i":"","n":"apply","t":"apply(flags: Flag*): Flags","d":"fs2.io.file.Flags","k":"def","x":""},
{"l":"fs2/io/file/Flags$.html#fromOpenOptions-a1a","e":false,"i":"","n":"fromOpenOptions","t":"fromOpenOptions(options: Iterable[OpenOption]): Flags","d":"fs2.io.file.Flags","k":"def","x":""},
{"l":"fs2/io/file/Path.html#","e":false,"i":"","n":"Path","t":"Path","d":"fs2.io.file","k":"class","x":"Path to a file or directory on a file system."},
{"l":"fs2/io/file/Path.html#/-d5d","e":false,"i":"","n":"/","t":"/(name: String): Path","d":"fs2.io.file.Path","k":"def","x":"Joins the given path segments together using the platform-specific separator as\na delimiter, then normalizes the resulting path.\n"},
{"l":"fs2/io/file/Path.html#/-1f0","e":false,"i":"","n":"/","t":"/(path: Path): Path","d":"fs2.io.file.Path","k":"def","x":"Joins the given path segments together using the platform-specific separator as\na delimiter, then normalizes the resulting path.\n"},
{"l":"fs2/io/file/Path.html#absolute-0","e":false,"i":"","n":"absolute","t":"absolute: Path","d":"fs2.io.file.Path","k":"def","x":"Returns a Path object representing the absolute path of this path."},
{"l":"fs2/io/file/Path.html#endsWith-fffffd1b","e":false,"i":"","n":"endsWith","t":"endsWith(path: String): Boolean","d":"fs2.io.file.Path","k":"def","x":"Tests if this path ends with the given path.\nIf the given path has N elements, and no root component, and this path has N or more elements,\nthen this path ends with the given path if the last N elements of each path,\nstarting at the element farthest from the root, are equal.\n"},
{"l":"fs2/io/file/Path.html#endsWith-fffff968","e":false,"i":"","n":"endsWith","t":"endsWith(path: Path): Boolean","d":"fs2.io.file.Path","k":"def","x":"Tests if this path ends with the given path.\nIf the given path has N elements, and no root component, and this path has N or more elements,\nthen this path ends with the given path if the last N elements of each path,\nstarting at the element farthest from the root, are equal.\n"},
{"l":"fs2/io/file/Path.html#extName-0","e":false,"i":"","n":"extName","t":"extName: String","d":"fs2.io.file.Path","k":"def","x":"Returns the extension of the path, from the last occurrence of the . (period)\ncharacter to end of string in the last portion of the path.\nIf there is no . in the last portion of the path, or if there are no . characters\nother than the first character of the filename of path, an empty string is returned.\n"},
{"l":"fs2/io/file/Path.html#fileName-0","e":false,"i":"","n":"fileName","t":"fileName: Path","d":"fs2.io.file.Path","k":"def","x":"Returns the name of the file or directory denoted by this path as a Path object.\nThe file name is the farthest element from the root in the directory hierarchy.\n"},
{"l":"fs2/io/file/Path.html#isAbsolute-0","e":false,"i":"","n":"isAbsolute","t":"isAbsolute: Boolean","d":"fs2.io.file.Path","k":"def","x":"Tells whether or not this path is absolute."},
{"l":"fs2/io/file/Path.html#names-0","e":false,"i":"","n":"names","t":"names: Seq[Path]","d":"fs2.io.file.Path","k":"def","x":"Returns the name elements in the path."},
{"l":"fs2/io/file/Path.html#normalize-0","e":false,"i":"","n":"normalize","t":"normalize: Path","d":"fs2.io.file.Path","k":"def","x":"Returns a path that is this path with redundant name elements eliminated."},
{"l":"fs2/io/file/Path.html#parent-0","e":false,"i":"","n":"parent","t":"parent: Option[Path]","d":"fs2.io.file.Path","k":"def","x":"Returns the parent path, or None if this path does not have a parent."},
{"l":"fs2/io/file/Path.html#relativize-1f0","e":false,"i":"","n":"relativize","t":"relativize(path: Path): Path","d":"fs2.io.file.Path","k":"def","x":"Constructs a relative path between this path and a given path."},
{"l":"fs2/io/file/Path.html#resolve-d5d","e":false,"i":"","n":"resolve","t":"resolve(name: String): Path","d":"fs2.io.file.Path","k":"def","x":"Resolve the given path against this path."},
{"l":"fs2/io/file/Path.html#resolve-1f0","e":false,"i":"","n":"resolve","t":"resolve(path: Path): Path","d":"fs2.io.file.Path","k":"def","x":"Resolve the given path against this path."},
{"l":"fs2/io/file/Path.html#resolveSibling-d5d","e":false,"i":"","n":"resolveSibling","t":"resolveSibling(name: String): Path","d":"fs2.io.file.Path","k":"def","x":"Resolves the given path against this path's parent path."},
{"l":"fs2/io/file/Path.html#resolveSibling-1f0","e":false,"i":"","n":"resolveSibling","t":"resolveSibling(path: Path): Path","d":"fs2.io.file.Path","k":"def","x":"Resolves the given path against this path's parent path."},
{"l":"fs2/io/file/Path.html#startsWith-fffffd1b","e":false,"i":"","n":"startsWith","t":"startsWith(path: String): Boolean","d":"fs2.io.file.Path","k":"def","x":"Tests if this path starts with the given path.\nThis path starts with the given path if this path's root component\nstarts with the root component of the given path,\nand this path starts with the same name elements as the given path.\nIf the given path has more name elements than this path then false is returned.\n"},
{"l":"fs2/io/file/Path.html#startsWith-fffff968","e":false,"i":"","n":"startsWith","t":"startsWith(path: Path): Boolean","d":"fs2.io.file.Path","k":"def","x":"Tests if this path starts with the given path.\nThis path starts with the given path if this path's root component\nstarts with the root component of the given path,\nand this path starts with the same name elements as the given path.\nIf the given path has more name elements than this path then false is returned.\n"},
{"l":"fs2/io/file/Path.html#toNioPath-0","e":false,"i":"","n":"toNioPath","t":"toNioPath: Path","d":"fs2.io.file.Path","k":"val","x":""},
{"l":"fs2/io/file/Path$.html#","e":false,"i":"","n":"Path","t":"Path","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/Path$.html#apply-d5d","e":false,"i":"","n":"apply","t":"apply(path: String): Path","d":"fs2.io.file.Path","k":"def","x":""},
{"l":"fs2/io/file/Path$.html#fromFsPath-fffff254","e":false,"i":"","n":"fromFsPath","t":"fromFsPath(fs: FileSystem, path: String): Path","d":"fs2.io.file.Path","k":"def","x":""},
{"l":"fs2/io/file/Path$.html#fromNioPath-fffffe49","e":false,"i":"","n":"fromNioPath","t":"fromNioPath(path: Path): Path","d":"fs2.io.file.Path","k":"def","x":""},
{"l":"fs2/io/file/Path$.html#instances-0","e":false,"i":"","n":"instances","t":"instances: Monoid[Path] & Order[Path] & Hash[Path] & Show[Path]","d":"fs2.io.file.Path","k":"def","x":""},
{"l":"fs2/io/file/PathInfo.html#","e":false,"i":"","n":"PathInfo","t":"PathInfo(path: Path, attributes: BasicFileAttributes)","d":"fs2.io.file","k":"class","x":"Provides a Path and its associated BasicFileAttributes."},
{"l":"fs2/io/file/Permissions.html#","e":false,"i":"","n":"Permissions","t":"Permissions","d":"fs2.io.file","k":"trait","x":"Describes the permissions of a file / directory."},
{"l":"fs2/io/file/Permissions.html#toNioFileAttribute-0","e":false,"i":"","n":"toNioFileAttribute","t":"toNioFileAttribute: FileAttribute[_]","d":"fs2.io.file.Permissions","k":"def","x":""},
{"l":"fs2/io/file/PosixFileAttributes.html#","e":false,"i":"","n":"PosixFileAttributes","t":"PosixFileAttributes extends BasicFileAttributes","d":"fs2.io.file","k":"trait","x":""},
{"l":"fs2/io/file/PosixFileAttributes.html#permissions-0","e":false,"i":"","n":"permissions","t":"permissions: PosixPermissions","d":"fs2.io.file.PosixFileAttributes","k":"def","x":""},
{"l":"fs2/io/file/PosixFileAttributes$.html#","e":false,"i":"","n":"PosixFileAttributes","t":"PosixFileAttributes","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission.html#","e":false,"i":"","n":"PosixPermission","t":"PosixPermission","d":"fs2.io.file","k":"trait","x":""},
{"l":"fs2/io/file/PosixPermission.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission","k":"val","x":""},
{"l":"fs2/io/file/PosixPermission$.html#","e":false,"i":"","n":"PosixPermission","t":"PosixPermission","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$GroupExecute$.html#","e":false,"i":"","n":"GroupExecute","t":"GroupExecute extends PosixPermission","d":"fs2.io.file.PosixPermission","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$GroupExecute$.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission.GroupExecute","k":"val","x":""},
{"l":"fs2/io/file/PosixPermission$$GroupRead$.html#","e":false,"i":"","n":"GroupRead","t":"GroupRead extends PosixPermission","d":"fs2.io.file.PosixPermission","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$GroupRead$.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission.GroupRead","k":"val","x":""},
{"l":"fs2/io/file/PosixPermission$$GroupWrite$.html#","e":false,"i":"","n":"GroupWrite","t":"GroupWrite extends PosixPermission","d":"fs2.io.file.PosixPermission","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$GroupWrite$.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission.GroupWrite","k":"val","x":""},
{"l":"fs2/io/file/PosixPermission$$OthersExecute$.html#","e":false,"i":"","n":"OthersExecute","t":"OthersExecute extends PosixPermission","d":"fs2.io.file.PosixPermission","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$OthersExecute$.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission.OthersExecute","k":"val","x":""},
{"l":"fs2/io/file/PosixPermission$$OthersRead$.html#","e":false,"i":"","n":"OthersRead","t":"OthersRead extends PosixPermission","d":"fs2.io.file.PosixPermission","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$OthersRead$.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission.OthersRead","k":"val","x":""},
{"l":"fs2/io/file/PosixPermission$$OthersWrite$.html#","e":false,"i":"","n":"OthersWrite","t":"OthersWrite extends PosixPermission","d":"fs2.io.file.PosixPermission","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$OthersWrite$.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission.OthersWrite","k":"val","x":""},
{"l":"fs2/io/file/PosixPermission$$OwnerExecute$.html#","e":false,"i":"","n":"OwnerExecute","t":"OwnerExecute extends PosixPermission","d":"fs2.io.file.PosixPermission","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$OwnerExecute$.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission.OwnerExecute","k":"val","x":""},
{"l":"fs2/io/file/PosixPermission$$OwnerRead$.html#","e":false,"i":"","n":"OwnerRead","t":"OwnerRead extends PosixPermission","d":"fs2.io.file.PosixPermission","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$OwnerRead$.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission.OwnerRead","k":"val","x":""},
{"l":"fs2/io/file/PosixPermission$$OwnerWrite$.html#","e":false,"i":"","n":"OwnerWrite","t":"OwnerWrite extends PosixPermission","d":"fs2.io.file.PosixPermission","k":"object","x":""},
{"l":"fs2/io/file/PosixPermission$$OwnerWrite$.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermission.OwnerWrite","k":"val","x":""},
{"l":"fs2/io/file/PosixPermissions.html#","e":false,"i":"","n":"PosixPermissions","t":"PosixPermissions extends Permissions","d":"fs2.io.file","k":"class","x":"Describes POSIX file permissions, where the user, group, and\nothers are each assigned read, write, and/or execute permissions."},
{"l":"fs2/io/file/PosixPermissions.html#add-bd3","e":false,"i":"","n":"add","t":"add(p: PosixPermission): PosixPermissions","d":"fs2.io.file.PosixPermissions","k":"def","x":""},
{"l":"fs2/io/file/PosixPermissions.html#remove-bd3","e":false,"i":"","n":"remove","t":"remove(p: PosixPermission): PosixPermissions","d":"fs2.io.file.PosixPermissions","k":"def","x":""},
{"l":"fs2/io/file/PosixPermissions.html#toNioFileAttribute-0","e":false,"i":"","n":"toNioFileAttribute","t":"toNioFileAttribute: FileAttribute[_]","d":"fs2.io.file.PosixPermissions","k":"def","x":""},
{"l":"fs2/io/file/PosixPermissions.html#toOctalString-0","e":false,"i":"","n":"toOctalString","t":"toOctalString: String","d":"fs2.io.file.PosixPermissions","k":"def","x":""},
{"l":"fs2/io/file/PosixPermissions.html#value-0","e":false,"i":"","n":"value","t":"value: Int","d":"fs2.io.file.PosixPermissions","k":"val","x":""},
{"l":"fs2/io/file/PosixPermissions$.html#","e":false,"i":"","n":"PosixPermissions","t":"PosixPermissions","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/PosixPermissions$.html#apply-fffff5ff","e":false,"i":"","n":"apply","t":"apply(permissions: PosixPermission*): PosixPermissions","d":"fs2.io.file.PosixPermissions","k":"def","x":""},
{"l":"fs2/io/file/PosixPermissions$.html#fromInt-fffff2e4","e":false,"i":"","n":"fromInt","t":"fromInt(value: Int): Option[PosixPermissions]","d":"fs2.io.file.PosixPermissions","k":"def","x":""},
{"l":"fs2/io/file/PosixPermissions$.html#fromOctal-fffffd22","e":false,"i":"","n":"fromOctal","t":"fromOctal(s: String): Option[PosixPermissions]","d":"fs2.io.file.PosixPermissions","k":"def","x":""},
{"l":"fs2/io/file/PosixPermissions$.html#fromString-fffffd22","e":false,"i":"","n":"fromString","t":"fromString(s: String): Option[PosixPermissions]","d":"fs2.io.file.PosixPermissions","k":"def","x":""},
{"l":"fs2/io/file/ReadCursor.html#","e":false,"i":"","n":"ReadCursor","t":"ReadCursor[F[_]](file: FileHandle[F], offset: Long)","d":"fs2.io.file","k":"class","x":"Associates a FileHandle with an offset in to the file."},
{"l":"fs2/io/file/ReadCursor.html#read-29c","e":false,"i":"","n":"read","t":"read(chunkSize: Int)(implicit F: Functor[F]): F[Option[(ReadCursor[F], Chunk[Byte])]]","d":"fs2.io.file.ReadCursor","k":"def","x":"Reads a single chunk from the underlying file handle, returning the\nread chunk and a new cursor with an offset incremented by the chunk size.\n"},
{"l":"fs2/io/file/ReadCursor.html#readAll-fffff1d5","e":false,"i":"","n":"readAll","t":"readAll(chunkSize: Int): Pull[F, Byte, ReadCursor[F]]","d":"fs2.io.file.ReadCursor","k":"def","x":"Reads all chunks from the underlying file handle, returning a cursor\nwith offset incremented by the total number of bytes read.\n"},
{"l":"fs2/io/file/ReadCursor.html#readPull-fffff1d5","e":false,"i":"","n":"readPull","t":"readPull(chunkSize: Int): Pull[F, Nothing, Option[(ReadCursor[F], Chunk[Byte])]]","d":"fs2.io.file.ReadCursor","k":"def","x":"Like read but returns a pull instead of an F[(ReadCursor[F], Option[Chunk[Byte]])].\n"},
{"l":"fs2/io/file/ReadCursor.html#readUntil-ffffff59","e":false,"i":"","n":"readUntil","t":"readUntil(chunkSize: Int, end: Long): Pull[F, Byte, ReadCursor[F]]","d":"fs2.io.file.ReadCursor","k":"def","x":"Reads chunks until the specified end position in the file. Returns a pull that outputs\nthe read chunks and completes with a cursor with offset incremented by the total number\nof bytes read.\n"},
{"l":"fs2/io/file/ReadCursor.html#seek-e63","e":false,"i":"","n":"seek","t":"seek(position: Long): ReadCursor[F]","d":"fs2.io.file.ReadCursor","k":"def","x":"Returns a new cursor with the offset adjusted to the specified position."},
{"l":"fs2/io/file/ReadCursor.html#tail-fffffd10","e":false,"i":"","n":"tail","t":"tail(chunkSize: Int, pollDelay: FiniteDuration)(implicit t: Temporal[F]): Pull[F, Byte, ReadCursor[F]]","d":"fs2.io.file.ReadCursor","k":"def","x":"Returns an infinite stream that reads until the end of the file and then starts\npolling the file for additional writes. Similar to the tail command line utility.\n"},
{"l":"fs2/io/file/ReadCursor$.html#","e":false,"i":"","n":"ReadCursor","t":"ReadCursor","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/ReadCursor$.html#fromPath-fffff40f","e":false,"i":"","n":"fromPath","t":"fromPath[F[_] : Async](path: Path, flags: Seq[OpenOption]): Resource[F, ReadCursor[F]]","d":"fs2.io.file.ReadCursor","k":"def","x":""},
{"l":"fs2/io/file/WalkOptions.html#","e":false,"i":"","n":"WalkOptions","t":"WalkOptions","d":"fs2.io.file","k":"trait","x":"Options that customize a filesystem walk via Files[F].walk."},
{"l":"fs2/io/file/WalkOptions.html#allowCycles-0","e":false,"i":"","n":"allowCycles","t":"allowCycles: Boolean","d":"fs2.io.file.WalkOptions","k":"def","x":"Indicates whether to allow cycles when following links. If true, any link causing a\ncycle is emitted as the link path. If false, a cycle results in walk failing with a FileSystemLoopException.\n"},
{"l":"fs2/io/file/WalkOptions.html#chunkSize-0","e":false,"i":"","n":"chunkSize","t":"chunkSize: Int","d":"fs2.io.file.WalkOptions","k":"def","x":"Size of chunks emitted from the walk."},
{"l":"fs2/io/file/WalkOptions.html#followLinks-0","e":false,"i":"","n":"followLinks","t":"followLinks: Boolean","d":"fs2.io.file.WalkOptions","k":"def","x":"Indicates whether links are followed during the walk. If false, the path of\neach link is emitted. If true, links are followed and their contents are emitted.\n"},
{"l":"fs2/io/file/WalkOptions.html#maxDepth-0","e":false,"i":"","n":"maxDepth","t":"maxDepth: Int","d":"fs2.io.file.WalkOptions","k":"def","x":"Maximum depth to walk. A value of 0 results in emitting just the starting path.\nA value of 1 results in emitting the starting path and all direct descendants.\n"},
{"l":"fs2/io/file/WalkOptions.html#withAllowCycles-502","e":false,"i":"","n":"withAllowCycles","t":"withAllowCycles(value: Boolean): WalkOptions","d":"fs2.io.file.WalkOptions","k":"def","x":"Returns a new WalkOptions with the specified value for allowCycles."},
{"l":"fs2/io/file/WalkOptions.html#withChunkSize-fffffd5b","e":false,"i":"","n":"withChunkSize","t":"withChunkSize(chunkSize: Int): WalkOptions","d":"fs2.io.file.WalkOptions","k":"def","x":"Returns a new WalkOptions with the specified chunk size."},
{"l":"fs2/io/file/WalkOptions.html#withFollowLinks-502","e":false,"i":"","n":"withFollowLinks","t":"withFollowLinks(value: Boolean): WalkOptions","d":"fs2.io.file.WalkOptions","k":"def","x":"Returns a new WalkOptions with the specified value for followLinks."},
{"l":"fs2/io/file/WalkOptions.html#withMaxDepth-fffffd5b","e":false,"i":"","n":"withMaxDepth","t":"withMaxDepth(maxDepth: Int): WalkOptions","d":"fs2.io.file.WalkOptions","k":"def","x":"Returns a new WalkOptions with the specified max depth."},
{"l":"fs2/io/file/WalkOptions$.html#","e":false,"i":"","n":"WalkOptions","t":"WalkOptions","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/WalkOptions$.html#Default-0","e":false,"i":"","n":"Default","t":"Default: WalkOptions","d":"fs2.io.file.WalkOptions","k":"val","x":"Default walk options, using a large chunk size, unlimited depth, and no link following."},
{"l":"fs2/io/file/WalkOptions$.html#Eager-0","e":false,"i":"","n":"Eager","t":"Eager: WalkOptions","d":"fs2.io.file.WalkOptions","k":"val","x":"Like Default but uses the maximum chunk size, hinting the implementation should perform all file system operations before emitting any paths."},
{"l":"fs2/io/file/WalkOptions$.html#Lazy-0","e":false,"i":"","n":"Lazy","t":"Lazy: WalkOptions","d":"fs2.io.file.WalkOptions","k":"val","x":"Like Default but uses the minimum chunk size, hinting the implementation should perform minumum number of file system operations before emitting each path."},
{"l":"fs2/io/file/Watcher.html#","e":false,"i":"","n":"Watcher","t":"Watcher[F[_]]","d":"fs2.io.file","k":"class","x":"Allows watching the file system for changes to directories and files by using the platform's WatchService.\n"},
{"l":"fs2/io/file/Watcher.html#events-fffff8b7","e":false,"i":"","n":"events","t":"events(pollTimeout: FiniteDuration): Stream[F, Event]","d":"fs2.io.file.Watcher","k":"def","x":"Stream of events for paths that have been registered or watched.\n"},
{"l":"fs2/io/file/Watcher.html#register-1a1","e":false,"i":"","n":"register","t":"register(path: Path, types: Seq[EventType], modifiers: Seq[Modifier]): F[F[Unit]]","d":"fs2.io.file.Watcher","k":"def","x":"Registers for events on the specified path."},
{"l":"fs2/io/file/Watcher.html#watch-1a1","e":false,"i":"","n":"watch","t":"watch(path: Path, types: Seq[EventType], modifiers: Seq[Modifier]): F[F[Unit]]","d":"fs2.io.file.Watcher","k":"def","x":"Registers for events on the specified path."},
{"l":"fs2/io/file/Watcher$.html#","e":false,"i":"","n":"Watcher","t":"Watcher","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/Watcher$.html#default-249","e":false,"i":"","n":"default","t":"default[F[_] : Files](implicit evidence$1: Files[F], F: Async[F]): Resource[F, Watcher[F]]","d":"fs2.io.file.Watcher","k":"def","x":"Creates a watcher for the default file system."},
{"l":"fs2/io/file/Watcher$.html#default-54b","e":false,"i":"","n":"default","t":"default[F[_]](F: Async[F]): Resource[F, Watcher[F]]","d":"fs2.io.file.Watcher","k":"def","x":""},
{"l":"fs2/io/file/Watcher$.html#fromFileSystem-4c0","e":false,"i":"","n":"fromFileSystem","t":"fromFileSystem[F[_] : Files](fs: FileSystem)(implicit evidence$1: Files[F], F: Async[F]): Resource[F, Watcher[F]]","d":"fs2.io.file.Watcher","k":"def","x":"Creates a watcher for the supplied file system."},
{"l":"fs2/io/file/Watcher$.html#fromFileSystem-fffff9f4","e":false,"i":"","n":"fromFileSystem","t":"fromFileSystem[F[_]](fs: FileSystem, F: Async[F]): Resource[F, Watcher[F]]","d":"fs2.io.file.Watcher","k":"def","x":""},
{"l":"fs2/io/file/Watcher$.html#fromWatchService-fffffc8b","e":false,"i":"","n":"fromWatchService","t":"fromWatchService[F[_] : Files](ws: WatchService)(implicit evidence$1: Files[F], F: Async[F]): F[Watcher[F]]","d":"fs2.io.file.Watcher","k":"def","x":"Creates a watcher for the supplied NIO WatchService."},
{"l":"fs2/io/file/Watcher$.html#fromWatchService-22d","e":false,"i":"","n":"fromWatchService","t":"fromWatchService[F[_]](ws: WatchService, F: Async[F]): F[Watcher[F]]","d":"fs2.io.file.Watcher","k":"def","x":""},
{"l":"fs2/io/file/Watcher$$Event.html#","e":false,"i":"","n":"Event","t":"Event","d":"fs2.io.file.Watcher","k":"class","x":"Event raised by Watcher. Supports standard events as well as arbitrary non-standard events (via NonStandard)."},
{"l":"fs2/io/file/Watcher$$Event$.html#","e":false,"i":"","n":"Event","t":"Event","d":"fs2.io.file.Watcher","k":"object","x":""},
{"l":"fs2/io/file/Watcher$$Event$.html#fromWatchEvent-fffff6cf","e":false,"i":"","n":"fromWatchEvent","t":"fromWatchEvent(e: WatchEvent[_], registeredDirectory: Path): Event","d":"fs2.io.file.Watcher.Event","k":"def","x":"Converts a NIO WatchEvent to an FS2 Watcher.Event.\n"},
{"l":"fs2/io/file/Watcher$$Event$$Created.html#","e":false,"i":"","n":"Created","t":"Created(path: Path, count: Int) extends Event","d":"fs2.io.file.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/file/Watcher$$Event$$Deleted.html#","e":false,"i":"","n":"Deleted","t":"Deleted(path: Path, count: Int) extends Event","d":"fs2.io.file.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/file/Watcher$$Event$$Modified.html#","e":false,"i":"","n":"Modified","t":"Modified(path: Path, count: Int) extends Event","d":"fs2.io.file.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/file/Watcher$$Event$$NonStandard.html#","e":false,"i":"","n":"NonStandard","t":"NonStandard(event: WatchEvent[_], registeredDirectory: Path) extends Event","d":"fs2.io.file.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/file/Watcher$$Event$$Overflow.html#","e":false,"i":"","n":"Overflow","t":"Overflow(count: Int) extends Event","d":"fs2.io.file.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/file/Watcher$$EventType.html#","e":false,"i":"","n":"EventType","t":"EventType","d":"fs2.io.file.Watcher","k":"class","x":"Type of event raised by Watcher. Supports the standard events types as well as arbitrary non-standard types (via NonStandard)."},
{"l":"fs2/io/file/Watcher$$EventType$.html#","e":false,"i":"","n":"EventType","t":"EventType","d":"fs2.io.file.Watcher","k":"object","x":""},
{"l":"fs2/io/file/Watcher$$EventType$.html#toWatchEventKind-356","e":false,"i":"","n":"toWatchEventKind","t":"toWatchEventKind(et: EventType): Kind[_]","d":"fs2.io.file.Watcher.EventType","k":"def","x":""},
{"l":"fs2/io/file/Watcher$$EventType$$Created$.html#","e":false,"i":"","n":"Created","t":"Created extends EventType","d":"fs2.io.file.Watcher.EventType","k":"object","x":""},
{"l":"fs2/io/file/Watcher$$EventType$$Deleted$.html#","e":false,"i":"","n":"Deleted","t":"Deleted extends EventType","d":"fs2.io.file.Watcher.EventType","k":"object","x":""},
{"l":"fs2/io/file/Watcher$$EventType$$Modified$.html#","e":false,"i":"","n":"Modified","t":"Modified extends EventType","d":"fs2.io.file.Watcher.EventType","k":"object","x":""},
{"l":"fs2/io/file/Watcher$$EventType$$NonStandard.html#","e":false,"i":"","n":"NonStandard","t":"NonStandard(kind: Kind[_]) extends EventType","d":"fs2.io.file.Watcher.EventType","k":"class","x":""},
{"l":"fs2/io/file/Watcher$$EventType$$Overflow$.html#","e":false,"i":"","n":"Overflow","t":"Overflow extends EventType","d":"fs2.io.file.Watcher.EventType","k":"object","x":""},
{"l":"fs2/io/file/WriteCursor.html#","e":false,"i":"","n":"WriteCursor","t":"WriteCursor[F[_]](file: FileHandle[F], offset: Long)","d":"fs2.io.file","k":"class","x":"Associates a FileHandle with an offset in to the file."},
{"l":"fs2/io/file/WriteCursor.html#seek-fffff11e","e":false,"i":"","n":"seek","t":"seek(position: Long): WriteCursor[F]","d":"fs2.io.file.WriteCursor","k":"def","x":"Returns a new cursor with the offset adjusted to the specified position."},
{"l":"fs2/io/file/WriteCursor.html#write-fffffaf5","e":false,"i":"","n":"write","t":"write(bytes: Chunk[Byte])(implicit F: Monad[F]): F[WriteCursor[F]]","d":"fs2.io.file.WriteCursor","k":"def","x":"Writes a single chunk to the underlying file handle, returning a new cursor\nwith an offset incremented by the chunk size.\n"},
{"l":"fs2/io/file/WriteCursor.html#writeAll-557","e":false,"i":"","n":"writeAll","t":"writeAll(s: Stream[F, Byte]): Pull[F, Nothing, WriteCursor[F]]","d":"fs2.io.file.WriteCursor","k":"def","x":"Writes all chunks from the supplied stream to the underlying file handle, returning a cursor\nwith offset incremented by the total number of bytes written.\n"},
{"l":"fs2/io/file/WriteCursor.html#writePull-fffff9d2","e":false,"i":"","n":"writePull","t":"writePull(bytes: Chunk[Byte]): Pull[F, Nothing, WriteCursor[F]]","d":"fs2.io.file.WriteCursor","k":"def","x":"Like write but returns a pull instead of an F[WriteCursor[F]].\n"},
{"l":"fs2/io/file/WriteCursor$.html#","e":false,"i":"","n":"WriteCursor","t":"WriteCursor","d":"fs2.io.file","k":"object","x":""},
{"l":"fs2/io/file/WriteCursor$.html#fromFileHandle-3c2","e":false,"i":"","n":"fromFileHandle","t":"fromFileHandle[F[_] : Async](file: FileHandle[F], append: Boolean): F[WriteCursor[F]]","d":"fs2.io.file.WriteCursor","k":"def","x":""},
{"l":"fs2/io/file/WriteCursor$.html#fromPath-fffff40f","e":false,"i":"","n":"fromPath","t":"fromPath[F[_] : Async](path: Path, flags: Seq[OpenOption]): Resource[F, WriteCursor[F]]","d":"fs2.io.file.WriteCursor","k":"def","x":""},
{"l":"fs2/io/net.html#","e":false,"i":"","n":"fs2.io.net","t":"fs2.io.net","d":"","k":"package","x":"Provides support for doing network I/O -- TCP, UDP, and TLS."},
{"l":"fs2/io/net.html#BindException-0","e":false,"i":"","n":"BindException","t":"BindException = BindException","d":"fs2.io.net","k":"type","x":""},
{"l":"fs2/io/net.html#ConnectException-0","e":false,"i":"","n":"ConnectException","t":"ConnectException = ConnectException","d":"fs2.io.net","k":"type","x":""},
{"l":"fs2/io/net.html#DatagramSocketOption-0","e":false,"i":"","n":"DatagramSocketOption","t":"DatagramSocketOption = SocketOption","d":"fs2.io.net","k":"type","x":""},
{"l":"fs2/io/net.html#DatagramSocketOption-0","e":false,"i":"","n":"DatagramSocketOption","t":"DatagramSocketOption: SocketOption.type","d":"fs2.io.net","k":"val","x":""},
{"l":"fs2/io/net.html#ProtocolException-0","e":false,"i":"","n":"ProtocolException","t":"ProtocolException = ProtocolException","d":"fs2.io.net","k":"type","x":""},
{"l":"fs2/io/net.html#SocketException-0","e":false,"i":"","n":"SocketException","t":"SocketException = SocketException","d":"fs2.io.net","k":"type","x":""},
{"l":"fs2/io/net.html#SocketTimeoutException-0","e":false,"i":"","n":"SocketTimeoutException","t":"SocketTimeoutException = SocketTimeoutException","d":"fs2.io.net","k":"type","x":""},
{"l":"fs2/io/net.html#UnknownHostException-0","e":false,"i":"","n":"UnknownHostException","t":"UnknownHostException = UnknownHostException","d":"fs2.io.net","k":"type","x":""},
{"l":"fs2/io/net/tls.html#","e":false,"i":"","n":"fs2.io.net.tls","t":"fs2.io.net.tls","d":"","k":"package","x":""},
{"l":"fs2/io/net/tls.html#SSLException-0","e":false,"i":"","n":"SSLException","t":"SSLException = SSLException","d":"fs2.io.net.tls","k":"type","x":""},
{"l":"fs2/io/net/tls.html#SSLSession-0","e":false,"i":"","n":"SSLSession","t":"SSLSession = SSLSession","d":"fs2.io.net.tls","k":"type","x":""},
{"l":"fs2/io/net/tls/DTLSSocket.html#","e":false,"i":"","n":"DTLSSocket","t":"DTLSSocket[F[_]] extends DatagramSocket[F]","d":"fs2.io.net.tls","k":"trait","x":"UDP socket that supports encryption via DTLS."},
{"l":"fs2/io/net/tls/DTLSSocket.html#beginHandshake-0","e":false,"i":"","n":"beginHandshake","t":"beginHandshake: F[Unit]","d":"fs2.io.net.tls.DTLSSocket","k":"def","x":"Initiates handshaking -- either the initial or a renegotiation."},
{"l":"fs2/io/net/tls/DTLSSocket.html#session-0","e":false,"i":"","n":"session","t":"session: F[SSLSession]","d":"fs2.io.net.tls.DTLSSocket","k":"def","x":"Provides access to the current SSLSession for purposes of querying\nsession info such as the negotiated cipher suite or the peer certificate.\n"},
{"l":"fs2/io/net/tls/DTLSSocket$.html#","e":false,"i":"","n":"DTLSSocket","t":"DTLSSocket","d":"fs2.io.net.tls","k":"object","x":""},
{"l":"fs2/io/net/tls/TLSContext.html#","e":false,"i":"","n":"TLSContext","t":"TLSContext[F[_]]","d":"fs2.io.net.tls","k":"trait","x":"Allows creation of TLSSockets.\n"},
{"l":"fs2/io/net/tls/TLSContext.html#client-fffffa90","e":false,"i":"","n":"client","t":"client(socket: Socket[F]): Resource[F, TLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":"Creates a TLSSocket builder in client mode."},
{"l":"fs2/io/net/tls/TLSContext.html#client-fffff991","e":false,"i":"","n":"client","t":"client(socket: Socket[F], params: TLSParameters, logger: Option[String => F[Unit]]): Resource[F, TLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext.html#clientBuilder-fffff4ca","e":false,"i":"","n":"clientBuilder","t":"clientBuilder(socket: Socket[F]): SocketBuilder[F, [F[_]] =>> TLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":"Creates a TLSSocket builder in client mode, allowing optional parameters to be configured."},
{"l":"fs2/io/net/tls/TLSContext.html#dtlsClient-3fc","e":false,"i":"","n":"dtlsClient","t":"dtlsClient(socket: DatagramSocket[F], remoteAddress: SocketAddress[IpAddress], params: TLSParameters, logger: Option[String => F[Unit]]): Resource[F, DTLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext.html#dtlsClient-bfb","e":false,"i":"","n":"dtlsClient","t":"dtlsClient(socket: DatagramSocket[F], remoteAddress: SocketAddress[IpAddress]): Resource[F, DTLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":"Creates a DTLSSocket builder in client mode."},
{"l":"fs2/io/net/tls/TLSContext.html#dtlsClientBuilder-93f","e":false,"i":"","n":"dtlsClientBuilder","t":"dtlsClientBuilder(socket: DatagramSocket[F], remoteAddress: SocketAddress[IpAddress]): SocketBuilder[F, [F[_]] =>> DTLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":"Creates a DTLSSocket builder in client mode, allowing optional parameters to be configured."},
{"l":"fs2/io/net/tls/TLSContext.html#dtlsServer-3fc","e":false,"i":"","n":"dtlsServer","t":"dtlsServer(socket: DatagramSocket[F], remoteAddress: SocketAddress[IpAddress], params: TLSParameters, logger: Option[String => F[Unit]]): Resource[F, DTLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext.html#dtlsServer-bfb","e":false,"i":"","n":"dtlsServer","t":"dtlsServer(socket: DatagramSocket[F], remoteAddress: SocketAddress[IpAddress]): Resource[F, DTLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":"Creates a DTLSSocket builder in server mode."},
{"l":"fs2/io/net/tls/TLSContext.html#dtlsServerBuilder-93f","e":false,"i":"","n":"dtlsServerBuilder","t":"dtlsServerBuilder(socket: DatagramSocket[F], remoteAddress: SocketAddress[IpAddress]): SocketBuilder[F, [F[_]] =>> DTLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":"Creates a DTLSSocket builder in client mode, allowing optional parameters to be configured."},
{"l":"fs2/io/net/tls/TLSContext.html#server-fffffa90","e":false,"i":"","n":"server","t":"server(socket: Socket[F]): Resource[F, TLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":"Creates a TLSSocket builder in server mode."},
{"l":"fs2/io/net/tls/TLSContext.html#server-fffff991","e":false,"i":"","n":"server","t":"server(socket: Socket[F], params: TLSParameters, logger: Option[String => F[Unit]]): Resource[F, TLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext.html#serverBuilder-fffff4ca","e":false,"i":"","n":"serverBuilder","t":"serverBuilder(socket: Socket[F]): SocketBuilder[F, [F[_]] =>> TLSSocket[F]]","d":"fs2.io.net.tls.TLSContext","k":"def","x":"Creates a TLSSocket builder in server mode, allowing optional parameters to be configured."},
{"l":"fs2/io/net/tls/TLSContext$.html#","e":false,"i":"","n":"TLSContext","t":"TLSContext","d":"fs2.io.net.tls","k":"object","x":""},
{"l":"fs2/io/net/tls/TLSContext$$Builder$.html#","e":false,"i":"","n":"Builder","t":"Builder","d":"fs2.io.net.tls.TLSContext","k":"object","x":""},
{"l":"fs2/io/net/tls/TLSContext$$Builder$.html#forAsync-222","e":false,"i":"","n":"forAsync","t":"forAsync[F[_] : Async]: Builder[F]","d":"fs2.io.net.tls.TLSContext.Builder","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext$$Builder.html#","e":false,"i":"","n":"Builder","t":"Builder[F[_]]","d":"fs2.io.net.tls.TLSContext","k":"trait","x":""},
{"l":"fs2/io/net/tls/TLSContext$$Builder.html#fromKeyStore-697","e":false,"i":"","n":"fromKeyStore","t":"fromKeyStore(keyStore: KeyStore, keyPassword: Array[Char]): F[TLSContext[F]]","d":"fs2.io.net.tls.TLSContext.Builder","k":"def","x":"Creates a TLSContext from the specified key store."},
{"l":"fs2/io/net/tls/TLSContext$$Builder.html#fromKeyStoreFile-fffff1e4","e":false,"i":"","n":"fromKeyStoreFile","t":"fromKeyStoreFile(file: Path, storePassword: Array[Char], keyPassword: Array[Char]): F[TLSContext[F]]","d":"fs2.io.net.tls.TLSContext.Builder","k":"def","x":"Creates a TLSContext from the specified key store file."},
{"l":"fs2/io/net/tls/TLSContext$$Builder.html#fromKeyStoreResource-fffff4f8","e":false,"i":"","n":"fromKeyStoreResource","t":"fromKeyStoreResource(resource: String, storePassword: Array[Char], keyPassword: Array[Char]): F[TLSContext[F]]","d":"fs2.io.net.tls.TLSContext.Builder","k":"def","x":"Creates a TLSContext from the specified class path resource."},
{"l":"fs2/io/net/tls/TLSContext$$Builder.html#fromSSLContext-fffff6e9","e":false,"i":"","n":"fromSSLContext","t":"fromSSLContext(ctx: SSLContext): TLSContext[F]","d":"fs2.io.net.tls.TLSContext.Builder","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext$$Builder.html#insecure-0","e":false,"i":"","n":"insecure","t":"insecure: F[TLSContext[F]]","d":"fs2.io.net.tls.TLSContext.Builder","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext$$Builder.html#insecureResource-0","e":false,"i":"","n":"insecureResource","t":"insecureResource: Resource[F, TLSContext[F]]","d":"fs2.io.net.tls.TLSContext.Builder","k":"def","x":"Creates a TLSContext which trusts all certificates."},
{"l":"fs2/io/net/tls/TLSContext$$Builder.html#system-0","e":false,"i":"","n":"system","t":"system: F[TLSContext[F]]","d":"fs2.io.net.tls.TLSContext.Builder","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext$$Builder.html#systemResource-0","e":false,"i":"","n":"systemResource","t":"systemResource: Resource[F, TLSContext[F]]","d":"fs2.io.net.tls.TLSContext.Builder","k":"def","x":"Creates a TLSContext from the system default SSLContext."},
{"l":"fs2/io/net/tls/TLSContext$$SocketBuilder$.html#","e":false,"i":"","n":"SocketBuilder","t":"SocketBuilder","d":"fs2.io.net.tls.TLSContext","k":"object","x":""},
{"l":"fs2/io/net/tls/TLSContext$$SocketBuilder.html#","e":false,"i":"","n":"SocketBuilder","t":"SocketBuilder[F[_], S[_[_]]]","d":"fs2.io.net.tls.TLSContext","k":"trait","x":""},
{"l":"fs2/io/net/tls/TLSContext$$SocketBuilder.html#build-0","e":false,"i":"","n":"build","t":"build: Resource[F, S[F]]","d":"fs2.io.net.tls.TLSContext.SocketBuilder","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext$$SocketBuilder.html#withLogger-72f","e":false,"i":"","n":"withLogger","t":"withLogger(logger: TLSLogger[F]): SocketBuilder[F, S]","d":"fs2.io.net.tls.TLSContext.SocketBuilder","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext$$SocketBuilder.html#withLogging-fffffdb8","e":false,"i":"","n":"withLogging","t":"withLogging(log: (=> String) => F[Unit]): SocketBuilder[F, S]","d":"fs2.io.net.tls.TLSContext.SocketBuilder","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext$$SocketBuilder.html#withParameters-589","e":false,"i":"","n":"withParameters","t":"withParameters(params: TLSParameters): SocketBuilder[F, S]","d":"fs2.io.net.tls.TLSContext.SocketBuilder","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSContext$$SocketBuilder.html#withoutLogging-0","e":false,"i":"","n":"withoutLogging","t":"withoutLogging: SocketBuilder[F, S]","d":"fs2.io.net.tls.TLSContext.SocketBuilder","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSLogger.html#","e":false,"i":"","n":"TLSLogger","t":"TLSLogger[+F[_]]","d":"fs2.io.net.tls","k":"trait","x":""},
{"l":"fs2/io/net/tls/TLSLogger$.html#","e":false,"i":"","n":"TLSLogger","t":"TLSLogger","d":"fs2.io.net.tls","k":"object","x":""},
{"l":"fs2/io/net/tls/TLSLogger$$Disabled$.html#","e":false,"i":"","n":"Disabled","t":"Disabled extends TLSLogger[Nothing]","d":"fs2.io.net.tls.TLSLogger","k":"object","x":""},
{"l":"fs2/io/net/tls/TLSLogger$$Enabled.html#","e":false,"i":"","n":"Enabled","t":"Enabled[F[_]](log: (=> String) => F[Unit]) extends TLSLogger[F]","d":"fs2.io.net.tls.TLSLogger","k":"class","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#","e":false,"i":"","n":"TLSParameters","t":"TLSParameters","d":"fs2.io.net.tls","k":"trait","x":"Parameters used in creation of a TLS/DTLS session.\nSee javax.net.ssl.SSLParameters for detailed documentation on each parameter."},
{"l":"fs2/io/net/tls/TLSParameters.html#algorithmConstraints-0","e":false,"i":"","n":"algorithmConstraints","t":"algorithmConstraints: Option[AlgorithmConstraints]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#applicationProtocols-0","e":false,"i":"","n":"applicationProtocols","t":"applicationProtocols: Option[List[String]]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#cipherSuites-0","e":false,"i":"","n":"cipherSuites","t":"cipherSuites: Option[List[String]]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#enableRetransmissions-0","e":false,"i":"","n":"enableRetransmissions","t":"enableRetransmissions: Option[Boolean]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#endpointIdentificationAlgorithm-0","e":false,"i":"","n":"endpointIdentificationAlgorithm","t":"endpointIdentificationAlgorithm: Option[String]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#handshakeApplicationProtocolSelector-0","e":false,"i":"","n":"handshakeApplicationProtocolSelector","t":"handshakeApplicationProtocolSelector: Option[(SSLEngine, List[String]) => String]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#maximumPacketSize-0","e":false,"i":"","n":"maximumPacketSize","t":"maximumPacketSize: Option[Int]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#needClientAuth-0","e":false,"i":"","n":"needClientAuth","t":"needClientAuth: Boolean","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#protocols-0","e":false,"i":"","n":"protocols","t":"protocols: Option[List[String]]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#serverNames-0","e":false,"i":"","n":"serverNames","t":"serverNames: Option[List[SNIServerName]]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#sniMatchers-0","e":false,"i":"","n":"sniMatchers","t":"sniMatchers: Option[List[SNIMatcher]]","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#toSSLParameters-0","e":false,"i":"","n":"toSSLParameters","t":"toSSLParameters: SSLParameters","d":"fs2.io.net.tls.TLSParameters","k":"def","x":"Converts to a javax.net.ssl.SSLParameters instance."},
{"l":"fs2/io/net/tls/TLSParameters.html#useCipherSuitesOrder-0","e":false,"i":"","n":"useCipherSuitesOrder","t":"useCipherSuitesOrder: Boolean","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters.html#wantClientAuth-0","e":false,"i":"","n":"wantClientAuth","t":"wantClientAuth: Boolean","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters$.html#","e":false,"i":"","n":"TLSParameters","t":"TLSParameters","d":"fs2.io.net.tls","k":"object","x":""},
{"l":"fs2/io/net/tls/TLSParameters$.html#Default-0","e":false,"i":"","n":"Default","t":"Default: TLSParameters","d":"fs2.io.net.tls.TLSParameters","k":"val","x":""},
{"l":"fs2/io/net/tls/TLSParameters$.html#apply-4ba","e":false,"i":"","n":"apply","t":"apply(algorithmConstraints: Option[AlgorithmConstraints], applicationProtocols: Option[List[String]], cipherSuites: Option[List[String]], enableRetransmissions: Option[Boolean], endpointIdentificationAlgorithm: Option[String], maximumPacketSize: Option[Int], protocols: Option[List[String]], serverNames: Option[List[SNIServerName]], sniMatchers: Option[List[SNIMatcher]], useCipherSuitesOrder: Boolean, needClientAuth: Boolean, wantClientAuth: Boolean, handshakeApplicationProtocolSelector: Option[(SSLEngine, List[String]) => String]): TLSParameters","d":"fs2.io.net.tls.TLSParameters","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSParameters$.html#apply-c7d","e":false,"i":"","n":"apply","t":"apply(algorithmConstraints: Option[AlgorithmConstraints], applicationProtocols: Option[List[String]], cipherSuites: Option[List[String]], enableRetransmissions: Option[Boolean], endpointIdentificationAlgorithm: Option[String], maximumPacketSize: Option[Int], protocols: Option[List[String]], serverNames: Option[List[SNIServerName]], sniMatchers: Option[List[SNIMatcher]], useCipherSuitesOrder: Boolean, needClientAuth: Boolean, wantClientAuth: Boolean): TLSParameters","d":"fs2.io.net.tls.TLSParameters","k":"def","x":""},
{"l":"fs2/io/net/tls/TLSSocket.html#","e":false,"i":"","n":"TLSSocket","t":"TLSSocket[F[_]] extends Socket[F]","d":"fs2.io.net.tls","k":"trait","x":"TCP socket that supports encryption via TLS."},
{"l":"fs2/io/net/tls/TLSSocket.html#applicationProtocol-0","e":false,"i":"","n":"applicationProtocol","t":"applicationProtocol: F[String]","d":"fs2.io.net.tls.TLSSocket","k":"def","x":"Provides access to the current application protocol that has been negotiated.\n"},
{"l":"fs2/io/net/tls/TLSSocket.html#beginHandshake-0","e":false,"i":"","n":"beginHandshake","t":"beginHandshake: F[Unit]","d":"fs2.io.net.tls.TLSSocket","k":"def","x":"Initiates handshaking -- either the initial or a renegotiation."},
{"l":"fs2/io/net/tls/TLSSocket.html#session-0","e":false,"i":"","n":"session","t":"session: F[SSLSession]","d":"fs2.io.net.tls.TLSSocket","k":"def","x":"Provides access to the current SSLSession for purposes of querying\nsession info such as the negotiated cipher suite or the peer certificate.\n"},
{"l":"fs2/io/net/tls/TLSSocket$.html#","e":false,"i":"","n":"TLSSocket","t":"TLSSocket","d":"fs2.io.net.tls","k":"object","x":""},
{"l":"fs2/io/net/unixsocket.html#","e":false,"i":"","n":"fs2.io.net.unixsocket","t":"fs2.io.net.unixsocket","d":"","k":"package","x":""},
{"l":"fs2/io/net/unixsocket/JdkUnixSockets$.html#","e":false,"i":"","n":"JdkUnixSockets","t":"JdkUnixSockets","d":"fs2.io.net.unixsocket","k":"object","x":""},
{"l":"fs2/io/net/unixsocket/JdkUnixSockets$.html#forAsync-fffffd6d","e":false,"i":"","n":"forAsync","t":"forAsync[F[_]](implicit F: Async[F]): UnixSockets[F]","d":"fs2.io.net.unixsocket.JdkUnixSockets","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/JdkUnixSockets$.html#forAsyncAndFiles-fffff279","e":false,"i":"","n":"forAsyncAndFiles","t":"forAsyncAndFiles[F[_] : Files]: UnixSockets[F]","d":"fs2.io.net.unixsocket.JdkUnixSockets","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/JdkUnixSockets$.html#supported-0","e":false,"i":"","n":"supported","t":"supported: Boolean","d":"fs2.io.net.unixsocket.JdkUnixSockets","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/JnrUnixSockets$.html#","e":false,"i":"","n":"JnrUnixSockets","t":"JnrUnixSockets","d":"fs2.io.net.unixsocket","k":"object","x":""},
{"l":"fs2/io/net/unixsocket/JnrUnixSockets$.html#forAsync-fffffd6d","e":false,"i":"","n":"forAsync","t":"forAsync[F[_]](implicit F: Async[F]): UnixSockets[F]","d":"fs2.io.net.unixsocket.JnrUnixSockets","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/JnrUnixSockets$.html#forAsyncAndFiles-fffff279","e":false,"i":"","n":"forAsyncAndFiles","t":"forAsyncAndFiles[F[_] : Files]: UnixSockets[F]","d":"fs2.io.net.unixsocket.JnrUnixSockets","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/JnrUnixSockets$.html#supported-0","e":false,"i":"","n":"supported","t":"supported: Boolean","d":"fs2.io.net.unixsocket.JnrUnixSockets","k":"val","x":""},
{"l":"fs2/io/net/unixsocket/UnixSocketAddress.html#","e":false,"i":"","n":"UnixSocketAddress","t":"UnixSocketAddress(path: String)","d":"fs2.io.net.unixsocket","k":"class","x":""},
{"l":"fs2/io/net/unixsocket/UnixSocketAddress$.html#","e":false,"i":"","n":"UnixSocketAddress","t":"UnixSocketAddress","d":"fs2.io.net.unixsocket","k":"object","x":""},
{"l":"fs2/io/net/unixsocket/UnixSocketAddress$.html#apply-fffff97e","e":false,"i":"","n":"apply","t":"apply(path: File): UnixSocketAddress","d":"fs2.io.net.unixsocket.UnixSocketAddress","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/UnixSocketAddress$.html#apply-1a5","e":false,"i":"","n":"apply","t":"apply(path: Path): UnixSocketAddress","d":"fs2.io.net.unixsocket.UnixSocketAddress","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/UnixSockets.html#","e":false,"i":"","n":"UnixSockets","t":"UnixSockets[F[_]]","d":"fs2.io.net.unixsocket","k":"trait","x":"Capability of working with AF_UNIX sockets."},
{"l":"fs2/io/net/unixsocket/UnixSockets.html#client-fffff63d","e":false,"i":"","n":"client","t":"client(address: UnixSocketAddress): Resource[F, Socket[F]]","d":"fs2.io.net.unixsocket.UnixSockets","k":"def","x":"Returns a resource which opens a unix socket to the specified path.\n"},
{"l":"fs2/io/net/unixsocket/UnixSockets.html#server-fffff7bf","e":false,"i":"","n":"server","t":"server(address: UnixSocketAddress, deleteIfExists: Boolean, deleteOnClose: Boolean): Stream[F, Socket[F]]","d":"fs2.io.net.unixsocket.UnixSockets","k":"def","x":"Listens to the specified path for connections and emits a Socket for each connection."},
{"l":"fs2/io/net/unixsocket/UnixSockets$.html#","e":false,"i":"","n":"UnixSockets","t":"UnixSockets","d":"fs2.io.net.unixsocket","k":"object","x":""},
{"l":"fs2/io/net/unixsocket/UnixSockets$.html#apply-a91","e":false,"i":"","n":"apply","t":"apply[F[_]](implicit F: UnixSockets[F]): UnixSockets[F]","d":"fs2.io.net.unixsocket.UnixSockets","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/UnixSockets$.html#forAsync-fffffd6d","e":false,"i":"","n":"forAsync","t":"forAsync[F[_]](implicit F: Async[F]): UnixSockets[F]","d":"fs2.io.net.unixsocket.UnixSockets","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/UnixSockets$.html#forAsyncAndFiles-fffff279","e":false,"i":"","n":"forAsyncAndFiles","t":"forAsyncAndFiles[F[_] : Files]: UnixSockets[F]","d":"fs2.io.net.unixsocket.UnixSockets","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/UnixSockets$.html#forIO-0","e":false,"i":"","n":"forIO","t":"forIO: UnixSockets[IO]","d":"fs2.io.net.unixsocket.UnixSockets","k":"def","x":""},
{"l":"fs2/io/net/unixsocket/UnixSockets$.html#forLiftIO-fffff750","e":false,"i":"","n":"forLiftIO","t":"forLiftIO[F[_] : LiftIO]: UnixSockets[F]","d":"fs2.io.net.unixsocket.UnixSockets","k":"def","x":""},
{"l":"fs2/io/net/Datagram.html#","e":false,"i":"","n":"Datagram","t":"Datagram(remote: SocketAddress[IpAddress], bytes: Chunk[Byte])","d":"fs2.io.net","k":"class","x":"A single datagram to send to the specified remote address or received from the specified address.\n"},
{"l":"fs2/io/net/DatagramSocket.html#","e":false,"i":"","n":"DatagramSocket","t":"DatagramSocket[F[_]]","d":"fs2.io.net","k":"trait","x":"Provides the ability to read/write from a UDP socket in the effect F.\n"},
{"l":"fs2/io/net/DatagramSocket.html#join-826","e":false,"i":"","n":"join","t":"join(join: MulticastJoin[IpAddress], interface: NetworkInterface): F[GroupMembership]","d":"fs2.io.net.DatagramSocket","k":"def","x":"Joins a multicast group on a specific network interface.\n"},
{"l":"fs2/io/net/DatagramSocket.html#localAddress-0","e":false,"i":"","n":"localAddress","t":"localAddress: F[SocketAddress[IpAddress]]","d":"fs2.io.net.DatagramSocket","k":"def","x":"Returns the local address of this udp socket."},
{"l":"fs2/io/net/DatagramSocket.html#read-0","e":false,"i":"","n":"read","t":"read: F[Datagram]","d":"fs2.io.net.DatagramSocket","k":"def","x":"Reads a single datagram from this udp socket.\n"},
{"l":"fs2/io/net/DatagramSocket.html#reads-0","e":false,"i":"","n":"reads","t":"reads: Stream[F, Datagram]","d":"fs2.io.net.DatagramSocket","k":"def","x":"Reads datagrams received from this udp socket."},
{"l":"fs2/io/net/DatagramSocket.html#write-6c4","e":false,"i":"","n":"write","t":"write(datagram: Datagram): F[Unit]","d":"fs2.io.net.DatagramSocket","k":"def","x":"Writes a single datagram to this udp socket.\n"},
{"l":"fs2/io/net/DatagramSocket.html#writes-0","e":false,"i":"","n":"writes","t":"writes: (F, Datagram) => Nothing","d":"fs2.io.net.DatagramSocket","k":"def","x":"Writes supplied datagrams to this udp socket.\n"},
{"l":"fs2/io/net/DatagramSocket$GroupMembership.html#","e":false,"i":"","n":"GroupMembership","t":"GroupMembership","d":"fs2.io.net.DatagramSocket","k":"trait","x":"Result of joining a multicast group on a UDP socket."},
{"l":"fs2/io/net/DatagramSocket$GroupMembership.html#block-af3","e":false,"i":"","n":"block","t":"block(source: IpAddress): DatagramSocketPlatform.this.F[Unit]","d":"fs2.io.net.DatagramSocket.GroupMembership","k":"def","x":"Blocks datagrams from the specified source address."},
{"l":"fs2/io/net/DatagramSocket$GroupMembership.html#drop-0","e":false,"i":"","n":"drop","t":"drop: F[Unit]","d":"fs2.io.net.DatagramSocket.GroupMembership","k":"def","x":"Leaves the multicast group, resulting in no further datagrams from this group being read."},
{"l":"fs2/io/net/DatagramSocket$GroupMembership.html#unblock-af3","e":false,"i":"","n":"unblock","t":"unblock(source: IpAddress): DatagramSocketPlatform.this.F[Unit]","d":"fs2.io.net.DatagramSocket.GroupMembership","k":"def","x":"Unblocks datagrams from the specified source address."},
{"l":"fs2/io/net/DatagramSocket$.html#","e":false,"i":"","n":"DatagramSocket","t":"DatagramSocket","d":"fs2.io.net","k":"object","x":""},
{"l":"fs2/io/net/DatagramSocket$.html#NetworkInterface-0","e":false,"i":"","n":"NetworkInterface","t":"NetworkInterface = NetworkInterface","d":"fs2.io.net.DatagramSocket","k":"type","x":""},
{"l":"fs2/io/net/DatagramSocketGroup.html#","e":false,"i":"","n":"DatagramSocketGroup","t":"DatagramSocketGroup[F[_]]","d":"fs2.io.net","k":"trait","x":""},
{"l":"fs2/io/net/DatagramSocketGroup.html#openDatagramSocket-a9e","e":false,"i":"","n":"openDatagramSocket","t":"openDatagramSocket(address: Option[Host], port: Option[Port], options: List[DatagramSocketOption], protocolFamily: Option[ProtocolFamily]): Resource[F, DatagramSocket[F]]","d":"fs2.io.net.DatagramSocketGroup","k":"def","x":"Creates a UDP socket bound to the specified address.\n"},
{"l":"fs2/io/net/Network.html#","e":false,"i":"","n":"Network","t":"Network[F[_]] extends SocketGroup[F], DatagramSocketGroup[F]","d":"fs2.io.net","k":"trait","x":"Provides the ability to work with TCP, UDP, and TLS.\n"},
{"l":"fs2/io/net/Network.html#datagramSocketGroup-74a","e":false,"i":"","n":"datagramSocketGroup","t":"datagramSocketGroup(threadFactory: ThreadFactory): Resource[F, DatagramSocketGroup[F]]","d":"fs2.io.net.Network","k":"def","x":"Provides an isolated DatagramSocketGroup[F] with the specified thread configuration.\nThe resulting socket group is shutdown during resource finalization, resulting in\nclosure of any sockets that were created."},
{"l":"fs2/io/net/Network.html#socketGroup-983","e":false,"i":"","n":"socketGroup","t":"socketGroup(threadCount: Int, threadFactory: ThreadFactory): Resource[F, SocketGroup[F]]","d":"fs2.io.net.Network","k":"def","x":"Provides an isolated SocketGroup[F] with the specified thread pool configuration.\nThe resulting socket group is shutdown during resource finalization, resulting in\nclosure of any sockets that were created."},
{"l":"fs2/io/net/Network.html#tlsContext-0","e":false,"i":"","n":"tlsContext","t":"tlsContext: Builder[F]","d":"fs2.io.net.Network","k":"def","x":"Returns a builder for TLSContext[F] values."},
{"l":"fs2/io/net/Network$.html#","e":false,"i":"","n":"Network","t":"Network","d":"fs2.io.net","k":"object","x":""},
{"l":"fs2/io/net/Network$.html#apply-fffffc2d","e":false,"i":"","n":"apply","t":"apply[F[_]](implicit F: Network[F]): F.type","d":"fs2.io.net.Network","k":"def","x":""},
{"l":"fs2/io/net/Network$.html#forAsync-3c6","e":false,"i":"","n":"forAsync","t":"forAsync[F[_]](implicit F: Async[F]): Network[F]","d":"fs2.io.net.Network","k":"def","x":""},
{"l":"fs2/io/net/Network$.html#forAsyncAndDns-fffffcc2","e":false,"i":"","n":"forAsyncAndDns","t":"forAsyncAndDns[F[_]](implicit F: Async[F], dns: Dns[F]): Network[F]","d":"fs2.io.net.Network","k":"def","x":""},
{"l":"fs2/io/net/Network$.html#forIO-0","e":false,"i":"","n":"forIO","t":"forIO: Network[IO]","d":"fs2.io.net.Network","k":"def","x":""},
{"l":"fs2/io/net/Network$.html#forLiftIO-43","e":false,"i":"","n":"forLiftIO","t":"forLiftIO[F[_] : LiftIO]: Network[F]","d":"fs2.io.net.Network","k":"def","x":""},
{"l":"fs2/io/net/Network$.html#implicitForAsync-3c6","e":false,"i":"","n":"implicitForAsync","t":"implicitForAsync[F[_] : Async]: Network[F]","d":"fs2.io.net.Network","k":"def","x":""},
{"l":"fs2/io/net/Socket.html#","e":false,"i":"","n":"Socket","t":"Socket[F[_]]","d":"fs2.io.net","k":"trait","x":"Provides the ability to read/write from a TCP socket in the effect F.\n"},
{"l":"fs2/io/net/Socket.html#endOfInput-0","e":false,"i":"","n":"endOfInput","t":"endOfInput: F[Unit]","d":"fs2.io.net.Socket","k":"def","x":"Indicates that this channel will not read more data. Causes End-Of-Stream be signalled to available.\nThis is a no-op on Node.js.\n"},
{"l":"fs2/io/net/Socket.html#endOfOutput-0","e":false,"i":"","n":"endOfOutput","t":"endOfOutput: F[Unit]","d":"fs2.io.net.Socket","k":"def","x":"Indicates to peer, we are done writing. *"},
{"l":"fs2/io/net/Socket.html#isOpen-0","e":false,"i":"","n":"isOpen","t":"isOpen: F[Boolean]","d":"fs2.io.net.Socket","k":"def","x":""},
{"l":"fs2/io/net/Socket.html#localAddress-0","e":false,"i":"","n":"localAddress","t":"localAddress: F[SocketAddress[IpAddress]]","d":"fs2.io.net.Socket","k":"def","x":"Asks for the local address of the socket."},
{"l":"fs2/io/net/Socket.html#read-aba","e":false,"i":"","n":"read","t":"read(maxBytes: Int): F[Option[Chunk[Byte]]]","d":"fs2.io.net.Socket","k":"def","x":"Reads up to maxBytes from the peer."},
{"l":"fs2/io/net/Socket.html#readN-aba","e":false,"i":"","n":"readN","t":"readN(numBytes: Int): F[Chunk[Byte]]","d":"fs2.io.net.Socket","k":"def","x":"Reads exactly numBytes from the peer in a single chunk."},
{"l":"fs2/io/net/Socket.html#reads-0","e":false,"i":"","n":"reads","t":"reads: Stream[F, Byte]","d":"fs2.io.net.Socket","k":"def","x":"Reads bytes from the socket as a stream."},
{"l":"fs2/io/net/Socket.html#remoteAddress-0","e":false,"i":"","n":"remoteAddress","t":"remoteAddress: F[SocketAddress[IpAddress]]","d":"fs2.io.net.Socket","k":"def","x":"Asks for the remote address of the peer."},
{"l":"fs2/io/net/Socket.html#write-5b7","e":false,"i":"","n":"write","t":"write(bytes: Chunk[Byte]): F[Unit]","d":"fs2.io.net.Socket","k":"def","x":"Writes bytes to the peer."},
{"l":"fs2/io/net/Socket.html#writes-0","e":false,"i":"","n":"writes","t":"writes: (F, Byte) => Nothing","d":"fs2.io.net.Socket","k":"def","x":"Writes the supplied stream of bytes to this socket via write semantics.\n"},
{"l":"fs2/io/net/Socket$.html#","e":false,"i":"","n":"Socket","t":"Socket","d":"fs2.io.net","k":"object","x":""},
{"l":"fs2/io/net/SocketGroup.html#","e":false,"i":"","n":"SocketGroup","t":"SocketGroup[F[_]]","d":"fs2.io.net","k":"trait","x":"Supports creation of client and server TCP sockets that all share\nan underlying non-blocking channel group.\n"},
{"l":"fs2/io/net/SocketGroup.html#client-fffffd95","e":false,"i":"","n":"client","t":"client(to: SocketAddress[Host], options: List[SocketOption]): Resource[F, Socket[F]]","d":"fs2.io.net.SocketGroup","k":"def","x":"Opens a TCP connection to the specified server."},
{"l":"fs2/io/net/SocketGroup.html#server-fffffac1","e":false,"i":"","n":"server","t":"server(address: Option[Host], port: Option[Port], options: List[SocketOption]): Stream[F, Socket[F]]","d":"fs2.io.net.SocketGroup","k":"def","x":"Creates a TCP server bound to specified address/port and returns a stream of\nclient sockets -- one per client that connects to the bound address/port."},
{"l":"fs2/io/net/SocketGroup.html#serverResource-fffffafb","e":false,"i":"","n":"serverResource","t":"serverResource(address: Option[Host], port: Option[Port], options: List[SocketOption]): Resource[F, (SocketAddress[IpAddress], Stream[F, Socket[F]])]","d":"fs2.io.net.SocketGroup","k":"def","x":"Like server but provides the SocketAddress of the bound server socket before providing accepted sockets."},
{"l":"fs2/io/net/SocketOption.html#","e":false,"i":"","n":"SocketOption","t":"SocketOption","d":"fs2.io.net","k":"trait","x":"Specifies a socket option on a TCP/UDP socket."},
{"l":"fs2/io/net/SocketOption.html#Value-0","e":false,"i":"","n":"Value","t":"Value","d":"fs2.io.net.SocketOption","k":"type","x":""},
{"l":"fs2/io/net/SocketOption.html#key-0","e":false,"i":"","n":"key","t":"key: SocketOption[Value]","d":"fs2.io.net.SocketOption","k":"val","x":""},
{"l":"fs2/io/net/SocketOption.html#value-0","e":false,"i":"","n":"value","t":"value: Value","d":"fs2.io.net.SocketOption","k":"val","x":""},
{"l":"fs2/io/net/SocketOption$.html#","e":false,"i":"","n":"SocketOption","t":"SocketOption","d":"fs2.io.net","k":"object","x":""},
{"l":"fs2/io/net/SocketOption$.html#Key-0","e":false,"i":"","n":"Key","t":"Key[A] = SocketOption[A]","d":"fs2.io.net.SocketOption","k":"type","x":""},
{"l":"fs2/io/net/SocketOption$.html#apply-531","e":false,"i":"","n":"apply","t":"apply[A](key0: SocketOption[A], value0: A): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#boolean-2fd","e":false,"i":"","n":"boolean","t":"boolean(key: SocketOption[Boolean], value: Boolean): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#broadcast-98","e":false,"i":"","n":"broadcast","t":"broadcast(value: Boolean): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#integer-fffff5d6","e":false,"i":"","n":"integer","t":"integer(key: SocketOption[Integer], value: Int): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#keepAlive-98","e":false,"i":"","n":"keepAlive","t":"keepAlive(value: Boolean): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#linger-fffff8f1","e":false,"i":"","n":"linger","t":"linger(value: Int): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#multicastInterface-fffff3b0","e":false,"i":"","n":"multicastInterface","t":"multicastInterface(value: NetworkInterface): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#multicastLoop-98","e":false,"i":"","n":"multicastLoop","t":"multicastLoop(value: Boolean): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#multicastTtl-fffff8f1","e":false,"i":"","n":"multicastTtl","t":"multicastTtl(value: Int): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#noDelay-98","e":false,"i":"","n":"noDelay","t":"noDelay(value: Boolean): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#receiveBufferSize-fffff8f1","e":false,"i":"","n":"receiveBufferSize","t":"receiveBufferSize(value: Int): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#reuseAddress-98","e":false,"i":"","n":"reuseAddress","t":"reuseAddress(value: Boolean): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#reusePort-98","e":false,"i":"","n":"reusePort","t":"reusePort(value: Boolean): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#sendBufferSize-fffff8f1","e":false,"i":"","n":"sendBufferSize","t":"sendBufferSize(value: Int): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/net/SocketOption$.html#typeOfService-fffff8f1","e":false,"i":"","n":"typeOfService","t":"typeOfService(value: Int): SocketOption","d":"fs2.io.net.SocketOption","k":"def","x":""},
{"l":"fs2/io/process.html#","e":false,"i":"","n":"fs2.io.process","t":"fs2.io.process","d":"","k":"package","x":""},
{"l":"fs2/io/process/Process.html#","e":false,"i":"","n":"Process","t":"Process[F[_]]","d":"fs2.io.process","k":"trait","x":""},
{"l":"fs2/io/process/Process.html#exitValue-0","e":false,"i":"","n":"exitValue","t":"exitValue: F[Int]","d":"fs2.io.process.Process","k":"def","x":"Fiber blocks until the process exits, then returns the exit value.\nIf the process has already exited then the exit value is available immediately.\n"},
{"l":"fs2/io/process/Process.html#isAlive-0","e":false,"i":"","n":"isAlive","t":"isAlive: F[Boolean]","d":"fs2.io.process.Process","k":"def","x":""},
{"l":"fs2/io/process/Process.html#stderr-0","e":false,"i":"","n":"stderr","t":"stderr: Stream[F, Byte]","d":"fs2.io.process.Process","k":"def","x":"A Stream that reads from stderr of the process. This stream should be compiled at most once,\nand interrupting or otherwise canceling a read-in-progress may kill the process. Not draining\nthis Stream may cause the process to block, or even deadlock.\n"},
{"l":"fs2/io/process/Process.html#stdin-0","e":false,"i":"","n":"stdin","t":"stdin: (F, Byte) => Nothing","d":"fs2.io.process.Process","k":"def","x":"A Pipe that writes to stdin of the process. The resulting stream should be compiled\nat most once, and interrupting or otherwise canceling a write-in-progress may kill the process.\nIf the process expects data through stdin, you have to supply it or close it. Failure to do so\nmay cause the process to block, or even deadlock."},
{"l":"fs2/io/process/Process.html#stdout-0","e":false,"i":"","n":"stdout","t":"stdout: Stream[F, Byte]","d":"fs2.io.process.Process","k":"def","x":"A Stream that reads from stdout of the process. This stream should be compiled at most once,\nand interrupting or otherwise canceling a read-in-progress may kill the process. Not draining\nthis Stream may cause the process to block, or even deadlock.\n"},
{"l":"fs2/io/process/ProcessBuilder.html#","e":false,"i":"","n":"ProcessBuilder","t":"ProcessBuilder","d":"fs2.io.process","k":"class","x":""},
{"l":"fs2/io/process/ProcessBuilder.html#args-0","e":false,"i":"","n":"args","t":"args: List[String]","d":"fs2.io.process.ProcessBuilder","k":"def","x":"Arguments passed to command."},
{"l":"fs2/io/process/ProcessBuilder.html#command-0","e":false,"i":"","n":"command","t":"command: String","d":"fs2.io.process.ProcessBuilder","k":"def","x":"Command to run."},
{"l":"fs2/io/process/ProcessBuilder.html#extraEnv-0","e":false,"i":"","n":"extraEnv","t":"extraEnv: Map[String, String]","d":"fs2.io.process.ProcessBuilder","k":"def","x":"Additional environment variables for this process.\nThese may override inherited environment variables.\n"},
{"l":"fs2/io/process/ProcessBuilder.html#inheritEnv-0","e":false,"i":"","n":"inheritEnv","t":"inheritEnv: Boolean","d":"fs2.io.process.ProcessBuilder","k":"def","x":"Whether to inherit environment variables of the current process.\nDefaults to true.\n"},
{"l":"fs2/io/process/ProcessBuilder.html#spawn-de3","e":false,"i":"","n":"spawn","t":"spawn[F[_] : Processes]: Resource[F, Process[F]]","d":"fs2.io.process.ProcessBuilder","k":"def","x":"Starts the process and returns a handle for interacting with it.\nClosing the resource will kill the process if it has not already terminated.\n"},
{"l":"fs2/io/process/ProcessBuilder.html#withArgs-6b8","e":false,"i":"","n":"withArgs","t":"withArgs(args: List[String]): ProcessBuilder","d":"fs2.io.process.ProcessBuilder","k":"def","x":""},
{"l":"fs2/io/process/ProcessBuilder.html#withCommand-fffff985","e":false,"i":"","n":"withCommand","t":"withCommand(command: String): ProcessBuilder","d":"fs2.io.process.ProcessBuilder","k":"def","x":""},
{"l":"fs2/io/process/ProcessBuilder.html#withCurrentWorkingDirectory-0","e":false,"i":"","n":"withCurrentWorkingDirectory","t":"withCurrentWorkingDirectory: ProcessBuilder","d":"fs2.io.process.ProcessBuilder","k":"def","x":""},
{"l":"fs2/io/process/ProcessBuilder.html#withExtraEnv-7a2","e":false,"i":"","n":"withExtraEnv","t":"withExtraEnv(env: Map[String, String]): ProcessBuilder","d":"fs2.io.process.ProcessBuilder","k":"def","x":""},
{"l":"fs2/io/process/ProcessBuilder.html#withInheritEnv-fffffe6a","e":false,"i":"","n":"withInheritEnv","t":"withInheritEnv(inherit: Boolean): ProcessBuilder","d":"fs2.io.process.ProcessBuilder","k":"def","x":""},
{"l":"fs2/io/process/ProcessBuilder.html#withWorkingDirectory-bd2","e":false,"i":"","n":"withWorkingDirectory","t":"withWorkingDirectory(workingDirectory: Path): ProcessBuilder","d":"fs2.io.process.ProcessBuilder","k":"def","x":""},
{"l":"fs2/io/process/ProcessBuilder.html#workingDirectory-0","e":false,"i":"","n":"workingDirectory","t":"workingDirectory: Option[Path]","d":"fs2.io.process.ProcessBuilder","k":"def","x":"Working directory for this process.\nIf None then it will use the working directory of the current process.\nDefaults to None\n"},
{"l":"fs2/io/process/ProcessBuilder$.html#","e":false,"i":"","n":"ProcessBuilder","t":"ProcessBuilder","d":"fs2.io.process","k":"object","x":""},
{"l":"fs2/io/process/ProcessBuilder$.html#apply-f9d","e":false,"i":"","n":"apply","t":"apply(command: String, args: List[String]): ProcessBuilder","d":"fs2.io.process.ProcessBuilder","k":"def","x":""},
{"l":"fs2/io/process/ProcessBuilder$.html#apply-fffff9fa","e":false,"i":"","n":"apply","t":"apply(command: String, args: String*): ProcessBuilder","d":"fs2.io.process.ProcessBuilder","k":"def","x":""},
{"l":"fs2/io/process/Processes.html#","e":false,"i":"","n":"Processes","t":"Processes[F[_]]","d":"fs2.io.process","k":"trait","x":""},
{"l":"fs2/io/process/Processes.html#spawn-609","e":false,"i":"","n":"spawn","t":"spawn(process: ProcessBuilder): Resource[F, Process[F]]","d":"fs2.io.process.Processes","k":"def","x":""},
{"l":"fs2/io/process/Processes$.html#","e":false,"i":"","n":"Processes","t":"Processes","d":"fs2.io.process","k":"object","x":""},
{"l":"fs2/io/process/Processes$.html#apply-fffff72f","e":false,"i":"","n":"apply","t":"apply[F[_] : Processes]: Processes[F]","d":"fs2.io.process.Processes","k":"def","x":""},
{"l":"fs2/io/process/Processes$.html#forAsync-fffff8c7","e":false,"i":"","n":"forAsync","t":"forAsync[F[_]](implicit F: Async[F]): Processes[F]","d":"fs2.io.process.Processes","k":"def","x":""},
{"l":"fs2/io/process/Processes$.html#forIO-0","e":false,"i":"","n":"forIO","t":"forIO: Processes[IO]","d":"fs2.io.process.Processes","k":"def","x":""},
{"l":"fs2/io/process/Processes$.html#forLiftIO-384","e":false,"i":"","n":"forLiftIO","t":"forLiftIO[F[_] : LiftIO]: Processes[F]","d":"fs2.io.process.Processes","k":"def","x":""},
{"l":"fs2/io/Watcher.html#","e":false,"i":"","n":"Watcher","t":"Watcher[F[_]]","d":"fs2.io","k":"class","x":"Allows watching the file system for changes to directories and files by using the platform's WatchService.\n"},
{"l":"fs2/io/Watcher.html#events-fffff8b7","e":false,"i":"","n":"events","t":"events(pollTimeout: FiniteDuration): Stream[F, Event]","d":"fs2.io.Watcher","k":"def","x":"Stream of events for paths that have been registered or watched.\n"},
{"l":"fs2/io/Watcher.html#register-a7a","e":false,"i":"","n":"register","t":"register(path: Path, types: Seq[EventType], modifiers: Seq[Modifier]): F[F[Unit]]","d":"fs2.io.Watcher","k":"def","x":"Registers for events on the specified path."},
{"l":"fs2/io/Watcher.html#watch-a7a","e":false,"i":"","n":"watch","t":"watch(path: Path, types: Seq[EventType], modifiers: Seq[Modifier]): F[F[Unit]]","d":"fs2.io.Watcher","k":"def","x":"Registers for events on the specified path."},
{"l":"fs2/io/Watcher$.html#","e":false,"i":"","n":"Watcher","t":"Watcher","d":"fs2.io","k":"object","x":""},
{"l":"fs2/io/Watcher$.html#default-54b","e":false,"i":"","n":"default","t":"default[F[_]](implicit F: Async[F]): Resource[F, Watcher[F]]","d":"fs2.io.Watcher","k":"def","x":"Creates a watcher for the default file system."},
{"l":"fs2/io/Watcher$.html#fromFileSystem-fffff9f4","e":false,"i":"","n":"fromFileSystem","t":"fromFileSystem[F[_]](fs: FileSystem)(implicit F: Async[F]): Resource[F, Watcher[F]]","d":"fs2.io.Watcher","k":"def","x":"Creates a watcher for the supplied file system."},
{"l":"fs2/io/Watcher$.html#fromWatchService-22d","e":false,"i":"","n":"fromWatchService","t":"fromWatchService[F[_]](ws: WatchService)(implicit F: Async[F]): F[Watcher[F]]","d":"fs2.io.Watcher","k":"def","x":"Creates a watcher for the supplied NIO WatchService."},
{"l":"fs2/io/Watcher$$Event.html#","e":false,"i":"","n":"Event","t":"Event","d":"fs2.io.Watcher","k":"class","x":"Event raised by Watcher. Supports standard events as well as arbitrary non-standard events (via NonStandard)."},
{"l":"fs2/io/Watcher$$Event$.html#","e":false,"i":"","n":"Event","t":"Event","d":"fs2.io.Watcher","k":"object","x":""},
{"l":"fs2/io/Watcher$$Event$.html#fromWatchEvent-86b","e":false,"i":"","n":"fromWatchEvent","t":"fromWatchEvent(e: WatchEvent[_], registeredDirectory: Path): Event","d":"fs2.io.Watcher.Event","k":"def","x":"Converts a NIO WatchEvent to an FS2 Watcher.Event.\n"},
{"l":"fs2/io/Watcher$$Event$.html#pathOf-fffffdf0","e":false,"i":"","n":"pathOf","t":"pathOf(event: Event): Option[Path]","d":"fs2.io.Watcher.Event","k":"def","x":"Determines the path for which the supplied event references."},
{"l":"fs2/io/Watcher$$Event$$Created.html#","e":false,"i":"","n":"Created","t":"Created(path: Path, count: Int) extends Event","d":"fs2.io.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/Watcher$$Event$$Deleted.html#","e":false,"i":"","n":"Deleted","t":"Deleted(path: Path, count: Int) extends Event","d":"fs2.io.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/Watcher$$Event$$Modified.html#","e":false,"i":"","n":"Modified","t":"Modified(path: Path, count: Int) extends Event","d":"fs2.io.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/Watcher$$Event$$NonStandard.html#","e":false,"i":"","n":"NonStandard","t":"NonStandard(event: WatchEvent[_], registeredDirectory: Path) extends Event","d":"fs2.io.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/Watcher$$Event$$Overflow.html#","e":false,"i":"","n":"Overflow","t":"Overflow(count: Int) extends Event","d":"fs2.io.Watcher.Event","k":"class","x":""},
{"l":"fs2/io/Watcher$$EventType.html#","e":false,"i":"","n":"EventType","t":"EventType","d":"fs2.io.Watcher","k":"class","x":"Type of event raised by Watcher. Supports the standard events types as well as arbitrary non-standard types (via NonStandard)."},
{"l":"fs2/io/Watcher$$EventType$.html#","e":false,"i":"","n":"EventType","t":"EventType","d":"fs2.io.Watcher","k":"object","x":""},
{"l":"fs2/io/Watcher$$EventType$.html#toWatchEventKind-482","e":false,"i":"","n":"toWatchEventKind","t":"toWatchEventKind(et: EventType): Kind[_]","d":"fs2.io.Watcher.EventType","k":"def","x":""},
{"l":"fs2/io/Watcher$$EventType$$Created$.html#","e":false,"i":"","n":"Created","t":"Created extends EventType","d":"fs2.io.Watcher.EventType","k":"object","x":""},
{"l":"fs2/io/Watcher$$EventType$$Deleted$.html#","e":false,"i":"","n":"Deleted","t":"Deleted extends EventType","d":"fs2.io.Watcher.EventType","k":"object","x":""},
{"l":"fs2/io/Watcher$$EventType$$Modified$.html#","e":false,"i":"","n":"Modified","t":"Modified extends EventType","d":"fs2.io.Watcher.EventType","k":"object","x":""},
{"l":"fs2/io/Watcher$$EventType$$NonStandard.html#","e":false,"i":"","n":"NonStandard","t":"NonStandard(kind: Kind[_]) extends EventType","d":"fs2.io.Watcher.EventType","k":"class","x":""},
{"l":"fs2/io/Watcher$$EventType$$Overflow$.html#","e":false,"i":"","n":"Overflow","t":"Overflow extends EventType","d":"fs2.io.Watcher.EventType","k":"object","x":""},
{"l":"fs2/io/compression$.html#","e":false,"i":"","n":"compression","t":"compression","d":"fs2.io","k":"object","x":""},
{"l":"fs2/io/compression$.html#ZipException-0","e":false,"i":"","n":"ZipException","t":"ZipException = ZipException","d":"fs2.io.compression","k":"type","x":""},
{"l":"fs2/io/compression$.html#fs2ioCompressionForAsync-a0d","e":false,"i":"","n":"fs2ioCompressionForAsync","t":"fs2ioCompressionForAsync[F[_] : Async]: Compression[F]","d":"fs2.io.compression","k":"def","x":""},
{"l":"fs2/io/compression$.html#fs2ioCompressionForIO-0","e":false,"i":"","n":"fs2ioCompressionForIO","t":"fs2ioCompressionForIO: Compression[IO]","d":"fs2.io.compression","k":"def","x":""},
{"l":"fs2/io/compression$.html#fs2ioCompressionForSync-1a6","e":false,"i":"","n":"fs2ioCompressionForSync","t":"fs2ioCompressionForSync[F[_] : Sync]: Compression[F]","d":"fs2.io.compression","k":"def","x":""}];