package co.jufeng.accessor.mybatis;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.wrapper.ObjectWrapper;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

import java.util.Map;

/**
 * spring boot
 * Map 类型结果转驼峰 需要在application-dev.properties添加 mybatis.configuration.map-underscore-to-camel-case=true
 * @author 郑坚焱
 * Copyright (c) 2016-2018
 */
public class MapWrapperFactory implements ObjectWrapperFactory {

    @Override
    public boolean hasWrapperFor(Object object) {
        return object != null && object instanceof Map;
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
    public ObjectWrapper getWrapperFor(MetaObject metaObject, Object object) {
        return new MyMapWrapper(metaObject, (Map) object);
    }

}