package org.apache.ibatis.reflection.wrapper;

import java.util.Map;

import org.apache.ibatis.reflection.MetaObject;

import co.jufeng.accessor.mybatis.MyMapWrapper;

/**
 * 驼峰处理
 * @author 郑坚焱
 * Copyright (c) 2016-2018
 */
public class DefaultObjectWrapperFactory implements ObjectWrapperFactory {

	@Override
	public boolean hasWrapperFor(Object object) {
		return object != null && object instanceof Map;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public ObjectWrapper getWrapperFor(MetaObject metaObject, Object object) {
		return new MyMapWrapper(metaObject, (Map) object);
	}

}