/*
 * Decompiled with CFR 0.152.
 */
package co.jufeng.dao.hibernate.dao.impl;

import co.jufeng.core.enums.PropertyEnum;
import co.jufeng.dao.AbstractAccessor;
import co.jufeng.dao.hibernate.criterion.ICriterion;
import co.jufeng.dao.hibernate.criterion.IProjection;
import co.jufeng.dao.hibernate.criterion.IQuery;
import co.jufeng.dao.hibernate.criterion.IRestrictions;
import co.jufeng.dao.hibernate.criterion.enums.OrderEnum;
import co.jufeng.dao.hibernate.criterion.enums.ProjectionMode;
import co.jufeng.dao.hibernate.criterion.impl.Avg;
import co.jufeng.dao.hibernate.criterion.impl.Between;
import co.jufeng.dao.hibernate.criterion.impl.Count;
import co.jufeng.dao.hibernate.criterion.impl.Eq;
import co.jufeng.dao.hibernate.criterion.impl.Ge;
import co.jufeng.dao.hibernate.criterion.impl.Group;
import co.jufeng.dao.hibernate.criterion.impl.Gt;
import co.jufeng.dao.hibernate.criterion.impl.Hql;
import co.jufeng.dao.hibernate.criterion.impl.Ilike;
import co.jufeng.dao.hibernate.criterion.impl.In;
import co.jufeng.dao.hibernate.criterion.impl.IsNotNull;
import co.jufeng.dao.hibernate.criterion.impl.IsNull;
import co.jufeng.dao.hibernate.criterion.impl.Le;
import co.jufeng.dao.hibernate.criterion.impl.Lt;
import co.jufeng.dao.hibernate.criterion.impl.Max;
import co.jufeng.dao.hibernate.criterion.impl.Min;
import co.jufeng.dao.hibernate.criterion.impl.Ne;
import co.jufeng.dao.hibernate.criterion.impl.Or;
import co.jufeng.dao.hibernate.criterion.impl.Order;
import co.jufeng.dao.hibernate.criterion.impl.Paging;
import co.jufeng.dao.hibernate.criterion.impl.Property;
import co.jufeng.dao.hibernate.criterion.impl.Sql;
import co.jufeng.dao.hibernate.criterion.impl.Sum;
import co.jufeng.dao.hibernate.criterion.impl.UniqueResult;
import co.jufeng.dao.hibernate.dao.IHibernateAccessor;
import co.jufeng.dao.hibernate.factory.IEntityFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateAccessor
extends AbstractAccessor
implements IHibernateAccessor {
    private static final long serialVersionUID = 4376162086967771456L;
    public static Logger LOG = LoggerFactory.getLogger(HibernateAccessor.class);
    private SessionFactory sessionFactory;
    private Session session;

    public static HibernateAccessor newInstance(SessionFactory sessionFactory) {
        return new HibernateAccessor(sessionFactory);
    }

    public static HibernateAccessor newInstance(Session session) {
        return new HibernateAccessor(session);
    }

    private HibernateAccessor(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.session = sessionFactory.getCurrentSession();
    }

    private HibernateAccessor(Session session) {
        this.session = session;
    }

    @Override
    public Serializable save(Object ... entity) throws Exception {
        if (entity[0] instanceof Collection || entity[0] instanceof List || entity[0] instanceof Set) {
            return this.save((Collection)entity[0]);
        }
        if (entity.getClass().isArray()) {
            return this.save(new Object[]{Arrays.asList(entity)});
        }
        return null;
    }

    @Override
    public Serializable save(Collection<Serializable> entities) throws Exception {
        ArrayList<Serializable> ids = null;
        try {
            if (entities.size() == 1) {
                return this.session.save((Object)entities.iterator().next());
            }
            ids = new ArrayList<Serializable>();
            Iterator<Serializable> it = entities.iterator();
            int i = 0;
            while (it.hasNext()) {
                if (i % 1000 == 0) {
                    this.session.flush();
                    this.session.clear();
                }
                ids.add(this.session.save((Object)it.next()));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ids;
    }

    @Override
    public boolean delete(Object ... entity) throws Exception {
        try {
            for (int i = 0; i < entity.length; ++i) {
                this.session.delete(entity[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean delete(Class<?> clazz, Serializable ... id) throws Exception {
        try {
            for (int i = 0; i < id.length; ++i) {
                this.session.delete(this.getById(id[i], clazz));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean delete(Class<?> clazz, Collection<Serializable> ids) throws Exception {
        try {
            Iterator<Serializable> it = ids.iterator();
            while (it.hasNext()) {
                this.delete(clazz, it.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean delete(Collection<Serializable> entities) throws Exception {
        try {
            Iterator<Serializable> it = entities.iterator();
            while (it.hasNext()) {
                this.delete(it.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteAll(IEntityFactory entityFactory) throws Exception {
        try {
            Collection collection = (Collection)((Object)this.get(entityFactory));
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                this.delete(it.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean update(Object ... entity) throws Exception {
        try {
            this.session.update((Object)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean update(Collection<Serializable> entities) throws Exception {
        Iterator<Serializable> it = entities.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i % 30 == 0) {
                this.session.flush();
                this.session.clear();
            }
            this.update(it.next());
            ++i;
        }
        return true;
    }

    @Override
    public Serializable get(ICriterion ... criterions) throws Exception {
        boolean checkIsUniqueResult;
        Criteria[] criteria = this.getCriteria(criterions);
        if (criteria.length <= 0) {
            // empty if block
        }
        this.checkCriterionNumber(criterions);
        Serializable result = null;
        if (criteria.length > 1) {
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            for (int i = 0; i < criteria.length; ++i) {
                criteria[i] = this.createAGroupCriteria(criteria[i], criterions);
                checkIsUniqueResult = this.checkIsUniqueResult(criterions);
                if (checkIsUniqueResult) {
                    list.add((Serializable)criteria[i].uniqueResult());
                    continue;
                }
                list.add((Serializable)((Object)criteria[i].list()));
            }
            if (list.size() > 0) {
                return list;
            }
        }
        if (criteria.length == 1) {
            criteria[0] = this.createAGroupCriteria(criteria[0], criterions);
            boolean checkIsUniqueResult2 = this.checkIsUniqueResult(criterions);
            if (checkIsUniqueResult2) {
                return (Serializable)criteria[0].uniqueResult();
            }
            return (Serializable)((Object)criteria[0].list());
        }
        IQuery iquery = this.createSQLQuery(criterions);
        if (null == iquery) {
            return result;
        }
        if (iquery instanceof Sql) {
            Query query = this.getSQLQuery(iquery);
            query = this.createAGroupCriteria(query, criterions);
            checkIsUniqueResult = this.checkIsUniqueResult(criterions);
            if (checkIsUniqueResult) {
                return (Serializable)query.uniqueResult();
            }
            return (Serializable)((Object)query.list());
        }
        if (iquery instanceof Hql) {
            Query query = this.getHQLQuery(iquery);
            query = this.createAGroupCriteria(query, criterions);
            checkIsUniqueResult = this.checkIsUniqueResult(criterions);
            if (checkIsUniqueResult) {
                return (Serializable)query.uniqueResult();
            }
            return (Serializable)((Object)query.list());
        }
        return null;
    }

    private boolean checkIsUniqueResult(ICriterion[] criterions) {
        for (int i = 0; i < criterions.length; ++i) {
            if (!(criterions[i] instanceof UniqueResult)) continue;
            return (Boolean)criterions[i].getValue();
        }
        return false;
    }

    IQuery createSQLQuery(ICriterion ... criterions) {
        for (int i = 0; i < criterions.length; ++i) {
            if (!(criterions[i] instanceof IQuery)) continue;
            return (IQuery)criterions[i];
        }
        return null;
    }

    Query getSQLQuery(IQuery query) {
        SQLQuery sqlQuery = this.session.createSQLQuery(query.getQuery());
        Object[] arrayObject = (Object[])query.getValue();
        for (int i = 0; i < arrayObject.length; ++i) {
            try {
                String className = this.getClassName(arrayObject[i]);
                String simpleClassName = Class.forName(className).getSimpleName();
                sqlQuery.addEntity(simpleClassName, className);
                sqlQuery.setCacheable(query.getCacheable());
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return sqlQuery;
    }

    Query getHQLQuery(IQuery query) {
        Query hqlQuery = this.session.createQuery(query.getQuery());
        Object[] arrayObject = (Object[])query.getValue();
        for (int i = 0; i < arrayObject.length; ++i) {
            try {
                hqlQuery.setCacheable(query.getCacheable());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hqlQuery;
    }

    @Override
    public Serializable getFunction(ICriterion ... criterions) throws Exception {
        ArrayList list = new ArrayList();
        try {
            CriteriaImpl[] criteriaArray = (CriteriaImpl[])this.getCriteria(criterions);
            for (int j = 0; j < criteriaArray.length; ++j) {
                criteriaArray[j] = (CriteriaImpl)this.createAGroupCriteria((Criteria)criteriaArray[j], criterions);
                HashMap<ProjectionMode, Serializable> maps = new HashMap<ProjectionMode, Serializable>();
                HashMap<String, HashMap<ProjectionMode, Serializable>> mapFunction = new HashMap<String, HashMap<ProjectionMode, Serializable>>();
                block11: for (int i = 0; i < criterions.length; ++i) {
                    Serializable serializable;
                    if (criterions[i] instanceof Count) {
                        Count count = (Count)criterions[i];
                        switch (count.getProjectionMode()) {
                            case COUNT: {
                                serializable = (Serializable)criteriaArray[j].setProjection(Projections.rowCount()).uniqueResult();
                                if (serializable == null || Integer.valueOf(serializable.toString()) <= 0) break;
                                maps.put(ProjectionMode.COUNT, serializable);
                                mapFunction.put(criteriaArray[j].getEntityOrClassName(), maps);
                                break;
                            }
                            case COUNT_DISTINCT: {
                                serializable = (Serializable)criteriaArray[j].setProjection((Projection)Projections.countDistinct((String)count.getName())).uniqueResult();
                                if (serializable == null || Integer.valueOf(serializable.toString()) <= 0) break;
                                maps.put(ProjectionMode.COUNT_DISTINCT, serializable);
                                mapFunction.put(criteriaArray[j].getClass().getName(), maps);
                                break;
                            }
                        }
                        continue;
                    }
                    if (criterions[i] instanceof Max) {
                        serializable = (Serializable)criteriaArray[j].setProjection((Projection)Projections.max((String)criterions[i].getName())).uniqueResult();
                        if (serializable == null) continue;
                        maps.put(ProjectionMode.MAX, serializable);
                        mapFunction.put(criteriaArray[j].getEntityOrClassName(), maps);
                        continue;
                    }
                    if (criterions[i] instanceof Min) {
                        serializable = (Serializable)criteriaArray[j].setProjection((Projection)Projections.projectionList().add((Projection)Projections.min((String)criterions[i].getName()))).uniqueResult();
                        if (serializable == null) continue;
                        maps.put(ProjectionMode.MIN, serializable);
                        mapFunction.put(criteriaArray[j].getEntityOrClassName(), maps);
                        continue;
                    }
                    if (criterions[i] instanceof Avg) {
                        serializable = (Serializable)criteriaArray[j].setProjection((Projection)Projections.avg((String)criterions[i].getName())).uniqueResult();
                        if (serializable == null) continue;
                        maps.put(ProjectionMode.AVG, serializable);
                        mapFunction.put(criteriaArray[j].getEntityOrClassName(), maps);
                        continue;
                    }
                    if (criterions[i] instanceof Sum) {
                        serializable = (Serializable)criteriaArray[j].setProjection((Projection)Projections.sum((String)criterions[i].getName())).uniqueResult();
                        if (serializable == null) continue;
                        maps.put(ProjectionMode.SUM, serializable);
                        mapFunction.put(criteriaArray[j].getEntityOrClassName(), maps);
                        continue;
                    }
                    if (!(criterions[i] instanceof Group)) continue;
                    Group group = (Group)criterions[i];
                    switch (group.getProjectionMode()) {
                        case GROUP: {
                            serializable = (Serializable)((Object)criteriaArray[j].setProjection((Projection)Projections.groupProperty((String)criterions[i].getName())).list());
                            if (serializable == null) continue block11;
                            maps.put(ProjectionMode.GROUP, serializable);
                            mapFunction.put(criteriaArray[j].getEntityOrClassName(), maps);
                            continue block11;
                        }
                        case GROUP_COUNT: {
                            ProjectionList projectionList = Projections.projectionList();
                            projectionList.add((Projection)Projections.groupProperty((String)criterions[i].getName()));
                            projectionList.add(Projections.rowCount());
                            criteriaArray[j].setProjection((Projection)projectionList);
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            for (Object[] obj : criteriaArray[j].list()) {
                                map.put(obj[0].toString(), obj[1]);
                            }
                            if (map.size() <= 0) continue block11;
                            maps.put(ProjectionMode.GROUP_COUNT, map);
                            mapFunction.put(criteriaArray[j].getEntityOrClassName(), maps);
                            continue block11;
                        }
                    }
                }
                if (mapFunction.size() <= 0) continue;
                list.add(mapFunction);
            }
            if (criteriaArray.length == 1) {
                return (Serializable)((Map)list.get(0)).get(criteriaArray[0].getEntityOrClassName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int getLineNumber() {
        return new Throwable().getStackTrace()[1].getLineNumber();
    }

    @Override
    public Criteria[] getCriteria(ICriterion ... criterions) {
        int i;
        CriteriaImpl[] criterias = new CriteriaImpl[this.checkEntityNumber(criterions)];
        int index = 0;
        for (i = 0; i < criterions.length; ++i) {
            if (!(criterions[i] instanceof IEntityFactory)) continue;
            this.arrayEntity = (Object[])criterions[i].getValue();
            String alias = criterions[i].getName();
            if (this.arrayEntity.length > 1) {
                for (int j = 0; j < this.arrayEntity.length; ++j) {
                    if (null != alias) {
                        criterias[j] = this.session.createCriteria(this.arrayEntity[j].toString(), alias);
                        criterias[j].setCacheable(criterions[i].getCacheable());
                    } else {
                        criterias[j] = this.getCriteria(this.arrayEntity[j].toString());
                        criterias[j].setCacheable(criterions[i].getCacheable());
                    }
                    ++index;
                }
                continue;
            }
            if (null != alias) {
                criterias[index] = this.session.createCriteria(this.arrayEntity[0].toString(), alias);
                criterias[index].setCacheable(criterions[i].getCacheable());
            } else {
                criterias[index] = this.getCriteria(this.arrayEntity[0].toString());
                criterias[index].setCacheable(criterions[i].getCacheable());
                ++index;
            }
            ++index;
        }
        for (i = 0; i < criterias.length; ++i) {
            LOG.debug(criterias[i].toString());
        }
        return criterias;
    }

    private int checkEntityNumber(ICriterion ... criterions) {
        this.entityFactorySize = 0;
        for (int i = 0; i < criterions.length; ++i) {
            if (!(criterions[i] instanceof IEntityFactory)) continue;
            Object[] arrayEntity = (Object[])criterions[i].getValue();
            if (arrayEntity.length > 1) {
                this.entityFactorySize += arrayEntity.length;
                continue;
            }
            ++this.entityFactorySize;
        }
        return this.entityFactorySize;
    }

    private int checkCriterionNumber(ICriterion ... criterions) {
        this.criterionSize = 0;
        for (int i = 0; i < criterions.length; ++i) {
            if (!(criterions[i] instanceof IRestrictions) && !(criterions[i] instanceof IProjection)) continue;
            ++this.criterionSize;
        }
        return this.criterionSize;
    }

    @Override
    public Criteria createAGroupCriteria(Criteria criteria, ICriterion ... criterions) {
        if (this.criterionSize <= 0) {
            return criteria;
        }
        Disjunction ors = Restrictions.disjunction();
        try {
            Conjunction createAGroupEqCriteria = Restrictions.conjunction();
            Conjunction createAGroupNeCriteria = Restrictions.conjunction();
            Conjunction createAGroupGtCriteria = Restrictions.conjunction();
            Conjunction createAGroupGeCriteria = Restrictions.conjunction();
            Conjunction createAGroupLtCriteria = Restrictions.conjunction();
            Conjunction createAGroupLeCriteria = Restrictions.conjunction();
            Conjunction createAGroupIsNullCriteria = Restrictions.conjunction();
            Disjunction createAGroupIsNotNullCriteria = Restrictions.disjunction();
            Disjunction createAGroupIlikeCriteria = Restrictions.disjunction();
            Disjunction createAGroupOrCriteria = Restrictions.disjunction();
            Disjunction createAGroupInCriteria = Restrictions.disjunction();
            Disjunction createAGroupBetweenCriteria = Restrictions.disjunction();
            ProjectionList createAGroupPropertyCriteria = Projections.projectionList();
            int ieq = 0;
            int ine = 0;
            int igt = 0;
            int ige = 0;
            int ilt = 0;
            int ile = 0;
            int iIsNull = 0;
            int iIsNotNull = 0;
            int ior = 0;
            int iIn = 0;
            int ilikei = 0;
            int ibetween = 0;
            for (int i = 0; i < criterions.length; ++i) {
                Object[] array;
                if (criterions[i] instanceof Eq) {
                    array = (Object[])criterions[i].getValue();
                    for (int j = 0; j < array.length; ++j) {
                        createAGroupEqCriteria.add((Criterion)Restrictions.eq((String)criterions[i].getName(), (Object)array[j]));
                    }
                    ++ieq;
                    continue;
                }
                if (criterions[i] instanceof Ne) {
                    array = (Object[])criterions[i].getValue();
                    for (int j = 0; j < array.length; ++j) {
                        createAGroupNeCriteria.add((Criterion)Restrictions.ne((String)criterions[i].getName(), (Object)array[j]));
                    }
                    ++ine;
                    continue;
                }
                if (criterions[i] instanceof Gt) {
                    array = (Object[])criterions[i].getValue();
                    for (int j = 0; j < array.length; ++j) {
                        createAGroupGtCriteria.add((Criterion)Restrictions.gt((String)criterions[i].getName(), (Object)array[j]));
                    }
                    ++igt;
                    continue;
                }
                if (criterions[i] instanceof Ge) {
                    array = (Object[])criterions[i].getValue();
                    for (int j = 0; j < array.length; ++j) {
                        createAGroupGeCriteria.add((Criterion)Restrictions.ge((String)criterions[i].getName(), (Object)array[j]));
                    }
                    ++ige;
                    continue;
                }
                if (criterions[i] instanceof Lt) {
                    array = (Object[])criterions[i].getValue();
                    for (int j = 0; j < array.length; ++j) {
                        createAGroupLtCriteria.add((Criterion)Restrictions.lt((String)criterions[i].getName(), (Object)array[j]));
                    }
                    ++ilt;
                    continue;
                }
                if (criterions[i] instanceof Le) {
                    array = (Object[])criterions[i].getValue();
                    for (int j = 0; j < array.length; ++j) {
                        createAGroupLeCriteria.add((Criterion)Restrictions.le((String)criterions[i].getName(), (Object)array[j]));
                    }
                    ++ile;
                    continue;
                }
                if (criterions[i] instanceof IsNull) {
                    array = (Object[])criterions[i].getValue();
                    for (int j = 0; j < array.length; ++j) {
                        createAGroupIsNullCriteria.add(Restrictions.isNull((String)array[j].toString()));
                    }
                    ++iIsNull;
                    continue;
                }
                if (criterions[i] instanceof IsNotNull) {
                    array = (Object[])criterions[i].getValue();
                    for (int j = 0; j < array.length; ++j) {
                        createAGroupIsNotNullCriteria.add(Restrictions.isNotNull((String)array[j].toString()));
                    }
                    ++iIsNotNull;
                    continue;
                }
                if (criterions[i] instanceof Or) {
                    array = (Object[])criterions[i].getValue();
                    for (int j = 0; j < array.length; ++j) {
                        createAGroupOrCriteria.add((Criterion)Restrictions.eq((String)criterions[i].getName(), (Object)array[j]));
                    }
                    ++ior;
                    continue;
                }
                if (criterions[i] instanceof In) {
                    array = (Object[])criterions[i].getValue();
                    createAGroupInCriteria.add(Restrictions.in((String)criterions[i].getName(), (Object[])array));
                    ++iIn;
                    continue;
                }
                if (criterions[i] instanceof Between) {
                    array = (Object[])criterions[i].getValue();
                    createAGroupBetweenCriteria.add(Restrictions.between((String)criterions[i].getName(), (Object)array[0], (Object)array[1]));
                    ++ibetween;
                    continue;
                }
                if (criterions[i] instanceof Property) {
                    int j;
                    array = (Object[])criterions[i].getValue();
                    ArrayList<Projection> projectionList = new ArrayList<Projection>();
                    for (j = 0; j < array.length; ++j) {
                        projectionList.add(Projections.property((String)(PropertyEnum.ALIAS.getValue() + "." + array[j])).as(array[j].toString()));
                    }
                    for (j = 0; j < projectionList.size(); ++j) {
                        createAGroupPropertyCriteria.add((Projection)projectionList.get(j));
                    }
                    String entityVO = criterions[i].getName();
                    if (entityVO == null) {
                        entityVO = this.arrayEntity[0].toString();
                    }
                    Class<?> classNameVO = Class.forName(entityVO);
                    criteria.setProjection((Projection)createAGroupPropertyCriteria);
                    criteria.setResultTransformer(Transformers.aliasToBean(classNameVO));
                    continue;
                }
                if (criterions[i] instanceof Ilike) {
                    Ilike ilike = (Ilike)criterions[i];
                    Object[] array2 = (Object[])ilike.getValue();
                    switch (ilike.getMatchMode()) {
                        case EXACT: {
                            for (int j = 0; j < array2.length; ++j) {
                                createAGroupIlikeCriteria.add(Restrictions.ilike((String)ilike.getName(), (String)array2[j].toString(), (MatchMode)MatchMode.EXACT));
                            }
                            ++ilikei;
                            break;
                        }
                        case START: {
                            for (int j = 0; j < array2.length; ++j) {
                                createAGroupIlikeCriteria.add(Restrictions.ilike((String)ilike.getName(), (String)array2[j].toString(), (MatchMode)MatchMode.START));
                            }
                            ++ilikei;
                            break;
                        }
                        case END: {
                            for (int j = 0; j < array2.length; ++j) {
                                createAGroupIlikeCriteria.add(Restrictions.ilike((String)ilike.getName(), (String)array2[j].toString(), (MatchMode)MatchMode.END));
                            }
                            ++ilikei;
                            break;
                        }
                        case ANYWHERE: {
                            for (int j = 0; j < array2.length; ++j) {
                                createAGroupIlikeCriteria.add(Restrictions.ilike((String)ilike.getName(), (String)array2[j].toString(), (MatchMode)MatchMode.ANYWHERE));
                            }
                            ++ilikei;
                            break;
                        }
                    }
                    continue;
                }
                if (criterions[i] instanceof Paging) {
                    Paging paging = (Paging)criterions[i];
                    int firstResult = paging.getFirstResult();
                    int maxResults = paging.getMaxResults();
                    criteria.setFirstResult((firstResult - 1) * maxResults);
                    criteria.setMaxResults(maxResults);
                    continue;
                }
                if (!(criterions[i] instanceof Order)) continue;
                if (OrderEnum.DESC.getValue().equalsIgnoreCase(criterions[i].getName())) {
                    criteria.addOrder(org.hibernate.criterion.Order.desc((String)criterions[i].getValue().toString()));
                    continue;
                }
                if (!OrderEnum.ASC.getValue().equalsIgnoreCase(criterions[i].getName())) continue;
                criteria.addOrder(org.hibernate.criterion.Order.asc((String)criterions[i].getValue().toString()));
            }
            if (ieq > 0) {
                ors.add((Criterion)createAGroupEqCriteria);
            }
            if (ine > 0) {
                ors.add((Criterion)createAGroupNeCriteria);
            }
            if (igt > 0) {
                ors.add((Criterion)createAGroupGtCriteria);
            }
            if (ige > 0) {
                ors.add((Criterion)createAGroupGeCriteria);
            }
            if (ilt > 0) {
                ors.add((Criterion)createAGroupLtCriteria);
            }
            if (ile > 0) {
                ors.add((Criterion)createAGroupLeCriteria);
            }
            if (iIsNull > 0) {
                ors.add((Criterion)createAGroupIsNullCriteria);
            }
            if (iIsNotNull > 0) {
                ors.add((Criterion)createAGroupIsNotNullCriteria);
            }
            if (ior > 0) {
                ors.add((Criterion)createAGroupOrCriteria);
            }
            if (iIn > 0) {
                ors.add((Criterion)createAGroupInCriteria);
            }
            if (ilikei > 0) {
                ors.add((Criterion)createAGroupIlikeCriteria);
            }
            if (ibetween > 0) {
                ors.add((Criterion)createAGroupBetweenCriteria);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteria.add((Criterion)ors);
    }

    @Override
    public Query createAGroupCriteria(Query query, ICriterion ... criterions) {
        for (int i = 0; i < criterions.length; ++i) {
            if (!(criterions[i] instanceof Paging)) continue;
            Paging paging = (Paging)criterions[i];
            int firstResult = paging.getFirstResult();
            int maxResults = paging.getMaxResults();
            query.setFirstResult((firstResult - 1) * maxResults);
            query.setMaxResults(maxResults);
        }
        return query;
    }

    @Override
    public boolean isEmpty(Class<?> clazz, String criteriaKey, String criteriaValue) throws Exception {
        StringBuffer hql = new StringBuffer();
        hql.append("from " + clazz.getName());
        hql.append(" as model where model." + criteriaKey + "=" + "'" + criteriaValue + "'");
        Object object = this.session.createQuery(hql.toString()).uniqueResult();
        return object == null;
    }

    @Override
    public <T> T getById(Serializable id, Class<T> T) throws Exception {
        return (T)this.session.get(T, id);
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public Session openSession() {
        return this.session;
    }

    @Override
    public Criteria getCriteria(Class<?> entity) {
        return this.session.createCriteria(entity);
    }

    @Override
    public Criteria getCriteria(String className) {
        return this.session.createCriteria(className);
    }

    @Override
    public void closeSession() {
        if (null != this.session) {
            this.session.close();
        }
    }

    @Override
    public void close() {
        this.closeSession();
    }

    @Override
    public void evict(Object entity) throws Exception {
        this.session.evict(entity);
    }

    @Override
    public void clear() throws Exception {
        this.session.clear();
    }

    @Override
    public void contains(Object entity) throws Exception {
        this.session.contains(entity);
    }

    @Override
    public void flush() throws Exception {
        this.session.flush();
    }

    @Override
    public Object beginTransaction() throws Exception {
        return this.session.beginTransaction();
    }

    @Override
    public void commit() throws Exception {
        this.session.getTransaction().commit();
    }
}

