/*
 * Decompiled with CFR 0.152.
 */
package co.leantechniques.maven.buildtime;

import co.leantechniques.maven.buildtime.SystemClock;
import co.leantechniques.maven.buildtime.TimerVisitor;

public class MojoTimer
implements Comparable<MojoTimer> {
    private final String projectName;
    private String name;
    private long startTime = 0L;
    private long endTime = 0L;
    private SystemClock systemClock;

    public MojoTimer(String projectName, String name, SystemClock systemClock) {
        this(projectName, name, 0L, 0L, systemClock);
    }

    public MojoTimer(String projectName, String name, long startTime, long endTime) {
        this(projectName, name, startTime, endTime, new SystemClock());
    }

    public MojoTimer(String projectName, String name, long startTime, long endTime, SystemClock systemClock) {
        this.projectName = projectName;
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.systemClock = systemClock;
    }

    public Long getDuration() {
        return this.endTime - this.startTime;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void stop() {
        this.endTime = this.systemClock.currentTimeMillis();
    }

    public void start() {
        this.startTime = this.systemClock.currentTimeMillis();
    }

    public void accept(TimerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int compareTo(MojoTimer that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        if (this.startTime > that.startTime) {
            return 1;
        }
        if (this.startTime < that.startTime) {
            return -1;
        }
        return 0;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

