/*
 * Decompiled with CFR 0.152.
 */
package co.leantechniques.maven.buildtime;

import co.leantechniques.maven.buildtime.MojoExecutionName;
import co.leantechniques.maven.buildtime.MojoTimer;
import co.leantechniques.maven.buildtime.ProjectTimer;
import co.leantechniques.maven.buildtime.SystemClock;
import co.leantechniques.maven.buildtime.TimerVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

public class SessionTimer {
    private ConcurrentMap<String, ProjectTimer> projects;
    private SystemClock systemClock;

    public SessionTimer() {
        this(new ConcurrentHashMap<String, ProjectTimer>(), new SystemClock());
    }

    public SessionTimer(ConcurrentMap<String, ProjectTimer> projects, SystemClock systemClock) {
        this.projects = projects;
        this.systemClock = systemClock;
    }

    public ProjectTimer getProject(MavenProject project) {
        return this.getProject(project.getArtifactId());
    }

    public ProjectTimer getProject(String projectArtifactId) {
        if (!this.projects.containsKey(projectArtifactId)) {
            this.projects.putIfAbsent(projectArtifactId, new ProjectTimer(projectArtifactId, this.systemClock));
        }
        return (ProjectTimer)this.projects.get(projectArtifactId);
    }

    public void accept(TimerVisitor visitor) {
        visitor.visit(this);
        ArrayList projectTimers = new ArrayList(this.projects.values());
        Collections.sort(projectTimers);
        for (ProjectTimer projectTimer : projectTimers) {
            projectTimer.accept(visitor);
        }
    }

    public void mojoStarted(MavenProject project, MojoExecution mojoExecution) {
        this.getProject(project).startTimerFor(new MojoExecutionName(mojoExecution));
    }

    public void mojoSucceeded(MavenProject project, MojoExecution mojoExecution) {
        this.getProject(project).stopTimerFor(new MojoExecutionName(mojoExecution));
    }

    public void mojoFailed(MavenProject project, MojoExecution mojoExecution) {
        this.getProject(project).stopTimerFor(new MojoExecutionName(mojoExecution));
    }

    public MojoTimer getMojoTimer(MavenProject project, MojoExecution mojoExecution) {
        return this.getProject(project).getMojoTimer(new MojoExecutionName(mojoExecution));
    }
}

