/*
 * Decompiled with CFR 0.152.
 */
package co.leantechniques.maven.buildtime.output;

import co.leantechniques.maven.buildtime.AbstractTimerVisitor;
import co.leantechniques.maven.buildtime.LogOutput;
import co.leantechniques.maven.buildtime.MavenHelper;
import co.leantechniques.maven.buildtime.MojoTimer;
import co.leantechniques.maven.buildtime.ProjectTimer;
import co.leantechniques.maven.buildtime.SessionTimer;
import co.leantechniques.maven.buildtime.output.Reporter;
import java.util.Locale;
import org.apache.maven.execution.ExecutionEvent;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;

public class LogReporter
implements Reporter {
    public static final int MAX_NAME_LENGTH = 58;
    public static final String DIVIDER = "------------------------------------------------------------------------";

    @Override
    public void performReport(Logger logger, ExecutionEvent event, SessionTimer session) {
        LogOutput logOutput = new LogOutput(logger, Boolean.parseBoolean(MavenHelper.getExecutionProperty(event, "buildtime.output.log", "false")));
        session.accept(new LogReportVisitor(logOutput));
    }

    public static class LogReportVisitor
    extends AbstractTimerVisitor {
        private LogOutput logOutput;

        public LogReportVisitor(LogOutput logOutput) {
            this.logOutput = logOutput;
        }

        @Override
        public void visit(SessionTimer sessionTimer) {
            this.logOutput.log(LogReporter.DIVIDER);
            this.logOutput.log("Build Time Summary:");
            this.logOutput.log(LogReporter.DIVIDER);
        }

        @Override
        public void visit(ProjectTimer projectTimer) {
            this.logOutput.log(String.format("%s [%.3fs]", projectTimer.getProjectName(), (double)projectTimer.getDuration().longValue() / 1000.0));
        }

        @Override
        public void visit(MojoTimer mojoTimer) {
            this.logOutput.log(String.format(Locale.ENGLISH, "  %s [%.3fs]", this.getDisplayName(mojoTimer.getName()), (double)mojoTimer.getDuration().longValue() / 1000.0));
        }

        private String getDisplayName(String name) {
            String truncatedName = name.length() >= 58 ? StringUtils.substring((String)name, (int)0, (int)58) : name + " ";
            return StringUtils.rightPad((String)truncatedName, (int)58, (String)".");
        }
    }
}

