/*
 * Decompiled with CFR 0.152.
 */
package co.lujun.lmbluetoothsdk;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import co.lujun.lmbluetoothsdk.base.Bluetooth;
import co.lujun.lmbluetoothsdk.base.BluetoothLEListener;
import co.lujun.lmbluetoothsdk.service.BluetoothLEService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@TargetApi(value=21)
public class BluetoothLEController
extends Bluetooth {
    private BluetoothLeScanner mLEScanner;
    private BluetoothLEService mBluetoothLEService;
    private BluetoothDevice mConnectDevice;
    private ScanSettings mLeSettings;
    private List<ScanFilter> mLeFilters;
    private Handler mHandler;
    private int mScanTime = 120000;
    private static BluetoothLEController sBluetoothLEController;
    private BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            if (BluetoothLEController.this.mBluetoothListener != null) {
                BluetoothLEController.this.mBluetoothListener.onActionDeviceFound(device);
            }
        }
    };
    private CBTScanCallback mCbtScanCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BluetoothLEController getInstance() {
        if (sBluetoothLEController != null) return sBluetoothLEController;
        Class<BluetoothLEController> clazz = BluetoothLEController.class;
        synchronized (BluetoothLEController.class) {
            if (sBluetoothLEController != null) return sBluetoothLEController;
            sBluetoothLEController = new BluetoothLEController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sBluetoothLEController;
        }
    }

    public BluetoothLEController build(Context context) {
        this.mContext = context;
        this.mHandler = new Handler();
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        this.mBluetoothLEService = new BluetoothLEService();
        return this;
    }

    public void setBluetoothListener(BluetoothLEListener listener) {
        this.mBluetoothListener = listener;
        this.registerReceiver();
        if (this.mBluetoothLEService != null) {
            this.mBluetoothLEService.setBluetoothLEListener(this.mBluetoothListener);
        }
    }

    public boolean isSupportBLE() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    @Override
    public boolean startScan() {
        if (!this.isAvailable() && !this.isEnabled()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mLEScanner = this.mBluetoothAdapter.getBluetoothLeScanner();
            this.mLeSettings = new ScanSettings.Builder().setScanMode(2).build();
            this.mLeFilters = new ArrayList<ScanFilter>();
        }
        this.scanLeDevice();
        return true;
    }

    private void scanLeDevice() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                BluetoothLEController.this.cancelScan();
            }
        }, (long)this.mScanTime);
        if (this.mBluetoothListener != null) {
            this.mBluetoothListener.onActionDiscoveryStateChanged("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
        } else {
            if (this.mCbtScanCallback == null) {
                this.mCbtScanCallback = new CBTScanCallback();
            }
            this.mLEScanner.startScan(this.mLeFilters, this.mLeSettings, (ScanCallback)this.mCbtScanCallback);
        }
    }

    @Override
    public boolean cancelScan() {
        if (!this.isAvailable() && !this.isEnabled()) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        } else {
            this.mLEScanner.stopScan((ScanCallback)this.mCbtScanCallback);
        }
        if (this.mBluetoothListener != null) {
            this.mBluetoothListener.onActionDiscoveryStateChanged("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        }
        return true;
    }

    @Override
    public Set<BluetoothDevice> getBondedDevices() {
        return super.getBondedDevices();
    }

    @Override
    public BluetoothDevice findDeviceByMac(String mac) {
        return super.findDeviceByMac(mac);
    }

    @Override
    public void connect(String mac) {
        if (this.mBluetoothLEService != null) {
            this.mConnectDevice = this.mBluetoothAdapter.getRemoteDevice(mac);
            this.mBluetoothLEService.connect(this.mContext, this.mConnectDevice);
        }
    }

    public void reConnect() {
        if (this.mBluetoothLEService != null) {
            this.mBluetoothLEService.reConnect();
        }
    }

    @Override
    public void disconnect() {
        if (this.mBluetoothLEService != null) {
            this.mBluetoothLEService.disConnect();
        }
    }

    @Override
    public void release() {
        this.mBluetoothLEService.close();
        this.mBluetoothLEService = null;
        super.release();
    }

    @Override
    public int getConnectionState() {
        if (this.mBluetoothLEService != null) {
            return this.mBluetoothLEService.getState();
        }
        return 5;
    }

    @Override
    public void write(byte[] data) {
        if (this.mBluetoothLEService != null) {
            this.mBluetoothLEService.write(data);
        }
    }

    public void setScanTime(int time) {
        this.mScanTime = time;
    }

    public int getScanTime() {
        return this.mScanTime;
    }

    @Override
    public BluetoothDevice getConnectedDevice() {
        return this.mConnectDevice;
    }

    private class CBTScanCallback
    extends ScanCallback {
        private CBTScanCallback() {
        }

        public void onScanResult(int callbackType, ScanResult result) {
            super.onScanResult(callbackType, result);
            if (BluetoothLEController.this.mBluetoothListener != null) {
                BluetoothLEController.this.mBluetoothListener.onActionDeviceFound(result.getDevice());
            }
        }

        public void onBatchScanResults(List<ScanResult> results) {
            super.onBatchScanResults(results);
        }

        public void onScanFailed(int errorCode) {
            super.onScanFailed(errorCode);
        }
    }
}

