/*
 * Decompiled with CFR 0.152.
 */
package co.lujun.lmbluetoothsdk.base;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import co.lujun.lmbluetoothsdk.base.BaseListener;
import co.lujun.lmbluetoothsdk.receiver.BlueToothReceiver;
import java.util.Set;

public abstract class Bluetooth {
    protected BluetoothAdapter mBluetoothAdapter;
    protected BlueToothReceiver mReceiver;
    protected BaseListener mBluetoothListener;
    protected Context mContext;

    protected void registerReceiver() {
        if (this.mBluetoothListener == null || this.mContext == null) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        filter.addAction("android.bluetooth.device.action.FOUND");
        filter.addAction("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
        this.mReceiver = new BlueToothReceiver(this.mBluetoothListener);
        this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, filter);
    }

    public boolean isAvailable() {
        return this.mBluetoothAdapter != null;
    }

    public boolean isEnabled() {
        if (this.isAvailable()) {
            return this.mBluetoothAdapter.isEnabled();
        }
        return false;
    }

    public boolean openBluetooth() {
        if (!this.isAvailable()) {
            return false;
        }
        return this.mBluetoothAdapter.enable();
    }

    public void closeBluetooth() {
        if (!this.isAvailable() && !this.isEnabled()) {
            return;
        }
        this.mBluetoothAdapter.disable();
    }

    public int getBluetoothState() {
        if (!this.isAvailable()) {
            return 10;
        }
        return this.mBluetoothAdapter.getState();
    }

    public boolean setDiscoverable(int time) {
        return false;
    }

    public boolean startScan() {
        return false;
    }

    public boolean cancelScan() {
        return false;
    }

    public Set<BluetoothDevice> getBondedDevices() {
        if (!this.isAvailable() || !this.isEnabled()) {
            throw new RuntimeException("Bluetooth is not avaliable!");
        }
        return this.mBluetoothAdapter.getBondedDevices();
    }

    public BluetoothDevice findDeviceByMac(String mac) {
        if (!this.isAvailable() || !this.isEnabled()) {
            throw new RuntimeException("Bluetooth is not avaliable!");
        }
        return this.mBluetoothAdapter.getRemoteDevice(mac);
    }

    public void startAsServer() {
    }

    public void connect(String mac) {
    }

    public void reConnect(String mac) {
    }

    public void disconnect() {
    }

    public void write(byte[] data) {
    }

    public BluetoothDevice getConnectedDevice() {
        return null;
    }

    public void release() {
        this.mBluetoothAdapter = null;
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
    }

    public int getConnectionState() {
        return 5;
    }
}

