/*
 * Decompiled with CFR 0.152.
 */
package co.lujun.lmbluetoothsdk;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import co.lujun.lmbluetoothsdk.base.Bluetooth;
import co.lujun.lmbluetoothsdk.base.BluetoothListener;
import co.lujun.lmbluetoothsdk.service.BluetoothService;
import java.util.Set;
import java.util.UUID;

public class BluetoothController
extends Bluetooth {
    private BluetoothService mBluetoothService;
    private static BluetoothController sBluetoothController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BluetoothController getInstance() {
        if (sBluetoothController != null) return sBluetoothController;
        Class<BluetoothController> clazz = BluetoothController.class;
        synchronized (BluetoothController.class) {
            if (sBluetoothController != null) return sBluetoothController;
            sBluetoothController = new BluetoothController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sBluetoothController;
        }
    }

    public BluetoothController build(Context context) {
        this.mContext = context;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mBluetoothService = new BluetoothService();
        return this;
    }

    public void setBluetoothListener(BluetoothListener listener) {
        this.mBluetoothListener = listener;
        this.registerReceiver();
        if (this.mBluetoothService != null) {
            this.mBluetoothService.setBluetoothListener(this.mBluetoothListener);
        }
    }

    @Override
    public boolean setDiscoverable(int time) {
        if (!this.isAvailable() && !this.isEnabled()) {
            return false;
        }
        Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
        intent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", time);
        this.mContext.startActivity(intent);
        return true;
    }

    @Override
    public boolean startScan() {
        if (!this.isAvailable() && !this.isEnabled()) {
            return false;
        }
        return this.mBluetoothAdapter.startDiscovery();
    }

    @Override
    public boolean cancelScan() {
        if (!this.isAvailable() && !this.isEnabled()) {
            return false;
        }
        return this.mBluetoothAdapter.cancelDiscovery();
    }

    @Override
    public Set<BluetoothDevice> getBondedDevices() {
        return super.getBondedDevices();
    }

    @Override
    public BluetoothDevice findDeviceByMac(String mac) {
        return super.findDeviceByMac(mac);
    }

    @Override
    public void startAsServer() {
        if (this.mBluetoothService != null) {
            this.mBluetoothService.start();
        }
    }

    @Override
    public void connect(String mac) {
        if (!this.isAvailable() || !this.isEnabled()) {
            throw new RuntimeException("Bluetooth is not avaliable!");
        }
        if (this.mBluetoothAdapter.isDiscovering()) {
            this.mBluetoothAdapter.cancelDiscovery();
        }
        if (this.mBluetoothService != null) {
            this.mBluetoothService.connect(this.mBluetoothAdapter.getRemoteDevice(mac));
        }
    }

    @Override
    public void reConnect(String mac) {
        if (!this.isAvailable() || !this.isEnabled()) {
            throw new RuntimeException("Bluetooth is not avaliable!");
        }
        if (this.mBluetoothAdapter.isDiscovering()) {
            this.mBluetoothAdapter.cancelDiscovery();
        }
        if (this.getConnectionState() == 4 && this.mBluetoothService != null && mac != null) {
            this.mBluetoothService.connect(this.mBluetoothAdapter.getRemoteDevice(mac));
        }
    }

    @Override
    public void disconnect() {
        if (this.mBluetoothService != null) {
            this.mBluetoothService.stop();
        }
    }

    @Override
    public void release() {
        this.mBluetoothService = null;
        super.release();
    }

    @Override
    public int getConnectionState() {
        if (this.mBluetoothService != null) {
            return this.mBluetoothService.getState();
        }
        return 5;
    }

    @Override
    public void write(byte[] data) {
        if (this.mBluetoothService != null) {
            this.mBluetoothService.write(data);
        }
    }

    public UUID getAppUuid() {
        if (this.mBluetoothService != null) {
            return this.mBluetoothService.getAppUuid();
        }
        return null;
    }

    public void setAppUuid(UUID uuid) {
        if (this.mBluetoothService != null) {
            this.mBluetoothService.setAppUuid(uuid);
        }
    }

    @Override
    public BluetoothDevice getConnectedDevice() {
        if (this.mBluetoothService != null) {
            return this.mBluetoothService.getConnectedDevice();
        }
        return null;
    }
}

