/*
 * Decompiled with CFR 0.152.
 */
package co.lujun.lmbluetoothsdk.receiver;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import co.lujun.lmbluetoothsdk.base.BaseListener;

public class BlueToothReceiver
extends BroadcastReceiver {
    private BaseListener mBluetoothListener;

    public BlueToothReceiver(BaseListener listener) {
        this.mBluetoothListener = listener;
    }

    public void onReceive(Context context, Intent intent) {
        String action;
        if (intent == null || this.mBluetoothListener == null) {
            return;
        }
        switch (action = intent.getAction()) {
            case "android.bluetooth.adapter.action.STATE_CHANGED": {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                int preState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", 0);
                this.mBluetoothListener.onActionStateChanged(preState, state);
                break;
            }
            case "android.bluetooth.adapter.action.DISCOVERY_STARTED": {
                this.mBluetoothListener.onActionDiscoveryStateChanged("android.bluetooth.adapter.action.DISCOVERY_STARTED");
                break;
            }
            case "android.bluetooth.adapter.action.DISCOVERY_FINISHED": {
                this.mBluetoothListener.onActionDiscoveryStateChanged("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
                break;
            }
            case "android.bluetooth.device.action.FOUND": {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                short rssi = intent.getShortExtra("android.bluetooth.device.extra.RSSI", (short)0);
                this.mBluetoothListener.onActionDeviceFound(device, rssi);
                break;
            }
            case "android.bluetooth.adapter.action.SCAN_MODE_CHANGED": {
                int scanMode = intent.getIntExtra("android.bluetooth.adapter.extra.SCAN_MODE", 0);
                int preScanMode = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE", 0);
                this.mBluetoothListener.onActionScanModeChanged(preScanMode, scanMode);
            }
        }
    }
}

