/*
 * Decompiled with CFR 0.152.
 */
package co.lujun.lmbluetoothsdk.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.util.Log;
import co.lujun.lmbluetoothsdk.base.BaseListener;
import co.lujun.lmbluetoothsdk.base.BluetoothLEListener;
import java.util.List;

@TargetApi(value=21)
public class BluetoothLEService {
    private BaseListener mBluetoothListener;
    private BluetoothGatt mBluetoothGatt;
    private BluetoothGattCharacteristic mWriteCharacteristic;
    private BluetoothGattCharacteristic mNotifyCharacteristic;
    private String writeCharacteristicUUID;
    private String readCharacteristicUUID;
    private int mState = 0;
    private BluetoothGattCallback mBTGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            switch (newState) {
                case 2: {
                    BluetoothLEService.this.setState(3);
                    gatt.discoverServices();
                    break;
                }
                case 0: {
                    BluetoothLEService.this.setState(4);
                    break;
                }
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            if (status == 0) {
                List services = gatt.getServices();
                if (BluetoothLEService.this.mBluetoothListener != null) {
                    ((BluetoothLEListener)BluetoothLEService.this.mBluetoothListener).onDiscoveringServices(services);
                }
                for (BluetoothGattService service : services) {
                    List characteristics = service.getCharacteristics();
                    for (BluetoothGattCharacteristic characteristic : characteristics) {
                        int charaProp = characteristic.getProperties();
                        String charaUUID = characteristic.getUuid().toString();
                        if ((charaProp | 1) > 0) {
                            if (BluetoothLEService.this.readCharacteristicUUID.isEmpty()) {
                                if (BluetoothLEService.this.mNotifyCharacteristic != null) {
                                    BluetoothLEService.this.mBluetoothGatt.setCharacteristicNotification(BluetoothLEService.this.mNotifyCharacteristic, false);
                                    BluetoothLEService.this.mNotifyCharacteristic = null;
                                }
                                gatt.readCharacteristic(characteristic);
                            }
                            Log.d((String)"LMBluetoothSdk", (String)("Assigning read characteristic : " + characteristic.getUuid()));
                        }
                        if ((charaProp | 0x10) > 0) {
                            if (BluetoothLEService.this.readCharacteristicUUID.isEmpty()) {
                                BluetoothLEService.this.mNotifyCharacteristic = characteristic;
                                BluetoothLEService.this.mBluetoothGatt.setCharacteristicNotification(characteristic, true);
                            } else if (charaUUID.equalsIgnoreCase(BluetoothLEService.this.readCharacteristicUUID)) {
                                BluetoothLEService.this.mNotifyCharacteristic = characteristic;
                                if (BluetoothLEService.this.mBluetoothGatt.setCharacteristicNotification(characteristic, true)) {
                                    Log.d((String)"LMBluetoothSdk", (String)("Subscribing to characteristic : " + characteristic.getUuid()));
                                }
                            }
                        }
                        if (BluetoothLEService.this.writeCharacteristicUUID.isEmpty()) {
                            if ((charaProp & 0x10 | charaProp & 4) <= 0) continue;
                            BluetoothLEService.this.mWriteCharacteristic = characteristic;
                            continue;
                        }
                        if (!((charaProp & 8 | charaProp & 4) > 0 & charaUUID.equalsIgnoreCase(BluetoothLEService.this.writeCharacteristicUUID))) continue;
                        Log.d((String)"LMBluetoothSdk", (String)("Assigning write characteristic : " + characteristic.getUuid()));
                        BluetoothLEService.this.mWriteCharacteristic = characteristic;
                    }
                    if (BluetoothLEService.this.mBluetoothListener == null) continue;
                    ((BluetoothLEListener)BluetoothLEService.this.mBluetoothListener).onDiscoveringCharacteristics(characteristics);
                }
                BluetoothLEService.this.setState(6);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            if (BluetoothLEService.this.mBluetoothListener != null) {
                ((BluetoothLEListener)BluetoothLEService.this.mBluetoothListener).onReadData(characteristic);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            if (BluetoothLEService.this.mBluetoothListener != null) {
                ((BluetoothLEListener)BluetoothLEService.this.mBluetoothListener).onWriteData(characteristic);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            super.onCharacteristicChanged(gatt, characteristic);
            if (BluetoothLEService.this.mBluetoothListener != null) {
                ((BluetoothLEListener)BluetoothLEService.this.mBluetoothListener).onDataChanged(characteristic);
            }
        }
    };

    public synchronized void setBluetoothLEListener(BaseListener listener) {
        this.mBluetoothListener = listener;
    }

    private synchronized void setState(int state) {
        this.mState = state;
        if (this.mBluetoothListener != null) {
            this.mBluetoothListener.onBluetoothServiceStateChanged(state);
        }
    }

    public int getState() {
        return this.mState;
    }

    public void connect(Context context, BluetoothDevice device) {
        this.setState(2);
        this.mBluetoothGatt = device.connectGatt(context, false, this.mBTGattCallback);
    }

    public void reConnect() {
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.connect();
        }
    }

    public void disConnect() {
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.disconnect();
        }
    }

    public void close() {
        this.disConnect();
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.close();
        }
        this.mBluetoothGatt = null;
    }

    public void write(byte[] data) {
        if (this.mBluetoothGatt != null) {
            this.mWriteCharacteristic.setValue(data);
            this.mBluetoothGatt.writeCharacteristic(this.mWriteCharacteristic);
        }
    }

    public void setWriteCharacteristic(String characteristicUUID) {
        this.writeCharacteristicUUID = characteristicUUID;
    }

    public void setReadCharacteristic(String characteristicUUID) {
        this.readCharacteristicUUID = characteristicUUID;
    }
}

