/*
 * Decompiled with CFR 0.152.
 */
package co.lujun.lmbluetoothsdk.service;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import co.lujun.lmbluetoothsdk.base.BaseListener;
import co.lujun.lmbluetoothsdk.base.BluetoothListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.UUID;

public class BluetoothService {
    private static final String TAG = "LMBluetoothSdk";
    private final BluetoothAdapter mAdapter;
    private AcceptThread mAcceptThread;
    private ConnectThread mConnectThread;
    private ConnectedThread mConnectedThread;
    private BaseListener mBluetoothListener;
    private BluetoothDevice mBluetoothDevice;
    private int mState = 0;
    private UUID mAppUuid = UUID.fromString("fa87c0d0-afac-11de-8a39-0800200c9a66");

    public BluetoothService() {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public synchronized void setBluetoothListener(BaseListener listener) {
        this.mBluetoothListener = listener;
    }

    public UUID getAppUuid() {
        return this.mAppUuid;
    }

    public void setAppUuid(UUID uuid) {
        this.mAppUuid = uuid;
    }

    private synchronized void setState(int state) {
        this.mState = state;
        if (this.mBluetoothListener != null) {
            this.mBluetoothListener.onBluetoothServiceStateChanged(state);
        }
    }

    public int getState() {
        return this.mState;
    }

    public synchronized void start() {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread == null) {
            this.mAcceptThread = new AcceptThread();
            this.mAcceptThread.start();
        }
        this.setState(1);
    }

    public synchronized void connect(BluetoothDevice device) {
        if (this.mState == 2 && this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(device);
        this.mConnectThread.start();
        this.setState(2);
    }

    public synchronized void connected(BluetoothSocket socket) {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread != null) {
            this.mAcceptThread.cancel();
            this.mAcceptThread = null;
        }
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        this.mBluetoothDevice = socket.getRemoteDevice();
        this.setState(3);
    }

    public synchronized void stop() {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread != null) {
            this.mAcceptThread.cancel();
            this.mAcceptThread = null;
        }
        this.mBluetoothDevice = null;
        this.setState(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] out) {
        ConnectedThread r;
        BluetoothService bluetoothService = this;
        synchronized (bluetoothService) {
            if (this.mState != 3) {
                return;
            }
            r = this.mConnectedThread;
        }
        r.write(out, 0, out.length);
    }

    public BluetoothDevice getConnectedDevice() {
        return this.mBluetoothDevice;
    }

    private class ConnectedThread
    extends Thread {
        private final BluetoothSocket mmSocket;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        public ConnectedThread(BluetoothSocket socket) {
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            try {
                while (true) {
                    int bytes;
                    if (this.mmInStream.available() <= 0 || (bytes = this.mmInStream.read(buffer)) <= 0) {
                        continue;
                    }
                    byte[] data = Arrays.copyOf(buffer, bytes);
                    if (BluetoothService.this.mBluetoothListener == null) continue;
                    ((BluetoothListener)BluetoothService.this.mBluetoothListener).onReadData(this.mmSocket.getRemoteDevice(), data);
                }
            }
            catch (IOException e) {
                BluetoothService.this.setState(4);
                return;
            }
        }

        public void write(byte[] buffer, int start, int end) {
            try {
                this.mmOutStream.write(buffer, start, end);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ConnectThread
    extends Thread {
        private final BluetoothSocket mmSocket;

        public ConnectThread(BluetoothDevice device) {
            BluetoothSocket tmp = null;
            try {
                tmp = device.createRfcommSocketToServiceRecord(BluetoothService.this.mAppUuid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mmSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BluetoothService.this.mAdapter.cancelDiscovery();
            try {
                this.mmSocket.connect();
            }
            catch (IOException e) {
                BluetoothService.this.setState(1);
                try {
                    this.mmSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BluetoothService.this.start();
                return;
            }
            BluetoothService bluetoothService = BluetoothService.this;
            synchronized (bluetoothService) {
                BluetoothService.this.mConnectThread = null;
            }
            BluetoothService.this.connected(this.mmSocket);
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class AcceptThread
    extends Thread {
        private final BluetoothServerSocket mmServerSocket;

        public AcceptThread() {
            BluetoothServerSocket tmp = null;
            try {
                tmp = BluetoothService.this.mAdapter.listenUsingRfcommWithServiceRecord(BluetoothService.TAG, BluetoothService.this.mAppUuid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mmServerSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BluetoothSocket socket = null;
            while (BluetoothService.this.mState != 3) {
                try {
                    socket = this.mmServerSocket.accept();
                }
                catch (IOException e) {
                    break;
                }
                if (socket == null) continue;
                BluetoothService bluetoothService = BluetoothService.this;
                synchronized (bluetoothService) {
                    switch (BluetoothService.this.mState) {
                        case 1: 
                        case 2: 
                        case 4: {
                            BluetoothService.this.connected(socket);
                            break;
                        }
                        case 0: 
                        case 3: {
                            try {
                                socket.close();
                                break;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }

        public void cancel() {
            try {
                this.mmServerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

