/*
 * Decompiled with CFR 0.152.
 */
package co.lujun.popmenulayout;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.CardView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import co.lujun.popmenulayout.MenuBean;
import co.lujun.popmenulayout.OnMenuClickListener;
import co.lujun.popmenulayout.PopMenuLayout;
import co.lujun.popmenulayout.R;
import co.lujun.popmenulayout.Util;
import co.lujun.popmenulayout.adapter.MenuAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PopMenuView
extends PopupWindow {
    private Context mContext;
    private View mRootView;
    private CardView mCardView;
    private RecyclerView mRecyclerView;
    private MenuAdapter mMenuAdapter;
    private LinearLayoutManager mLayoutManager;
    private PopMenuLayout mPopMenuLayout;
    private PopMenuView mChildPopMenuView;
    private PopMenuView mParentPopMenuView;
    private OnMenuClickListener mOnMenuClickListener;
    private List<MenuBean> mMenus;
    private int mLayoutManagerOrientation = 1;
    private int mWidth = -1;
    private int mHeight = -1;
    private int mAnimStyle = -1;
    private float mMenuItemHeight = 50.0f;
    private boolean isWithLevel1MenuWidth = false;
    private float mMenuDividerDp = 1.0f;
    private float mMenuTextPaddingLeft = 10.0f;
    private float mMenuTextPaddingRight = 10.0f;
    private float mMenuTextPaddingTop = 5.0f;
    private float mMenuTextPaddingBottom = 5.0f;
    private float mMenuTextSize = 14.0f;
    private int mDividerColor = -7829368;
    private int mExpandableIcon = R.drawable.ic_expandable_arrow;
    private int mMenuTextColor = -16777216;
    private int mHorizontalMenuBackgroundRes = R.drawable.shape_default_menu;
    private int mVerticalMenuBackgroundRes = R.drawable.shape_default_menu;
    private int mMaxMenuItemCount = 4;
    private int mMenuLayoutBgColor = -1;
    private float mDividerMarginLeft = 0.0f;
    private float mDividerMarginRight = 0.0f;
    private float mDividerMarginTop = 0.0f;
    private float mDividerMarginBottom = 0.0f;
    private static final String TAG = "PopMenuView";

    public PopMenuView(Context context, PopMenuLayout popMenuLayout, int mWidth, int mHeight) {
        this(context, popMenuLayout, null, mWidth, mHeight);
    }

    public PopMenuView(Context context, PopMenuLayout popMenuLayout, PopMenuView parentPopMenuView, int mWidth, int mHeight) {
        super(context);
        this.mContext = context;
        this.mPopMenuLayout = popMenuLayout;
        this.mParentPopMenuView = parentPopMenuView;
        this.mWidth = mWidth;
        this.mHeight = mHeight;
        this.mMenuDividerDp = Util.dp2px(this.mContext, this.mMenuDividerDp);
        this.mMenuTextPaddingLeft = Util.dp2px(this.mContext, this.mMenuTextPaddingLeft);
        this.mMenuTextPaddingRight = Util.dp2px(this.mContext, this.mMenuTextPaddingRight);
        this.mMenuTextPaddingTop = Util.dp2px(this.mContext, this.mMenuTextPaddingTop);
        this.mMenuTextPaddingBottom = Util.dp2px(this.mContext, this.mMenuTextPaddingBottom);
        this.mMenuItemHeight = Util.dp2px(this.mContext, this.mMenuItemHeight);
        this.mDividerMarginLeft = Util.dp2px(this.mContext, this.mDividerMarginLeft);
        this.mDividerMarginRight = Util.dp2px(this.mContext, this.mDividerMarginRight);
        this.mDividerMarginTop = Util.dp2px(this.mContext, this.mDividerMarginTop);
        this.mDividerMarginBottom = Util.dp2px(this.mContext, this.mDividerMarginBottom);
        this.init(context);
    }

    private void init(Context context) {
        this.mMenus = new ArrayList<MenuBean>();
        this.mMenuAdapter = new MenuAdapter(this.mContext, this.mMenus, this.mLayoutManagerOrientation);
        this.mMenuAdapter.setMenuWidth(this.mWidth);
        this.mMenuAdapter.setTextPaddingLeft(this.mMenuTextPaddingLeft);
        this.mMenuAdapter.setTextPaddingBottom(this.mMenuTextPaddingBottom);
        this.mMenuAdapter.setTextPaddingRight(this.mMenuTextPaddingRight);
        this.mMenuAdapter.setTextPaddingTop(this.mMenuTextPaddingTop);
        this.mMenuAdapter.setDividerDp(this.mMenuDividerDp);
        this.mMenuAdapter.setDividerColor(this.mDividerColor);
        this.mMenuAdapter.setExpandableIcon(this.mExpandableIcon);
        this.mMenuAdapter.setMenuTextColor(this.mMenuTextColor);
        this.mMenuAdapter.setHorizontalMenuBackgroundRes(this.mHorizontalMenuBackgroundRes);
        this.mMenuAdapter.setVerticalMenuBackgroundRes(this.mVerticalMenuBackgroundRes);
        this.mMenuAdapter.setMenuTextSize(this.mMenuTextSize);
        this.mMenuAdapter.setOnMenuClickListener(new OnMenuClickListener(){

            @Override
            public void onMenuClick(int level1Index, int level2Index, int level3Index) {
                PopMenuView.this.dealMenuClickEvent(level1Index, level2Index, level3Index);
            }
        });
        this.mLayoutManager = new LinearLayoutManager(this.mContext);
        this.mLayoutManager.setOrientation(this.mLayoutManagerOrientation);
        this.mRootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.view_menu_container, null);
        this.mCardView = (CardView)this.mRootView.findViewById(R.id.cardView);
        this.mCardView.setCardBackgroundColor(this.mMenuLayoutBgColor);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mCardView.getLayoutParams();
        if (this.mWidth != -1) {
            params.width = this.mWidth;
        }
        if (this.mHeight != -1) {
            params.height = this.mHeight;
        }
        this.mCardView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRecyclerView = (RecyclerView)this.mRootView.findViewById(R.id.recyclerView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mMenuAdapter);
        this.setContentView(this.mRootView);
        this.setWidth(-2);
        this.setHeight(-2);
        this.setFocusable(true);
        this.setAnimationStyle(this.mAnimStyle);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
    }

    public void dismiss() {
        super.dismiss();
        if (this.getParentPopMenuView() != null && this.getParentPopMenuView().isShowing()) {
            this.getParentPopMenuView().dismiss();
        }
        if (this.mPopMenuLayout != null) {
            this.mPopMenuLayout.setAllChildLevelMenuDismissFlag();
        }
    }

    private void dealMenuClickEvent(int level1Index, int level2Index, int level3Index) {
        if (this.mPopMenuLayout != null && this.mPopMenuLayout.getMenuShow()[1] && !this.mPopMenuLayout.getMenuShow()[2] && this.mMenus.get(level2Index).isExpandable()) {
            this.mPopMenuLayout.setMenus(2, true);
            if (this.getChildPopMenuView() == null) {
                this.setChildPopMenuView(new PopMenuView(this.mContext, this.mPopMenuLayout, this, this.mWidth, this.mHeight));
            }
            PopMenuView popMenuView = this.getChildPopMenuView();
            this.cloneAttributes(popMenuView);
            List<MenuBean> menus = this.mMenus.get(level2Index).getChild();
            popMenuView.setMenus(menus);
            popMenuView.setOnMenuClickListener(this.mOnMenuClickListener);
            int[] location = new int[2];
            this.mRootView.getLocationOnScreen(location);
            int showX = level1Index >= 1 && level1Index == this.mPopMenuLayout.getMenus().size() - 1 ? location[0] - popMenuView.getWidth() : location[0] + this.mRootView.getWidth();
            LinearLayoutManager manager = (LinearLayoutManager)this.mRecyclerView.getLayoutManager();
            int currentIndexTop = manager.findViewByPosition(level2Index).getTop();
            int showY = location[1] + (currentIndexTop + (1 - menus.size()) * (int)this.mMenuItemHeight);
            popMenuView.showAtLocation((View)this.mPopMenuLayout, 0, showX, showY);
        } else {
            if (this.mOnMenuClickListener != null) {
                this.mOnMenuClickListener.onMenuClick(level1Index, level2Index, level3Index);
            }
            this.dismiss();
        }
    }

    private void cloneAttributes(PopMenuView popMenuView) {
        popMenuView.setMenuItemHeight(this.mMenuItemHeight);
        popMenuView.setWithLevel1MenuWidth(this.isWithLevel1MenuWidth);
        popMenuView.setMenuTextPaddingLeft(this.mMenuTextPaddingLeft);
        popMenuView.setMenuTextPaddingBottom(this.mMenuTextPaddingBottom);
        popMenuView.setMenuTextPaddingRight(this.mMenuTextPaddingRight);
        popMenuView.setMenuTextPaddingTop(this.mMenuTextPaddingTop);
        popMenuView.setMenuDividerDp(this.mMenuDividerDp);
        popMenuView.setDividerColor(this.mDividerColor);
        popMenuView.setExpandableIcon(this.mExpandableIcon);
        popMenuView.setMenuTextColor(this.mMenuTextColor);
        popMenuView.setHorizontalMenuBackgroundRes(this.mHorizontalMenuBackgroundRes);
        popMenuView.setVerticalMenuBackgroundRes(this.mVerticalMenuBackgroundRes);
        popMenuView.setMenuTextSize(this.mMenuTextSize);
        popMenuView.setMaxMenuItemCount(this.mMaxMenuItemCount);
        popMenuView.setMenuLayoutBgColor(this.mMenuLayoutBgColor);
        popMenuView.setDividerMarginLeft(this.mDividerMarginLeft);
        popMenuView.setDividerMarginRight(this.mDividerMarginRight);
        popMenuView.setDividerMarginTop(this.mDividerMarginTop);
        popMenuView.setDividerMarginBottom(this.mDividerMarginBottom);
    }

    private int getSuitableWidth(List<MenuBean> menus) {
        if (this.isWithLevel1MenuWidth) {
            return this.mWidth;
        }
        Paint paint = new Paint(1);
        paint.setTextSize(this.mMenuAdapter.getMenuTextSize());
        ArrayList<Float> tmpList = new ArrayList<Float>();
        for (MenuBean menu : menus) {
            tmpList.add(Float.valueOf(paint.measureText(TextUtils.isEmpty((CharSequence)menu.getText()) ? "" : menu.getText())));
        }
        float tmpMaxW = ((Float)Collections.max(tmpList)).floatValue() + this.mMenuAdapter.getTextPaddingLeft() + this.mMenuAdapter.getTextPaddingRight();
        if (tmpMaxW > 0.0f) {
            if (this.getParentPopMenuView() != null) {
                PopMenuView popMenuView = this.getParentPopMenuView();
                int[] location = new int[2];
                int[] parentRootViewLocation = new int[2];
                this.mPopMenuLayout.getLocationOnScreen(location);
                this.getParentPopMenuView().getRootView().getLocationOnScreen(parentRootViewLocation);
                int width1 = Math.abs(location[0] - parentRootViewLocation[0]);
                int width2 = Math.abs(location[0] + this.mPopMenuLayout.getWidth() - parentRootViewLocation[0] - this.getParentPopMenuView().getWidth());
                int leftWidth = Math.max(width1, width2);
                this.mWidth = tmpMaxW > (float)leftWidth ? leftWidth : (int)tmpMaxW;
            } else {
                this.mWidth = tmpMaxW > (float)this.mPopMenuLayout.getWidth() ? this.mPopMenuLayout.getWidth() : (int)tmpMaxW;
            }
        }
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setHeight(int mHeight) {
        this.mHeight = mHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public List<MenuBean> getMenus() {
        return this.mMenus;
    }

    public void setMenus(List<MenuBean> menus) {
        int suitW = this.getSuitableWidth(menus);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mCardView.getLayoutParams();
        params.height = (menus.size() <= this.mMaxMenuItemCount ? menus.size() : this.mMaxMenuItemCount) * (int)this.mMenuItemHeight;
        params.width = suitW;
        this.mCardView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mMenuAdapter.setMenuWidth(suitW);
        this.mMenuAdapter.setMenuHeight((int)this.mMenuItemHeight);
        this.mMenus.clear();
        for (MenuBean menu : menus) {
            this.mMenus.add(menu);
        }
        if (this.mMenuAdapter != null) {
            this.mMenuAdapter.notifyDataSetChanged();
        }
    }

    public View getRootView() {
        return this.mRootView;
    }

    public void setOnMenuClickListener(OnMenuClickListener listener) {
        this.mOnMenuClickListener = listener;
    }

    public PopMenuView getChildPopMenuView() {
        return this.mChildPopMenuView;
    }

    public void setChildPopMenuView(PopMenuView mChildPopMenuView) {
        this.mChildPopMenuView = mChildPopMenuView;
    }

    public PopMenuView getParentPopMenuView() {
        return this.mParentPopMenuView;
    }

    public void setParentPopMenuView(PopMenuView parentPopMenuView) {
        this.mParentPopMenuView = parentPopMenuView;
    }

    public float getMenuItemHeight() {
        return this.mMenuItemHeight;
    }

    public void setMenuItemHeight(float menuItemHeight) {
        this.mMenuItemHeight = menuItemHeight;
    }

    public int getAnimStyle() {
        return this.mAnimStyle;
    }

    public void setAnimStyle(int mAnimStyle) {
        this.mAnimStyle = mAnimStyle;
        this.setAnimationStyle(mAnimStyle);
    }

    public boolean isWithLevel1MenuWidth() {
        return this.isWithLevel1MenuWidth;
    }

    public void setWithLevel1MenuWidth(boolean withLevel1MenuWidth) {
        this.isWithLevel1MenuWidth = withLevel1MenuWidth;
    }

    public float getMenuDividerDp() {
        return this.mMenuDividerDp;
    }

    public void setMenuDividerDp(float dividerDp) {
        this.mMenuDividerDp = dividerDp;
        this.mMenuAdapter.setDividerDp(this.mMenuDividerDp);
    }

    public float getMenuTextPaddingLeft() {
        return this.mMenuTextPaddingLeft;
    }

    public void setMenuTextPaddingLeft(float paddingLeft) {
        this.mMenuTextPaddingLeft = paddingLeft;
        this.mMenuAdapter.setTextPaddingLeft(this.mMenuTextPaddingLeft);
    }

    public float getMenuTextPaddingRight() {
        return this.mMenuTextPaddingRight;
    }

    public void setMenuTextPaddingRight(float paddingRight) {
        this.mMenuTextPaddingRight = paddingRight;
        this.mMenuAdapter.setTextPaddingRight(this.mMenuTextPaddingRight);
    }

    public float getMenuTextPaddingTop() {
        return this.mMenuTextPaddingTop;
    }

    public void setMenuTextPaddingTop(float paddingTop) {
        this.mMenuTextPaddingTop = paddingTop;
        this.mMenuAdapter.setTextPaddingTop(this.mMenuTextPaddingTop);
    }

    public float getMenuTextPaddingBottom() {
        return this.mMenuTextPaddingBottom;
    }

    public void setMenuTextPaddingBottom(float paddingBottom) {
        this.mMenuTextPaddingBottom = paddingBottom;
        this.mMenuAdapter.setTextPaddingBottom(this.mMenuTextPaddingBottom);
    }

    public float getMenuTextSize() {
        return this.mMenuTextSize;
    }

    public void setMenuTextSize(float textSize) {
        this.mMenuTextSize = textSize;
        this.mMenuAdapter.setMenuTextSize(this.mMenuTextSize);
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColor(int dividerColor) {
        this.mDividerColor = dividerColor;
        this.mMenuAdapter.setDividerColor(this.mDividerColor);
    }

    public int getExpandableIcon() {
        return this.mExpandableIcon;
    }

    public void setExpandableIcon(int expandableIcon) {
        this.mExpandableIcon = expandableIcon;
        this.mMenuAdapter.setExpandableIcon(this.mExpandableIcon);
    }

    public int getMenuTextColor() {
        return this.mMenuTextColor;
    }

    public void setMenuTextColor(int textColor) {
        this.mMenuTextColor = textColor;
        this.mMenuAdapter.setMenuTextColor(this.mMenuTextColor);
    }

    public int getHorizontalMenuBackgroundRes() {
        return this.mHorizontalMenuBackgroundRes;
    }

    public void setHorizontalMenuBackgroundRes(int horizontalMenuBackgroundRes) {
        this.mHorizontalMenuBackgroundRes = horizontalMenuBackgroundRes;
        this.mMenuAdapter.setHorizontalMenuBackgroundRes(this.mHorizontalMenuBackgroundRes);
    }

    public int getVerticalMenuBackgroundRes() {
        return this.mVerticalMenuBackgroundRes;
    }

    public void setVerticalMenuBackgroundRes(int verticalMenuBackgroundRes) {
        this.mVerticalMenuBackgroundRes = verticalMenuBackgroundRes;
        this.mMenuAdapter.setVerticalMenuBackgroundRes(this.mVerticalMenuBackgroundRes);
    }

    public int getMaxMenuItemCount() {
        return this.mMaxMenuItemCount;
    }

    public void setMaxMenuItemCount(int maxMenuItemCount) {
        this.mMaxMenuItemCount = maxMenuItemCount;
    }

    public int getMenuLayoutBgColor() {
        return this.mMenuLayoutBgColor;
    }

    public void setMenuLayoutBgColor(int menuLayoutBgColor) {
        this.mMenuLayoutBgColor = menuLayoutBgColor;
        if (this.mCardView != null) {
            this.mCardView.setCardBackgroundColor(this.mMenuLayoutBgColor);
        }
    }

    public float getDividerMarginBottom() {
        return this.mDividerMarginBottom;
    }

    public void setDividerMarginBottom(float dividerMarginBottom) {
        this.mDividerMarginBottom = dividerMarginBottom;
        this.mMenuAdapter.setDividerMarginBottom(this.mDividerMarginBottom);
    }

    public float getDividerMarginTop() {
        return this.mDividerMarginTop;
    }

    public void setDividerMarginTop(float dividerMarginTop) {
        this.mDividerMarginTop = dividerMarginTop;
        this.mMenuAdapter.setDividerMarginTop(this.mDividerMarginTop);
    }

    public float getDividerMarginRight() {
        return this.mDividerMarginRight;
    }

    public void setDividerMarginRight(float dividerMarginRight) {
        this.mDividerMarginRight = dividerMarginRight;
        this.mMenuAdapter.setDividerMarginRight(this.mDividerMarginRight);
    }

    public float getDividerMarginLeft() {
        return this.mDividerMarginLeft;
    }

    public void setDividerMarginLeft(float dividerMarginLeft) {
        this.mDividerMarginLeft = dividerMarginLeft;
        this.mMenuAdapter.setDividerMarginLeft(this.mDividerMarginLeft);
    }
}

