/*
 * Decompiled with CFR 0.152.
 */
package co.lujun.popmenulayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import co.lujun.popmenulayout.MenuBean;
import co.lujun.popmenulayout.OnMenuClickListener;
import co.lujun.popmenulayout.PopMenuView;
import co.lujun.popmenulayout.R;
import co.lujun.popmenulayout.Util;
import co.lujun.popmenulayout.adapter.MenuAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PopMenuLayout
extends RelativeLayout {
    private Context mContext;
    private List<MenuBean> mMenus;
    private MenuAdapter m1LevelMenuAdapter;
    private OnMenuClickListener mOnMenuClickListener;
    private RecyclerView recyclerView;
    private LinearLayoutManager mLayoutManager;
    private PopMenuView popMenuView;
    private String mConfigJson;
    private int mLayoutManagerOrientation = 0;
    private int mWidth;
    private int mHeight;
    private int mLevel2MenuAnimStyle = -1;
    private float mLevel1MenuItemHeight = 50.0f;
    private float mChildMenuItemHeight = 50.0f;
    private boolean isWithLevel1MenuWidth = false;
    private float mMenuDividerDp = 1.0f;
    private float mMenuTextPaddingLeft = 10.0f;
    private float mMenuTextPaddingRight = 10.0f;
    private float mMenuTextPaddingTop = 5.0f;
    private float mMenuTextPaddingBottom = 5.0f;
    private float mMenuTextSize = 14.0f;
    private int mDividerColor = -7829368;
    private int mExpandableIcon = R.drawable.ic_expandable_arrow;
    private int mMenuTextColor = -16777216;
    private int mChildMenuLayoutBgColor = -1;
    private int mLevel1MenuLayoutBgColor = -1;
    private int mHorizontalMenuBackgroundRes = R.drawable.shape_default_menu;
    private int mVerticalMenuBackgroundRes = R.drawable.shape_default_menu;
    private int mMaxMenuItemCount = 4;
    private float mDividerMarginLeft = 0.0f;
    private float mDividerMarginRight = 0.0f;
    private float mDividerMarginTop = 0.0f;
    private float mDividerMarginBottom = 0.0f;
    private boolean[] mMenuShow;
    private static final int SUPPORT_MENU_LEVEL = 3;
    private static final String TAG = "PopMenuLayout";

    public PopMenuLayout(Context context) {
        this(context, null);
    }

    public PopMenuLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PopMenuLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.initAttrs(context, attrs, defStyleAttr);
        this.mMenuShow = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            this.mMenuShow[i] = i == 0;
        }
        this.mContext = context;
        this.mMenus = new ArrayList<MenuBean>();
        this.m1LevelMenuAdapter = new MenuAdapter(this.mContext, this.mMenus, this.mLayoutManagerOrientation);
        this.m1LevelMenuAdapter.setMenuHeight((int)this.mLevel1MenuItemHeight);
        this.m1LevelMenuAdapter.setOnMenuClickListener(new OnMenuClickListener(){

            @Override
            public void onMenuClick(int level1Index, int level2Index, int level3Index) {
                PopMenuLayout.this.dealMenuClickEvent(level1Index, level2Index, level3Index);
            }
        });
        this.invalidateViewsAttr();
        this.recyclerView = new RecyclerView(this.mContext, attrs, defStyleAttr);
        this.recyclerView.setId(R.id.recyclerView);
        this.mLayoutManager = new LinearLayoutManager(this.mContext);
        this.mLayoutManager.setOrientation(this.mLayoutManagerOrientation);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.recyclerView.setBackgroundColor(this.mLevel1MenuLayoutBgColor);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(12);
        this.recyclerView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.recyclerView);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.PopMenuLayout, defStyleAttr, 0);
        this.mConfigJson = attributes.getString(R.styleable.PopMenuLayout_config_json);
        this.mLevel2MenuAnimStyle = attributes.getResourceId(R.styleable.PopMenuLayout_level2_menu_anim_style, this.mLevel2MenuAnimStyle);
        this.mLevel1MenuItemHeight = attributes.getDimension(R.styleable.PopMenuLayout_level1_menu_item_height, Util.dp2px(context, this.mLevel1MenuItemHeight));
        this.mChildMenuItemHeight = attributes.getDimension(R.styleable.PopMenuLayout_child_menu_item_height, Util.dp2px(context, this.mChildMenuItemHeight));
        this.isWithLevel1MenuWidth = attributes.getBoolean(R.styleable.PopMenuLayout_cmenu_w_follow_level1_menu, this.isWithLevel1MenuWidth);
        this.mMenuDividerDp = attributes.getDimension(R.styleable.PopMenuLayout_menu_divider_width, Util.dp2px(context, this.mMenuDividerDp));
        this.mMenuTextPaddingLeft = attributes.getDimension(R.styleable.PopMenuLayout_menu_left_padding, Util.dp2px(context, this.mMenuTextPaddingLeft));
        this.mMenuTextPaddingRight = attributes.getDimension(R.styleable.PopMenuLayout_menu_right_padding, Util.dp2px(context, this.mMenuTextPaddingRight));
        this.mMenuTextPaddingTop = attributes.getDimension(R.styleable.PopMenuLayout_menu_top_padding, Util.dp2px(context, this.mMenuTextPaddingTop));
        this.mMenuTextPaddingBottom = attributes.getDimension(R.styleable.PopMenuLayout_menu_bottom_padding, Util.dp2px(context, this.mMenuTextPaddingBottom));
        this.mDividerColor = attributes.getColor(R.styleable.PopMenuLayout_menu_divider_color, this.mDividerColor);
        this.mExpandableIcon = attributes.getResourceId(R.styleable.PopMenuLayout_menu_expandable_icon, this.mExpandableIcon);
        this.mMenuTextColor = attributes.getColor(R.styleable.PopMenuLayout_menu_text_color, this.mMenuTextColor);
        this.mHorizontalMenuBackgroundRes = attributes.getResourceId(R.styleable.PopMenuLayout_horizontal_menu_bg, this.mHorizontalMenuBackgroundRes);
        this.mVerticalMenuBackgroundRes = attributes.getResourceId(R.styleable.PopMenuLayout_vertical_menu_bg, this.mVerticalMenuBackgroundRes);
        this.mMenuTextSize = attributes.getDimension(R.styleable.PopMenuLayout_menu_text_size, Util.sp2px(context, this.mMenuTextSize));
        this.mMaxMenuItemCount = attributes.getInteger(R.styleable.PopMenuLayout_child_menu_max_count, this.mMaxMenuItemCount);
        this.mLevel1MenuLayoutBgColor = attributes.getColor(R.styleable.PopMenuLayout_level1_menu_layout_bg_color, this.mLevel1MenuLayoutBgColor);
        this.mChildMenuLayoutBgColor = attributes.getColor(R.styleable.PopMenuLayout_cmenu_layout_bg_color, this.mChildMenuLayoutBgColor);
        this.mDividerMarginLeft = attributes.getDimension(R.styleable.PopMenuLayout_divider_margin_left, Util.dp2px(context, this.mDividerMarginLeft));
        this.mDividerMarginRight = attributes.getDimension(R.styleable.PopMenuLayout_divider_margin_right, Util.dp2px(context, this.mDividerMarginRight));
        this.mDividerMarginTop = attributes.getDimension(R.styleable.PopMenuLayout_divider_margin_top, Util.dp2px(context, this.mDividerMarginTop));
        this.mDividerMarginBottom = attributes.getDimension(R.styleable.PopMenuLayout_divider_margin_bottom, Util.dp2px(context, this.mDividerMarginBottom));
        attributes.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Log.d((String)TAG, (String)"onSizeChanged");
        this.mWidth = w;
        this.mHeight = h;
        this.initView();
    }

    private void parseJson() throws JSONException {
        if (TextUtils.isEmpty((CharSequence)this.mConfigJson)) {
            return;
        }
        JSONObject object = new JSONObject(this.mConfigJson);
        JSONArray array = object.getJSONArray("menus");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            this.mMenus.add(this.parseNode(obj));
        }
    }

    private MenuBean parseNode(JSONObject object) throws JSONException {
        Iterator iterator = object.keys();
        MenuBean menu = new MenuBean();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.equals("index")) {
                menu.setIndex(object.getString("index"));
                continue;
            }
            if (key.equals("expandable")) {
                menu.setExpandable(object.getBoolean("expandable"));
                continue;
            }
            if (key.equals("text")) {
                menu.setText(object.getString("text"));
                continue;
            }
            if (!key.equals("child")) continue;
            JSONArray array = object.getJSONArray("child");
            ArrayList<MenuBean> menus = new ArrayList<MenuBean>();
            for (int i = 0; i < array.length(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                menus.add(this.parseNode(obj));
            }
            menu.setChild(menus);
        }
        return menu;
    }

    private void dealMenuClickEvent(int level1Index, int level2Index, int level3Index) {
        MenuBean menu1 = this.mMenus.get(level1Index);
        if (menu1.isExpandable() && this.isChildMenuShow()) {
            this.dealClickEventOnly(level1Index, level2Index, level3Index);
        } else if (menu1.isExpandable() && !this.isChildMenuShow()) {
            if (!this.mMenuShow[1]) {
                this.expandMenu(level1Index, level2Index, level3Index);
            } else {
                this.dealClickEventOnly(level1Index, level2Index, level3Index);
            }
        } else {
            this.onMenuClick(level1Index, level2Index, level3Index);
        }
    }

    private void onMenuClick(int level1Index, int level2Index, int level3Index) {
        if (this.mOnMenuClickListener != null) {
            this.mOnMenuClickListener.onMenuClick(level1Index, level2Index, level3Index);
        }
    }

    private void expandMenu(int level1Index, int level2Index, int level3Index) {
        this.mMenuShow[1] = true;
        int[] location = new int[2];
        this.recyclerView.getLocationOnScreen(location);
        List<MenuBean> menus = this.mMenus.get(level1Index).getChild();
        this.popMenuView.setAnimStyle(this.mLevel2MenuAnimStyle);
        this.popMenuView.setMenus(menus);
        this.popMenuView.showAtLocation((View)this.recyclerView, 0, this.mWidth / this.mMenus.size() * level1Index + (this.mWidth / this.mMenus.size() - this.popMenuView.getWidth()) / 2, location[1] - (menus.size() <= this.mMaxMenuItemCount ? menus.size() : this.mMaxMenuItemCount) * (int)this.mChildMenuItemHeight);
    }

    private void dealClickEventOnly(int level1Index, int level2Index, int level3Index) {
        if (this.mOnMenuClickListener != null) {
            this.mOnMenuClickListener.onMenuClick(level1Index, level2Index, level3Index);
        }
        if (this.popMenuView.isShowing()) {
            this.popMenuView.dismiss();
        }
    }

    private boolean isChildMenuShow() {
        return this.mMenuShow[1] || this.mMenuShow[2];
    }

    private void initView() {
        this.invalidateData();
        if (this.popMenuView == null) {
            this.popMenuView = new PopMenuView(this.mContext, this, this.mWidth / 3, -1);
            this.popMenuView.setMenuItemHeight(this.mChildMenuItemHeight);
            this.popMenuView.setOnMenuClickListener(new OnMenuClickListener(){

                @Override
                public void onMenuClick(int level1Index, int level2Index, int level3Index) {
                    if (PopMenuLayout.this.mOnMenuClickListener != null) {
                        PopMenuLayout.this.mOnMenuClickListener.onMenuClick(level1Index, level2Index, level3Index);
                    }
                }
            });
            this.invalidateViewsAttr();
        }
    }

    private void invalidateViewsAttr() {
        if (this.m1LevelMenuAdapter != null) {
            this.m1LevelMenuAdapter.setTextPaddingLeft(this.mMenuTextPaddingLeft);
            this.m1LevelMenuAdapter.setTextPaddingBottom(this.mMenuTextPaddingBottom);
            this.m1LevelMenuAdapter.setTextPaddingRight(this.mMenuTextPaddingRight);
            this.m1LevelMenuAdapter.setTextPaddingTop(this.mMenuTextPaddingTop);
            this.m1LevelMenuAdapter.setDividerDp(this.mMenuDividerDp);
            this.m1LevelMenuAdapter.setDividerColor(this.mDividerColor);
            this.m1LevelMenuAdapter.setExpandableIcon(this.mExpandableIcon);
            this.m1LevelMenuAdapter.setMenuTextColor(this.mMenuTextColor);
            this.m1LevelMenuAdapter.setHorizontalMenuBackgroundRes(this.mHorizontalMenuBackgroundRes);
            this.m1LevelMenuAdapter.setVerticalMenuBackgroundRes(this.mVerticalMenuBackgroundRes);
            this.m1LevelMenuAdapter.setMenuTextSize(this.mMenuTextSize);
            this.m1LevelMenuAdapter.setDividerMarginLeft(this.mDividerMarginLeft);
            this.m1LevelMenuAdapter.setDividerMarginRight(this.mDividerMarginRight);
            this.m1LevelMenuAdapter.setDividerMarginTop(this.mDividerMarginTop);
            this.m1LevelMenuAdapter.setDividerMarginBottom(this.mDividerMarginBottom);
        }
        if (this.popMenuView != null) {
            this.popMenuView.setWithLevel1MenuWidth(this.isWithLevel1MenuWidth);
            this.popMenuView.setMenuTextPaddingLeft(this.mMenuTextPaddingLeft);
            this.popMenuView.setMenuTextPaddingBottom(this.mMenuTextPaddingBottom);
            this.popMenuView.setMenuTextPaddingRight(this.mMenuTextPaddingRight);
            this.popMenuView.setMenuTextPaddingTop(this.mMenuTextPaddingTop);
            this.popMenuView.setMenuDividerDp(this.mMenuDividerDp);
            this.popMenuView.setDividerColor(this.mDividerColor);
            this.popMenuView.setExpandableIcon(this.mExpandableIcon);
            this.popMenuView.setMenuTextColor(this.mMenuTextColor);
            this.popMenuView.setHorizontalMenuBackgroundRes(this.mHorizontalMenuBackgroundRes);
            this.popMenuView.setVerticalMenuBackgroundRes(this.mVerticalMenuBackgroundRes);
            this.popMenuView.setMenuTextSize(this.mMenuTextSize);
            this.popMenuView.setMaxMenuItemCount(this.mMaxMenuItemCount);
            this.popMenuView.setMenuLayoutBgColor(this.mChildMenuLayoutBgColor);
            this.popMenuView.setDividerMarginLeft(this.mDividerMarginLeft);
            this.popMenuView.setDividerMarginRight(this.mDividerMarginRight);
            this.popMenuView.setDividerMarginTop(this.mDividerMarginTop);
            this.popMenuView.setDividerMarginBottom(this.mDividerMarginBottom);
        }
    }

    private void invalidateData() {
        try {
            if (this.mMenus.size() <= 0) {
                this.parseJson();
            }
            this.m1LevelMenuAdapter.setMenuWidth(this.mWidth / (this.mMenus.size() > 0 ? this.mMenus.size() : 1));
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.m1LevelMenuAdapter);
            this.m1LevelMenuAdapter.notifyDataSetChanged();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean[] getMenuShow() {
        return this.mMenuShow;
    }

    public void setMenus(int pos, boolean expanded) {
        if (pos >= 0 && pos < 3) {
            this.mMenuShow[pos] = expanded;
        }
    }

    public void setAllChildLevelMenuDismissFlag() {
        for (int i = 1; i < 3; ++i) {
            this.mMenuShow[i] = false;
        }
    }

    public int getLayoutWidth() {
        return this.mWidth;
    }

    public String getConfigJson() {
        return this.mConfigJson;
    }

    public void setConfigJson(String configJson) {
        this.mConfigJson = configJson;
        this.invalidateData();
    }

    public void setOnMenuClickListener(OnMenuClickListener listener) {
        this.mOnMenuClickListener = listener;
    }

    public int getLayoutManagerOrientation() {
        return this.mLayoutManagerOrientation;
    }

    public void setLayoutManagerOrientation(int layoutManagerOrientation) {
        this.mLayoutManagerOrientation = layoutManagerOrientation;
    }

    public List<MenuBean> getMenus() {
        return this.mMenus;
    }

    public void setMenus(List<MenuBean> menus) {
        this.mMenus.clear();
        for (MenuBean menu : menus) {
            this.mMenus.add(menu);
        }
        this.invalidateData();
    }

    public float getChildMenuItemHeight() {
        return this.mChildMenuItemHeight;
    }

    public void setChildMenuItemHeight(float childMenuItemHeight) {
        this.mChildMenuItemHeight = childMenuItemHeight;
    }

    public float getLevel1MenuItemHeight() {
        return this.mLevel1MenuItemHeight;
    }

    public void setLevel1MenuItemHeight(float level1MenuItemHeight) {
        this.mLevel1MenuItemHeight = level1MenuItemHeight;
    }

    public int getLevel2MenuAnimStyle() {
        return this.mLevel2MenuAnimStyle;
    }

    public void setLevel2MenuAnimStyle(int level2MenuAnimStyle) {
        this.mLevel2MenuAnimStyle = level2MenuAnimStyle;
    }

    public boolean isWithLevel1MenuWidth() {
        return this.isWithLevel1MenuWidth;
    }

    public void setWithLevel1MenuWidth(boolean withLevel1MenuWidth) {
        this.isWithLevel1MenuWidth = withLevel1MenuWidth;
    }

    public float getMenuTextPaddingBottom() {
        return this.mMenuTextPaddingBottom;
    }

    public void setMenuTextPaddingBottom(float paddingBottom) {
        this.mMenuTextPaddingBottom = paddingBottom;
        this.invalidateViewsAttr();
    }

    public float getMenuTextPaddingTop() {
        return this.mMenuTextPaddingTop;
    }

    public void setMenuTextPaddingTop(float paddingTop) {
        this.mMenuTextPaddingTop = paddingTop;
        this.invalidateViewsAttr();
    }

    public float getMenuTextPaddingRight() {
        return this.mMenuTextPaddingRight;
    }

    public void setMenuTextPaddingRight(float paddingRight) {
        this.mMenuTextPaddingRight = paddingRight;
        this.invalidateViewsAttr();
    }

    public float getMenuTextPaddingLeft() {
        return this.mMenuTextPaddingLeft;
    }

    public void setMenuTextPaddingLeft(float paddingLeft) {
        this.mMenuTextPaddingLeft = paddingLeft;
        this.invalidateViewsAttr();
    }

    public float getMenuDividerDp() {
        return this.mMenuDividerDp;
    }

    public void setMenuDividerDp(float menuDividerDp) {
        this.mMenuDividerDp = menuDividerDp;
        this.invalidateViewsAttr();
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColor(int dividerColor) {
        this.mDividerColor = dividerColor;
        this.invalidateViewsAttr();
    }

    public int getExpandableIcon() {
        return this.mExpandableIcon;
    }

    public void setExpandableIcon(int expandableIcon) {
        this.mExpandableIcon = expandableIcon;
        this.invalidateViewsAttr();
    }

    public int getMenuTextColor() {
        return this.mMenuTextColor;
    }

    public void setMenuTextColor(int textColor) {
        this.mMenuTextColor = textColor;
        this.invalidateViewsAttr();
    }

    public int getHorizontalMenuBackgroundRes() {
        return this.mHorizontalMenuBackgroundRes;
    }

    public void setHorizontalMenuBackgroundRes(int horizontalMenuBackgroundRes) {
        this.mHorizontalMenuBackgroundRes = horizontalMenuBackgroundRes;
        this.invalidateViewsAttr();
    }

    public int getVerticalMenuBackgroundRes() {
        return this.mVerticalMenuBackgroundRes;
    }

    public void setVerticalMenuBackgroundRes(int verticalMenuBackgroundRes) {
        this.mVerticalMenuBackgroundRes = verticalMenuBackgroundRes;
        this.invalidateViewsAttr();
    }

    public float getMenuTextSize() {
        return this.mMenuTextSize;
    }

    public void setMenuTextSize(float textSize) {
        this.mMenuTextSize = textSize;
        this.invalidateViewsAttr();
    }

    public int getMaxMenuItemCount() {
        return this.mMaxMenuItemCount;
    }

    public void setMaxMenuItemCount(int maxMenuItemCount) {
        this.mMaxMenuItemCount = maxMenuItemCount;
    }

    public int getChildMenuLayoutBgColor() {
        return this.mChildMenuLayoutBgColor;
    }

    public void setChildMenuLayoutBgColor(int childMenuLayoutBgColor) {
        this.mChildMenuLayoutBgColor = childMenuLayoutBgColor;
    }

    public int getLevel1MenuLayoutBgColor() {
        return this.mLevel1MenuLayoutBgColor;
    }

    public void setLevel1MenuLayoutBgColor(int level1MenuLayoutBgColor) {
        this.mLevel1MenuLayoutBgColor = level1MenuLayoutBgColor;
    }

    public float getDividerMarginBottom() {
        return this.mDividerMarginBottom;
    }

    public void setDividerMarginBottom(float dividerMarginBottom) {
        this.mDividerMarginBottom = dividerMarginBottom;
    }

    public float getDividerMarginTop() {
        return this.mDividerMarginTop;
    }

    public void setDividerMarginTop(float dividerMarginTop) {
        this.mDividerMarginTop = dividerMarginTop;
    }

    public float getDividerMarginRight() {
        return this.mDividerMarginRight;
    }

    public void setDividerMarginRight(float dividerMarginRight) {
        this.mDividerMarginRight = dividerMarginRight;
    }

    public float getDividerMarginLeft() {
        return this.mDividerMarginLeft;
    }

    public void setDividerMarginLeft(float dividerMarginLeft) {
        this.mDividerMarginLeft = dividerMarginLeft;
    }
}

