/*
 * Decompiled with CFR 0.152.
 */
package co.lujun.popmenulayout.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import co.lujun.popmenulayout.MenuBean;
import co.lujun.popmenulayout.OnMenuClickListener;
import co.lujun.popmenulayout.R;
import co.lujun.popmenulayout.Util;
import java.util.List;

public class MenuAdapter
extends RecyclerView.Adapter<MenuViewHolder> {
    private Context mContext;
    private List<MenuBean> mMenus;
    private OnMenuClickListener onMenuClickListener;
    private int mLayoutManagerOrientation;
    private int mMenuWidth;
    private int mMenuHeight;
    private int mDividerColor = -7829368;
    private int mExpandableIcon = R.drawable.ic_expandable_arrow;
    private int mMenuTextColor = -16777216;
    private int mHorizontalMenuBackgroundRes = R.drawable.shape_default_menu;
    private int mVerticalMenuBackgroundRes = R.drawable.shape_default_menu;
    private float mMenuTextSize = 14.0f;
    private float mDividerDp = 1.0f;
    private float mTextPaddingLeft = 10.0f;
    private float mTextPaddingRight = 10.0f;
    private float mTextPaddingTop = 5.0f;
    private float mTextPaddingBottom = 5.0f;
    private float mDividerMarginLeft = 0.0f;
    private float mDividerMarginRight = 0.0f;
    private float mDividerMarginTop = 0.0f;
    private float mDividerMarginBottom = 0.0f;
    private static final String TAG = "MenuAdapter";

    public MenuAdapter(Context context, List<MenuBean> menus, int orientation) {
        this(context, menus, -1, -1, orientation);
    }

    public MenuAdapter(Context context, List<MenuBean> menus, int width, int height, int orientation) {
        this.mContext = context;
        this.mMenus = menus;
        this.mMenuWidth = width;
        this.mMenuHeight = height;
        this.mLayoutManagerOrientation = orientation;
        this.mTextPaddingLeft = Util.dp2px(this.mContext, this.mTextPaddingLeft);
        this.mTextPaddingTop = Util.dp2px(this.mContext, this.mTextPaddingTop);
        this.mTextPaddingRight = Util.dp2px(this.mContext, this.mTextPaddingRight);
        this.mTextPaddingBottom = Util.dp2px(this.mContext, this.mTextPaddingBottom);
        this.mDividerDp = Util.dp2px(this.mContext, this.mDividerDp);
        this.mMenuTextSize = Util.sp2px(this.mContext, this.mMenuTextSize);
        this.mDividerMarginLeft = Util.dp2px(this.mContext, this.mDividerMarginLeft);
        this.mDividerMarginRight = Util.dp2px(this.mContext, this.mDividerMarginRight);
        this.mDividerMarginTop = Util.dp2px(this.mContext, this.mDividerMarginTop);
        this.mDividerMarginBottom = Util.dp2px(this.mContext, this.mDividerMarginBottom);
    }

    public int getItemCount() {
        return this.mMenus.size();
    }

    public MenuViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new MenuViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.view_menu_item, parent, false));
    }

    public void onBindViewHolder(MenuViewHolder holder, int position) {
        final MenuBean menu = this.mMenus.get(position);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)holder.rlRootView.getLayoutParams();
        if (this.mMenuWidth != -1) {
            params.width = this.mMenuWidth;
        }
        if (this.mMenuHeight != -1) {
            params.height = this.mMenuHeight;
        }
        holder.rlRootView.setLayoutParams((ViewGroup.LayoutParams)params);
        holder.tvMenuText.setTextColor(this.mMenuTextColor);
        holder.tvMenuText.setTextSize(0, this.mMenuTextSize);
        holder.tvMenuText.setText((CharSequence)menu.getText());
        holder.tvMenuText.setPadding((int)this.mTextPaddingLeft, (int)this.mTextPaddingTop, (int)this.mTextPaddingRight, (int)this.mTextPaddingBottom);
        if (menu.isExpandable()) {
            holder.ivMenuIcon.setImageResource(this.mExpandableIcon);
            holder.ivMenuIcon.setVisibility(0);
        } else {
            holder.ivMenuIcon.setVisibility(8);
        }
        if (this.mLayoutManagerOrientation == 0) {
            holder.rlRootView.setBackgroundResource(this.mHorizontalMenuBackgroundRes);
            holder.viewDividerBottom.setVisibility(8);
            RelativeLayout.LayoutParams dividerRightParams = (RelativeLayout.LayoutParams)holder.viewDividerRight.getLayoutParams();
            dividerRightParams.width = (int)this.mDividerDp;
            dividerRightParams.setMargins(dividerRightParams.leftMargin, (int)this.mDividerMarginTop, dividerRightParams.rightMargin, (int)this.mDividerMarginBottom);
            holder.viewDividerRight.setLayoutParams((ViewGroup.LayoutParams)dividerRightParams);
            holder.viewDividerRight.setBackgroundColor(this.mDividerColor);
            holder.viewDividerRight.setVisibility(position == this.mMenus.size() - 1 ? 8 : 0);
        } else {
            holder.rlRootView.setBackgroundResource(this.mVerticalMenuBackgroundRes);
            holder.viewDividerRight.setVisibility(8);
            RelativeLayout.LayoutParams bottomRightParams = (RelativeLayout.LayoutParams)holder.viewDividerBottom.getLayoutParams();
            bottomRightParams.height = (int)this.mDividerDp;
            bottomRightParams.setMargins((int)this.mDividerMarginLeft, bottomRightParams.topMargin, (int)this.mDividerMarginRight, bottomRightParams.bottomMargin);
            holder.viewDividerBottom.setLayoutParams((ViewGroup.LayoutParams)bottomRightParams);
            holder.viewDividerBottom.setBackgroundColor(this.mDividerColor);
            holder.viewDividerBottom.setVisibility(position == this.mMenus.size() - 1 ? 8 : 0);
        }
        holder.tvMenuText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MenuAdapter.this.onMenuClickListener != null) {
                    char[] indexes = menu.getIndex().toCharArray();
                    int level1Index = indexes.length >= 1 ? Character.getNumericValue(indexes[0]) : -1;
                    int level2Index = indexes.length >= 2 ? Character.getNumericValue(indexes[1]) : -1;
                    int level3Index = indexes.length >= 3 ? Character.getNumericValue(indexes[2]) : -1;
                    MenuAdapter.this.onMenuClickListener.onMenuClick(level1Index, level2Index, level3Index);
                }
            }
        });
    }

    public void setOnMenuClickListener(OnMenuClickListener listener) {
        this.onMenuClickListener = listener;
    }

    public int getMenuHeight() {
        return this.mMenuHeight;
    }

    public void setMenuHeight(int mMenuHeight) {
        this.mMenuHeight = mMenuHeight;
    }

    public int getMenuWidth() {
        return this.mMenuWidth;
    }

    public void setMenuWidth(int mMenuWidth) {
        this.mMenuWidth = mMenuWidth;
    }

    public float getDividerDp() {
        return this.mDividerDp;
    }

    public void setDividerDp(float mDividerDp) {
        this.mDividerDp = mDividerDp;
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColor(int mDividerColor) {
        this.mDividerColor = mDividerColor;
    }

    public int getExpandableIcon() {
        return this.mExpandableIcon;
    }

    public void setExpandableIcon(int mExpandableIcon) {
        this.mExpandableIcon = mExpandableIcon;
    }

    public float getMenuTextSize() {
        return this.mMenuTextSize;
    }

    public void setMenuTextSize(float mMenuTextSize) {
        this.mMenuTextSize = mMenuTextSize;
    }

    public int getMenuTextColor() {
        return this.mMenuTextColor;
    }

    public void setMenuTextColor(int mMenuTextColor) {
        this.mMenuTextColor = mMenuTextColor;
    }

    public int getHorizontalMenuBackgroundRes() {
        return this.mHorizontalMenuBackgroundRes;
    }

    public void setHorizontalMenuBackgroundRes(int mHorizontalMenuBackgroundRes) {
        this.mHorizontalMenuBackgroundRes = mHorizontalMenuBackgroundRes;
    }

    public int getVerticalMenuBackgroundRes() {
        return this.mVerticalMenuBackgroundRes;
    }

    public void setVerticalMenuBackgroundRes(int mVerticalMenuBackgroundRes) {
        this.mVerticalMenuBackgroundRes = mVerticalMenuBackgroundRes;
    }

    public float getTextPaddingBottom() {
        return this.mTextPaddingBottom;
    }

    public void setTextPaddingBottom(float mTextPaddingBottom) {
        this.mTextPaddingBottom = mTextPaddingBottom;
    }

    public float getTextPaddingTop() {
        return this.mTextPaddingTop;
    }

    public void setTextPaddingTop(float mTextPaddingTop) {
        this.mTextPaddingTop = mTextPaddingTop;
    }

    public float getTextPaddingRight() {
        return this.mTextPaddingRight;
    }

    public void setTextPaddingRight(float mTextPaddingRight) {
        this.mTextPaddingRight = mTextPaddingRight;
    }

    public float getTextPaddingLeft() {
        return this.mTextPaddingLeft;
    }

    public void setTextPaddingLeft(float mTextPaddingLeft) {
        this.mTextPaddingLeft = mTextPaddingLeft;
    }

    public float getDividerMarginBottom() {
        return this.mDividerMarginBottom;
    }

    public void setDividerMarginBottom(float dividerMarginBottom) {
        this.mDividerMarginBottom = dividerMarginBottom;
    }

    public float getDividerMarginTop() {
        return this.mDividerMarginTop;
    }

    public void setDividerMarginTop(float dividerMarginTop) {
        this.mDividerMarginTop = dividerMarginTop;
    }

    public float getDividerMarginRight() {
        return this.mDividerMarginRight;
    }

    public void setDividerMarginRight(float dividerMarginRight) {
        this.mDividerMarginRight = dividerMarginRight;
    }

    public float getDividerMarginLeft() {
        return this.mDividerMarginLeft;
    }

    public void setDividerMarginLeft(float dividerMarginLeft) {
        this.mDividerMarginLeft = dividerMarginLeft;
    }

    static class MenuViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvMenuText;
        ImageView ivMenuIcon;
        RelativeLayout rlRootView;
        View viewDividerBottom;
        View viewDividerRight;

        public MenuViewHolder(View v) {
            super(v);
            this.tvMenuText = (TextView)v.findViewById(R.id.tv_menu_text);
            this.ivMenuIcon = (ImageView)v.findViewById(R.id.iv_expandable_icon);
            this.rlRootView = (RelativeLayout)v.findViewById(R.id.menuItemRootView);
            this.viewDividerBottom = v.findViewById(R.id.view_divider_bottom);
            this.viewDividerRight = v.findViewById(R.id.view_divider_right);
        }
    }
}

