package com.moengage.core.security.internal

import android.util.Base64
import java.security.KeyFactory
import java.security.spec.MGF1ParameterSpec
import java.security.spec.X509EncodedKeySpec
import javax.crypto.Cipher
import javax.crypto.spec.OAEPParameterSpec
import javax.crypto.spec.PSource

/**
 * Handle the encrypting / decrypting logic for RSA Algorithm
 *
 * @author Abhishek Kumar
 * @since 2.3.0
 */

private const val ALGORITHM_NAME_RSA = "RSA"
private const val CIPHER_TRANSFORMATION = "RSA/ECB/OAEPPadding"
private const val MD_NAME = "SHA-512"
private const val MGF_NAME = "MGF1"

/**
 * Encrypt the text with RSA Algorithm
 *
 * @param key used for encryption
 * @param plaintext text which need to encrypt
 * @return encrypted text
 * @since 2.3.0
 */
public fun encryptUsingRsaAlgo(key: ByteArray, plaintext: String): String? {
    val cipher = Cipher.getInstance(CIPHER_TRANSFORMATION)
    val parameterSpec = OAEPParameterSpec(
        MD_NAME,
        MGF_NAME,
        MGF1ParameterSpec.SHA512,
        PSource.PSpecified.DEFAULT
    )
    val keySpec = X509EncodedKeySpec(key)
    val keyFactory: KeyFactory = KeyFactory.getInstance(ALGORITHM_NAME_RSA)
    cipher.init(Cipher.ENCRYPT_MODE, keyFactory.generatePublic(keySpec), parameterSpec)
    return Base64.encodeToString(cipher.doFinal(plaintext.toByteArray()), Base64.DEFAULT)
}