/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.decoder;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.decoder.AbstractDecoder;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Special;
import co.nstant.in.cbor.model.UnicodeString;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class UnicodeStringDecoder
extends AbstractDecoder<UnicodeString> {
    public UnicodeStringDecoder(CborDecoder decoder, InputStream inputStream) {
        super(decoder, inputStream);
    }

    @Override
    public UnicodeString decode(int initialByte) throws CborException {
        long length = this.getLength(initialByte);
        if (length == -1L) {
            if (this.decoder.isAutoDecodeInfinitiveUnicodeStrings()) {
                return this.decodeInfinitiveLength();
            }
            UnicodeString unicodeString = new UnicodeString(null);
            unicodeString.setChunked(true);
            return unicodeString;
        }
        return this.decodeFixedLength(length);
    }

    private UnicodeString decodeInfinitiveLength() throws CborException {
        ByteArrayOutputStream bytes;
        block2: {
            MajorType majorType;
            bytes = new ByteArrayOutputStream();
            while (true) {
                DataItem dataItem;
                if ((dataItem = this.decoder.decodeNext()) == null) {
                    throw new CborException("Unexpected end of stream");
                }
                majorType = dataItem.getMajorType();
                if (Special.BREAK.equals(dataItem)) break block2;
                if (majorType != MajorType.UNICODE_STRING) break;
                UnicodeString unicodeString = (UnicodeString)dataItem;
                byte[] byteArray = unicodeString.toString().getBytes(StandardCharsets.UTF_8);
                bytes.write(byteArray, 0, byteArray.length);
            }
            throw new CborException("Unexpected major type " + (Object)((Object)majorType));
        }
        return new UnicodeString(new String(bytes.toByteArray(), StandardCharsets.UTF_8));
    }

    private UnicodeString decodeFixedLength(long length) throws CborException {
        return new UnicodeString(new String(this.decodeBytes(length), StandardCharsets.UTF_8));
    }
}

