/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.model;

import co.nstant.in.cbor.model.ChunkableDataItem;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class Map
extends ChunkableDataItem {
    private final LinkedHashMap<DataItem, DataItem> map;
    private final List<DataItem> keys = new LinkedList<DataItem>();

    public Map() {
        super(MajorType.MAP);
        this.map = new LinkedHashMap();
    }

    public Map(int initialCapacity) {
        super(MajorType.MAP);
        this.map = new LinkedHashMap(initialCapacity);
    }

    public Map put(DataItem key, DataItem value) {
        if (this.map.put(key, value) == null) {
            this.keys.add(key);
        }
        return this;
    }

    public DataItem get(DataItem key) {
        return this.map.get(key);
    }

    public DataItem remove(DataItem key) {
        this.keys.remove(key);
        return (DataItem)this.map.remove(key);
    }

    public Collection<DataItem> getKeys() {
        return this.keys;
    }

    public Collection<DataItem> getValues() {
        return this.map.values();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Map) {
            Map other = (Map)object;
            return super.equals(object) && this.map.equals(other.map);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.map.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isChunked()) {
            stringBuilder.append("{_ ");
        } else {
            stringBuilder.append("{ ");
        }
        for (DataItem key : this.keys) {
            stringBuilder.append(key).append(": ").append(this.map.get(key)).append(", ");
        }
        if (stringBuilder.toString().endsWith(", ")) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

