/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.JsonUtils;
import com.openfin.desktop.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)DesktopUtils.class.getName());
    private static final String OS = System.getProperty("os.name").toLowerCase();

    public static void errorAckOnException(AckListener ackListener, Object source, Exception ex) {
        if (ackListener != null) {
            try {
                DesktopUtils.errorAck(ackListener, DesktopUtils.getNack(source, ex));
            }
            catch (Exception e) {
                logger.error("Error", (Throwable)e);
            }
        }
    }

    public static Ack getNack(Object source, Exception ex) {
        JSONObject payload = new JSONObject();
        JsonUtils.updateValue(payload, "reason", ex.getMessage());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ex.printStackTrace(printWriter);
        JsonUtils.updateValue(payload, "stacktrace", stringWriter.toString());
        return new Ack(payload, source);
    }

    public static Ack getNack(Object source, String reason) {
        JSONObject payload = new JSONObject();
        JsonUtils.updateValue(payload, "reason", reason);
        return new Ack(payload, source);
    }

    public static void successAck(AckListener ackListener, Ack ack) {
        try {
            if (ackListener != null) {
                ackListener.onSuccess(ack);
            }
        }
        catch (Exception ex) {
            logger.error("Error invoking success callback", (Throwable)ex);
        }
    }

    public static void errorAck(AckListener callback, Ack ack) {
        try {
            if (callback != null) {
                callback.onError(ack);
            }
        }
        catch (Exception ex) {
            logger.error("Error invoking error callback", (Throwable)ex);
        }
    }

    public static void addEventListener(Window window, final String evenType, EventListener eventListener) throws Exception {
        logger.debug("addEventListener " + evenType);
        final CountDownLatch latch = new CountDownLatch(1);
        window.addEventListener(evenType, eventListener, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                latch.countDown();
                logger.debug("addEventListener ack " + ack.isSuccessful());
            }

            @Override
            public void onError(Ack ack) {
                logger.error(String.format("Error adding event listener %s %s", evenType, ack.getReason()));
            }
        });
        latch.await(5L, TimeUnit.SECONDS);
        if (latch.getCount() != 0L) {
            logger.error("Error adding event listener " + evenType);
        }
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }
}

