/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonBean {
    protected JSONObject json;

    public JsonBean() {
        this.json = new JSONObject();
    }

    public JsonBean(JSONObject json) {
        this.json = json;
    }

    public JSONObject getJson() {
        return this.json;
    }

    public final JSONObject getJsonCopy() {
        return new JSONObject(this.getJson().toString());
    }

    public String getString(String property) {
        return this.json.optString(property, null);
    }

    public int getIntegerValue(String property) {
        int value = 0;
        try {
            value = this.json.getInt(property);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }

    public double getDoubleValue(String property) {
        return this.getDoubleValue(property, 0.0);
    }

    public double getDoubleValue(String property, double defaultValue) {
        return this.json.optDouble(property, defaultValue);
    }

    public boolean getBooleanValue(String property) {
        return this.getBooleanValue(property, false);
    }

    public boolean getBooleanValue(String property, boolean defaultValue) {
        return this.json.optBoolean(property, defaultValue);
    }

    public JSONObject getJsonValue(String property) {
        return this.json.optJSONObject(property);
    }

    public JsonBean put(String key, Object value) throws JSONException {
        this.json.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.json.get(key);
    }

    public String toString() {
        return this.json.toString(2);
    }

    public Boolean getBoolean(String name) {
        return this.json.has(name) ? Boolean.valueOf(this.json.getBoolean(name)) : null;
    }

    public void setBoolean(String name, Boolean value) {
        if (value == null) {
            this.json.remove(name);
        } else {
            this.json.put(name, (Object)value);
        }
    }

    public void setString(String name, String value) {
        this.json.put(name, value == null ? JSONObject.NULL : value);
    }

    public <T> void setArray(String name, Collection<T> value) {
        this.json.put(name, value);
    }

    public JSONArray getArray(String name) {
        if (this.json.has(name)) {
            return this.json.getJSONArray(name);
        }
        return null;
    }

    public <T> List<T> getList(String name) {
        JSONArray array = this.getArray(name);
        if (array != null) {
            int arrayLength = array.length();
            ArrayList<Object> list = new ArrayList<Object>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object obj = array.get(i);
                list.add(obj);
            }
            return list;
        }
        return null;
    }

    public <T> void setJsonArray(String name, List<T> values) {
        if (values == null) {
            this.json.remove(name);
        } else {
            JSONArray array = new JSONArray();
            values.forEach(obj -> {
                if (obj instanceof JsonBean) {
                    JsonBean jsonBean = (JsonBean)obj;
                    array.put((Object)jsonBean.getJsonCopy());
                } else {
                    array.put(obj);
                }
            });
            this.json.put(name, (Object)array);
        }
    }

    public <T extends JsonBean> List<T> getJsonBeanList(String name, Class<T> clazz) {
        JSONArray array = this.getArray(name);
        if (array != null) {
            int arrayLength = array.length();
            ArrayList<JsonBean> list = new ArrayList<JsonBean>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                JSONObject obj = array.getJSONObject(i);
                JsonBean newBean = (JsonBean)this.getJsonBean(obj, clazz);
                if (newBean == null) continue;
                list.add(newBean);
            }
            return list;
        }
        return null;
    }

    public Integer getInteger(String name) {
        return this.json.has(name) ? Integer.valueOf(this.json.getInt(name)) : null;
    }

    public void setInteger(String name, Integer value) {
        this.json.put(name, value == null ? JSONObject.NULL : value);
    }

    public void setLong(String name, Long value) {
        this.json.put(name, value == null ? JSONObject.NULL : value);
    }

    public <T> T getJsonBean(String name, Class<T> clazz) {
        return this.getJsonBean(this.json.getJSONObject(name), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getJsonBean(JSONObject obj, Class<T> clazz) {
        T t;
        try {
            t = clazz.getDeclaredConstructor(JSONObject.class).newInstance(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        return t;
    }

    public <T extends JsonBean> void setJsonBean(String name, T jsonBean) {
        if (jsonBean == null) {
            this.json.remove(name);
        } else {
            this.json.put(name, (Object)jsonBean.getJson());
        }
    }

    public void setRectangle(String name, Rectangle rect) {
        if (rect == null) {
            this.json.remove(name);
        } else {
            JSONObject jsonRect = new JSONObject();
            jsonRect.put("x", rect.x);
            jsonRect.put("y", rect.y);
            jsonRect.put("width", rect.width);
            jsonRect.put("height", rect.height);
            this.json.put(name, (Object)jsonRect);
        }
    }

    public Rectangle getRectangle(String name) {
        if (this.json.has(name)) {
            JSONObject rect = this.json.getJSONObject(name);
            return new Rectangle(rect.getInt("x"), rect.getInt("y"), rect.getInt("width"), rect.getInt("height"));
        }
        return null;
    }
}

