/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.Identity;
import com.openfin.desktop.LayoutOptions;
import com.openfin.desktop.platform.Platform;
import java.util.concurrent.CompletionStage;
import org.json.JSONObject;

public class Layout {
    private Identity identity;
    private DesktopConnection connection;
    private Platform platform;

    private Layout(Identity identity, DesktopConnection connection) {
        this.identity = identity;
        this.connection = connection;
        this.platform = Platform.wrap(this.identity.getUuid(), this.connection);
    }

    public static Layout wrap(Identity identity, DesktopConnection connection) {
        return new Layout(identity, connection);
    }

    public CompletionStage<LayoutOptions> getConfig() {
        return this.platform.getChannelClient().thenCompose(client -> {
            JSONObject payload = new JSONObject();
            payload.put("target", (Object)this.identity.getJson());
            return client.dispatchAsync("get-frame-snapshot", payload).thenApply(ack -> {
                JSONObject result = ack.getJsonObject().getJSONObject("data").getJSONObject("result");
                return new LayoutOptions(result);
            });
        });
    }

    public CompletionStage<Void> applyPreset(String presetType) {
        return this.platform.getChannelClient().thenCompose(client -> {
            JSONObject presetTypeJson = new JSONObject();
            presetTypeJson.put("presetType", (Object)presetType);
            JSONObject payload = new JSONObject();
            payload.put("target", (Object)this.identity.getJson());
            payload.put("opts", (Object)presetTypeJson);
            return client.dispatchAsync("apply-preset-layout", payload).thenAcceptAsync(ack -> {
                if (!ack.isSuccessful()) {
                    throw new RuntimeException("error applyPreset, reason: " + ack.getReason());
                }
            });
        });
    }

    public CompletionStage<Void> replace(LayoutOptions newLayout) {
        return this.platform.getChannelClient().thenCompose(client -> {
            JSONObject layoutJson = new JSONObject();
            layoutJson.put("layout", (Object)newLayout.getJson());
            JSONObject payload = new JSONObject();
            payload.put("target", (Object)this.identity.getJson());
            payload.put("opts", (Object)layoutJson);
            return client.dispatchAsync("replace-layout", payload).thenAcceptAsync(ack -> {
                if (!ack.isSuccessful()) {
                    throw new RuntimeException("error replace, reason: " + ack.getReason());
                }
            });
        });
    }
}

