/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFinThreadPool
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OpenFinThreadPool.class);
    private ConcurrentHashMap<Runnable, ThreadPoolTimerTask> pendingRunnableTimerTaskMap;
    private ConcurrentHashMap<Runnable, String> executingRunnableStackTraceMap;
    private Timer executionTimer;
    private int pendingTaskTimeout;
    private boolean logStackTrace;
    private String threadPoolName;

    public OpenFinThreadPool(final String name, int nThreads) {
        super(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            AtomicInteger threadId = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, name + "-" + this.threadId.getAndIncrement());
            }
        });
        this.threadPoolName = name;
        this.pendingRunnableTimerTaskMap = new ConcurrentHashMap();
        this.executingRunnableStackTraceMap = new ConcurrentHashMap();
        this.executionTimer = new Timer(name + "ThreadPoolReportTimer");
        this.pendingTaskTimeout = Integer.parseInt(System.getProperty("com.openfin.desktop.threadpool.pendingtask.timeout", "10000"));
        this.logStackTrace = Boolean.parseBoolean(System.getProperty("com.openfin.desktop.threadpool.logstacktrace", "false"));
    }

    @Override
    public void execute(Runnable task) {
        try {
            ThreadPoolTimerTask tt = new ThreadPoolTimerTask(task, new Exception().getStackTrace()){

                @Override
                public void run() {
                    logger.warn("{}: unable to get available thread after {}ms, thread pool size: {}, running thread count: {}, the threads in the thread pool might have been exhausted.", new Object[]{OpenFinThreadPool.this.threadPoolName, OpenFinThreadPool.this.pendingTaskTimeout, OpenFinThreadPool.this.getCorePoolSize(), OpenFinThreadPool.this.executingRunnableStackTraceMap.size()});
                    if (OpenFinThreadPool.this.logStackTrace) {
                        logger.warn("waiting task was submitted at: {}", (Object)this.stackTrace);
                        for (String runningStackTrace : OpenFinThreadPool.this.executingRunnableStackTraceMap.values()) {
                            logger.warn("running task was submitted at: {}", (Object)runningStackTrace);
                        }
                    }
                }
            };
            this.executionTimer.schedule((TimerTask)tt, this.pendingTaskTimeout);
            this.pendingRunnableTimerTaskMap.put(task, tt);
        }
        catch (Exception ex) {
            logger.error("error execute", (Throwable)ex);
        }
        finally {
            super.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread thread, Runnable task) {
        try {
            ThreadPoolTimerTask waitForExecutionTimerTask = this.pendingRunnableTimerTaskMap.get(task);
            waitForExecutionTimerTask.cancel();
            this.executingRunnableStackTraceMap.put(task, waitForExecutionTimerTask.stackTrace);
        }
        catch (Exception ex) {
            logger.error("error beforeExecute", (Throwable)ex);
        }
        finally {
            super.beforeExecute(thread, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable task, Throwable t) {
        try {
            this.executingRunnableStackTraceMap.remove(task);
        }
        catch (Exception ex) {
            logger.error("error afterExecute", (Throwable)ex);
        }
        finally {
            super.afterExecute(task, t);
        }
    }

    abstract class ThreadPoolTimerTask
    extends TimerTask {
        Runnable task;
        String stackTrace;

        ThreadPoolTimerTask(Runnable task, StackTraceElement[] stackTrace) {
            this.task = task;
            StringBuilder sb = new StringBuilder("Stack trace").append(System.lineSeparator());
            for (StackTraceElement traceElement : stackTrace) {
                sb.append("\tat ").append(traceElement).append(System.lineSeparator());
            }
            this.stackTrace = sb.toString();
        }
    }
}

