/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.channel.AbstractProtocolHandler;
import com.openfin.desktop.channel.ChannelAction;
import com.openfin.desktop.channel.ChannelBase;
import com.openfin.desktop.channel.ChannelListener;
import com.openfin.desktop.channel.ConnectionEvent;
import com.openfin.desktop.channel.EndpointIdentity;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class ChannelClient
extends ChannelBase {
    private CopyOnWriteArrayList<ChannelListener> channelListeners;
    private AbstractProtocolHandler protocolHandler;

    ChannelClient(AbstractProtocolHandler protocolHandler, EndpointIdentity endpointIdentity) {
        super(endpointIdentity);
        this.protocolHandler = protocolHandler;
        this.channelListeners = new CopyOnWriteArrayList();
    }

    public void dispatch(String action, JSONObject actionPayload, AckListener ackListener) {
        super.dispatch(this.protocolHandler, this.endpointIdentity.toJSON(), action, actionPayload, ackListener);
    }

    public CompletableFuture<Ack> dispatchAsync(String action, Object actionPayload) {
        return super.dispatchAsync(this.protocolHandler, this.endpointIdentity.toJSON(), action, actionPayload);
    }

    @Override
    public boolean register(String action, ChannelAction listener) {
        return super.register(action, listener);
    }

    public CompletableFuture<Ack> disconnect() {
        this.logger.debug("disconnecting {} {}", (Object)this.getChannelName(), (Object)this.getEndpointId());
        CompletableFuture<Ack> future = this.protocolHandler.getChannel().disconnect(this);
        future.thenAccept(ack -> this.cleanup());
        return future;
    }

    public boolean addChannelListener(ChannelListener listener) {
        return this.channelListeners.add(listener);
    }

    public boolean removeChannelListener(ChannelListener listener) {
        return this.channelListeners.remove(listener);
    }

    void fireChannelConnectEvent(ConnectionEvent event) {
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelConnect(event);
        }
    }

    void fireChannelDisconnectEvent(ConnectionEvent event) {
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelDisconnect(event);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.channelListeners.clear();
    }
}

