/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.ActionEvent;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.channel.AbstractProtocolHandler;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.ChannelAction;
import com.openfin.desktop.channel.ChannelBase;
import com.openfin.desktop.channel.ChannelClientConnectEvent;
import com.openfin.desktop.channel.ChannelListener;
import com.openfin.desktop.channel.ChannelProviderListener;
import com.openfin.desktop.channel.ConnectionEvent;
import com.openfin.desktop.channel.EndpointIdentity;
import com.openfin.desktop.channel.ProtocolOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelProvider
extends ChannelBase {
    private static final Logger logger = LoggerFactory.getLogger((String)ChannelProvider.class.getName());
    private final Channel channel;
    private final List<ProtocolOptions> protocolOptionsList;
    private final ConcurrentHashMap<String, EndpointIdentity> clientMap;
    private final ConcurrentHashMap<String, AbstractProtocolHandler> protocolHandlerMap;
    private final CopyOnWriteArrayList<ChannelProviderListener> providerListeners;
    private static final String CLIENT_DISCONNECTED_EVENT = "client-disconnected";

    ChannelProvider(Channel channel, List<ProtocolOptions> protocolOptionsList, EndpointIdentity endpointIdentity) {
        super(endpointIdentity);
        this.channel = channel;
        this.protocolOptionsList = protocolOptionsList;
        this.clientMap = new ConcurrentHashMap();
        this.protocolHandlerMap = new ConcurrentHashMap();
        this.providerListeners = new CopyOnWriteArrayList();
        this.channel.addChannelListener(new ChannelListener(){

            @Override
            public void onChannelConnect(ConnectionEvent connectionEvent) {
            }

            @Override
            public void onChannelDisconnect(ConnectionEvent connectionEvent) {
                ChannelProvider.this.processDisconnection(connectionEvent.getEndpointId());
            }
        });
        JSONObject eventListenerPayload = new JSONObject();
        eventListenerPayload.put("topic", (Object)"channel");
        eventListenerPayload.put("type", (Object)CLIENT_DISCONNECTED_EVENT);
        this.channel.getDesktopConnection().addEventCallback(eventListenerPayload, new EventListener(){

            @Override
            public void eventReceived(ActionEvent actionEvent) {
                JSONObject event = actionEvent.getEventObject();
                if (ChannelProvider.this.channel.getName().equals(event.getString("channelName"))) {
                    ChannelProvider.this.processDisconnection(event.getString("endpointId"));
                }
            }
        }, null, this);
    }

    public void destroy(AckListener ackListener) {
        this.channel.destroy(this, ackListener);
    }

    public void processConnection(JSONObject connectionPayload, JSONObject ackToSenderPayload) throws Exception {
        JSONObject clientIdentity = connectionPayload.getJSONObject("clientIdentity");
        String clientEndpointId = clientIdentity.optString("endpointId");
        if (Objects.nonNull(clientEndpointId)) {
            JSONObject offer = connectionPayload.optJSONObject("offer");
            ProtocolOptions protocolOptions = this.selectRequestedProtocol(offer);
            if (Objects.isNull(protocolOptions)) {
                logger.error("requested channel protocol is not supported");
                ackToSenderPayload.put("success", false);
                return;
            }
            EndpointIdentity clientEndpointIdentity = new EndpointIdentity(clientIdentity);
            this.fireClientConnectEvent(new ChannelClientConnectEvent(clientEndpointIdentity.getChannelId(), clientEndpointIdentity.getUuid(), clientEndpointIdentity.getName(), clientEndpointIdentity.getChannelName(), clientEndpointIdentity.getEndpointId(), connectionPayload.opt("payload")));
            this.clientMap.put(clientEndpointId, clientEndpointIdentity);
            this.channel.fireChannelConnectEvent(new ChannelClientConnectEvent(clientEndpointIdentity.getChannelId(), clientEndpointIdentity.getUuid(), clientEndpointIdentity.getName(), clientEndpointIdentity.getChannelName(), clientEndpointIdentity.getEndpointId(), connectionPayload.has("payload") ? connectionPayload.get("payload") : null));
            AbstractProtocolHandler protocolHandler = AbstractProtocolHandler.createProtocolHandler(protocolOptions, this.channel);
            protocolHandler.initializeProvider(this.getEndpointIdentity(), clientEndpointIdentity);
            JSONObject answer = protocolHandler.processConnectOffer(offer);
            this.protocolHandlerMap.put(clientEndpointId, protocolHandler);
            if (Objects.nonNull(answer)) {
                JSONObject ackPayload = ackToSenderPayload.getJSONObject("payload");
                ackPayload.put("answer", (Object)answer);
            } else {
                ackToSenderPayload.put("success", false);
            }
        } else {
            logger.warn("Missing client endpoint id");
        }
    }

    private ProtocolOptions selectRequestedProtocol(JSONObject offer) {
        ProtocolOptions options = Channel.CLASSIC_PROTOCOL;
        if (Objects.nonNull(offer)) {
            options = null;
            if (Objects.nonNull(AbstractProtocolHandler.getOfferProtocolByType(offer, Channel.RTC_PROTOCOL)) && this.protocolOptionsList.contains(Channel.RTC_PROTOCOL)) {
                options = Channel.RTC_PROTOCOL;
            } else if (Objects.nonNull(AbstractProtocolHandler.getOfferProtocolByType(offer, Channel.CLASSIC_PROTOCOL)) && this.protocolOptionsList.contains(Channel.CLASSIC_PROTOCOL)) {
                options = Channel.CLASSIC_PROTOCOL;
            }
        }
        logger.debug("selected channel protocol {}", (Object)(Objects.nonNull(options) ? options.getName() : ""));
        return options;
    }

    private void processDisconnection(String endpointId) {
        logger.debug(String.format("Client disconnected %s from channel %s", endpointId, this.channel.getName()));
        EndpointIdentity endpointIdentity = this.clientMap.remove(endpointId);
        AbstractProtocolHandler protocolHandler = this.protocolHandlerMap.remove(endpointId);
        if (Objects.nonNull(protocolHandler)) {
            protocolHandler.cleanup();
        }
        this.fireClientDisconnectEvent(new ChannelClientConnectEvent(endpointIdentity.getChannelId(), endpointIdentity.getUuid(), endpointIdentity.getName(), endpointIdentity.getChannelName(), endpointIdentity.getEndpointId(), null));
    }

    public void publish(String action, JSONObject actionPayload, AckListener ackListener) {
        for (EndpointIdentity client : this.clientMap.values()) {
            EndpointIdentity destId = new EndpointIdentity(client.getChannelName(), null, client.getUuid(), client.getName(), client.getEndpointId());
            AbstractProtocolHandler protocolHandler = this.protocolHandlerMap.get(client.getEndpointId());
            if (Objects.nonNull(protocolHandler)) {
                this.dispatch(protocolHandler, destId.toJSON(), action, actionPayload, ackListener);
                continue;
            }
            logger.warn("Missing protocol handler for publish {} {}", (Object)client.getUuid(), (Object)client.getEndpointId());
        }
    }

    public List<CompletableFuture<Ack>> publishAsync(String action, JSONObject actionPayload) {
        ArrayList<CompletableFuture<Ack>> list = new ArrayList<CompletableFuture<Ack>>();
        for (EndpointIdentity client : this.clientMap.values()) {
            EndpointIdentity destId = new EndpointIdentity(client.getChannelName(), null, client.getUuid(), client.getName(), client.getEndpointId());
            AbstractProtocolHandler protocolHandler = this.protocolHandlerMap.get(client.getEndpointId());
            if (Objects.nonNull(protocolHandler)) {
                list.add(this.dispatchAsync(protocolHandler, destId.toJSON(), action, actionPayload));
                continue;
            }
            logger.warn("Missing protocol handler for publish {} {}", (Object)client.getUuid(), (Object)client.getEndpointId());
        }
        return list;
    }

    public CompletableFuture<Ack> dispatchAsync(JSONObject destinationIdentity, String action, JSONObject actionPayload) {
        AbstractProtocolHandler protocolHandler = this.protocolHandlerMap.get(destinationIdentity.getString("endpointId"));
        if (Objects.nonNull(protocolHandler)) {
            return this.dispatchAsync(protocolHandler, destinationIdentity, action, actionPayload);
        }
        CompletableFuture<Ack> ackFuture = new CompletableFuture<Ack>();
        ackFuture.complete(DesktopUtils.getNack((Object)this, "Invalid destinationIdentity"));
        return ackFuture;
    }

    public void dispatch(JSONObject destinationIdentity, String action, JSONObject actionPayload, AckListener ackListener) {
        AbstractProtocolHandler protocolHandler = this.protocolHandlerMap.get(destinationIdentity.getString("endpointId"));
        if (Objects.nonNull(protocolHandler)) {
            super.dispatch(protocolHandler, destinationIdentity, action, actionPayload, ackListener);
        } else {
            DesktopUtils.errorAck(ackListener, DesktopUtils.getNack((Object)this, "Invalid destinationIdentity"));
        }
    }

    @Override
    public boolean register(String action, ChannelAction listener) {
        return super.register(action, listener);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.clientMap.clear();
        this.protocolHandlerMap.clear();
    }

    public boolean addProviderListener(ChannelProviderListener listener) {
        return this.providerListeners.add(listener);
    }

    public boolean removeProviderListener(ChannelProviderListener listener) {
        return this.providerListeners.remove(listener);
    }

    protected void fireClientConnectEvent(ChannelClientConnectEvent event) throws Exception {
        for (ChannelProviderListener listener : this.providerListeners) {
            listener.onClientConnect(event);
        }
    }

    protected void fireClientDisconnectEvent(ChannelClientConnectEvent event) {
        for (ChannelProviderListener listener : this.providerListeners) {
            listener.onClientDisconnect(event);
        }
    }
}

