/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.channel.AbstractProtocolHandler;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.ProtocolOptions;
import java.util.concurrent.CompletableFuture;
import org.json.JSONObject;

public class ClassicProtocolHandler
extends AbstractProtocolHandler {
    public ClassicProtocolHandler(Channel channel) {
        super(channel);
    }

    @Override
    public ProtocolOptions getProtocolOptions() {
        return Channel.CLASSIC_PROTOCOL;
    }

    @Override
    protected JSONObject getSupportedOfferProtocol() {
        JSONObject prot = super.getSupportedOfferProtocol();
        prot.put("type", (Object)Channel.CLASSIC_PROTOCOL.getName());
        prot.put("version", Channel.CLASSIC_PROTOCOL.getVersion());
        return prot;
    }

    @Override
    protected JSONObject getSupportedAnswerProtocol() {
        JSONObject prot = super.getSupportedAnswerProtocol();
        prot.put("type", (Object)Channel.CLASSIC_PROTOCOL.getName());
        prot.put("version", Channel.CLASSIC_PROTOCOL.getVersion());
        return prot;
    }

    @Override
    public void sendChannelMessage(String action, JSONObject destionationIdentity, JSONObject providerIdentity, JSONObject actionPayload, AckListener ackListener) {
        JSONObject payload = new JSONObject(destionationIdentity, new String[]{"name", "uuid", "channelId", "channelName", "endpointId"});
        payload.put("providerIdentity", (Object)providerIdentity);
        payload.put("action", (Object)action);
        payload.put("payload", (Object)actionPayload);
        this.channel.getDesktopConnection().sendAction("send-channel-message", payload, ackListener, this);
    }

    @Override
    public CompletableFuture<Ack> sendChannelMessageAsync(String action, JSONObject destionationIdentity, JSONObject providerIdentity, Object actionPayload) {
        JSONObject payload = new JSONObject(destionationIdentity, new String[]{"name", "uuid", "channelId", "channelName", "endpointId"});
        payload.put("providerIdentity", (Object)providerIdentity);
        payload.put("action", (Object)action);
        payload.put("payload", actionPayload);
        CompletableFuture ackFuture = new CompletableFuture();
        return this.channel.getDesktopConnection().sendActionAsync("send-channel-message", payload, this);
    }
}

