/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import java.util.Objects;
import org.json.JSONObject;

public class EndpointIdentity {
    private final String channelName;
    private final String channelId;
    private final String uuid;
    private final String name;
    private final String endpointId;
    private JSONObject json;

    public EndpointIdentity(JSONObject json) {
        this.channelName = json.optString("channelName");
        this.channelId = json.optString("channelId");
        this.uuid = json.optString("uuid");
        this.name = json.optString("name");
        this.endpointId = json.optString("endpointId");
        this.json = json;
    }

    public EndpointIdentity(String channelName, String channelId, String uuid, String name, String endpointId) {
        this.channelName = channelName;
        this.channelId = channelId;
        this.uuid = uuid;
        this.name = name != null ? name : this.uuid;
        this.endpointId = endpointId != null ? endpointId : null;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public int hashCode() {
        return Objects.hash(this.channelName, this.channelId, this.uuid, this.name, this.endpointId);
    }

    public boolean equals(Object obj) {
        boolean b;
        boolean bl = b = this == obj;
        if (!b && obj instanceof EndpointIdentity) {
            EndpointIdentity that = (EndpointIdentity)obj;
            b = Objects.equals(this.channelName, that.channelName) && Objects.equals(this.channelId, that.channelId) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.name, that.name) && Objects.equals(this.endpointId, that.endpointId);
        }
        return b;
    }

    public JSONObject toJSON() {
        if (this.json == null) {
            this.json = new JSONObject();
            this.json.put("channelName", (Object)this.channelName);
            this.json.put("channelId", (Object)this.channelId);
            this.json.put("uuid", (Object)this.uuid);
            this.json.put("name", (Object)this.name);
            this.json.put("endpointId", (Object)this.endpointId);
        }
        return this.json;
    }

    public String toString() {
        return this.toJSON().toString();
    }
}

