/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.fdc3;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.OpenFinRuntime;
import com.openfin.desktop.channel.AbstractServiceClient;
import com.openfin.desktop.channel.ChannelAction;
import com.openfin.desktop.fdc3.AppIntent;
import com.openfin.desktop.fdc3.AppMetadata;
import com.openfin.desktop.fdc3.Channel;
import com.openfin.desktop.fdc3.Context;
import com.openfin.desktop.fdc3.ContextListener;
import com.openfin.desktop.fdc3.IntentListener;
import com.openfin.desktop.fdc3.IntentMetadata;
import com.openfin.desktop.fdc3.IntentResolution;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class FDC3Client
extends AbstractServiceClient {
    private static final String Open = "OPEN";
    private static final String FindIntent = "FIND-INTENT";
    private static final String FindIntentsByContext = "FIND-INTENTS-BY-CONTEXT";
    private static final String Broadcast = "BROADCAST";
    private static final String RaiseIntent = "RAISE-INTENT";
    private static final String AddContextListener = "ADD-CONTEXT-LISTENER";
    private static final String AddIntentListener = "ADD-INTENT-LISTENER";
    private static final String RemoveIntentListener = "REMOVE-INTENT-LISTENER";
    private static final String GetDesktopChannels = "GET-DESKTOP-CHANNELS";
    private static final String GetChannelByID = "GET-CHANNEL-BY-ID";
    private static final String GetCurrentChannel = "GET-CURRENT-CHANNEL";
    private static final String ContextAction = "RECEIVE-CONTEXT";
    private static final String ChannelContextAction = "HANDLE-CHANNEL-CONTEXT";
    private static final String IntentAction = "RECEIVE-INTENT";
    private static final String ServiceChannelName = "of-fdc3-service-v1";
    private static final String Fdc3ChannelNameKey = "fdc3ChannelName";
    private static FDC3Client instance;
    private CopyOnWriteArrayList<ContextListener> contextListeners = new CopyOnWriteArrayList();
    private ConcurrentHashMap<String, ContextListener> channelContextMap;
    private ConcurrentHashMap<String, IntentListener> intentMap = new ConcurrentHashMap();

    public static synchronized FDC3Client getInstance(DesktopConnection desktopConnection) {
        if (instance == null) {
            instance = new FDC3Client(desktopConnection);
        }
        return instance;
    }

    private FDC3Client(DesktopConnection desktopConnection) {
        super(ServiceChannelName, desktopConnection);
        this.channelContextMap = new ConcurrentHashMap();
    }

    @Override
    public void connect(final AckListener ackListener) {
        OpenFinRuntime runtime = new OpenFinRuntime(this.desktopConnection);
        try {
            runtime.getRuntimeInfo(new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    JSONObject data = (JSONObject)ack.getData();
                    if (data.has(FDC3Client.Fdc3ChannelNameKey)) {
                        FDC3Client.this.setChannelName(data.getString(FDC3Client.Fdc3ChannelNameKey));
                    }
                    FDC3Client.super.connect(ackListener);
                }

                @Override
                public void onError(Ack ack) {
                    ackListener.onError(ack);
                }
            });
        }
        catch (Exception ex) {
            this.logger.error("Error getting RuntimeInfo", (Throwable)ex);
            DesktopUtils.errorAckOnException(ackListener, this, ex);
        }
    }

    void serviceDispatch(String action, JSONObject actionPayload, AckListener ackListener) {
        this.channelClient.dispatch(action, actionPayload, ackListener);
    }

    public void open(String name, Context context, AckListener ackListener) {
        JSONObject payload = new JSONObject();
        payload.put("name", (Object)name);
        if (context != null) {
            payload.put("context", (Object)context);
        }
        this.serviceDispatch(Open, payload, ackListener);
    }

    public void broadcast(Context context, AckListener ackListener) {
        JSONObject payload = new JSONObject();
        payload.put("context", (Object)context);
        this.serviceDispatch(Broadcast, payload, ackListener);
    }

    private AppIntent parseAppIntent(JSONObject appIntentJson) {
        JSONObject intentJson = appIntentJson.getJSONObject("intent");
        IntentMetadata im = new IntentMetadata(intentJson.getString("name"), intentJson.getString("displayName"));
        JSONArray appsJson = appIntentJson.getJSONArray("apps");
        ArrayList<AppMetadata> apps = new ArrayList<AppMetadata>();
        for (int i = 0; i < appsJson.length(); ++i) {
            JSONObject appObj = appsJson.getJSONObject(i);
            apps.add(new AppMetadata(appObj.getString("name")));
        }
        return new AppIntent(im, apps);
    }

    public void findIntent(String intent, Context context, final AsyncCallback<AppIntent> callback) {
        JSONObject payload = new JSONObject();
        payload.put("intent", (Object)intent);
        if (context != null) {
            payload.put("context", (Object)context);
        }
        this.serviceDispatch(FindIntent, payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                JSONObject result = ack.getJsonObject().getJSONObject("data").getJSONObject("result");
                callback.onSuccess(FDC3Client.this.parseAppIntent(result));
            }

            @Override
            public void onError(Ack ack) {
            }
        });
    }

    public void findIntentsByContext(Context context, final AsyncCallback<List<AppIntent>> callback) {
        JSONObject payload = new JSONObject();
        payload.put("context", (Object)(context == null ? null : context));
        this.serviceDispatch(FindIntentsByContext, payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                System.out.println(ack.getJsonObject().toString());
                JSONArray result = ack.getJsonObject().getJSONObject("data").getJSONArray("result");
                ArrayList<AppIntent> intents = new ArrayList<AppIntent>();
                for (int i = 0; i < result.length(); ++i) {
                    intents.add(FDC3Client.this.parseAppIntent(result.getJSONObject(i)));
                }
                callback.onSuccess(intents);
            }

            @Override
            public void onError(Ack ack) {
            }
        });
    }

    public void raiseIntent(String intent, Context context, String target, final AsyncCallback<IntentResolution> callback) {
        JSONObject payload = new JSONObject();
        payload.put("intent", (Object)intent);
        payload.put("context", (Object)(context == null ? null : context));
        payload.put("target", (Object)target);
        this.serviceDispatch(RaiseIntent, payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                FDC3Client.this.logger.info("raise intent onSuccess, response: {}", (Object)ack.getJsonObject().toString());
                JSONObject dataObj = (JSONObject)ack.getData();
                JSONObject result = dataObj.getJSONObject("result");
                Object resultData = result.has("data") ? result.get("data") : null;
                IntentResolution ir = new IntentResolution(result.getString("source"), resultData, result.getString("version"));
                callback.onSuccess(ir);
            }

            @Override
            public void onError(Ack ack) {
                FDC3Client.this.logger.info("raise intent onError, reason: {}", (Object)ack.getReason());
            }
        });
    }

    private void registerContextAction() {
        this.logger.debug(String.format("Registering action %s", ContextAction));
        this.channelClient.register(ContextAction, new ChannelAction(){

            public JSONObject invoke(String action, Object payload, JSONObject senderIdentity) {
                Context context = Context.fromJson(((JSONObject)payload).getJSONObject("context"));
                for (ContextListener listener : FDC3Client.this.contextListeners) {
                    listener.onContext(context);
                }
                return null;
            }
        });
    }

    private void registerChannelContextAction() {
        this.logger.debug(String.format("Registering action %s", ChannelContextAction));
        this.channelClient.register(ChannelContextAction, new ChannelAction(){

            public JSONObject invoke(String action, Object payload, JSONObject senderIdentity) {
                JSONObject jsonPayload = (JSONObject)JSONObject.class.cast(payload);
                String channelId = jsonPayload.getString("channel");
                ContextListener listener = FDC3Client.this.channelContextMap.get(channelId);
                if (listener != null) {
                    Context context = Context.fromJson(jsonPayload.getJSONObject("context"));
                    listener.onContext(context);
                    return null;
                }
                FDC3Client.this.logger.debug(String.format("no channel listeners for %s", channelId));
                return null;
            }
        });
    }

    synchronized void addChannelContextListener(String channelId, ContextListener contextListener) {
        if (this.channelContextMap.get(channelId) == null) {
            this.logger.debug(String.format("Registering action %s", ChannelContextAction));
            this.channelContextMap.put(channelId, contextListener);
        } else {
            this.logger.debug(String.format("channel listeners already registered for %s", channelId));
        }
    }

    private void registerIntentAction() {
        this.logger.debug(String.format("Registering action %s", IntentAction));
        this.channelClient.register(IntentAction, new ChannelAction(){

            public JSONObject invoke(String action, Object payload, JSONObject senderIdentity) {
                JSONObject jsonPayload = (JSONObject)JSONObject.class.cast(payload);
                String intent = jsonPayload.getString("intent");
                Context context = Context.fromJson(jsonPayload.getJSONObject("context"));
                IntentListener listener = FDC3Client.this.intentMap.get(intent);
                JSONObject result = null;
                if (listener != null) {
                    result = listener.onIntent(context);
                }
                return result;
            }
        });
    }

    @Override
    protected void onChannelConnected() {
        super.onChannelConnected();
        this.registerContextAction();
        this.registerChannelContextAction();
        this.registerIntentAction();
    }

    public void addContextListener(final ContextListener callback, final AckListener ackListener) {
        if (this.contextListeners.size() == 0) {
            JSONObject payload = new JSONObject();
            payload.put("id", (Object)this.channelName);
            this.serviceDispatch(AddContextListener, payload, new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    if (ack.isSuccessful()) {
                        FDC3Client.this.contextListeners.add(callback);
                        if (ackListener != null) {
                            ackListener.onSuccess(ack);
                        }
                        FDC3Client.this.logger.debug("context listener registered");
                    } else if (ackListener != null) {
                        ackListener.onError(ack);
                    }
                }

                @Override
                public void onError(Ack ack) {
                    FDC3Client.this.logger.warn("unable to register context listener reason: {}", (Object)ack.getReason());
                    if (ackListener != null) {
                        ackListener.onError(ack);
                    }
                }
            });
        } else {
            this.contextListeners.add(callback);
            if (ackListener != null) {
                ackListener.onSuccess(null);
            }
        }
    }

    public boolean removeContextListener(ContextListener listener) {
        return this.contextListeners.remove(listener);
    }

    public void addIntentListener(final String intent, final IntentListener listener, final AckListener ackListener) {
        if (this.intentMap.get(intent) == null) {
            JSONObject payload = new JSONObject();
            payload.put("intent", (Object)intent);
            this.serviceDispatch(AddIntentListener, payload, new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    if (ack.isSuccessful()) {
                        FDC3Client.this.intentMap.put(intent, listener);
                        if (ackListener != null) {
                            ackListener.onSuccess(ack);
                        }
                        FDC3Client.this.logger.debug("intent {} listener registered", (Object)intent);
                    } else if (ackListener != null) {
                        ackListener.onError(ack);
                    }
                }

                @Override
                public void onError(Ack ack) {
                    FDC3Client.this.logger.warn("unable to register intent listener {}, reason: {}", (Object)intent, (Object)ack.getReason());
                    if (ackListener != null) {
                        ackListener.onError(ack);
                    }
                }
            });
        } else {
            JSONObject obj = new JSONObject();
            obj.put("success", false);
            obj.put("reason", (Object)"Intent listener already registered");
            Ack ack = new Ack(obj, this);
            this.logger.warn("unable to register intent listener {}, reason: {}", (Object)intent, (Object)ack.getReason());
            if (ackListener != null) {
                ackListener.onError(ack);
            }
        }
    }

    void removeIntentListener(String intent, IntentListener listener, AckListener ackListener) {
        if (this.intentMap.get(intent) == listener) {
            JSONObject payload = new JSONObject();
            payload.put("intent", (Object)intent);
            this.serviceDispatch(RemoveIntentListener, payload, new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                }

                @Override
                public void onError(Ack ack) {
                }
            });
        }
    }

    public void getChannelById(final String id, final AsyncCallback<Channel> callback) {
        JSONObject payload = new JSONObject();
        payload.put("id", (Object)id);
        this.serviceDispatch(GetChannelByID, payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                if (ack.isSuccessful()) {
                    JSONObject data = ack.getJsonObject().getJSONObject("data");
                    JSONObject result = data.getJSONObject("result");
                    if (id.equals(result.getString("id"))) {
                        Channel c = new Channel(id, FDC3Client.this);
                        if (result.has("name")) {
                            c.setName(result.getString("name"));
                        } else if (result.has("visualIdentity")) {
                            JSONObject vid = result.getJSONObject("visualIdentity");
                            c.setName(vid.getString("name"));
                        }
                        callback.onSuccess(c);
                    } else {
                        FDC3Client.this.logger.debug("channel not found: {}", (Object)id);
                        callback.onSuccess(null);
                    }
                } else {
                    FDC3Client.this.logger.debug("channel not found: {}", (Object)id);
                    callback.onSuccess(null);
                }
            }

            @Override
            public void onError(Ack ack) {
                FDC3Client.this.logger.info("raise intent onError, reason: {}", (Object)ack.getReason());
                callback.onSuccess(null);
            }
        });
    }

    public void getDefaultChannel(AsyncCallback<Channel> callback) {
        this.getChannelById("default", callback);
    }
}

