package com.openfin.desktop;

import java.awt.Point;
import java.util.List;

import org.json.JSONObject;

public class MonitorInfo extends JsonBean {
	private Point dpi;
	private MonitorDetails primaryMonitor;
	private List<MonitorDetails> nonPrimaryMonitors;

	public MonitorInfo(JSONObject json) {
		super(json);
	}
	
	public double getDeviceScaleFactor() {
		return json.optDouble("deviceScaleFactor", 1);
	}
	
	public Point getDpi() {
		if (this.dpi == null && json.has("dpi")) {
			JSONObject jsonDpi = json.getJSONObject("dpi");
			this.dpi = new Point(jsonDpi.getInt("x"), jsonDpi.getInt("y"));
		}
		return this.dpi;
	}
	
	public MonitorDetails getPrimaryMonitor() {
		if (this.primaryMonitor == null && this.json.has("primaryMonitor")) {
			this.primaryMonitor = this.getJsonBean("primaryMonitor", MonitorDetails.class);
		}
		return this.primaryMonitor;
	}
	
	public List<MonitorDetails> getNonPrimaryMonitors() {
		if (this.nonPrimaryMonitors == null && this.json.has("nonPrimaryMonitors")) {
			this.nonPrimaryMonitors = this.getJsonBeanList("nonPrimaryMonitors", MonitorDetails.class);
		}
		return this.nonPrimaryMonitors;
	}
}
