package com.openfin.desktop.channel;

public interface ChannelProviderListener {
    /**
     * Callback when a channel provider receives a connect request from a channel client
     *
     * @param connectionEvent connection event
     * @throws Exception a provider can reject the connection by throwing an exception
     */
    public void onClientConnect(ChannelClientConnectEvent connectionEvent) throws Exception;

    /**
     * Callback when a channel provider receives when a channel client disconnects
     *
     * @param connectionEvent event object for the disconnect
     */
    public void onClientDisconnect(ChannelClientConnectEvent connectionEvent);

}
