package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import org.json.JSONObject;

import java.util.concurrent.CompletableFuture;

public class ClassicProtocolHandler extends AbstractProtocolHandler {

    public ClassicProtocolHandler(Channel channel) {
        super(channel);
    }

    @Override
    public ProtocolOptions getProtocolOptions() {
        return Channel.CLASSIC_PROTOCOL;
    }

    @Override
    protected JSONObject getSupportedOfferProtocol() {
        JSONObject prot = super.getSupportedOfferProtocol();
        prot.put("type", Channel.CLASSIC_PROTOCOL.getName());
        prot.put("version", Channel.CLASSIC_PROTOCOL.getVersion());
        return prot;
    }

    @Override
    protected JSONObject getSupportedAnswerProtocol() {
        JSONObject prot = super.getSupportedAnswerProtocol();
        prot.put("type", Channel.CLASSIC_PROTOCOL.getName());
        prot.put("version", Channel.CLASSIC_PROTOCOL.getVersion());
        return prot;
    }

    @Override
    public void sendChannelMessage(String action, JSONObject destionationIdentity, JSONObject providerIdentity,
                            JSONObject actionPayload, AckListener ackListener) {
        JSONObject payload = new JSONObject(destionationIdentity,
                new String[] { "name", "uuid", "channelId", "channelName", "endpointId" });
        payload.put("providerIdentity", providerIdentity);
        payload.put("action", action);
        payload.put("payload", actionPayload);
        channel.getDesktopConnection().sendAction("send-channel-message", payload, ackListener,this);
    }

    @Override
    public CompletableFuture<Ack> sendChannelMessageAsync(String action, JSONObject destionationIdentity, JSONObject providerIdentity,
                                                   Object actionPayload) {
        JSONObject payload = new JSONObject(destionationIdentity,
                new String[] { "name", "uuid", "channelId", "channelName", "endpointId" });
        payload.put("providerIdentity", providerIdentity);
        payload.put("action", action);
        payload.put("payload", actionPayload);
        CompletableFuture<Ack> ackFuture = new CompletableFuture<>();
        return channel.getDesktopConnection().sendActionAsync("send-channel-message", payload, this);
    }

}
