package com.openfin.desktop.channel;

import org.json.JSONObject;

public class ConnectionEvent {
	private final String channelId;
	private final String uuid;
	private final String name;
	private final String channelName;
	private final String endpointId;

	public ConnectionEvent(String channelId, String uuid, String name, String channelName, String endpointId) {
		this.channelId = channelId;
		this.uuid = uuid;
		this.name = name;
		this.channelName = channelName;
		this.endpointId = endpointId;
	}

	public ConnectionEvent(JSONObject eventObj) {
		this.channelId = eventObj.optString("channelId");
		this.uuid = eventObj.optString("uuid");
		this.name = eventObj.optString("name");
		this.channelName = eventObj.optString("channelName");
		this.endpointId = eventObj.optString("endpointId");
	}

	public String getChannelId() {
		return channelId;
	}

	public String getUuid() {
		return uuid;
	}

	public String getName() {
		return name;
	}

	public String getChannelName() {
		return channelName;
	}
	
	public String getEndpointId() {
		return endpointId;
	}
}
