package com.openfin.desktop.interop;

import org.json.JSONObject;

import com.openfin.desktop.JsonBean;

public class ContextGroupInfo extends JsonBean {
	
	private DisplayMetadata displayMetadata;
	
	public ContextGroupInfo() {
	}
	
	public ContextGroupInfo(JSONObject jsonObject) {
		super(jsonObject);
	}

	public String getId() {
		return this.getString("id");
	}
	
	public void setId(String id) {
		this.setString("id", id);
	}

	public DisplayMetadata getDisplayMetadata() {
		if (this.displayMetadata == null && this.json.has("displayMetadata") && !this.json.isNull("displayMetadata")) {
			this.displayMetadata = new DisplayMetadata(this.json.getJSONObject("displayMetadata"));
		}
		return this.displayMetadata;
	}
	
	public void setDisplayMetadata(DisplayMetadata displayMetadata) {
		this.setJsonBean("displayMetadata", displayMetadata);
	}
}
