package com.openfin.desktop.notifications;

import org.json.JSONObject;

import com.openfin.desktop.JsonBean;

public class NotificationIndicator extends JsonBean {
	
	public final static String TYPE_FAILURE = "failure";
	public final static String TYPE_SUCCESS = "success";
	public final static String TYPE_WARNING = "warning";
	
	/**
	 * Indicates the semantic intent behind the indicator - this determines the visual styling of the indicator when seen by the user.
	 *  
	 * @param type indicator type can be one of the following: {@link #TYPE_FAILURE}, {@link #TYPE_SUCCESS}, {@link #TYPE_WARNING}
	 */
	public NotificationIndicator(String type) {
		super();
		this.setString("type", type);
	}
	
	public NotificationIndicator(JSONObject json) {
		super(json);
	}
	
	public String getType() {
		return this.getString("type");
	}

	public String getText() {
		return this.getString("text");
	}
	
	public void setText(String text) {
		this.setString("text", text);
	}
}
