package com.openfin.desktop.notifications;

import org.json.JSONObject;

import com.openfin.desktop.JsonBean;

/**
 * For notifications that have come from a cloud-hosted notification feed.
 * @author Anthony
 *
 */
public class NotificationSourceFeed extends JsonBean implements NotificationSource {

	private FeedApplication application;

	public NotificationSourceFeed(JSONObject jsonObject) {
		super(jsonObject);
	}

	public FeedApplication getApplication() {
		if (this.application == null && this.json.has("application") && !this.json.isNull("application")) {
			this.application = new FeedApplication(this.json.getJSONObject("application"));
		}
		return this.application;
	}

	public String getId() {
		return this.getString("id");
	}

	@Override
	public String getType() {
		return this.getString("type");
	}

}
