package com.openfin.desktop.snapshot;

import org.json.JSONObject;

/**
 * Interface to be implemented to provide snapshot operations.
 */
public interface SnapshotSourceProvider {
    /**
     * The method to be invoked when requesting the current snapshot
     * @return current snapshot
     */
    public JSONObject getSnapshot();

    /**
     * The method to be invoked when applying the snapshot.
     *
     * @param snapshot The snapshot object to be applied.  The object can be String, JSONObject or JSONArray
     */
    void applySnapshot(JSONObject snapshot);
}
