/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.LaunchExternalProcessResult;
import com.openfin.desktop.MonitorInfo;
import com.openfin.desktop.TerminateExternalProcessResult;
import com.openfin.desktop.win32.InstallChecker;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFinRuntime {
    private static Logger logger = LoggerFactory.getLogger((String)OpenFinRuntime.class.getName());
    protected DesktopConnection connection;
    protected JSONObject eventListenerPayload;
    protected JSONObject configPayload;
    private static String adapterVersion;
    private static long adapterBuildTime;

    public OpenFinRuntime(DesktopConnection connection) {
        this.connection = connection;
    }

    public void getMachineId(AckListener listener) {
        this.connection.sendAction("get-machine-id", null, listener, this);
    }

    public void getEntityInfo(String uuid, String name, AckListener listener) {
        JSONObject payload = new JSONObject();
        payload.put("uuid", (Object)uuid);
        payload.put("name", (Object)name);
        this.connection.sendAction("get-entity-info", payload, listener, this);
    }

    public void getVersion(AckListener listener) {
        this.connection.sendAction("get-version", null, listener, this);
    }

    public void getCommandLineArguments(AckListener listener) {
        this.connection.sendAction("get-command-line-arguments", null, listener, this);
    }

    public void getProcessList(AckListener listener) {
        this.connection.sendAction("process-snapshot", null, listener, this);
    }

    public void getLog(String logName, AckListener listener) {
        try {
            this.connection.sendAction("view-log", new JSONObject().put("name", (Object)logName), listener, this);
        }
        catch (JSONException e) {
            logger.error("Error getLog", (Throwable)e);
        }
    }

    public void getLogList(AckListener listener) {
        this.connection.sendAction("list-logs", null, listener, this);
    }

    public void log(String level, String message) throws DesktopException {
        try {
            this.connection.sendAction("write-to-log", new JSONObject().put("level", (Object)level).put("message", (Object)message));
        }
        catch (JSONException e) {
            logger.error("Error logging message", (Throwable)e);
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void log(String level, String message, AckListener listener) throws DesktopException {
        try {
            this.connection.sendAction("write-to-log", new JSONObject().put("level", (Object)level).put("message", (Object)message), listener, this);
        }
        catch (JSONException e) {
            logger.error("Error logging message", (Throwable)e);
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void getProxySettings(AckListener listener) {
        this.connection.sendAction("get-proxy-settings", null, listener, this);
    }

    public void resolveProxy(String url, AckListener listener) {
        this.connection.sendAction("resolve-proxy", new JSONObject().put("url", (Object)url), listener, this);
    }

    public void updateProxySettings(String type, String proxyAddress, int proxyPort, AckListener listener) throws DesktopException {
        try {
            this.connection.sendAction("update-proxy", new JSONObject().put("type", (Object)type).put("proxyAddress", (Object)proxyAddress).put("proxyPort", proxyPort), listener, this);
        }
        catch (JSONException e) {
            logger.error("Error updating proxy settings", (Throwable)e);
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void clearCache(boolean cache, boolean cookies, boolean localStorage, boolean appcache, boolean userData) throws DesktopException {
        try {
            this.connection.sendAction("clear-cache", new JSONObject().put("cache", cache).put("cookies", cookies).put("localStorage", localStorage).put("appcache", appcache).put("userData", userData));
        }
        catch (JSONException e) {
            logger.error("Error clearing cache", (Throwable)e);
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void clearCache(boolean cache, boolean cookies, boolean localStorage, boolean appcache, boolean userData, AckListener listener) throws DesktopException {
        try {
            this.connection.sendAction("clear-cache", new JSONObject().put("cache", cache).put("cookies", cookies).put("localStorage", localStorage).put("appcache", appcache).put("userData", userData), listener, this);
        }
        catch (JSONException e) {
            logger.error("Error clearing cache", (Throwable)e);
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void deleteCacheOnRestart() throws DesktopException {
        this.connection.sendAction("delete-cache-request", null);
    }

    public void deleteCacheOnRestart(AckListener listener) {
        this.connection.sendAction("delete-cache-request", null, listener, this);
    }

    public void openUrlWithBrowser(AckListener listener) {
        this.connection.sendAction("open-url-with-browser", null, listener, this);
    }

    public void getMonitorInfo(AckListener listener) {
        this.connection.sendAction("get-monitor-info", null, listener, this);
    }

    public CompletableFuture<MonitorInfo> getMonitorInfoAsync() {
        return this.connection.sendActionAsync("get-monitor-info", null, this).thenApply(ack -> {
            if (ack.isSuccessful()) {
                return new MonitorInfo(ack.getJsonObject().getJSONObject("data"));
            }
            throw new RuntimeException("error getting monitor info, reason: " + ack.getReason());
        });
    }

    public void getAllWindows(AckListener listener) {
        this.connection.sendAction("get-all-windows", null, listener, this);
    }

    public void getAllApplications(AckListener listener) {
        this.connection.sendAction("get-all-applications", new JSONObject(), listener, this);
    }

    public void exit() throws DesktopException {
        this.connection.exit();
    }

    public void getMousePosition(AckListener listener) {
        this.connection.sendAction("get-mouse-position", null, listener, this);
    }

    public void openUrlWithBrowser() throws DesktopException {
        this.connection.sendAction("open-url-with-browser", null);
    }

    public void getConfig(String section, AckListener callback) throws DesktopException {
        try {
            if (this.configPayload == null) {
                this.configPayload = new JSONObject();
            }
            this.configPayload.put("section", (Object)section);
            this.connection.sendAction("get-config", this.configPayload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error setConfig", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void showDeveloperTools(String applicationUUID, String windowName, AckListener callback) throws DesktopException {
        try {
            JSONObject developerToolsPayload = new JSONObject();
            developerToolsPayload.put("uuid", (Object)applicationUUID);
            developerToolsPayload.put("name", (Object)windowName);
            this.connection.sendAction("show-developer-tools", developerToolsPayload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error showing developer tool", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    protected void addEventListener(JSONObject subscriptionObject, EventListener listener, AckListener callback) throws DesktopException {
        this.connection.addEventCallback(subscriptionObject, listener, callback, this);
    }

    public void addEventListener(String type, EventListener listener, AckListener callback) throws DesktopException {
        try {
            if (this.eventListenerPayload == null) {
                this.eventListenerPayload = new JSONObject();
                this.eventListenerPayload.put("topic", (Object)"system");
            }
            this.eventListenerPayload.put("type", (Object)type);
            this.addEventListener(this.eventListenerPayload, listener, callback);
        }
        catch (Exception e) {
            logger.error("Error adding event listener", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void removeEventListener(String type, EventListener listener, AckListener callback) throws DesktopException {
        try {
            if (this.eventListenerPayload == null) {
                this.eventListenerPayload = new JSONObject();
                this.eventListenerPayload.put("topic", (Object)"system");
            }
            this.eventListenerPayload.put("type", (Object)type);
            this.connection.removeEventCallback(this.eventListenerPayload, listener, callback, this);
        }
        catch (Exception e) {
            logger.error("Error reoving event listener", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void launchExternalProcess(String path, String commandLine, AsyncCallback<LaunchExternalProcessResult> callback, AckListener listener) throws DesktopException {
        JSONObject launchExternalProcessPayload = new JSONObject();
        try {
            launchExternalProcessPayload.put("path", (Object)path);
            launchExternalProcessPayload.put("arguments", (Object)commandLine);
            launchExternalProcessPayload.put("commandLine", (Object)commandLine);
            this.launchExternalProcess(launchExternalProcessPayload, callback, listener);
        }
        catch (Exception e) {
            logger.error("Error launching external process", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void launchExternalProcess(JSONObject launchConfig, final AsyncCallback<LaunchExternalProcessResult> callback, final AckListener listener) throws DesktopException {
        try {
            AckListener mainCallback = null;
            if (callback != null) {
                mainCallback = new AckListener(){

                    @Override
                    public void onSuccess(Ack ack) {
                        try {
                            JSONObject data = (JSONObject)ack.getData();
                            callback.onSuccess(new LaunchExternalProcessResult(data.getString("uuid")));
                        }
                        catch (Exception e) {
                            logger.error("Error processing result from launching external process", (Throwable)e);
                        }
                    }

                    @Override
                    public void onError(Ack ack) {
                        DesktopUtils.errorAck(listener, ack);
                    }
                };
            }
            this.connection.sendAction("launch-external-process", launchConfig, mainCallback, this);
        }
        catch (Exception e) {
            logger.error("Error launching external process", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void terminateExternalProcess(final String processUuid, int timeout, boolean killTree, final AsyncCallback<TerminateExternalProcessResult> callback, final AckListener listener) throws DesktopException {
        try {
            JSONObject terminateExternalProcessPayload = new JSONObject();
            terminateExternalProcessPayload.put("uuid", (Object)processUuid);
            terminateExternalProcessPayload.put("timeout", timeout);
            terminateExternalProcessPayload.put("child", killTree);
            AckListener mainCallback = null;
            if (callback != null) {
                mainCallback = new AckListener(){

                    @Override
                    public void onSuccess(Ack ack) {
                        try {
                            JSONObject data = (JSONObject)ack.getData();
                            callback.onSuccess(new TerminateExternalProcessResult(processUuid, data.getString("result")));
                        }
                        catch (Exception e) {
                            logger.error("Error processing result from terminating external process", (Throwable)e);
                        }
                    }

                    @Override
                    public void onError(Ack ack) {
                        DesktopUtils.errorAck(listener, ack);
                    }
                };
            }
            this.connection.sendAction("terminate-external-process", terminateExternalProcessPayload, mainCallback, this);
        }
        catch (Exception e) {
            logger.error("Error termiating external process", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void releaseExternalProcess(String processUuid, AckListener callback) throws DesktopException {
        try {
            JSONObject releaseExternalProcessPayload = new JSONObject();
            releaseExternalProcessPayload.put("uuid", (Object)processUuid);
            this.connection.sendAction("release-external-process", releaseExternalProcessPayload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error releasing external process", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void setClipboard(String text, AckListener callback) throws DesktopException {
        try {
            JSONObject clipboardPayload = new JSONObject();
            clipboardPayload.put("data", (Object)text);
            this.connection.sendAction("set-clipboard", clipboardPayload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error setting clipboard", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void setCookie(String url, String name, String value, long ttl, boolean secure, boolean httpOnly, AckListener callback) throws DesktopException {
        this.setCookie(url, name, value, null, null, ttl, secure, httpOnly, callback);
    }

    public void setCookie(String url, String name, String value, String domain, String path, long ttl, boolean secure, boolean httpOnly, AckListener callback) throws DesktopException {
        try {
            JSONObject setCookiePayload = new JSONObject();
            setCookiePayload.put("url", (Object)url);
            setCookiePayload.put("name", (Object)name);
            setCookiePayload.put("value", (Object)value);
            setCookiePayload.put("ttl", ttl);
            setCookiePayload.put("secure", secure);
            setCookiePayload.put("httpOnly", httpOnly);
            setCookiePayload.put("path", (Object)path);
            setCookiePayload.put("domain", (Object)domain);
            this.connection.sendAction("set-cookie", setCookiePayload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error publishing cookie", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void getRvmInfo(AckListener callback) throws DesktopException {
        try {
            this.connection.sendAction("get-rvm-info", null, callback, this);
        }
        catch (Exception e) {
            logger.error("Error setting env variable", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void getRuntimeInfo(AckListener callback) throws DesktopException {
        try {
            this.connection.sendAction("get-runtime-info", null, callback, this);
        }
        catch (Exception e) {
            logger.error("Error setting env variable", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void getEnvironmentVariable(String name, AckListener callback) throws DesktopException {
        this.getEnvironmentVariables(new String[]{name}, callback);
    }

    public void getEnvironmentVariables(String[] names, AckListener callback) throws DesktopException {
        try {
            JSONArray array = new JSONArray();
            for (int i = 0; i < names.length; ++i) {
                array.put((Object)names[i]);
            }
            JSONObject payload = new JSONObject();
            payload.put("environmentVariables", (Object)array);
            this.connection.sendAction("get-environment-variable", payload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error setting env variable", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void getHostSpecs(AckListener listener) throws DesktopException {
        try {
            this.connection.sendAction("get-host-specs", null, listener, this);
        }
        catch (Exception e) {
            logger.error("Error setting env variable", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void launchManifest(String manifestUrl, JSONObject rvmLaunchOptions, AckListener listener) throws DesktopException {
        try {
            JSONObject payload = new JSONObject();
            payload.put("manifestUrl", (Object)manifestUrl);
            if (rvmLaunchOptions != null) {
                payload.put("opts", (Object)rvmLaunchOptions);
            }
            this.connection.sendAction("launch-manifest", payload, listener, this);
        }
        catch (Exception e) {
            logger.error("Error setting env variable", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public static String getAdapterVersion() {
        return adapterVersion;
    }

    public static String getAdapterBuildTime() {
        if (adapterBuildTime > 0L) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            return fmt.format(new Date(adapterBuildTime));
        }
        return null;
    }

    public static JSONObject getInstallInfo() {
        return InstallChecker.getInstallInfo();
    }

    static {
        logger = LoggerFactory.getLogger((String)OpenFinRuntime.class.getName());
        try {
            Package aPackage = OpenFinRuntime.class.getPackage();
            adapterVersion = aPackage.getImplementationVersion();
        }
        catch (Exception ex) {
            adapterVersion = null;
            logger.error("Error reading version", (Throwable)ex);
        }
        try {
            String rn = OpenFinRuntime.class.getName().replace('.', '/') + ".class";
            URL url = ClassLoader.getSystemResource(rn);
            if (url != null) {
                URLConnection conn = url.openConnection();
                if (conn != null) {
                    if (conn instanceof JarURLConnection) {
                        JarURLConnection j = (JarURLConnection)conn;
                        adapterBuildTime = j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
                    } else {
                        logger.info("OpenFin Java Adapter system resource connection " + conn.getClass().getName());
                    }
                } else {
                    logger.info("OpenFin Java Adapter null system resource connection " + rn);
                }
            } else {
                logger.info("OpenFin Java Adapter null system resource " + rn);
            }
        }
        catch (Exception ex) {
            adapterBuildTime = 0L;
            logger.error("Error reading buildTime");
        }
        logger.info("OpenFin Java Adapter version " + adapterVersion);
        logger.info("OpenFin Java Adapter built time " + adapterBuildTime);
    }
}

