/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.AcceleratorOptions;
import com.openfin.desktop.JsonBean;
import com.openfin.desktop.LayoutOptions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowOptions
extends JsonBean {
    private static final Logger logger = LoggerFactory.getLogger((String)WindowOptions.class.getName());
    private int resizeRegionBottomRightCorner = 4;
    private int resizeRegionSize = 2;
    private AcceleratorOptions acceleratorOptions;
    private LayoutOptions layoutOptions;

    public WindowOptions() {
    }

    public WindowOptions(String name, String url) {
        this();
        this.setName(name);
        this.setUrl(url);
    }

    public WindowOptions(JSONObject options) {
        super(options);
        this.getAccelerator();
        this.getLayoutOptions();
    }

    public void setShowTaskbarIcon(boolean showTaskbarIcon) {
        try {
            this.json.put("showTaskbarIcon", showTaskbarIcon);
        }
        catch (JSONException e) {
            logger.error("Error setting showTaskbarIcon", (Throwable)e);
        }
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        try {
            this.json.put("name", (Object)name);
        }
        catch (JSONException e) {
            logger.error("Error setting name", (Throwable)e);
        }
    }

    public String getUrl() {
        return this.getString("url");
    }

    public void setUrl(String url) {
        try {
            this.json.put("url", (Object)url);
        }
        catch (JSONException e) {
            logger.error("Error setting URL", (Throwable)e);
        }
    }

    public boolean getShowTaskbarIcon() {
        return this.getBooleanValue("showTaskbarIcon");
    }

    public void setDefaultWidth(int defaultWidth) {
        try {
            this.json.put("defaultWidth", defaultWidth);
        }
        catch (JSONException e) {
            logger.error("Error setting default width", (Throwable)e);
        }
    }

    public int getDefaultWidth() {
        return this.getIntegerValue("defaultWidth");
    }

    public void setDefaultHeight(int defaultHeight) {
        try {
            this.json.put("defaultHeight", defaultHeight);
        }
        catch (JSONException e) {
            logger.error("Error setting default height", (Throwable)e);
        }
    }

    public int getDefaultHeight() {
        return this.getIntegerValue("defaultHeight");
    }

    public void setDefaultTop(int defaultTop) {
        try {
            this.json.put("defaultTop", defaultTop);
        }
        catch (JSONException e) {
            logger.error("Error setting top", (Throwable)e);
        }
    }

    public int getDefaultTop() {
        return this.getIntegerValue("defaultTop");
    }

    public void setDefaultLeft(int defaultLeft) {
        try {
            this.json.put("defaultLeft", defaultLeft);
        }
        catch (JSONException e) {
            logger.error("Error setting left", (Throwable)e);
        }
    }

    public int getDefaultLeft() {
        return this.getIntegerValue("defaultLeft");
    }

    public void setFrame(boolean frame) {
        try {
            this.json.put("frame", frame);
        }
        catch (JSONException e) {
            logger.error("Error setting frame", (Throwable)e);
        }
    }

    public boolean getFrame() {
        return this.getBooleanValue("frame");
    }

    public void setResizable(boolean resizable) {
        try {
            this.json.put("resizable", resizable);
        }
        catch (JSONException e) {
            logger.error("Error setting resizable", (Throwable)e);
        }
    }

    public boolean getResizable() {
        return this.getBooleanValue("resizable");
    }

    public void setAutoShow(boolean autoShow) {
        try {
            this.json.put("autoShow", autoShow);
        }
        catch (JSONException e) {
            logger.error("Error setting autoShow", (Throwable)e);
        }
    }

    public boolean getAutoShow() {
        return this.getBooleanValue("autoShow");
    }

    public void setState(String state) {
        try {
            this.json.put("state", (Object)state);
        }
        catch (JSONException e) {
            logger.error("Error setting state", (Throwable)e);
        }
    }

    public String getState() {
        return this.getString("state");
    }

    public void setOpacity(double opacity) {
        try {
            this.json.put("opacity", opacity);
        }
        catch (JSONException e) {
            logger.error("Error setting opacity", (Throwable)e);
        }
    }

    public double getOpacity() {
        return this.getDoubleValue("opacity");
    }

    public void setCornerRounding(int width, int height) {
        try {
            this.json.put("cornerRounding", (Object)new JSONObject().put("width", width).put("height", height));
        }
        catch (JSONException e) {
            logger.error("Error setting cornerRounding", (Throwable)e);
        }
    }

    public int getCornerRoundingHeight() {
        int height = 0;
        JSONObject jsonObject = this.getJsonValue("cornerRounding");
        if (jsonObject != null && jsonObject.has("height")) {
            height = jsonObject.getInt("height");
        }
        return height;
    }

    public int getCornerRoundingWidth() {
        int width = 0;
        JSONObject jsonObject = this.getJsonValue("cornerRounding");
        if (jsonObject != null && jsonObject.has("width")) {
            width = jsonObject.getInt("width");
        }
        return width;
    }

    public void setMinWidth(int minWidth) {
        try {
            this.json.put("minWidth", minWidth);
        }
        catch (JSONException e) {
            logger.error("Error setting minWidth", (Throwable)e);
        }
    }

    public int getMinWidth() {
        return this.getIntegerValue("minWidth");
    }

    public void setMaxWidth(int maxWidth) {
        try {
            this.json.put("maxWidth", maxWidth);
        }
        catch (JSONException e) {
            logger.error("Error setting maxWidth", (Throwable)e);
        }
    }

    public int getMaxWidth() {
        return this.getIntegerValue("maxWidth");
    }

    public void setMinHeight(int minHeight) {
        try {
            this.json.put("minHeight", minHeight);
        }
        catch (JSONException e) {
            logger.error("Error setting minHeight", (Throwable)e);
        }
    }

    public int getMinHeight() {
        return this.getIntegerValue("minHeight");
    }

    public void setMaxHeight(int maxHeight) {
        try {
            this.json.put("maxHeight", maxHeight);
        }
        catch (JSONException e) {
            logger.error("Error setting maxHeight", (Throwable)e);
        }
    }

    public int getMaxHeight() {
        return this.getIntegerValue("maxHeight");
    }

    public void setSaveWindowState(boolean saveWindowState) {
        try {
            this.json.put("saveWindowState", saveWindowState);
        }
        catch (JSONException e) {
            logger.error("Error setting sateWindowState", (Throwable)e);
        }
    }

    public boolean getSaveWindowState() {
        return this.getBooleanValue("saveWindowState", true);
    }

    public void setMinimizable(boolean maximizable) {
        try {
            this.json.put("minimizable", maximizable);
        }
        catch (JSONException e) {
            logger.error("Error setting minimizable", (Throwable)e);
        }
    }

    public boolean getMinimizable() {
        return this.getBooleanValue("minimizable");
    }

    public void setMaximizable(boolean maximizable) {
        try {
            this.json.put("maximizable", maximizable);
        }
        catch (JSONException e) {
            logger.error("Error setting maximizable", (Throwable)e);
        }
    }

    public boolean getMaximizable() {
        return this.getBooleanValue("maximizable");
    }

    public void setHideOnClose(boolean hideOnClose) {
        try {
            this.json.put("hideOnClose", hideOnClose);
        }
        catch (JSONException e) {
            logger.error("Error setting hideOnClose", (Throwable)e);
        }
    }

    public boolean getHideOnClose() {
        return this.getBooleanValue("hideOnClose");
    }

    public void setContextMenu(boolean contextMenu) {
        try {
            this.json.put("contextMenu", contextMenu);
        }
        catch (JSONException e) {
            logger.error("Error setting contextMenu", (Throwable)e);
        }
    }

    public boolean getContextMenu() {
        return this.getBooleanValue("contextMenu");
    }

    public void setTaskbarIcon(String taskbarIcon) {
        try {
            this.json.put("taskbarIcon", (Object)taskbarIcon);
        }
        catch (JSONException e) {
            logger.error("Error setting taskbarIcon", (Throwable)e);
        }
    }

    public String getTaskbarIcon() {
        return this.getString("taskbarIcon");
    }

    public void setResizeRegionBottomRightCorner(int resizeRegionBottomRightCorner) {
        try {
            this.resizeRegionBottomRightCorner = resizeRegionBottomRightCorner;
            this.json.put("resizeRegion", (Object)new JSONObject().put("bottomRightCorner", this.resizeRegionBottomRightCorner).put("size", this.resizeRegionSize));
        }
        catch (JSONException e) {
            logger.error("Error setting resizeRegionBottomRightCorner", (Throwable)e);
        }
    }

    public int getResizeRegionBottomRightCorner() {
        int value = -1;
        JSONObject jsonObject = this.getJsonValue("resizeRegion");
        if (jsonObject != null && jsonObject.has("bottomRightCorner")) {
            value = this.getIntegerValue("bottomRightCorner");
        }
        return value;
    }

    public void setResizeRegionSize(int resizeRegionSize) {
        try {
            this.resizeRegionSize = resizeRegionSize;
            this.json.put("resizeRegion", (Object)new JSONObject().put("bottomRightCorner", this.resizeRegionBottomRightCorner).put("size", this.resizeRegionSize));
        }
        catch (JSONException e) {
            logger.error("Error setting resizeRegionSize", (Throwable)e);
        }
    }

    public int getResizeRegionSize() {
        int value = -1;
        JSONObject jsonObject = this.getJsonValue("resizeRegion");
        if (jsonObject != null && jsonObject.has("size")) {
            value = this.getIntegerValue("size");
        }
        return value;
    }

    public void setDefaultCentered(boolean defaultCentered) {
        try {
            this.json.put("defaultCentered", defaultCentered);
        }
        catch (JSONException e) {
            logger.error("Error setting defaultCentered", (Throwable)e);
        }
    }

    public boolean getDefaultCentered() {
        return this.getBooleanValue("defaultCentered");
    }

    public String getPreload() {
        return this.getString("preload");
    }

    public void setPreload(String url) {
        try {
            this.json.put("preload", (Object)url);
        }
        catch (JSONException e) {
            logger.error("Error setting preload URL", (Throwable)e);
        }
    }

    public boolean isDisableIabSecureLogging() {
        return this.getBooleanValue("disableIabSecureLogging");
    }

    public void setDisableIabSecureLogging(boolean disable) {
        try {
            this.json.put("disableIabSecureLogging", disable);
        }
        catch (JSONException e) {
            logger.error("Error setting disableIabSecureLogging", (Throwable)e);
        }
    }

    public void setAccelerator(AcceleratorOptions acceleratorOptions) {
        this.acceleratorOptions = acceleratorOptions;
    }

    public AcceleratorOptions getAccelerator() {
        if (this.acceleratorOptions == null && this.json.has("accelerator")) {
            this.acceleratorOptions = new AcceleratorOptions(this.json.getJSONObject("accelerator"));
        }
        return this.acceleratorOptions;
    }

    public LayoutOptions getLayoutOptions() {
        if (this.layoutOptions == null && this.json.has("layout")) {
            this.layoutOptions = new LayoutOptions(this.json.getJSONObject("layout"));
        }
        return this.layoutOptions;
    }

    public void setLayoutOptions(LayoutOptions layoutOptions) {
        this.layoutOptions = layoutOptions;
    }

    @Override
    public JSONObject getJson() {
        this.setJsonBean("accelerator", this.acceleratorOptions);
        this.setJsonBean("layout", this.layoutOptions);
        return super.getJson();
    }
}

