/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.ClassicProtocolHandler;
import com.openfin.desktop.channel.EndpointIdentity;
import com.openfin.desktop.channel.ProtocolOptions;
import com.openfin.desktop.channel.webrtc.WebRtcProtocolHandler;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractProtocolHandler {
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    protected Channel channel;
    protected boolean isProvider = false;
    protected EndpointIdentity endpointIdentity;
    protected EndpointIdentity clientEndpointIdentity;

    public AbstractProtocolHandler(Channel channel) {
        this.channel = channel;
    }

    public static AbstractProtocolHandler createProtocolHandler(ProtocolOptions options, Channel channel) {
        if (options == Channel.RTC_PROTOCOL) {
            return new WebRtcProtocolHandler(channel);
        }
        return new ClassicProtocolHandler(channel);
    }

    public ProtocolOptions getProtocolOptions() {
        return null;
    }

    public JSONObject getChannelConnectPayload(Object connectPayload) throws Exception {
        this.initializeClient();
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)this.channel.getName());
        if (Objects.nonNull(connectPayload)) {
            payload.put("payload", connectPayload);
        }
        JSONObject offer = new JSONObject();
        JSONArray protocols = new JSONArray();
        protocols.put((Object)this.getSupportedOfferProtocol());
        offer.put("supportedProtocols", (Object)protocols);
        offer.put("maxProtocols", 2);
        payload.put("offer", (Object)offer);
        return payload;
    }

    protected JSONObject getSupportedOfferProtocol() {
        return new JSONObject();
    }

    public void setClientEndpointIdentity(EndpointIdentity endpointIdentity) {
        this.clientEndpointIdentity = endpointIdentity;
    }

    public CompletionStage<Boolean> processConnectAnswer(JSONObject res) {
        CompletableFuture<Boolean> connectionFuture = new CompletableFuture<Boolean>();
        try {
            JSONObject answer = res.optJSONObject("answer");
            JSONObject payload = null;
            if (Objects.nonNull(answer)) {
                JSONArray protocols = answer.getJSONArray("supportedProtocols");
                JSONObject protocol = (JSONObject)protocols.get(0);
                payload = protocol.optJSONObject("payload");
            }
            JSONObject answerObj = Objects.nonNull(payload) ? payload.optJSONObject("answer") : null;
            this.acceptAnswer(answerObj, connectionFuture);
        }
        catch (Exception ex) {
            this.logger.error("Error accepting answer", (Throwable)ex);
            connectionFuture.complete(false);
        }
        return connectionFuture;
    }

    protected void acceptAnswer(JSONObject answer, CompletableFuture<Boolean> future) throws Exception {
        future.complete(true);
    }

    public JSONObject getChannelCreatePayload() {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)this.channel.getName());
        return payload;
    }

    protected JSONObject getSupportedAnswerProtocol() {
        return new JSONObject();
    }

    public JSONObject processConnectOffer(JSONObject offer) {
        JSONObject answer = null;
        try {
            JSONObject protocol = AbstractProtocolHandler.getOfferProtocolByType(offer, this.getProtocolOptions());
            JSONObject payload = Objects.nonNull(protocol) ? protocol.optJSONObject("payload") : null;
            this.acceptOffer(payload);
            JSONArray answerProtocols = new JSONArray();
            answerProtocols.put((Object)this.getSupportedAnswerProtocol());
            answer = new JSONObject();
            answer.put("supportedProtocols", (Object)answerProtocols);
        }
        catch (Exception ex) {
            this.logger.error("Error accepting answer", (Throwable)ex);
        }
        return answer;
    }

    protected void acceptOffer(JSONObject offer) throws Exception {
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void initializeClient() throws Exception {
    }

    public void initializeProvider(EndpointIdentity endpointIdentity, EndpointIdentity clientEndpointIdentity) throws Exception {
        this.isProvider = true;
        this.endpointIdentity = endpointIdentity;
        this.clientEndpointIdentity = clientEndpointIdentity;
    }

    public void sendChannelMessage(String action, JSONObject destionationIdentity, JSONObject providerIdentity, JSONObject actionPayload, AckListener ackListener) {
        this.logger.error("sendChannelMessage not implemented");
    }

    public CompletableFuture<Ack> sendChannelMessageAsync(String action, JSONObject destionationIdentity, JSONObject providerIdentity, Object actionPayload) {
        this.logger.error("sendChannelMessageAsync not implemented");
        return null;
    }

    protected void cleanup() {
        this.logger.debug("cleanup {} {}", (Object)this.channel.getName(), (Object)this.clientEndpointIdentity.getEndpointId());
    }

    public static JSONObject getOfferProtocolByType(JSONObject offer, ProtocolOptions options) {
        JSONArray supportedProtocols;
        JSONObject protocol = null;
        if (Objects.nonNull(offer) && Objects.nonNull(supportedProtocols = offer.optJSONArray("supportedProtocols"))) {
            for (int i = 0; i < supportedProtocols.length(); ++i) {
                JSONObject prot = (JSONObject)supportedProtocols.get(i);
                String type = prot.optString("type");
                if (!Objects.equals(type, options.getName())) continue;
                protocol = prot;
                break;
            }
        }
        return protocol;
    }
}

