/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.ActionEvent;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.channel.AbstractProtocolHandler;
import com.openfin.desktop.channel.ChannelBase;
import com.openfin.desktop.channel.ChannelClient;
import com.openfin.desktop.channel.ChannelListener;
import com.openfin.desktop.channel.ChannelProvider;
import com.openfin.desktop.channel.ConnectionEvent;
import com.openfin.desktop.channel.EndpointIdentity;
import com.openfin.desktop.channel.ProtocolOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    private static final Logger logger = LoggerFactory.getLogger((String)Channel.class.getName());
    private final DesktopConnection desktopConnection;
    private final String name;
    private ChannelProvider provider;
    private ConcurrentHashMap<String, ChannelClient> clientMap;
    private CopyOnWriteArrayList<ChannelListener> channelListeners;
    private CopyOnWriteArrayList<ConnectWait> pendingConnections;
    private static final String CONNECTED_EVENT = "connected";
    private static final String DISCONNECTED_EVENT = "disconnected";
    private static final String PROVIDER_NOT_READY_REASON = "internal-nack";
    public static final ProtocolOptions CLASSIC_PROTOCOL = new ProtocolOptions("classic", 1);
    public static final ProtocolOptions RTC_PROTOCOL = new ProtocolOptions("rtc", 1);

    public Channel(String name, DesktopConnection desktopConnection) {
        this.name = name;
        this.desktopConnection = desktopConnection;
        this.clientMap = new ConcurrentHashMap();
        this.channelListeners = new CopyOnWriteArrayList();
        this.pendingConnections = new CopyOnWriteArrayList();
        try {
            this.addEventListener(CONNECTED_EVENT, (ActionEvent e) -> {
                String eventChannelName = e.getEventObject().getString("channelName");
                if (eventChannelName.equals(this.name)) {
                    logger.debug("channel[{}] connected", (Object)this.name);
                    JSONObject providerIdentity = e.getEventObject();
                    EndpointIdentity ei = new EndpointIdentity(providerIdentity);
                    this.fireChannelConnectEvent(new ConnectionEvent(ei.getChannelId(), ei.getUuid(), ei.getName(), ei.getChannelName(), ei.getEndpointId()));
                    ArrayList<ConnectWait> connectionFutures = new ArrayList<ConnectWait>(this.pendingConnections);
                    this.pendingConnections.clear();
                    connectionFutures.forEach(connectWait -> this.connectAsyncInternal(null, connectWait.connectPayload, connectWait.handler).thenAccept(client -> connectWait.future.complete((ChannelClient)client)));
                }
            }, null);
            this.addEventListener(DISCONNECTED_EVENT, (ActionEvent e) -> {
                String eventChannelName = e.getEventObject().getString("channelName");
                if (eventChannelName.equals(this.name)) {
                    logger.debug("channel[{}] disconnected", (Object)this.name);
                    JSONObject providerIdentity = e.getEventObject();
                    EndpointIdentity ei = new EndpointIdentity(providerIdentity);
                    this.fireChannelDisconnectEvent(new ConnectionEvent(ei.getChannelId(), ei.getUuid(), ei.getName(), ei.getChannelName(), ei.getEndpointId()));
                }
            }, null);
        }
        catch (DesktopException e2) {
            logger.error("unable to subscribe to channel events", (Throwable)e2);
        }
    }

    public String getName() {
        return this.name;
    }

    public DesktopConnection getDesktopConnection() {
        return this.desktopConnection;
    }

    public CompletionStage<ChannelProvider> createAsync() {
        return this.createAsync(Arrays.asList(CLASSIC_PROTOCOL));
    }

    public CompletionStage<ChannelProvider> createAsync(List<ProtocolOptions> protocolList) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)this.getName());
        return this.desktopConnection.sendActionAsync("create-channel", payload, this).thenApply(ack -> {
            if (ack.isSuccessful()) {
                JSONObject providerIdentity = (JSONObject)ack.getData();
                EndpointIdentity providerEndpointIdentity = new EndpointIdentity(providerIdentity);
                this.provider = new ChannelProvider(this, protocolList, providerEndpointIdentity);
                return this.provider;
            }
            throw new RuntimeException("error creating channel provider, reason: " + ack.getReason());
        });
    }

    public void create(AsyncCallback<ChannelProvider> callback) {
        this.create(callback, CLASSIC_PROTOCOL);
    }

    public void create(AsyncCallback<ChannelProvider> callback, ProtocolOptions protocolType) {
        ArrayList<ProtocolOptions> list = new ArrayList<ProtocolOptions>();
        list.add(protocolType);
        this.createAsync(list).thenAccept(provider -> callback.onSuccess((ChannelProvider)provider));
    }

    void destroy(ChannelBase provider, final AckListener ackListener) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)provider.getChannelName());
        this.desktopConnection.sendAction("destroy-channel", payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                Channel.this.provider = null;
                if (ackListener != null) {
                    ackListener.onSuccess(ack);
                }
            }

            @Override
            public void onError(Ack ack) {
                if (ackListener != null) {
                    ackListener.onError(ack);
                }
            }
        }, this);
    }

    public CompletionStage<ChannelClient> connectAsync() {
        return this.connectAsync(null);
    }

    public CompletionStage<ChannelClient> connectAsync(Object connectPayload) {
        return this.connectAsync(connectPayload, CLASSIC_PROTOCOL);
    }

    public CompletionStage<ChannelClient> connectAsync(Object connectPayload, ProtocolOptions protocolType) {
        return this.connectAsync(null, connectPayload, protocolType);
    }

    public CompletionStage<ChannelClient> connectAsync(Boolean noWait, Object connectPayload, ProtocolOptions protocolType) {
        AbstractProtocolHandler protocolHandler = AbstractProtocolHandler.createProtocolHandler(protocolType, this);
        return this.connectAsyncInternal(noWait, connectPayload, protocolHandler);
    }

    private CompletionStage<ChannelClient> connectAsyncInternal(Boolean noWait, Object connectPayload, AbstractProtocolHandler protocolHandler) {
        CompletableFuture<ChannelClient> connectionFuture = new CompletableFuture<ChannelClient>();
        try {
            this.desktopConnection.sendActionAsync("connect-to-channel", protocolHandler.getChannelConnectPayload(connectPayload), this).thenAccept(ack -> {
                if (ack.isSuccessful()) {
                    JSONObject res = (JSONObject)ack.getData();
                    protocolHandler.processConnectAnswer(res).thenAccept(connected -> {
                        if (connected.booleanValue()) {
                            EndpointIdentity endpointIdentity = new EndpointIdentity(res);
                            ChannelClient client = new ChannelClient(protocolHandler, endpointIdentity);
                            this.clientMap.put(endpointIdentity.getEndpointId(), client);
                            protocolHandler.setClientEndpointIdentity(endpointIdentity);
                            connectionFuture.complete(client);
                        } else {
                            connectionFuture.completeExceptionally(new RuntimeException("error connecting to channel " + this.name + ", reason: failed to accept answer from provider"));
                        }
                    });
                } else if (!PROVIDER_NOT_READY_REASON.equals(ack.getReason())) {
                    connectionFuture.completeExceptionally(new RuntimeException("error connecting to channel " + this.name + ", reason: " + ack.getReason()));
                } else if (noWait != null && noWait.booleanValue()) {
                    connectionFuture.completeExceptionally(new RuntimeException("error connecting to channel " + this.name + ", reason: " + ack.getReason()));
                } else {
                    ConnectWait wait = new ConnectWait();
                    wait.future = connectionFuture;
                    wait.handler = protocolHandler;
                    wait.connectPayload = connectPayload;
                    this.pendingConnections.add(wait);
                }
            });
        }
        catch (Exception ex) {
            logger.error("Error connecting to channel", (Throwable)ex);
        }
        return connectionFuture;
    }

    public void connect(AsyncCallback<ChannelClient> callback) {
        this.connect(CLASSIC_PROTOCOL, callback);
    }

    public void connect(ProtocolOptions protocolType, AsyncCallback<ChannelClient> callback) {
        this.connectAsync(null, protocolType).thenAccept(client -> callback.onSuccess((ChannelClient)client));
    }

    CompletableFuture<Ack> disconnect(ChannelBase client) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)client.getChannelName());
        payload.put("uuid", (Object)client.getUuid());
        payload.put("name", (Object)client.getName());
        payload.put("endpointId", (Object)client.getEndpointId());
        return this.desktopConnection.sendActionAsync("disconnect-from-channel", payload, this);
    }

    public boolean hasProvider() {
        return this.provider != null;
    }

    public boolean hasClient() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.clientMap.keySet())).size() > 0;
    }

    public Object invokeAction(EndpointIdentity targetIdentity, String action, Object actionPayload, JSONObject senderIdentity) {
        Object result = null;
        if (targetIdentity.getEndpointId() != null && this.clientMap.contains(targetIdentity.getEndpointId())) {
            ChannelClient channelClient = this.clientMap.get(targetIdentity.getEndpointId());
            if (channelClient != null && channelClient.hasRegisteredAction(action)) {
                result = channelClient.invokeAction(action, actionPayload, senderIdentity);
            }
        } else if (this.provider != null && this.provider.hasRegisteredAction(action)) {
            result = this.provider.invokeAction(action, actionPayload, senderIdentity);
        } else {
            Collection<ChannelClient> clients = this.clientMap.values();
            JSONArray results = new JSONArray();
            for (ChannelClient client : clients) {
                Object cr;
                if (!client.hasRegisteredAction(action) || (cr = client.invokeAction(action, actionPayload, senderIdentity)) == null) continue;
                results.put(cr);
            }
            result = results.length() == 1 ? results.get(0) : results;
        }
        return result;
    }

    public boolean addChannelListener(ChannelListener listener) {
        return this.channelListeners.add(listener);
    }

    public boolean removeChannelListener(ChannelListener listener) {
        return this.channelListeners.remove(listener);
    }

    protected void fireChannelConnectEvent(ConnectionEvent event) {
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelConnect(event);
        }
        this.clientMap.values().forEach(channelClient -> channelClient.fireChannelConnectEvent(event));
    }

    protected void fireChannelDisconnectEvent(ConnectionEvent event) {
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelDisconnect(event);
        }
        this.clientMap.values().forEach(channelClient -> channelClient.fireChannelDisconnectEvent(event));
    }

    public void processConnection(JSONObject payload, JSONObject ackToSenderPayload) throws Exception {
        this.provider.processConnection(payload, ackToSenderPayload);
    }

    protected void addEventListener(JSONObject subscriptionObject, EventListener listener, AckListener callback) throws DesktopException {
        this.desktopConnection.addEventCallback(subscriptionObject, listener, callback, this);
    }

    public void addEventListener(String type, EventListener listener, AckListener callback) throws DesktopException {
        try {
            JSONObject eventListenerPayload = new JSONObject();
            eventListenerPayload.put("topic", (Object)"channel");
            eventListenerPayload.put("type", (Object)type);
            this.addEventListener(eventListenerPayload, listener, callback);
        }
        catch (Exception e) {
            logger.error("Error adding event listener", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void removeEventListener(String type, EventListener listener, AckListener callback) throws DesktopException {
        try {
            JSONObject eventListenerPayload = new JSONObject();
            eventListenerPayload.put("topic", (Object)"channel");
            eventListenerPayload.put("type", (Object)type);
            this.desktopConnection.removeEventCallback(eventListenerPayload, listener, callback, this);
        }
        catch (Exception e) {
            logger.error("Error removing event listener", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public CompletableFuture<Ack> raiseEvent(String type, JSONObject eventObject) throws DesktopException {
        JSONObject payload = new JSONObject();
        payload.put("eventName", (Object)String.format("channel/%s", type));
        payload.put("eventArgs", (Object)eventObject);
        return this.desktopConnection.sendActionAsync("raise-event", payload, this);
    }

    private static class ConnectWait {
        public CompletableFuture<ChannelClient> future;
        public AbstractProtocolHandler handler;
        public Object connectPayload;

        private ConnectWait() {
        }
    }
}

