/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.channel.AbstractProtocolHandler;
import com.openfin.desktop.channel.ChannelAction;
import com.openfin.desktop.channel.EndpointIdentity;
import com.openfin.desktop.channel.Middleware;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelBase {
    protected Middleware defaultAction;
    protected Middleware onError;
    protected Middleware beforeAction;
    protected Middleware afterAction;
    protected ConcurrentHashMap<String, ChannelAction> channelActionMap;
    protected EndpointIdentity endpointIdentity;
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public ChannelBase(EndpointIdentity endpointIdentity) {
        this.endpointIdentity = endpointIdentity;
        this.channelActionMap = new ConcurrentHashMap();
    }

    protected boolean register(String action, ChannelAction listener) {
        return this.channelActionMap.putIfAbsent(action, listener) == null;
    }

    public boolean remove(String action) {
        return this.channelActionMap.remove(action) != null;
    }

    public void setDefaultAction(Middleware middleware) {
        this.defaultAction = middleware;
    }

    public void setOnError(Middleware middleware) {
        this.onError = middleware;
    }

    public void setBeforeAction(Middleware middleware) {
        this.beforeAction = middleware;
    }

    public void setAfterAction(Middleware middleware) {
        this.afterAction = middleware;
    }

    public EndpointIdentity getEndpointIdentity() {
        return this.endpointIdentity;
    }

    public String getChannelName() {
        return this.endpointIdentity.getChannelName();
    }

    public String getUuid() {
        return this.endpointIdentity.getUuid();
    }

    public String getChannelId() {
        return this.endpointIdentity.getChannelId();
    }

    public String getName() {
        return this.endpointIdentity.getName();
    }

    public String getEndpointId() {
        return this.endpointIdentity.getEndpointId();
    }

    public boolean hasRegisteredAction(String action) {
        return this.channelActionMap.containsKey(action);
    }

    protected void dispatch(AbstractProtocolHandler protocolHandler, JSONObject destinationIdentity, String action, JSONObject actionPayload, AckListener ackListener) {
        protocolHandler.sendChannelMessage(action, destinationIdentity, this.endpointIdentity.toJSON(), actionPayload, ackListener);
    }

    protected CompletableFuture<Ack> dispatchAsync(AbstractProtocolHandler protocolHandler, JSONObject destinationIdentity, String action, Object actionPayload) {
        return protocolHandler.sendChannelMessageAsync(action, destinationIdentity, this.endpointIdentity.toJSON(), actionPayload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invokeAction(String action, Object payload, JSONObject senderIdentity) {
        block8: {
            ChannelAction channelAction = this.channelActionMap.get(action);
            if (channelAction == null && this.defaultAction == null) break block8;
            if (this.beforeAction != null) {
                payload = this.beforeAction.invoke(action, payload, senderIdentity);
            }
            payload = channelAction != null ? channelAction.invoke(action, payload, senderIdentity) : this.defaultAction.invoke(action, payload, senderIdentity);
            if (this.afterAction != null) {
                payload = this.afterAction.invoke(action, payload, senderIdentity);
            }
            Object object = payload;
            return object;
        }
        try {
            Object var5_7 = null;
            return var5_7;
        }
        catch (Exception ex) {
            if (this.onError != null) {
                this.onError.invoke(action, payload, senderIdentity);
            }
            ex.printStackTrace();
            Object var5_8 = null;
            return var5_8;
        }
    }

    protected void cleanup() {
        this.logger.debug("cleaning up {} {}", (Object)this.getChannelName(), (Object)this.getEndpointId());
        this.channelActionMap.clear();
    }
}

