/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel.webrtc;

import dev.onvoid.webrtc.CreateSessionDescriptionObserver;
import dev.onvoid.webrtc.RTCSessionDescription;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CreateDescObserver
implements CreateSessionDescriptionObserver,
Future<RTCSessionDescription> {
    private CountDownLatch latch = new CountDownLatch(1);
    private RTCSessionDescription description;
    private String error;

    public void onSuccess(RTCSessionDescription description) {
        this.description = description;
        this.latch.countDown();
    }

    public void onFailure(String error) {
        this.error = error;
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public RTCSessionDescription get() throws InterruptedException, ExecutionException {
        this.latch.await();
        this.checkError();
        return this.description;
    }

    @Override
    public RTCSessionDescription get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.latch.await(timeout, unit)) {
            this.checkError();
            return this.description;
        }
        throw new TimeoutException();
    }

    private void checkError() throws ExecutionException {
        if (Objects.nonNull(this.error)) {
            throw new ExecutionException(this.error, new IllegalStateException());
        }
    }
}

