/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel.webrtc;

import com.openfin.desktop.channel.webrtc.DataChannelListener;
import dev.onvoid.webrtc.RTCDataChannel;
import dev.onvoid.webrtc.RTCDataChannelBuffer;
import dev.onvoid.webrtc.RTCDataChannelInit;
import dev.onvoid.webrtc.RTCDataChannelObserver;
import dev.onvoid.webrtc.RTCDataChannelState;
import dev.onvoid.webrtc.RTCPeerConnection;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChannel
implements RTCDataChannelObserver {
    private static final Logger logger = LoggerFactory.getLogger(DataChannel.class);
    private RTCDataChannel dataChannel;
    private final CopyOnWriteArrayList<DataChannelListener> channelListeners;
    private final List<String> outboundQueue;

    public DataChannel(RTCPeerConnection peerConnection, String name) {
        logger.debug("creating data channel {}", (Object)name);
        this.dataChannel = peerConnection.createDataChannel(name, new RTCDataChannelInit());
        this.dataChannel.registerObserver((RTCDataChannelObserver)this);
        this.channelListeners = new CopyOnWriteArrayList();
        this.outboundQueue = new ArrayList<String>();
    }

    public DataChannel(RTCDataChannel dataChannel) {
        logger.debug("wrapping data channel {}", (Object)dataChannel.getLabel());
        this.dataChannel = dataChannel;
        this.dataChannel.registerObserver((RTCDataChannelObserver)this);
        this.channelListeners = new CopyOnWriteArrayList();
        this.outboundQueue = new ArrayList<String>();
    }

    public String getName() {
        return this.dataChannel.getLabel();
    }

    public DataChannelListener.State getState() {
        return this.mapState(this.dataChannel.getState());
    }

    public boolean addChannelListener(DataChannelListener listener) {
        return this.channelListeners.add(listener);
    }

    public boolean removeChannelListener(DataChannelListener listener) {
        return this.channelListeners.remove(listener);
    }

    private void fireChannelStatusEvent() {
        DataChannelListener.State state = this.mapState(this.dataChannel.getState());
        if (Objects.nonNull((Object)state)) {
            for (DataChannelListener listener : this.channelListeners) {
                listener.onStateChange(this, state);
            }
        }
    }

    private void fireChannelMessageEvent(String message) {
        for (DataChannelListener listener : this.channelListeners) {
            listener.onMessage(this, message);
        }
    }

    private DataChannelListener.State mapState(RTCDataChannelState state) {
        if (state == RTCDataChannelState.OPEN) {
            return DataChannelListener.State.OPEN;
        }
        if (state == RTCDataChannelState.CLOSED) {
            return DataChannelListener.State.CLOSED;
        }
        return null;
    }

    public void send(String s) throws Exception {
        logger.debug("datachannel {} sending {}", (Object)this.getName(), (Object)s);
        DataChannelListener.State state = this.getState();
        if (state == DataChannelListener.State.OPEN) {
            this.sendString(s);
        } else if (Objects.isNull((Object)state)) {
            this.queueMessage(s);
        } else {
            logger.error("datachannel {} not open for sending {}", (Object)this.getName(), (Object)state);
        }
    }

    private synchronized void queueMessage(String s) {
        this.outboundQueue.add(s);
        logger.debug("Queuing outbound message {} {}", (Object)this.getName(), (Object)this.outboundQueue.size());
    }

    private void sendString(String s) throws Exception {
        logger.debug("datachannel {} sending string {}", (Object)this.getName(), (Object)s);
        ByteBuffer data = ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
        RTCDataChannelBuffer buffer = new RTCDataChannelBuffer(data, false);
        this.dataChannel.send(buffer);
    }

    private synchronized void checkOutboundQueue() throws Exception {
        if (this.outboundQueue.size() > 0) {
            logger.debug("Sending queued outbound message {} {}", (Object)this.getName(), (Object)this.outboundQueue.size());
            for (String s : this.outboundQueue) {
                this.sendString(s);
            }
            this.outboundQueue.clear();
        }
    }

    public void close() {
        if (Objects.nonNull(this.dataChannel)) {
            logger.debug("Closing channel {}", (Object)this.getName());
            this.dataChannel.close();
            this.dataChannel.unregisterObserver();
            this.dataChannel.close();
            this.dataChannel.dispose();
            this.dataChannel = null;
        }
    }

    public void onBufferedAmountChange(long previousAmount) {
        logger.debug("onBufferedAmountChange {}", (Object)previousAmount);
    }

    public void onStateChange() {
        try {
            logger.debug("onStateChange {} {} {}", new Object[]{this.getName(), this.dataChannel.getId(), this.dataChannel.getState().toString()});
            if (this.getState() == DataChannelListener.State.OPEN) {
                this.checkOutboundQueue();
            }
            this.fireChannelStatusEvent();
        }
        catch (Exception ex) {
            logger.error("onStateChange", (Throwable)ex);
        }
    }

    public void onMessage(RTCDataChannelBuffer rtcDataChannelBuffer) {
        try {
            String m = this.decodeMessage(rtcDataChannelBuffer);
            this.fireChannelMessageEvent(m);
        }
        catch (Exception ex) {
            logger.error("onMessage", (Throwable)ex);
        }
    }

    private String decodeMessage(RTCDataChannelBuffer buffer) {
        byte[] payload;
        ByteBuffer byteBuffer = buffer.data;
        if (byteBuffer.hasArray()) {
            payload = byteBuffer.array();
        } else {
            payload = new byte[byteBuffer.limit()];
            byteBuffer.get(payload);
        }
        return new String(payload, StandardCharsets.UTF_8);
    }
}

