/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel.webrtc;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.ActionEvent;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.JsonBean;
import com.openfin.desktop.channel.AbstractProtocolHandler;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.EndpointIdentity;
import com.openfin.desktop.channel.ProtocolOptions;
import com.openfin.desktop.channel.webrtc.CreateDescObserver;
import com.openfin.desktop.channel.webrtc.DataChannel;
import com.openfin.desktop.channel.webrtc.DataChannelListener;
import com.openfin.desktop.channel.webrtc.SetDescObserver;
import dev.onvoid.webrtc.CreateSessionDescriptionObserver;
import dev.onvoid.webrtc.PeerConnectionFactory;
import dev.onvoid.webrtc.PeerConnectionObserver;
import dev.onvoid.webrtc.RTCAnswerOptions;
import dev.onvoid.webrtc.RTCConfiguration;
import dev.onvoid.webrtc.RTCDataChannel;
import dev.onvoid.webrtc.RTCIceCandidate;
import dev.onvoid.webrtc.RTCIceConnectionState;
import dev.onvoid.webrtc.RTCIceGatheringState;
import dev.onvoid.webrtc.RTCOfferOptions;
import dev.onvoid.webrtc.RTCPeerConnection;
import dev.onvoid.webrtc.RTCPeerConnectionIceErrorEvent;
import dev.onvoid.webrtc.RTCPeerConnectionState;
import dev.onvoid.webrtc.RTCRtpReceiver;
import dev.onvoid.webrtc.RTCRtpTransceiver;
import dev.onvoid.webrtc.RTCSdpType;
import dev.onvoid.webrtc.RTCSessionDescription;
import dev.onvoid.webrtc.RTCSignalingState;
import dev.onvoid.webrtc.SetSessionDescriptionObserver;
import dev.onvoid.webrtc.media.MediaStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONObject;

public class WebRtcProtocolHandler
extends AbstractProtocolHandler
implements PeerConnectionObserver,
EventListener,
DataChannelListener {
    private String connectionId;
    private String iceClientEventType;
    private String iceProviderEventType;
    private String sendIceEventType;
    private final PeerConnectionFactory factory;
    protected RTCPeerConnection peerConnection;
    private DataChannel requestChannel;
    private DataChannel responseChannel;
    private CompletableFuture<Boolean> clientConnectFuture;
    private final AtomicLong messageId = new AtomicLong(0L);
    private final Map<String, CompletableFuture<Ack>> responseMap;
    private static final String SDPAnswer = "answer";
    private static final String SDPOffer = "offer";
    private static final String SDPCandidate = "candidate";
    private static final String SDPTrickleReady = "trickle";
    private static final String REQUEST_CHANNEL_NAME = "request";
    private static final String RESPONSE_CHANNEL_NAME = "response";
    private static final String MESSAGE_ID_KEY = "messageId";

    public WebRtcProtocolHandler(Channel channel) {
        super(channel);
        this.factory = new PeerConnectionFactory();
        this.responseMap = new ConcurrentHashMap<String, CompletableFuture<Ack>>();
    }

    @Override
    public ProtocolOptions getProtocolOptions() {
        return Channel.RTC_PROTOCOL;
    }

    @Override
    public void initializeClient() throws Exception {
        this.connectionId = UUID.randomUUID().toString();
        this.logger.debug("Initializing client {} {}", (Object)this.channel.getName(), (Object)this.connectionId);
        this.iceProviderEventType = String.format("ice-provider-%s", this.connectionId);
        this.sendIceEventType = String.format("ice-client-%s", this.connectionId);
        this.channel.addEventListener(this.iceProviderEventType, (EventListener)this, null);
        this.createPeerConnection();
        this.createOffer();
    }

    private void createPeerConnection() {
        this.logger.debug("Creating peer connection {} {}", (Object)this.getChannel().getName(), (Object)(Objects.nonNull(this.clientEndpointIdentity) ? this.clientEndpointIdentity.getEndpointId() : ""));
        RTCConfiguration config = new RTCConfiguration();
        this.peerConnection = this.factory.createPeerConnection(config, (PeerConnectionObserver)this);
        if (!this.isProvider) {
            this.requestChannel = new DataChannel(this.peerConnection, REQUEST_CHANNEL_NAME);
            this.requestChannel.addChannelListener(this);
            this.responseChannel = new DataChannel(this.peerConnection, RESPONSE_CHANNEL_NAME);
            this.responseChannel.addChannelListener(this);
        }
    }

    private void createOffer() throws Exception {
        CreateDescObserver createObserver = new CreateDescObserver();
        SetDescObserver setObserver = new SetDescObserver();
        this.peerConnection.createOffer(new RTCOfferOptions(), (CreateSessionDescriptionObserver)createObserver);
        RTCSessionDescription offerDesc = createObserver.get();
        this.logger.debug("setting local description {} {}", (Object)this.channel.getName(), (Object)offerDesc.toString());
        this.peerConnection.setLocalDescription(offerDesc, (SetSessionDescriptionObserver)setObserver);
        setObserver.get();
    }

    private JSONObject getOfferPayload() {
        RTCSessionDescription offer = this.peerConnection.getLocalDescription();
        JSONObject payload = new JSONObject();
        payload.put("type", (Object)SDPOffer);
        payload.put("sdp", (Object)offer.sdp);
        this.logger.debug("OFFER {}", (Object)payload.toString());
        return payload;
    }

    @Override
    protected JSONObject getSupportedOfferProtocol() {
        JSONObject prot = super.getSupportedOfferProtocol();
        prot.put("type", (Object)Channel.RTC_PROTOCOL.getName());
        prot.put("version", Channel.RTC_PROTOCOL.getVersion());
        JSONObject payload = new JSONObject();
        payload.put("rtcConnectionId", (Object)this.connectionId);
        payload.put(SDPOffer, (Object)this.getOfferPayload());
        prot.put("payload", (Object)payload);
        return prot;
    }

    @Override
    protected void acceptAnswer(JSONObject answer, CompletableFuture<Boolean> future) throws Exception {
        this.logger.debug(String.format("accepting answer %s %s", this.channel.getName(), answer.toString()));
        this.clientConnectFuture = future;
        this.setRemoteDescription(new RTCSessionDescription(RTCSdpType.ANSWER, answer.getString("sdp")));
    }

    private void setRemoteDescription(RTCSessionDescription description) throws Exception {
        this.logger.debug("setting remote description {}", (Object)description.toString());
        SetDescObserver setObserver = new SetDescObserver();
        this.peerConnection.setRemoteDescription(description, (SetSessionDescriptionObserver)setObserver);
        setObserver.get();
    }

    @Override
    protected void acceptOffer(JSONObject payload) throws Exception {
        this.logger.debug("accepting offer {} {}", (Object)this.channel.getName(), (Object)payload.toString());
        JSONObject offer = payload.getJSONObject(SDPOffer);
        this.connectionId = payload.getString("rtcConnectionId");
        this.logger.debug(String.format("receiving provider connection Id %s", this.connectionId));
        this.iceClientEventType = String.format("ice-client-%s", this.connectionId);
        this.sendIceEventType = String.format("ice-provider-%s", this.connectionId);
        this.channel.addEventListener(this.iceClientEventType, (EventListener)this, null);
        this.createPeerConnection();
        this.setRemoteDescription(new RTCSessionDescription(RTCSdpType.OFFER, offer.getString("sdp")));
        this.createAnswer();
    }

    @Override
    protected JSONObject getSupportedAnswerProtocol() {
        JSONObject prot = super.getSupportedAnswerProtocol();
        prot.put("type", (Object)Channel.RTC_PROTOCOL.getName());
        prot.put("version", Channel.RTC_PROTOCOL.getVersion());
        JSONObject payload = new JSONObject();
        RTCSessionDescription desc = this.peerConnection.getLocalDescription();
        this.logger.debug("getting local description {}", (Object)desc.toString());
        JSONObject answerJson = new JSONObject();
        answerJson.put("type", (Object)SDPAnswer);
        answerJson.put("sdp", (Object)desc.sdp);
        payload.put(SDPAnswer, (Object)answerJson);
        prot.put("payload", (Object)payload);
        return prot;
    }

    protected RTCSessionDescription createAnswer() throws Exception {
        CreateDescObserver createObserver = new CreateDescObserver();
        SetDescObserver setObserver = new SetDescObserver();
        this.peerConnection.createAnswer(new RTCAnswerOptions(), (CreateSessionDescriptionObserver)createObserver);
        RTCSessionDescription answerDesc = createObserver.get();
        this.logger.debug("setting local description {} {}", (Object)this.channel.getName(), (Object)answerDesc.toString());
        this.peerConnection.setLocalDescription(answerDesc, (SetSessionDescriptionObserver)setObserver);
        setObserver.get();
        return answerDesc;
    }

    @Override
    public void sendChannelMessage(String action, JSONObject destionationIdentity, JSONObject providerIdentity, JSONObject actionPayload, AckListener ackListener) {
        String error = "sendChannelMessage not deprecated.  use sendChannelMessageAsync instead";
        this.logger.error(error);
        DesktopUtils.errorAck(ackListener, DesktopUtils.getNack((Object)this, error));
    }

    @Override
    public CompletableFuture<Ack> sendChannelMessageAsync(String action, JSONObject destionationIdentity, JSONObject providerIdentity, Object actionPayload) {
        CompletableFuture<Ack> ackFuture = new CompletableFuture<Ack>();
        try {
            String messageId = String.format("javartc-%d", this.getNextMessageId());
            JsonBean msg = new JsonBean();
            msg.setString("action", action);
            msg.setString(MESSAGE_ID_KEY, messageId);
            msg.put("payload", actionPayload);
            String data = msg.toString();
            this.logger.debug("sending message: {} {}", (Object)this.channel.getName(), (Object)data);
            this.requestChannel.send(data);
            this.responseMap.put(messageId, ackFuture);
        }
        catch (Exception ex) {
            this.logger.error("Error sending message {}", (Object)this.channel.getName(), (Object)ex);
        }
        return ackFuture;
    }

    public void onSignalingChange(RTCSignalingState state) {
        this.logger.debug("onSignalingChange {}", (Object)state);
        super.onSignalingChange(state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onConnectionChange(RTCPeerConnectionState state) {
        try {
            this.logger.debug("onConnectionChange {} {} {}", new Object[]{this.channel.getName(), state, Objects.nonNull(this.clientEndpointIdentity) ? this.clientEndpointIdentity.getEndpointId() : ""});
            super.onConnectionChange(state);
            if (state != RTCPeerConnectionState.CONNECTED) return;
        }
        catch (Exception ex) {
            this.logger.error("onConnectionChange", (Throwable)ex);
        }
    }

    public void onIceConnectionChange(RTCIceConnectionState state) {
        this.logger.debug("onIceConnectionChange {} {}", (Object)this.channel.getName(), (Object)state);
        super.onIceConnectionChange(state);
    }

    public void onStandardizedIceConnectionChange(RTCIceConnectionState state) {
        this.logger.debug("onStandardizedIceConnectionChange {}", (Object)state);
        super.onStandardizedIceConnectionChange(state);
    }

    public void onIceConnectionReceivingChange(boolean receiving) {
        this.logger.debug("onIceConnectionReceivingChange {}", (Object)receiving);
        super.onIceConnectionReceivingChange(receiving);
    }

    public void onIceGatheringChange(RTCIceGatheringState state) {
        this.logger.debug("onIceGatheringChange {}", (Object)state);
        super.onIceGatheringChange(state);
    }

    public void onIceCandidate(RTCIceCandidate rtcIceCandidate) {
        try {
            this.logger.debug("onIceCandidate {} {}", (Object)this.channel.getName(), (Object)rtcIceCandidate.toString());
            JSONObject candidateJson = new JSONObject();
            candidateJson.put(SDPCandidate, (Object)rtcIceCandidate.sdp);
            candidateJson.put("sdpMid", (Object)rtcIceCandidate.sdpMid);
            candidateJson.put("sdpMLineIndex", rtcIceCandidate.sdpMLineIndex);
            if (Objects.nonNull(rtcIceCandidate.serverUrl)) {
                candidateJson.put("serverUrl", (Object)rtcIceCandidate.serverUrl);
            }
            JSONObject payload = new JSONObject();
            payload.put(SDPCandidate, (Object)candidateJson);
            this.channel.raiseEvent(this.sendIceEventType, payload).thenAccept(ack -> {
                if (!ack.isSuccessful()) {
                    this.logger.error(String.format("Error sending client candidate %s", ack.getReason()));
                }
            });
        }
        catch (Exception ex) {
            this.logger.error("Error sending client candidate", (Throwable)ex);
        }
    }

    public void onIceCandidateError(RTCPeerConnectionIceErrorEvent event) {
        this.logger.info("onIceCandidateError {} {}", (Object)this.channel.getName(), (Object)event.toString());
        super.onIceCandidateError(event);
    }

    public void onIceCandidatesRemoved(RTCIceCandidate[] candidates) {
        this.logger.debug("onIceCandidatesRemoved");
        super.onIceCandidatesRemoved(candidates);
    }

    public void onAddStream(MediaStream stream) {
        super.onAddStream(stream);
    }

    public void onRemoveStream(MediaStream stream) {
        super.onRemoveStream(stream);
    }

    public void onDataChannel(RTCDataChannel dataChannel) {
        try {
            this.logger.debug("onDataChannel {} {}", (Object)this.channel.getName(), (Object)dataChannel.getLabel());
            super.onDataChannel(dataChannel);
            if (REQUEST_CHANNEL_NAME.equals(dataChannel.getLabel())) {
                this.requestChannel = new DataChannel(dataChannel);
                this.requestChannel.addChannelListener(this);
            } else if (RESPONSE_CHANNEL_NAME.equals(dataChannel.getLabel())) {
                this.responseChannel = new DataChannel(dataChannel);
                this.responseChannel.addChannelListener(this);
            }
        }
        catch (Exception ex) {
            this.logger.error("onDataChannel", (Throwable)ex);
        }
    }

    public void onRenegotiationNeeded() {
        this.logger.debug("onRenegotiationNeeded");
        super.onRenegotiationNeeded();
    }

    public void onAddTrack(RTCRtpReceiver receiver, MediaStream[] mediaStreams) {
        super.onAddTrack(receiver, mediaStreams);
    }

    public void onRemoveTrack(RTCRtpReceiver receiver) {
        super.onRemoveTrack(receiver);
    }

    public void onTrack(RTCRtpTransceiver transceiver) {
        super.onTrack(transceiver);
    }

    @Override
    public void eventReceived(ActionEvent actionEvent) {
        if (actionEvent.getEventObject().has(SDPCandidate)) {
            try {
                JSONObject candidateJson = actionEvent.getEventObject().getJSONObject(SDPCandidate);
                this.logger.debug(String.format("Adding remote candidate %s %s", this.channel.getName(), candidateJson.toString()));
                RTCIceCandidate candidate = new RTCIceCandidate(candidateJson.getString("sdpMid"), candidateJson.getInt("sdpMLineIndex"), candidateJson.getString(SDPCandidate), candidateJson.optString("serverUrl"));
                this.peerConnection.addIceCandidate(candidate);
            }
            catch (Exception ex) {
                this.logger.error("Error accepting remote ice candidate", (Throwable)ex);
            }
        }
    }

    @Override
    public void onStateChange(DataChannel source, DataChannelListener.State state) {
        try {
            this.logger.debug("onStateChange {} {} {} {}", new Object[]{this.channel.getName(), Objects.nonNull(this.clientEndpointIdentity) ? this.clientEndpointIdentity.getEndpointId() : "", source.getName(), state});
            if (Objects.nonNull(this.requestChannel) && Objects.nonNull(this.responseChannel) && this.requestChannel.getState() == DataChannelListener.State.OPEN && this.responseChannel.getState() == DataChannelListener.State.OPEN && Objects.nonNull(this.clientConnectFuture)) {
                this.logger.debug(String.format("webrtc handler connected %s %s", this.channel.getName(), this.connectionId));
                this.clientConnectFuture.complete(true);
                this.clientConnectFuture = null;
            }
        }
        catch (Exception ex) {
            this.logger.error("onStateChange", (Throwable)ex);
        }
    }

    @Override
    public void onMessage(DataChannel source, String message) {
        try {
            JSONObject json = new JSONObject(message);
            this.logger.debug("received message in {} {}: {}", new Object[]{this.channel.getName(), source.getName(), message});
            if (source.getName().equals(REQUEST_CHANNEL_NAME)) {
                this.processChannelRequest(json);
            } else if (source.getName().equals(RESPONSE_CHANNEL_NAME)) {
                this.processChannelResponse(json);
            } else {
                this.logger.error("received message from invalid data channel {}", (Object)source.getName());
            }
        }
        catch (Exception ex) {
            this.logger.error("Error processing {}", (Object)message);
        }
    }

    private void processChannelRequest(JSONObject request) throws Exception {
        String messageId = request.getString(MESSAGE_ID_KEY);
        JSONObject resp = new JSONObject();
        resp.put(MESSAGE_ID_KEY, (Object)messageId);
        try {
            String action = request.getString("action");
            Object actionPayload = request.opt("payload");
            EndpointIdentity targetEndpoint = this.isProvider ? this.endpointIdentity : this.clientEndpointIdentity;
            Object actionResult = this.channel.invokeAction(targetEndpoint, action, actionPayload, this.clientEndpointIdentity.toJSON());
            resp.put("payload", actionResult);
            resp.put("success", true);
        }
        catch (Exception ex) {
            this.logger.error("Error processing channel request", (Throwable)ex);
            resp.put("success", false);
            resp.put("error", (Object)ex.getMessage());
        }
        this.responseChannel.send(resp.toString());
    }

    private void processChannelResponse(JSONObject response) throws Exception {
        String respMsgId = response.optString(MESSAGE_ID_KEY, "");
        CompletableFuture<Ack> ackCompletableFuture = this.responseMap.get(respMsgId);
        if (Objects.nonNull(ackCompletableFuture)) {
            this.responseMap.remove(respMsgId);
            boolean success = response.optBoolean("success", false);
            JSONObject error = response.optJSONObject("error");
            JSONObject payload = response.optJSONObject("payload");
            JSONObject ackObj = new JSONObject();
            ackObj.put("success", success);
            ackObj.put("reason", (Object)error);
            JSONObject data = new JSONObject();
            data.put("result", (Object)payload);
            ackObj.put("data", (Object)data);
            ackCompletableFuture.complete(new Ack(ackObj, this));
        } else {
            this.logger.error("received response with invalid message ID {}", (Object)respMsgId);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        try {
            if (Objects.nonNull(this.iceProviderEventType)) {
                this.channel.removeEventListener(this.iceProviderEventType, this, null);
                this.iceProviderEventType = null;
            }
            if (Objects.nonNull(this.iceClientEventType)) {
                this.channel.removeEventListener(this.iceClientEventType, this, null);
                this.iceClientEventType = null;
            }
            if (Objects.nonNull(this.requestChannel)) {
                this.requestChannel.removeChannelListener(this);
                this.requestChannel.close();
            }
            if (Objects.nonNull(this.responseChannel)) {
                this.responseChannel.removeChannelListener(this);
                this.responseChannel.close();
            }
            if (Objects.nonNull(this.peerConnection)) {
                this.peerConnection.close();
            }
        }
        catch (Exception ex) {
            this.logger.error("Error cleaing up", (Throwable)ex);
        }
        finally {
            this.requestChannel = null;
            this.responseChannel = null;
            this.peerConnection = null;
        }
    }

    private long getNextMessageId() {
        return this.messageId.getAndIncrement();
    }
}

