/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.fdc3;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.WindowIdentity;
import com.openfin.desktop.fdc3.Context;
import com.openfin.desktop.fdc3.ContextListener;
import com.openfin.desktop.fdc3.FDC3Client;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private String id;
    private String name;
    private FDC3Client fdc3Client;
    private ContextListener contextListener;
    private static final String ChannelGetMembers = "CHANNEL-GET-MEMBERS";
    private static final String ChannelAddContextListener = "CHANNEL-ADD-CONTEXT-LISTENER";
    private static final String ChannelJOIN = "CHANNEL-JOIN";
    private static final String ChannelGetCurrentContext = "CHANNEL-GET-CURRENT-CONTEXT";

    Channel(String id, FDC3Client fdc3Client) {
        this.id = id;
        this.fdc3Client = fdc3Client;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void getCurrentContext(final AsyncCallback<Context> callback) {
        JSONObject payload = this.createPayload();
        this.fdc3Client.serviceDispatch(ChannelGetCurrentContext, payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                Context c = Context.fromJson(ack.getJsonObject());
                callback.onSuccess(c);
            }

            @Override
            public void onError(Ack ack) {
                callback.onSuccess(null);
            }
        });
    }

    public void join(AckListener listener) {
        this.join(null, listener);
    }

    private void join(WindowIdentity identity, AckListener listener) {
        JSONObject payload = this.createPayload();
        if (identity != null) {
            payload.put("identity", (Object)identity.toJsonObject());
        }
        this.fdc3Client.serviceDispatch(ChannelJOIN, payload, listener);
    }

    private void setContextListener(ContextListener contextListener, AckListener listener) {
        if (this.contextListener == null) {
            this.fdc3Client.addChannelContextListener(this.id, contextListener);
            this.contextListener = contextListener;
            JSONObject payload = this.createPayload();
            this.fdc3Client.serviceDispatch(ChannelAddContextListener, payload, listener);
        } else {
            this.logger.warn(String.format("Channel listener already set %s", this.id));
        }
    }

    private JSONObject createPayload() {
        JSONObject payload = new JSONObject();
        payload.put("id", (Object)this.id);
        return payload;
    }
}

