/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.interop;

import com.openfin.desktop.ClientIdentity;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.Identity;
import com.openfin.desktop.channel.ChannelClient;
import com.openfin.desktop.interop.Context;
import com.openfin.desktop.interop.ContextGroupInfo;
import com.openfin.desktop.interop.ContextListener;
import com.openfin.desktop.interop.Intent;
import com.openfin.desktop.interop.IntentListener;
import com.openfin.desktop.interop.InteropClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

public class InteropClientImpl
implements InteropClient {
    private DesktopConnection desktopConnection;
    private String brokerName;
    private ChannelClient channelClient;
    private ConcurrentHashMap<String, List<ContextListener>> contextTypeListenersMap;
    private ConcurrentHashMap<String, List<IntentListener>> intentListenersMap;

    public InteropClientImpl(DesktopConnection conn, String brokerName) {
        this.desktopConnection = conn;
        this.brokerName = brokerName;
        this.contextTypeListenersMap = new ConcurrentHashMap();
        this.intentListenersMap = new ConcurrentHashMap();
    }

    CompletionStage<InteropClient> connect() {
        return this.desktopConnection.getChannel("interop-broker-" + this.brokerName).connectAsync().thenApply(client -> {
            this.channelClient = client;
            return this;
        });
    }

    @Override
    public CompletionStage<Void> setContext(Context context) {
        JSONObject payload = new JSONObject();
        payload.put("context", (Object)context.getJson());
        return this.channelClient.dispatchAsync("setContext", payload).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error setContext, reason: " + ack.getReason());
            }
        });
    }

    @Override
    public CompletionStage<Void> addContextListener(ContextListener contextListener) {
        return this.addContextListener(null, contextListener);
    }

    @Override
    public CompletionStage<Void> addContextListener(String contextType, ContextListener listener) {
        String contextTypeKey = contextType == null ? "*" : contextType;
        AtomicBoolean first = new AtomicBoolean(false);
        List listeners = this.contextTypeListenersMap.computeIfAbsent(contextTypeKey, key -> {
            first.set(true);
            return new ArrayList();
        });
        listeners.add(listener);
        if (first.get()) {
            Object handlerId = contextType == null ? "invokeContextHandler" : "invokeContextHandler-" + contextTypeKey;
            this.channelClient.register((String)handlerId, (action, payload, senderIdentity) -> {
                Context context = new Context((JSONObject)payload);
                listeners.forEach(l -> l.onContext(context));
                return null;
            });
            JSONObject payload2 = new JSONObject();
            payload2.put("handlerId", handlerId);
            if (contextType != null) {
                payload2.put("contextType", (Object)contextType);
            }
            return this.channelClient.dispatchAsync("contextHandlerRegistered", payload2).thenAccept(ack -> {
                if (!ack.isSuccessful()) {
                    throw new RuntimeException("error addContextHandler, reason:" + ack.getReason());
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<Void> removeContextListener(ContextListener contextListener) {
        return this.removeContextListener(null, contextListener);
    }

    @Override
    public CompletionStage<Void> removeContextListener(String contextType, ContextListener listener) {
        String contextTypeKey = contextType == null ? "*" : contextType;
        AtomicBoolean last = new AtomicBoolean(false);
        this.contextTypeListenersMap.computeIfPresent(contextTypeKey, (key, listeners) -> {
            boolean removed = listeners.remove(listener);
            if (removed && listeners.size() == 0) {
                last.set(true);
                return null;
            }
            return listeners;
        });
        if (last.get()) {
            Object handlerId = contextType == null ? "invokeContextHandler" : "invokeContextHandler-" + contextTypeKey;
            this.channelClient.remove((String)handlerId);
            JSONObject payload = new JSONObject();
            payload.put("handlerId", handlerId);
            return this.channelClient.dispatchAsync("removeContextHandler", payload).thenAccept(ack -> {
                if (!ack.isSuccessful()) {
                    throw new RuntimeException("error removeContextHandler, reason:" + ack.getReason());
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<ContextGroupInfo[]> getContextGroups() {
        return this.channelClient.dispatchAsync("getContextGroups", new JSONObject()).thenApply(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error getContextGroups, reason: " + ack.getReason());
            }
            JSONArray resultJson = ack.getJsonObject().getJSONObject("data").getJSONArray("result");
            ContextGroupInfo[] result = new ContextGroupInfo[resultJson.length()];
            for (int i = 0; i < resultJson.length(); ++i) {
                result[i] = new ContextGroupInfo(resultJson.getJSONObject(i));
            }
            return result;
        });
    }

    @Override
    public CompletionStage<Void> joinContextGroup(String contextGroupId) {
        return this.joinContextGroup(contextGroupId, null);
    }

    @Override
    public CompletionStage<Void> joinContextGroup(String contextGroupId, Identity target) {
        JSONObject payload = new JSONObject();
        payload.put("contextGroupId", (Object)contextGroupId);
        if (target != null) {
            payload.put("target", (Object)target.getJson());
        }
        return this.channelClient.dispatchAsync("joinContextGroup", payload).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error joinContextGroup, reason: " + ack.getReason());
            }
        });
    }

    @Override
    public CompletionStage<Void> removeFromContextGroup() {
        return this.removeFromContextGroup(null);
    }

    @Override
    public CompletionStage<Void> removeFromContextGroup(Identity target) {
        JSONObject payload = new JSONObject();
        if (target != null) {
            payload.put("target", (Object)target.getJson());
        }
        return this.channelClient.dispatchAsync("removeFromContextGroup", payload).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error removeFromContextGroup, reason: " + ack.getReason());
            }
        });
    }

    @Override
    public CompletionStage<ClientIdentity[]> getAllClientsInContextGroup(String contextGroupId) {
        JSONObject payload = new JSONObject();
        payload.put("contextGroupId", (Object)contextGroupId);
        return this.channelClient.dispatchAsync("getAllClientsInContextGroup", payload).thenApply(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error getAllClientsInContextGroup, reason: " + ack.getReason());
            }
            JSONArray resultJson = ack.getJsonObject().getJSONObject("data").getJSONArray("result");
            ClientIdentity[] result = new ClientIdentity[resultJson.length()];
            for (int i = 0; i < resultJson.length(); ++i) {
                result[i] = new ClientIdentity(resultJson.getJSONObject(i));
            }
            return result;
        });
    }

    @Override
    public CompletionStage<ContextGroupInfo> getInfoForContextGroup(String contextGroupId) {
        JSONObject payload = new JSONObject();
        payload.put("contextGroupId", (Object)contextGroupId);
        return this.channelClient.dispatchAsync("getInfoForContextGroup", payload).thenApply(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error getInfoForContextGroup, reason: " + ack.getReason());
            }
            JSONObject resultJson = ack.getJsonObject().getJSONObject("data").getJSONObject("result");
            return new ContextGroupInfo(resultJson);
        });
    }

    @Override
    public CompletionStage<Void> fireIntent(Intent intent) {
        return this.channelClient.dispatchAsync("fireIntent", intent.getJson()).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error FireIntent, reason: " + ack.getReason());
            }
        });
    }

    @Override
    public CompletionStage<Void> registerIntentListener(String intentName, IntentListener intentListener) {
        AtomicBoolean first = new AtomicBoolean(false);
        List listeners = this.intentListenersMap.computeIfAbsent(intentName, key -> {
            first.set(true);
            return new ArrayList();
        });
        listeners.add(intentListener);
        if (first.get()) {
            String handlerId = "intent-handler-" + intentName;
            this.channelClient.register(handlerId, (action, payload, senderIdentity) -> {
                Intent intent = new Intent((JSONObject)payload);
                listeners.forEach(l -> l.onIntent(intent));
                return null;
            });
            JSONObject payload2 = new JSONObject();
            payload2.put("handlerId", (Object)handlerId);
            return this.channelClient.dispatchAsync("intentHandlerRegistered", payload2).thenAccept(ack -> {
                if (!ack.isSuccessful()) {
                    throw new RuntimeException("error registerIntentListener, reason:" + ack.getReason());
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }
}

