/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.net;

import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketClientFactory {
    private static Logger logger = LoggerFactory.getLogger((String)WebSocketClientFactory.class.getName());
    private static WebSocketClient client;

    WebSocketClientFactory() {
    }

    static synchronized WebSocketClient getWebSocketClient() {
        if (client == null) {
            logger.debug("Creating WebSocketClient");
            client = new WebSocketClient();
            try {
                logger.debug("Starting WebSocketClient");
                client.start();
            }
            catch (Exception e) {
                logger.error("Error creating WebSocketClient", (Throwable)e);
            }
        }
        return client;
    }

    static synchronized void stopWebSocketClient() {
        if (client != null) {
            try {
                if (client.getOpenSessions().isEmpty()) {
                    logger.debug("No live sessions.  closing");
                    client.stop();
                    client = null;
                }
            }
            catch (Exception e) {
                logger.error("Error stopping WebSocketClient", (Throwable)e);
            }
        }
    }
}

