/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.notifications;

import com.openfin.desktop.JsonBean;
import com.openfin.desktop.notifications.ButtonOptions;
import com.openfin.desktop.notifications.CustomData;
import com.openfin.desktop.notifications.NotificationActionResult;
import com.openfin.desktop.notifications.NotificationIndicator;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

public class NotificationOptions
extends JsonBean {
    public static final String STICKY_STICKY = "sticky";
    public static final String STICKY_TRANSIENT = "transient";
    private NotificationIndicator indicator;
    private ButtonOptions[] buttons;
    private NotificationActionResult onClose;
    private NotificationActionResult onExpire;
    private NotificationActionResult onSelect;
    private CustomData customData;

    public NotificationOptions(String title, String body, String category) {
        this.put("title", title);
        this.put("body", body);
        this.put("category", category);
    }

    public NotificationOptions(JSONObject json) {
        super(json);
    }

    public String getBody() {
        return this.getString("body");
    }

    public String getCategory() {
        return this.getString("category");
    }

    private Date getDateValue(String key) {
        if (this.json.has(key) && !this.json.isNull(key)) {
            long dateInMillis = this.json.getLong(key);
            return new Date(dateInMillis);
        }
        return null;
    }

    public Date getDate() {
        return this.getDateValue("date");
    }

    public void setDate(Date date) {
        this.setLong("date", date.getTime());
    }

    public Date getExpires() {
        return this.getDateValue("expires");
    }

    public void setExpires(Date date) {
        this.setLong("expires", date.getTime());
    }

    public String getId() {
        return this.getString("id");
    }

    public void setId(String id) {
        this.setString("id", id);
    }

    public String getIcon() {
        return this.getString("icon");
    }

    public void setIcon(String icon) {
        this.setString("icon", icon);
    }

    public String getSticky() {
        return this.getString(STICKY_STICKY);
    }

    public void setSticky(String sticky) {
        this.setString(STICKY_STICKY, sticky);
    }

    public NotificationIndicator getIndicator() {
        if (this.indicator == null && this.json.has("indicator") && !this.json.isNull("indicator")) {
            this.indicator = new NotificationIndicator(this.json.getJSONObject("indicator"));
        }
        return this.indicator;
    }

    public void setIndicator(NotificationIndicator indicator) {
        this.setJsonBean("indicator", indicator);
    }

    public String getTitle() {
        return this.getString("title");
    }

    public void setButtons(ButtonOptions ... buttons) {
        this.buttons = buttons;
        JSONArray buttonsJson = new JSONArray();
        if (buttons != null) {
            for (int i = 0; i < buttons.length; ++i) {
                buttonsJson.put((Object)buttons[i].getJsonCopy());
            }
        }
        this.json.put("buttons", (Object)buttonsJson);
    }

    public ButtonOptions[] getButtons() {
        if (this.buttons == null && this.json.has("buttons") && !this.json.isNull("buttons")) {
            JSONArray buttonsJson = this.json.getJSONArray("buttons");
            this.buttons = new ButtonOptions[buttonsJson.length()];
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i] = new ButtonOptions(buttonsJson.getJSONObject(i));
            }
        }
        return this.buttons;
    }

    public NotificationActionResult getOnClose() {
        if (this.onClose == null && this.json.has("onClose") && !this.json.isNull("onClose")) {
            this.onClose = new NotificationActionResult(this.json.getJSONObject("onClose"));
        }
        return this.onClose;
    }

    public void setOnClose(NotificationActionResult onClose) {
        this.setJsonBean("onClose", onClose);
    }

    public NotificationActionResult getOnExpire() {
        if (this.onExpire == null && this.json.has("onExpire") && !this.json.isNull("onExpire")) {
            this.onExpire = new NotificationActionResult(this.json.getJSONObject("onExpire"));
        }
        return this.onExpire;
    }

    public void setOnExpire(NotificationActionResult onExpire) {
        this.setJsonBean("onExpire", onExpire);
    }

    public NotificationActionResult getOnSelect() {
        if (this.onSelect == null && this.json.has("onSelect") && !this.json.isNull("onSelect")) {
            this.onSelect = new NotificationActionResult(this.json.getJSONObject("onSelect"));
        }
        return this.onSelect;
    }

    public void setOnSelect(NotificationActionResult onSelect) {
        this.setJsonBean("onSelect", onSelect);
    }

    public CustomData getCustomData() {
        if (this.customData == null && this.json.has("customData") && !this.json.isNull("customData")) {
            this.customData = new CustomData(this.json.getJSONObject("customData"));
        }
        return this.customData;
    }

    public void setCustomData(CustomData customData) {
        this.setJsonBean("customData", customData);
    }
}

