/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.notifications;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.OpenFinRuntime;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.ChannelClient;
import com.openfin.desktop.notifications.NotificationEventListener;
import com.openfin.desktop.notifications.NotificationOptions;
import com.openfin.desktop.notifications.ProviderStatus;
import com.openfin.desktop.notifications.events.NotificationActionEvent;
import com.openfin.desktop.notifications.events.NotificationClosedEvent;
import com.openfin.desktop.notifications.events.NotificationCreatedEvent;
import com.openfin.desktop.notifications.events.NotificationEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notifications {
    private static final Logger logger = LoggerFactory.getLogger(Notifications.class);
    public static final String EVENT_TYPE_ACTION = "notification-action";
    public static final String EVENT_TYPE_CREATED = "notification-created";
    public static final String EVENT_TYPE_CLOSED = "notification-closed";
    private static final String NotificationServiceChannelName = "of-notifications-service-v1";
    private static String NotificationsServiceManifestUrl = "https://cdn.openfin.co/services/openfin/notifications/app.json";
    private DesktopConnection desktopConnection;
    private CompletionStage<ChannelClient> channelClient;
    private ReentrantLock channelClientLock;
    private ConcurrentHashMap<String, CopyOnWriteArrayList<NotificationEventListener>> eventListenerMap;

    public Notifications(DesktopConnection desktopConnection) {
        this.desktopConnection = desktopConnection;
        this.channelClientLock = new ReentrantLock();
        this.eventListenerMap = new ConcurrentHashMap();
        this.eventListenerMap.put(EVENT_TYPE_ACTION, new CopyOnWriteArrayList());
        this.eventListenerMap.put(EVENT_TYPE_CREATED, new CopyOnWriteArrayList());
        this.eventListenerMap.put(EVENT_TYPE_CLOSED, new CopyOnWriteArrayList());
    }

    private void invokeEventListeners(JSONObject payload) {
        String eventType = payload.getString("type");
        CopyOnWriteArrayList<NotificationEventListener> listeners = this.eventListenerMap.get(eventType);
        for (NotificationEventListener listener : listeners) {
            NotificationEvent event = null;
            if (EVENT_TYPE_ACTION.equals(eventType)) {
                event = new NotificationActionEvent(payload);
            } else if (EVENT_TYPE_CREATED.equals(eventType)) {
                event = new NotificationCreatedEvent(payload);
            } else if (EVENT_TYPE_CLOSED.equals(eventType)) {
                event = new NotificationClosedEvent(payload);
            }
            if (event == null) continue;
            listener.onEvent(event);
        }
    }

    private CompletionStage<ChannelClient> getChannelClient() {
        if (this.channelClient == null) {
            this.channelClientLock.lock();
            if (this.channelClient == null) {
                try {
                    String launchError = this.launchNotificationCenter().get();
                    if (launchError == null) {
                        Channel channel = this.desktopConnection.getChannel(NotificationServiceChannelName);
                        this.channelClient = channel.connectAsync().thenApply(client -> {
                            client.register("event", (action, payload, senderIdentity) -> {
                                this.invokeEventListeners((JSONObject)payload);
                                return null;
                            });
                            client.dispatchAsync("add-event-listener", EVENT_TYPE_ACTION);
                            return client;
                        });
                        logger.debug("notification channel client created");
                    } else {
                        logger.error(String.format("Error getting notification client  %s", launchError));
                    }
                }
                catch (Exception ex) {
                    logger.error(String.format("Error getting notification client  %s", ex.toString()));
                }
                this.channelClientLock.unlock();
            }
        }
        return this.channelClient;
    }

    private CompletableFuture<String> launchNotificationCenter() {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            OpenFinRuntime r = new OpenFinRuntime(this.desktopConnection);
            r.launchManifest("fins://system-apps/notification-center", null, new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    future.complete(ack.getReason());
                }

                @Override
                public void onError(Ack ack) {
                    logger.error(String.format("Error starting  %s %s", NotificationsServiceManifestUrl, ack.getReason()));
                    future.complete(ack.getReason());
                }
            });
        }
        catch (Exception ex) {
            logger.error(String.format("Error loadManifest  %s %s", NotificationsServiceManifestUrl, ex.toString()));
            future.complete(ex.getMessage());
        }
        return future;
    }

    public CompletionStage<NotificationOptions> create(NotificationOptions options) {
        return this.getChannelClient().thenCompose(channelClient -> channelClient.dispatchAsync("create-notification", options.getJson()).thenApply(ack -> new NotificationOptions(((JSONObject)ack.getData()).getJSONObject("result"))));
    }

    public CompletionStage<Boolean> clear(String id) {
        return this.getChannelClient().thenCompose(channelClient -> {
            JSONObject payload = new JSONObject();
            payload.put("id", (Object)id);
            return channelClient.dispatchAsync("clear-notification", payload).thenApply(ack -> ack.isSuccessful());
        });
    }

    public CompletionStage<Integer> clearAll() {
        return this.getChannelClient().thenCompose(channelClient -> channelClient.dispatchAsync("clear-app-notifications", new JSONObject()).thenApply(ack -> ((JSONObject)ack.getData()).getInt("result")));
    }

    public CompletionStage<List<NotificationOptions>> getAll() {
        return this.getChannelClient().thenCompose(channelClient -> channelClient.dispatchAsync("fetch-app-notifications", new JSONObject()).thenApply(ack -> {
            JSONArray resultJson = ((JSONObject)ack.getData()).getJSONArray("result");
            int resultCnt = resultJson.length();
            ArrayList<NotificationOptions> result = new ArrayList<NotificationOptions>(resultCnt);
            for (int i = 0; i < resultCnt; ++i) {
                result.add(new NotificationOptions(resultJson.getJSONObject(i)));
            }
            return result;
        }));
    }

    public CompletionStage<Void> toggleNotificationCenter() {
        return this.getChannelClient().thenCompose(channelClient -> channelClient.dispatchAsync("toggle-notification-center", new JSONObject()).thenAccept(ack -> {}));
    }

    public boolean addEventListener(String eventType, NotificationEventListener listener) {
        return this.eventListenerMap.get(eventType).add(listener);
    }

    public boolean removeEventListener(String eventType, NotificationEventListener listener) {
        return this.eventListenerMap.get(eventType).remove(listener);
    }

    public CompletionStage<ProviderStatus> getProviderStatus() {
        return this.getChannelClient().thenCompose(channelClient -> channelClient.dispatchAsync("get-provider-status", new JSONObject()).thenApply(ack -> new ProviderStatus(((JSONObject)ack.getData()).getJSONObject("result"))));
    }
}

