/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.platform;

import com.openfin.desktop.Application;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.Identity;
import com.openfin.desktop.Window;
import com.openfin.desktop.WindowOptions;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.ChannelClient;
import com.openfin.desktop.platform.PlatformOptions;
import com.openfin.desktop.platform.PlatformSnapshot;
import com.openfin.desktop.platform.PlatformSnapshotOptions;
import com.openfin.desktop.platform.PlatformView;
import com.openfin.desktop.platform.PlatformViewOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Platform {
    private static final Logger logger = LoggerFactory.getLogger(Platform.class);
    private Application application;
    private CompletionStage<ChannelClient> channelClient;
    private ReentrantLock channelClientLock;

    private Platform(Application application) {
        this.application = application;
        this.channelClientLock = new ReentrantLock();
    }

    public static CompletionStage<Platform> start(DesktopConnection desktopConnection, PlatformOptions platformOptions) {
        CompletableFuture platformApiReadyCallback = new CompletableFuture();
        logger.debug("Platform options: {}", (Object)platformOptions.getJsonCopy());
        return ((CompletableFuture)Application.createApplication(platformOptions, desktopConnection).thenApply(app -> {
            Platform platform = new Platform((Application)app);
            platform.addEventListener("platform-api-ready", actionEvent -> platformApiReadyCallback.complete(null));
            app.runAsync();
            return platform;
        })).thenCombine((CompletionStage)platformApiReadyCallback, (platform, nothing) -> platform);
    }

    public static CompletionStage<Platform> startFromManifest(DesktopConnection desktopConnection, String manifestUrl) {
        CompletableFuture platformApiReadyCallback = new CompletableFuture();
        return ((CompletableFuture)Application.createFromManifestAsync(manifestUrl, desktopConnection).thenApply(app -> {
            Platform platform = new Platform((Application)app);
            platform.addEventListener("platform-api-ready", actionEvent -> platformApiReadyCallback.complete(null));
            app.runAsync();
            return platform;
        })).thenCombineAsync((CompletionStage)platformApiReadyCallback, (platform, nothing) -> platform);
    }

    public String getUuid() {
        return this.application.getUuid();
    }

    public void addEventListener(String type, EventListener listener) {
        try {
            this.application.addEventListener(type, listener, null);
        }
        catch (DesktopException e) {
            e.printStackTrace();
        }
    }

    public void removeEventListener(String type, EventListener listener) {
        try {
            this.application.removeEventListener(type, listener, null);
        }
        catch (DesktopException e) {
            e.printStackTrace();
        }
    }

    public CompletionStage<Platform> applySnapshot(String requestedSnapshot, PlatformSnapshotOptions opts) {
        JSONObject payload = new JSONObject();
        payload.put("manifestUrl", (Object)requestedSnapshot);
        return ((CompletableFuture)this.application.getConnection().sendActionAsync("get-application-manifest", payload, this).thenApply(ack -> {
            if (ack.isSuccessful()) {
                return new PlatformSnapshot(ack.getJsonObject().getJSONObject("data"));
            }
            throw new RuntimeException("error retriving snapshot, reason: " + ack.getReason());
        })).thenCompose(snapshot -> this.applySnapshot((PlatformSnapshot)snapshot, opts));
    }

    public CompletionStage<Platform> applySnapshot(PlatformSnapshot snapshot, PlatformSnapshotOptions opts) {
        return this.getChannelClient().thenCompose(client -> {
            JSONObject payload = new JSONObject();
            payload.put("snapshot", (Object)snapshot.getJsonCopy());
            if (opts != null) {
                payload.put("options", (Object)opts.getJsonCopy());
            }
            return client.dispatchAsync("apply-snapshot", payload);
        }).thenApply(ack -> {
            if (ack.isSuccessful()) {
                return this;
            }
            throw new RuntimeException("error applying platform snapshot, reason: " + ack.getReason());
        });
    }

    public CompletionStage<Void> closeView(PlatformView view) {
        return view.getCurrentWindow().thenAcceptBoth(this.getChannelClient(), (win, client) -> {
            JSONObject payload = new JSONObject();
            payload.put("target", (Object)win.getIdentity().getJsonCopy());
            payload.put("opts", (Object)view.getIdentity().getJsonCopy());
            client.dispatchAsync("close-view", payload);
        });
    }

    public CompletionStage<PlatformView> createView(PlatformViewOptions viewOpts, Identity target) {
        return this.getChannelClient().thenCompose(client -> {
            JSONObject payload = new JSONObject();
            payload.put("target", (Object)(target == null ? null : target.getJsonCopy()));
            payload.put("opts", (Object)viewOpts.getJsonCopy());
            return client.dispatchAsync("create-view", payload);
        }).thenApply(ack -> {
            if (ack.isSuccessful()) {
                JSONObject result = ack.getJsonObject().getJSONObject("data").getJSONObject("result");
                return new PlatformView(new Identity(result.getJSONObject("identity")), this.application.getConnection());
            }
            throw new RuntimeException("error creating platform view, reason: " + ack.getReason());
        });
    }

    public CompletionStage<Window> createWindow(WindowOptions winOpts) {
        return this.getChannelClient().thenCompose(client -> client.dispatchAsync("create-view-container", winOpts.getJsonCopy())).thenApply(ack -> {
            if (ack.isSuccessful()) {
                JSONObject data = ack.getJsonObject().getJSONObject("data");
                JSONObject identity = data.getJSONObject("result").getJSONObject("identity");
                return Window.wrap(identity.getString("uuid"), identity.getString("name"), this.application.getConnection());
            }
            throw new RuntimeException("error creating platform window, reason: " + ack.getReason());
        });
    }

    public CompletionStage<PlatformSnapshot> getSnapshot() {
        return this.getChannelClient().thenCompose(client -> client.dispatchAsync("get-snapshot", null)).thenApply(ack -> {
            if (ack.isSuccessful()) {
                return new PlatformSnapshot(ack.getJsonObject().getJSONObject("data").getJSONObject("result"));
            }
            throw new RuntimeException("error getting platform snapshot, reason: " + ack.getReason());
        });
    }

    public CompletionStage<PlatformView> reparentView(Identity viewIdentity, Identity targetIdentity) {
        if (viewIdentity.getUuid() == null) {
            viewIdentity.setUuid(this.getUuid());
        }
        PlatformView view = PlatformView.wrap(viewIdentity, this.application.getConnection());
        return view.getOptions().thenCompose(viewOpts -> this.createView((PlatformViewOptions)viewOpts, targetIdentity));
    }

    public CompletionStage<Void> quit() {
        return this.getChannelClient().thenAccept(client -> client.dispatchAsync("quit", null));
    }

    public static Platform wrap(String uuid, DesktopConnection desktopConnection) {
        return new Platform(Application.wrap(uuid, desktopConnection));
    }

    public CompletionStage<ChannelClient> getChannelClient() {
        if (this.channelClient == null) {
            this.channelClientLock.lock();
            if (this.channelClient == null) {
                Channel channel = this.application.getConnection().getChannel("custom-frame-" + this.getUuid());
                this.channelClient = channel.connectAsync();
                logger.debug("platform channel client {} created", (Object)channel.getName());
            }
            this.channelClientLock.unlock();
        }
        return this.channelClient;
    }
}

